/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.metrics;

import com.google.common.base.Preconditions;
import io.pravega.controller.metrics.AbstractControllerMetrics;
import io.pravega.shared.MetricsNames;
import io.pravega.shared.MetricsTags;
import io.pravega.shared.metrics.OpStatsLogger;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;

public final class TransactionMetrics
extends AbstractControllerMetrics {
    private static final AtomicReference<TransactionMetrics> INSTANCE = new AtomicReference();
    private final OpStatsLogger createTransactionLatency = STATS_LOGGER.createStats("pravega.controller.transactions.created_latency_ms", new String[0]);
    private final OpStatsLogger createTransactionSegmentsLatency = STATS_LOGGER.createStats("pravega.controller.transactions.created_segments_latency_ms", new String[0]);
    private final OpStatsLogger commitTransactionLatency = STATS_LOGGER.createStats("pravega.controller.transactions.committed_latency_ms", new String[0]);
    private final OpStatsLogger commitTransactionSegmentsLatency = STATS_LOGGER.createStats("pravega.controller.transactions.committed_segments_latency_ms", new String[0]);
    private final OpStatsLogger committingTransactionLatency = STATS_LOGGER.createStats("pravega.controller.transactions.committing_latency_ms", new String[0]);
    private final OpStatsLogger abortTransactionLatency = STATS_LOGGER.createStats("pravega.controller.transactions.aborted_latency_ms", new String[0]);
    private final OpStatsLogger abortTransactionSegmentsLatency = STATS_LOGGER.createStats("pravega.controller.transactions.aborted_segments_latency_ms", new String[0]);
    private final OpStatsLogger abortingTransactionLatency = STATS_LOGGER.createStats("pravega.controller.transactions.aborting_latency_ms", new String[0]);

    private TransactionMetrics() {
    }

    public static synchronized void initialize() {
        if (INSTANCE.get() == null) {
            INSTANCE.set(new TransactionMetrics());
        }
    }

    public static TransactionMetrics getInstance() {
        Preconditions.checkState((INSTANCE.get() != null ? 1 : 0) != 0, (Object)"You need call initialize before using this class.");
        return INSTANCE.get();
    }

    public void createTransaction(String scope, String streamName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.transactions.created"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.created", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
        this.createTransactionLatency.reportSuccessValue(latency.toMillis());
    }

    public void createTransactionSegments(Duration latency) {
        this.createTransactionSegmentsLatency.reportSuccessValue(latency.toMillis());
    }

    public void createTransactionFailed(String scope, String streamName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.transactions.create_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.create_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public void committingTransaction(Duration latency) {
        this.committingTransactionLatency.reportSuccessValue(latency.toMillis());
    }

    public void commitTransaction(String scope, String streamName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.transactions.committed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.committed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
        this.commitTransactionLatency.reportSuccessValue(latency.toMillis());
    }

    public void commitTransactionSegments(Duration latency) {
        this.commitTransactionSegmentsLatency.reportSuccessValue(latency.toMillis());
    }

    public void commitTransactionFailed(String scope, String streamName, String txnId) {
        this.commitTransactionFailed(scope, streamName);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.commit_failed", 1L, MetricsTags.transactionTags((String)scope, (String)streamName, (String)txnId));
    }

    public void commitTransactionFailed(String scope, String streamName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.transactions.commit_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.commit_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public void abortingTransaction(Duration latency) {
        this.abortingTransactionLatency.reportSuccessValue(latency.toMillis());
    }

    public void abortTransaction(String scope, String streamName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.transactions.aborted"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.aborted", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
        this.abortTransactionLatency.reportSuccessValue(latency.toMillis());
    }

    public void abortTransactionSegments(Duration latency) {
        this.abortTransactionSegmentsLatency.reportSuccessValue(latency.toMillis());
    }

    public void abortTransactionFailed(String scope, String streamName, String txnId) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.transactions.abort_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.abort_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.abort_failed", 1L, MetricsTags.transactionTags((String)scope, (String)streamName, (String)txnId));
    }

    public static void reportOpenTransactions(String scope, String streamName, int ongoingTransactions) {
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.transactions.opened", (Number)ongoingTransactions, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public static synchronized void reset() {
        TransactionMetrics old = INSTANCE.get();
        if (old != null) {
            old.createTransactionLatency.close();
            old.createTransactionSegmentsLatency.close();
            old.commitTransactionLatency.close();
            old.commitTransactionSegmentsLatency.close();
            old.committingTransactionLatency.close();
            old.abortTransactionLatency.close();
            old.abortTransactionSegmentsLatency.close();
            old.abortingTransactionLatency.close();
        }
        INSTANCE.set(new TransactionMetrics());
    }
}

