/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.control.impl.ModelHelper;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.common.Exceptions;
import io.pravega.common.Timer;
import io.pravega.common.cluster.Cluster;
import io.pravega.common.cluster.ClusterException;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.RequestTracker;
import io.pravega.common.tracing.TagLogger;
import io.pravega.common.util.RetriesExhaustedException;
import io.pravega.controller.metrics.StreamMetrics;
import io.pravega.controller.metrics.TransactionMetrics;
import io.pravega.controller.server.SegmentHelper;
import io.pravega.controller.store.SegmentRecord;
import io.pravega.controller.store.kvtable.KVTOperationContext;
import io.pravega.controller.store.kvtable.KVTableMetadataStore;
import io.pravega.controller.store.stream.BucketStore;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.ScaleMetadata;
import io.pravega.controller.store.stream.State;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.store.stream.VersionedTransactionData;
import io.pravega.controller.store.stream.records.StreamSegmentRecord;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import io.pravega.controller.task.KeyValueTable.TableMetadataTasks;
import io.pravega.controller.task.Stream.StreamMetadataTasks;
import io.pravega.controller.task.Stream.StreamTransactionMetadataTasks;
import io.pravega.shared.NameUtils;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.LoggerFactory;

public class ControllerService {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(ControllerService.class));
    private final KVTableMetadataStore kvtMetadataStore;
    private final TableMetadataTasks kvtMetadataTasks;
    private final StreamMetadataStore streamStore;
    private final BucketStore bucketStore;
    private final StreamMetadataTasks streamMetadataTasks;
    private final StreamTransactionMetadataTasks streamTransactionMetadataTasks;
    private final SegmentHelper segmentHelper;
    private final Executor executor;
    private final Cluster cluster;
    private final RequestTracker requestTracker;

    public CompletableFuture<List<Controller.NodeUri>> getControllerServerList() {
        if (this.cluster == null) {
            return Futures.failedFuture((Throwable)new IllegalStateException("Controller cluster not initialized"));
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.cluster.getClusterMembers().stream().map(host -> Controller.NodeUri.newBuilder().setEndpoint(host.getIpAddr()).setPort(host.getPort()).build()).collect(Collectors.toList());
            }
            catch (ClusterException e) {
                throw Exceptions.sneakyThrow((Throwable)e);
            }
        }, this.executor);
    }

    public CompletableFuture<Controller.CreateKeyValueTableStatus> createKeyValueTable(String scope, String kvtName, KeyValueTableConfiguration kvtConfig, long createTimestamp, long requestId) {
        Preconditions.checkNotNull((Object)kvtConfig, (Object)"kvTableConfig");
        Preconditions.checkArgument((createTimestamp >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((kvtConfig.getPartitionCount() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((kvtConfig.getPrimaryKeyLength() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((kvtConfig.getSecondaryKeyLength() >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((kvtConfig.getRolloverSizeBytes() >= 0L ? 1 : 0) != 0);
        Timer timer = new Timer();
        try {
            NameUtils.validateUserKeyValueTableName((String)kvtName);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.warn(requestId, "Create KeyValueTable failed due to invalid name {}", new Object[]{kvtName});
            return CompletableFuture.completedFuture(Controller.CreateKeyValueTableStatus.newBuilder().setStatus(Controller.CreateKeyValueTableStatus.Status.INVALID_TABLE_NAME).build());
        }
        return this.kvtMetadataTasks.createKeyValueTable(scope, kvtName, kvtConfig, createTimestamp, requestId).thenApplyAsync(status -> {
            this.reportCreateKVTableMetrics(scope, kvtName, kvtConfig.getPartitionCount(), (Controller.CreateKeyValueTableStatus.Status)status, timer.getElapsed());
            return Controller.CreateKeyValueTableStatus.newBuilder().setStatus(status).build();
        }, this.executor);
    }

    public CompletableFuture<List<Controller.SegmentRange>> getCurrentSegmentsKeyValueTable(String scope, String kvtName, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)kvtName, (String)"KeyValueTable");
        return this.kvtMetadataStore.getActiveSegments(scope, kvtName, null, this.executor).thenApplyAsync(activeSegments -> this.getSegmentRanges((List<? extends SegmentRecord>)activeSegments, scope, kvtName), this.executor);
    }

    public CompletableFuture<Pair<List<String>, String>> listKeyValueTables(String scope, String token, int limit, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        OperationContext context = this.streamStore.createScopeContext(scope, requestId);
        return this.kvtMetadataStore.listKeyValueTables(scope, token, limit, context, this.executor);
    }

    public CompletableFuture<Controller.KeyValueTableConfigResponse> getKeyValueTableConfiguration(String scope, String kvtName, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"Scope name");
        Exceptions.checkNotNullOrEmpty((String)kvtName, (String)"KeyValueTable name.");
        KVTOperationContext context = this.kvtMetadataStore.createContext(scope, kvtName, requestId);
        return this.kvtMetadataStore.getConfiguration(scope, kvtName, context, this.executor).handleAsync((r, ex) -> {
            if (ex == null) {
                return Controller.KeyValueTableConfigResponse.newBuilder().setConfig(ModelHelper.decode((String)scope, (String)kvtName, (KeyValueTableConfiguration)r)).setStatus(Controller.KeyValueTableConfigResponse.Status.SUCCESS).build();
            }
            if (Exceptions.unwrap((Throwable)ex) instanceof StoreException.DataNotFoundException) {
                return Controller.KeyValueTableConfigResponse.newBuilder().setStatus(Controller.KeyValueTableConfigResponse.Status.TABLE_NOT_FOUND).build();
            }
            return Controller.KeyValueTableConfigResponse.newBuilder().setStatus(Controller.KeyValueTableConfigResponse.Status.FAILURE).build();
        });
    }

    public CompletableFuture<Controller.DeleteKVTableStatus> deleteKeyValueTable(String scope, String kvtName, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"Scope Name");
        Exceptions.checkNotNullOrEmpty((String)kvtName, (String)"KeyValueTable Name");
        Timer timer = new Timer();
        return this.kvtMetadataTasks.deleteKeyValueTable(scope, kvtName, requestId).thenApplyAsync(status -> {
            this.reportDeleteKVTableMetrics(scope, kvtName, (Controller.DeleteKVTableStatus.Status)status, timer.getElapsed());
            return Controller.DeleteKVTableStatus.newBuilder().setStatus(status).build();
        }, this.executor);
    }

    public CompletableFuture<Controller.CreateReaderGroupResponse> createReaderGroup(String scope, String rgName, ReaderGroupConfig rgConfig, long createTimestamp, long requestId) {
        Preconditions.checkNotNull((Object)scope, (Object)"ReaderGroup scope is null");
        Preconditions.checkNotNull((Object)rgName, (Object)"ReaderGroup name is null");
        Preconditions.checkNotNull((Object)rgConfig, (Object)"ReaderGroup config is null");
        Preconditions.checkArgument((createTimestamp >= 0L ? 1 : 0) != 0);
        Timer timer = new Timer();
        try {
            NameUtils.validateReaderGroupName((String)rgName);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.error(requestId, "Create ReaderGroup failed due to invalid name {}", new Object[]{rgName});
            return CompletableFuture.completedFuture(Controller.CreateReaderGroupResponse.newBuilder().setStatus(Controller.CreateReaderGroupResponse.Status.INVALID_RG_NAME).build());
        }
        return this.streamMetadataTasks.createReaderGroup(scope, rgName, rgConfig, createTimestamp, requestId).thenApplyAsync(response -> {
            this.reportCreateReaderGroupMetrics(scope, rgName, response.getStatus(), timer.getElapsed());
            return response;
        }, this.executor);
    }

    public CompletableFuture<Controller.UpdateReaderGroupResponse> updateReaderGroup(String scope, String rgName, ReaderGroupConfig rgConfig, long requestId) {
        Preconditions.checkNotNull((Object)scope, (Object)"ReaderGroup scope is null");
        Preconditions.checkNotNull((Object)rgName, (Object)"ReaderGroup name is null");
        Preconditions.checkNotNull((Object)rgConfig, (Object)"ReaderGroup config is null");
        Timer timer = new Timer();
        return this.streamMetadataTasks.updateReaderGroup(scope, rgName, rgConfig, requestId).thenApplyAsync(response -> {
            this.reportUpdateReaderGroupMetrics(scope, rgName, response.getStatus(), timer.getElapsed());
            return response;
        }, this.executor);
    }

    public CompletableFuture<Controller.ReaderGroupConfigResponse> getReaderGroupConfig(String scope, String rgName, long requestId) {
        Preconditions.checkNotNull((Object)scope, (Object)"ReaderGroup scope is null");
        Preconditions.checkNotNull((Object)rgName, (Object)"ReaderGroup name is null");
        return this.streamMetadataTasks.getReaderGroupConfig(scope, rgName, requestId);
    }

    public CompletableFuture<Controller.DeleteReaderGroupStatus> deleteReaderGroup(String scope, String rgName, String readerGroupId, long requestId) {
        Preconditions.checkNotNull((Object)scope, (Object)"ReaderGroup scope is null");
        Preconditions.checkNotNull((Object)rgName, (Object)"ReaderGroup name is null");
        Preconditions.checkNotNull((Object)readerGroupId, (Object)"ReaderGroup Id is null");
        Timer timer = new Timer();
        return this.streamMetadataTasks.deleteReaderGroup(scope, rgName, readerGroupId, requestId).thenApplyAsync(status -> {
            this.reportDeleteReaderGroupMetrics(scope, rgName, (Controller.DeleteReaderGroupStatus.Status)status, timer.getElapsed());
            return Controller.DeleteReaderGroupStatus.newBuilder().setStatus(status).build();
        }, this.executor);
    }

    public CompletableFuture<Controller.SubscribersResponse> listSubscribers(String scope, String stream, long requestId) {
        Preconditions.checkNotNull((Object)scope, (Object)"scopeName is null");
        Preconditions.checkNotNull((Object)stream, (Object)"streamName is null");
        return this.streamMetadataTasks.listSubscribers(scope, stream, requestId);
    }

    public CompletableFuture<Controller.UpdateSubscriberStatus> updateSubscriberStreamCut(String scope, String stream, String subscriber, String readerGroupId, long generation, ImmutableMap<Long, Long> truncationStreamCut, long requestId) {
        Preconditions.checkNotNull((Object)scope, (Object)"scopeName is null");
        Preconditions.checkNotNull((Object)stream, (Object)"streamName is null");
        Preconditions.checkNotNull((Object)subscriber, (Object)"subscriber is null");
        Preconditions.checkNotNull((Object)readerGroupId, (Object)"readerGroupId is null");
        Preconditions.checkNotNull(truncationStreamCut, (Object)"Truncation StreamCut is null");
        Timer timer = new Timer();
        return this.streamMetadataTasks.updateSubscriberStreamCut(scope, stream, subscriber, readerGroupId, generation, truncationStreamCut, requestId).thenApplyAsync(status -> {
            this.reportUpdateTruncationSCMetrics(scope, stream, (Controller.UpdateSubscriberStatus.Status)status, timer.getElapsed());
            return Controller.UpdateSubscriberStatus.newBuilder().setStatus(status).build();
        }, this.executor);
    }

    public CompletableFuture<Controller.CreateStreamStatus> createStream(String scope, String stream, StreamConfiguration streamConfig, long createTimestamp, long requestId) {
        Preconditions.checkNotNull((Object)streamConfig, (Object)"streamConfig");
        Preconditions.checkArgument((createTimestamp >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((streamConfig.getRolloverSizeBytes() >= 0L ? 1 : 0) != 0, (Object)String.format("Segment rollover size bytes cannot be less than 0, actual is %s", streamConfig.getRolloverSizeBytes()));
        Timer timer = new Timer();
        try {
            NameUtils.validateStreamName((String)stream);
        }
        catch (IllegalArgumentException | NullPointerException e2) {
            log.error(requestId, "Create stream failed due to invalid stream name {}", new Object[]{stream});
            return CompletableFuture.completedFuture(Controller.CreateStreamStatus.newBuilder().setStatus(Controller.CreateStreamStatus.Status.INVALID_STREAM_NAME).build());
        }
        return Futures.exceptionallyExpecting(this.streamStore.getState(scope, stream, true, null, this.executor), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, (Object)((Object)State.UNKNOWN)).thenCompose(state -> {
            if (state.equals((Object)State.UNKNOWN) || state.equals((Object)State.CREATING)) {
                return this.streamMetadataTasks.createStreamRetryOnLockFailure(scope, stream, streamConfig, createTimestamp, 10, requestId).thenApplyAsync(status -> {
                    this.reportCreateStreamMetrics(scope, stream, streamConfig.getScalingPolicy().getMinNumSegments(), (Controller.CreateStreamStatus.Status)status, timer.getElapsed());
                    return Controller.CreateStreamStatus.newBuilder().setStatus(status).build();
                }, this.executor);
            }
            return CompletableFuture.completedFuture(Controller.CreateStreamStatus.newBuilder().setStatus(Controller.CreateStreamStatus.Status.STREAM_EXISTS).build());
        });
    }

    public CompletableFuture<Controller.UpdateStreamStatus> updateStream(String scope, String stream, StreamConfiguration streamConfig, long requestId) {
        Preconditions.checkNotNull((Object)streamConfig, (Object)"streamConfig");
        Timer timer = new Timer();
        return this.streamMetadataTasks.updateStream(scope, stream, streamConfig, requestId).thenApplyAsync(status -> {
            this.reportUpdateStreamMetrics(scope, stream, (Controller.UpdateStreamStatus.Status)status, timer.getElapsed());
            return Controller.UpdateStreamStatus.newBuilder().setStatus(status).build();
        }, this.executor);
    }

    public CompletableFuture<Controller.UpdateStreamStatus> truncateStream(String scope, String stream, Map<Long, Long> streamCut, long requestId) {
        Preconditions.checkNotNull((Object)scope, (Object)"scope");
        Preconditions.checkNotNull((Object)stream, (Object)"stream");
        Preconditions.checkNotNull(streamCut, (Object)"streamCut");
        Timer timer = new Timer();
        return this.streamMetadataTasks.truncateStream(scope, stream, streamCut, requestId).thenApplyAsync(status -> {
            this.reportTruncateStreamMetrics(scope, stream, (Controller.UpdateStreamStatus.Status)status, timer.getElapsed());
            return Controller.UpdateStreamStatus.newBuilder().setStatus(status).build();
        }, this.executor);
    }

    public CompletableFuture<StreamConfiguration> getStream(String scopeName, String streamName, long requestId) {
        OperationContext context = this.streamStore.createStreamContext(scopeName, streamName, requestId);
        return this.streamStore.getConfiguration(scopeName, streamName, context, this.executor);
    }

    public CompletableFuture<Controller.UpdateStreamStatus> sealStream(String scope, String stream, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Timer timer = new Timer();
        return this.streamMetadataTasks.sealStream(scope, stream, requestId).thenApplyAsync(status -> {
            this.reportSealStreamMetrics(scope, stream, (Controller.UpdateStreamStatus.Status)status, timer.getElapsed());
            return Controller.UpdateStreamStatus.newBuilder().setStatus(status).build();
        }, this.executor);
    }

    public CompletableFuture<Controller.DeleteStreamStatus> deleteStream(String scope, String stream, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Timer timer = new Timer();
        return this.streamMetadataTasks.deleteStream(scope, stream, requestId).thenApplyAsync(status -> {
            this.reportDeleteStreamMetrics(scope, stream, (Controller.DeleteStreamStatus.Status)status, timer.getElapsed());
            return Controller.DeleteStreamStatus.newBuilder().setStatus(status).build();
        }, this.executor);
    }

    public CompletableFuture<List<Controller.SegmentRange>> getCurrentSegments(String scope, String stream, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        OperationContext context = this.streamStore.createStreamContext(scope, stream, requestId);
        return this.streamStore.getActiveSegments(scope, stream, context, this.executor).thenApplyAsync(activeSegments -> this.getSegmentRanges((List<? extends SegmentRecord>)activeSegments, scope, stream), this.executor);
    }

    public CompletableFuture<List<Controller.SegmentRange>> getEpochSegments(String scope, String stream, int epoch, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Exceptions.checkArgument((epoch >= 0 ? 1 : 0) != 0, (String)"epoch", (String)"Epoch cannot be less than 0", (Object[])new Object[0]);
        OperationContext context = this.streamStore.createStreamContext(scope, stream, requestId);
        return this.streamStore.getEpoch(scope, stream, epoch, context, this.executor).thenApplyAsync(epochRecord -> this.getSegmentRanges((List<? extends SegmentRecord>)epochRecord.getSegments(), scope, stream), this.executor);
    }

    public CompletableFuture<Map<Controller.SegmentId, Long>> getSegmentsAtHead(String scope, String stream, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        OperationContext context = this.streamStore.createStreamContext(scope, stream, requestId);
        return this.streamStore.getSegmentsAtHead(scope, stream, context, this.executor).thenApply(segments -> segments.entrySet().stream().collect(Collectors.toMap(entry -> ModelHelper.createSegmentId((String)scope, (String)stream, (long)((StreamSegmentRecord)entry.getKey()).segmentId()), Map.Entry::getValue)));
    }

    public CompletableFuture<Map<Controller.SegmentRange, List<Long>>> getSegmentsImmediatelyFollowing(Controller.SegmentId segment, long requestId) {
        Preconditions.checkNotNull((Object)segment, (Object)"segment");
        String scope = segment.getStreamInfo().getScope();
        String stream = segment.getStreamInfo().getStream();
        OperationContext context = this.streamStore.createStreamContext(scope, stream, requestId);
        return this.streamStore.getSuccessors(scope, stream, segment.getSegmentId(), context, this.executor).thenApply(successors -> successors.entrySet().stream().collect(Collectors.toMap(entry -> ModelHelper.createSegmentRange((String)scope, (String)stream, (long)((StreamSegmentRecord)entry.getKey()).segmentId(), (double)((StreamSegmentRecord)entry.getKey()).getKeyStart(), (double)((StreamSegmentRecord)entry.getKey()).getKeyEnd()), Map.Entry::getValue)));
    }

    public CompletableFuture<List<StreamSegmentRecord>> getSegmentsBetweenStreamCuts(Controller.StreamCutRange range, long requestId) {
        Preconditions.checkNotNull((Object)range, (Object)"segment");
        Preconditions.checkArgument((!range.getFromMap().isEmpty() || !range.getToMap().isEmpty() ? 1 : 0) != 0);
        String scope = range.getStreamInfo().getScope();
        String stream = range.getStreamInfo().getStream();
        OperationContext context = this.streamStore.createStreamContext(scope, stream, requestId);
        return this.streamStore.getSegmentsBetweenStreamCuts(scope, stream, range.getFromMap(), range.getToMap(), context, this.executor);
    }

    public CompletableFuture<Controller.ScaleResponse> scale(String scope, String stream, List<Long> segmentsToSeal, Map<Double, Double> newKeyRanges, long scaleTimestamp, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Preconditions.checkNotNull(segmentsToSeal, (Object)"sealedSegments");
        Preconditions.checkNotNull(newKeyRanges, (Object)"newKeyRanges");
        return this.streamMetadataTasks.manualScale(scope, stream, segmentsToSeal, new ArrayList<Map.Entry<Double, Double>>(ModelHelper.encode(newKeyRanges)), scaleTimestamp, requestId);
    }

    public CompletableFuture<Controller.ScaleStatusResponse> checkScale(String scope, String stream, int epoch, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Exceptions.checkArgument((epoch >= 0 ? 1 : 0) != 0, (String)"epoch", (String)"Epoch cannot be less than 0", (Object[])new Object[0]);
        return this.streamMetadataTasks.checkScale(scope, stream, epoch, requestId);
    }

    public CompletableFuture<List<ScaleMetadata>> getScaleRecords(String scope, String stream, long from, long to, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        OperationContext context = this.streamStore.createStreamContext(scope, stream, requestId);
        return this.streamStore.getScaleMetadata(scope, stream, from, to, context, this.executor);
    }

    public CompletableFuture<Controller.NodeUri> getURI(Controller.SegmentId segment) {
        Preconditions.checkNotNull((Object)segment, (Object)"segment");
        return CompletableFuture.completedFuture(this.segmentHelper.getSegmentUri(segment.getStreamInfo().getScope(), segment.getStreamInfo().getStream(), segment.getSegmentId()));
    }

    private Controller.SegmentRange convert(String scope, String stream, SegmentRecord segment) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Preconditions.checkNotNull((Object)segment, (Object)"segment");
        return ModelHelper.createSegmentRange((String)scope, (String)stream, (long)segment.segmentId(), (double)segment.getKeyStart(), (double)segment.getKeyEnd());
    }

    public CompletableFuture<Boolean> isSegmentValid(String scope, String stream, long segmentId, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        OperationContext context = this.streamStore.createStreamContext(scope, stream, requestId);
        return this.streamStore.getActiveSegments(scope, stream, context, this.executor).thenApplyAsync(x -> x.stream().anyMatch(z -> z.segmentId() == segmentId), this.executor);
    }

    public CompletableFuture<Boolean> isStreamCutValid(String scope, String stream, Map<Long, Long> streamCut, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        OperationContext context = this.streamStore.createStreamContext(scope, stream, requestId);
        return this.streamStore.isStreamCutValid(scope, stream, streamCut, context, this.executor);
    }

    public CompletableFuture<Pair<UUID, List<Controller.SegmentRange>>> createTransaction(String scope, String stream, long lease, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Timer timer = new Timer();
        OperationContext context = this.streamStore.createStreamContext(scope, stream, requestId);
        return ((CompletableFuture)((CompletableFuture)this.streamStore.getConfiguration(scope, stream, context, this.executor).thenCompose(streamConfig -> this.streamTransactionMetadataTasks.createTxn(scope, stream, lease, requestId, streamConfig.getRolloverSizeBytes()))).thenApply(pair -> {
            VersionedTransactionData data = (VersionedTransactionData)pair.getKey();
            List segments = (List)pair.getValue();
            return new ImmutablePair((Object)data.getId(), this.getSegmentRanges(segments, scope, stream));
        })).handle((result, ex) -> {
            if (ex != null) {
                TransactionMetrics.getInstance().createTransactionFailed(scope, stream);
                throw new CompletionException((Throwable)ex);
            }
            TransactionMetrics.getInstance().createTransaction(scope, stream, timer.getElapsed());
            return result;
        });
    }

    private List<Controller.SegmentRange> getSegmentRanges(List<? extends SegmentRecord> activeSegments, String scope, String stream) {
        List<Controller.SegmentRange> listOfSegment = activeSegments.stream().map(segment -> this.convert(scope, stream, (SegmentRecord)segment)).collect(Collectors.toList());
        listOfSegment.sort(Comparator.comparingDouble(Controller.SegmentRange::getMinKey));
        return listOfSegment;
    }

    public CompletableFuture<Controller.TxnStatus> commitTransaction(String scope, String stream, UUID txId, String writerId, long timestamp, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Preconditions.checkNotNull((Object)txId, (Object)"txnId");
        Timer timer = new Timer();
        return this.streamTransactionMetadataTasks.commitTxn(scope, stream, txId, writerId, timestamp, requestId).handle((ok, ex) -> {
            if (ex != null) {
                log.error(requestId, "Transaction commit failed", new Object[]{ex});
                log.error("Transaction commit failed for txn {} on stream {}. Cause: {}", new Object[]{txId.toString(), NameUtils.getScopedStreamName((String)scope, (String)stream), ex});
                Throwable unwrap = this.getRealException((Throwable)ex);
                if (unwrap instanceof StoreException.DataNotFoundException || unwrap instanceof StoreException.IllegalStateException) {
                    TransactionMetrics.getInstance().commitTransactionFailed(scope, stream, txId.toString());
                    return Controller.TxnStatus.newBuilder().setStatus(Controller.TxnStatus.Status.FAILURE).build();
                }
                throw new CompletionException(unwrap);
            }
            TransactionMetrics.getInstance().committingTransaction(timer.getElapsed());
            return Controller.TxnStatus.newBuilder().setStatus(Controller.TxnStatus.Status.SUCCESS).build();
        });
    }

    private Throwable getRealException(Throwable ex) {
        Throwable unwrap = Exceptions.unwrap((Throwable)ex);
        if (unwrap instanceof RetriesExhaustedException) {
            unwrap = Exceptions.unwrap((Throwable)unwrap.getCause());
        }
        return unwrap;
    }

    public CompletableFuture<Controller.TxnStatus> abortTransaction(String scope, String stream, UUID txId, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Preconditions.checkNotNull((Object)txId, (Object)"txnId");
        Timer timer = new Timer();
        return this.streamTransactionMetadataTasks.abortTxn(scope, stream, txId, null, requestId).handle((ok, ex) -> {
            if (ex != null) {
                log.error(requestId, "Transaction abort failed for txn {} on Stream {}", new Object[]{txId.toString(), NameUtils.getScopedStreamName((String)scope, (String)stream), ex});
                Throwable unwrap = this.getRealException((Throwable)ex);
                if (unwrap instanceof StoreException.DataNotFoundException || unwrap instanceof StoreException.IllegalStateException) {
                    TransactionMetrics.getInstance().abortTransactionFailed(scope, stream, txId.toString());
                    return Controller.TxnStatus.newBuilder().setStatus(Controller.TxnStatus.Status.FAILURE).build();
                }
                throw new CompletionException(unwrap);
            }
            TransactionMetrics.getInstance().abortingTransaction(timer.getElapsed());
            return Controller.TxnStatus.newBuilder().setStatus(Controller.TxnStatus.Status.SUCCESS).build();
        });
    }

    public CompletableFuture<Controller.PingTxnStatus> pingTransaction(String scope, String stream, UUID txId, long lease, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Preconditions.checkNotNull((Object)txId, (Object)"txnId");
        return this.streamTransactionMetadataTasks.pingTxn(scope, stream, txId, lease, requestId);
    }

    public CompletableFuture<Controller.TxnState> checkTransactionStatus(String scope, String stream, UUID txnId, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Preconditions.checkNotNull((Object)txnId, (Object)"txnId");
        OperationContext context = this.streamStore.createStreamContext(scope, stream, requestId);
        return this.streamStore.transactionStatus(scope, stream, txnId, context, this.executor).thenApplyAsync(res -> Controller.TxnState.newBuilder().setState(Controller.TxnState.State.valueOf((String)res.name())).build(), this.executor);
    }

    public CompletableFuture<Controller.CreateScopeStatus> createScope(String scope, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Timer timer = new Timer();
        try {
            NameUtils.validateScopeName((String)scope);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.error(requestId, "Create scope failed due to invalid scope name {}", new Object[]{scope});
            return CompletableFuture.completedFuture(Controller.CreateScopeStatus.newBuilder().setStatus(Controller.CreateScopeStatus.Status.INVALID_SCOPE_NAME).build());
        }
        OperationContext context = this.streamStore.createScopeContext(scope, requestId);
        return this.streamStore.createScope(scope, context, this.executor).thenApply(r -> this.reportCreateScopeMetrics(scope, (Controller.CreateScopeStatus)r, timer.getElapsed()));
    }

    public CompletableFuture<Controller.DeleteScopeStatus> deleteScope(String scope, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Timer timer = new Timer();
        OperationContext context = this.streamStore.createScopeContext(scope, requestId);
        return this.streamStore.deleteScope(scope, context, this.executor).thenApply(r -> this.reportDeleteScopeMetrics(scope, (Controller.DeleteScopeStatus)r, timer.getElapsed()));
    }

    public CompletableFuture<Map<String, StreamConfiguration>> listStreamsInScope(String scope, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        OperationContext context = this.streamStore.createScopeContext(scope, requestId);
        return this.streamStore.listStreamsInScope(scope, context, this.executor);
    }

    public CompletableFuture<Pair<List<String>, String>> listStreams(String scope, String token, int limit, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        OperationContext context = this.streamStore.createScopeContext(scope, requestId);
        return this.streamStore.listStream(scope, token, limit, this.executor, context);
    }

    public CompletableFuture<Pair<List<String>, String>> listStreamsForTag(String scope, String tag, String token, long requestId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)tag, (String)"tag");
        OperationContext context = this.streamStore.createScopeContext(scope, requestId);
        return this.streamStore.listStreamsForTag(scope, tag, token, this.executor, context);
    }

    public CompletableFuture<List<String>> listScopes(long requestId) {
        return this.streamStore.listScopes(this.executor, requestId);
    }

    public CompletableFuture<Pair<List<String>, String>> listScopes(String token, int limit, long requestId) {
        return this.streamStore.listScopes(token, limit, this.executor, requestId);
    }

    public CompletableFuture<String> getScope(String scopeName, long requestId) {
        Preconditions.checkNotNull((Object)scopeName);
        OperationContext context = this.streamStore.createScopeContext(scopeName, requestId);
        return this.streamStore.getScopeConfiguration(scopeName, context, this.executor);
    }

    private void reportCreateKVTableMetrics(String scope, String kvtName, int initialSegments, Controller.CreateKeyValueTableStatus.Status status, Duration latency) {
        if (status.equals((Object)Controller.CreateKeyValueTableStatus.Status.SUCCESS)) {
            StreamMetrics.getInstance().createKeyValueTable(scope, kvtName, initialSegments, latency);
        } else if (status.equals((Object)Controller.CreateKeyValueTableStatus.Status.FAILURE)) {
            StreamMetrics.getInstance().createKeyValueTableFailed(scope, kvtName);
        }
    }

    private void reportDeleteKVTableMetrics(String scope, String kvtName, Controller.DeleteKVTableStatus.Status status, Duration latency) {
        if (status.equals((Object)Controller.DeleteKVTableStatus.Status.SUCCESS)) {
            StreamMetrics.getInstance().deleteKeyValueTable(scope, kvtName, latency);
        } else if (status.equals((Object)Controller.DeleteKVTableStatus.Status.FAILURE)) {
            StreamMetrics.getInstance().deleteKeyValueTableFailed(scope, kvtName);
        }
    }

    private void reportCreateStreamMetrics(String scope, String streamName, int initialSegments, Controller.CreateStreamStatus.Status status, Duration latency) {
        if (status.equals((Object)Controller.CreateStreamStatus.Status.SUCCESS)) {
            StreamMetrics.getInstance().createStream(scope, streamName, initialSegments, latency);
        } else if (status.equals((Object)Controller.CreateStreamStatus.Status.FAILURE)) {
            StreamMetrics.getInstance().createStreamFailed(scope, streamName);
        }
    }

    private Controller.CreateScopeStatus reportCreateScopeMetrics(String scope, Controller.CreateScopeStatus status, Duration latency) {
        if (status.getStatus().equals((Object)Controller.CreateScopeStatus.Status.SUCCESS)) {
            StreamMetrics.getInstance().createScope(latency);
        } else if (status.getStatus().equals((Object)Controller.CreateScopeStatus.Status.FAILURE)) {
            StreamMetrics.getInstance().createScopeFailed(scope);
        }
        return status;
    }

    private void reportUpdateStreamMetrics(String scope, String streamName, Controller.UpdateStreamStatus.Status status, Duration latency) {
        if (status.equals((Object)Controller.UpdateStreamStatus.Status.SUCCESS)) {
            StreamMetrics.getInstance().updateStream(scope, streamName, latency);
        } else if (status.equals((Object)Controller.UpdateStreamStatus.Status.FAILURE)) {
            StreamMetrics.getInstance().updateStreamFailed(scope, streamName);
        }
    }

    private void reportCreateReaderGroupMetrics(String scope, String rgName, Controller.CreateReaderGroupResponse.Status status, Duration latency) {
        if (status.equals((Object)Controller.CreateReaderGroupResponse.Status.SUCCESS)) {
            StreamMetrics.getInstance().createReaderGroup(scope, rgName, latency);
        } else if (status.equals((Object)Controller.CreateReaderGroupResponse.Status.FAILURE)) {
            StreamMetrics.getInstance().createReaderGroupFailed(scope, rgName);
        }
    }

    private void reportUpdateReaderGroupMetrics(String scope, String streamName, Controller.UpdateReaderGroupResponse.Status status, Duration latency) {
        if (status.equals((Object)Controller.UpdateReaderGroupResponse.Status.SUCCESS)) {
            StreamMetrics.getInstance().updateReaderGroup(scope, streamName, latency);
        } else if (status.equals((Object)Controller.UpdateReaderGroupResponse.Status.FAILURE)) {
            StreamMetrics.getInstance().updateReaderGroupFailed(scope, streamName);
        }
    }

    private void reportDeleteReaderGroupMetrics(String scope, String streamName, Controller.DeleteReaderGroupStatus.Status status, Duration latency) {
        if (status.equals((Object)Controller.DeleteReaderGroupStatus.Status.SUCCESS)) {
            StreamMetrics.getInstance().deleteReaderGroup(scope, streamName, latency);
        } else if (status.equals((Object)Controller.DeleteReaderGroupStatus.Status.FAILURE)) {
            StreamMetrics.getInstance().deleteReaderGroupFailed(scope, streamName);
        }
    }

    private void reportUpdateTruncationSCMetrics(String scope, String streamName, Controller.UpdateSubscriberStatus.Status status, Duration latency) {
        if (status.equals((Object)Controller.UpdateSubscriberStatus.Status.SUCCESS)) {
            StreamMetrics.getInstance().updateTruncationSC(scope, streamName, latency);
        } else if (status.equals((Object)Controller.UpdateSubscriberStatus.Status.FAILURE)) {
            StreamMetrics.getInstance().updateTruncationSCFailed(scope, streamName);
        }
    }

    private void reportTruncateStreamMetrics(String scope, String streamName, Controller.UpdateStreamStatus.Status status, Duration latency) {
        if (status.equals((Object)Controller.UpdateStreamStatus.Status.SUCCESS)) {
            StreamMetrics.getInstance().truncateStream(scope, streamName, latency);
        } else if (status.equals((Object)Controller.UpdateStreamStatus.Status.FAILURE)) {
            StreamMetrics.getInstance().truncateStreamFailed(scope, streamName);
        }
    }

    private void reportSealStreamMetrics(String scope, String streamName, Controller.UpdateStreamStatus.Status status, Duration latency) {
        if (status.equals((Object)Controller.UpdateStreamStatus.Status.SUCCESS)) {
            StreamMetrics.getInstance().sealStream(scope, streamName, latency);
        } else if (status.equals((Object)Controller.UpdateStreamStatus.Status.FAILURE)) {
            StreamMetrics.getInstance().sealStreamFailed(scope, streamName);
        }
    }

    private void reportDeleteStreamMetrics(String scope, String streamName, Controller.DeleteStreamStatus.Status status, Duration latency) {
        if (status.equals((Object)Controller.DeleteStreamStatus.Status.SUCCESS)) {
            StreamMetrics.getInstance().deleteStream(scope, streamName, latency);
        } else if (status.equals((Object)Controller.DeleteStreamStatus.Status.FAILURE)) {
            StreamMetrics.getInstance().deleteStreamFailed(scope, streamName);
        }
    }

    private Controller.DeleteScopeStatus reportDeleteScopeMetrics(String scope, Controller.DeleteScopeStatus status, Duration latency) {
        if (status.getStatus().equals((Object)Controller.DeleteScopeStatus.Status.SUCCESS)) {
            StreamMetrics.getInstance().deleteScope(latency);
        } else if (status.getStatus().equals((Object)Controller.DeleteScopeStatus.Status.FAILURE)) {
            StreamMetrics.getInstance().deleteScopeFailed(scope);
        }
        return status;
    }

    public CompletableFuture<Controller.TimestampResponse> noteTimestampFromWriter(String scope, String stream, String writerId, long timestamp, Map<Long, Long> streamCut, long requestId) {
        OperationContext context = this.streamStore.createStreamContext(scope, stream, requestId);
        return ((CompletableFuture)this.bucketStore.addStreamToBucketStore(BucketStore.ServiceType.WatermarkingService, scope, stream, this.executor).thenCompose(v -> this.streamStore.noteWriterMark(scope, stream, writerId, timestamp, streamCut, context, this.executor))).thenApply(r -> {
            Controller.TimestampResponse.Builder response = Controller.TimestampResponse.newBuilder();
            switch (r) {
                case SUCCESS: {
                    response.setResult(Controller.TimestampResponse.Status.SUCCESS);
                    break;
                }
                case INVALID_TIME: {
                    response.setResult(Controller.TimestampResponse.Status.INVALID_TIME);
                    break;
                }
                case INVALID_POSITION: {
                    response.setResult(Controller.TimestampResponse.Status.INVALID_POSITION);
                    break;
                }
                default: {
                    response.setResult(Controller.TimestampResponse.Status.INTERNAL_ERROR);
                }
            }
            return response.build();
        });
    }

    public CompletableFuture<Controller.RemoveWriterResponse> removeWriter(String scope, String stream, String writer, long requestId) {
        OperationContext context = this.streamStore.createStreamContext(scope, stream, requestId);
        return this.streamStore.shutdownWriter(scope, stream, writer, context, this.executor).handle((r, e) -> {
            Controller.RemoveWriterResponse.Builder response = Controller.RemoveWriterResponse.newBuilder();
            if (e != null) {
                if (Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException) {
                    response.setResult(Controller.RemoveWriterResponse.Status.UNKNOWN_WRITER);
                } else {
                    response.setResult(Controller.RemoveWriterResponse.Status.INTERNAL_ERROR);
                }
            } else {
                response.setResult(Controller.RemoveWriterResponse.Status.SUCCESS);
            }
            return response.build();
        });
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KVTableMetadataStore getKvtMetadataStore() {
        return this.kvtMetadataStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TableMetadataTasks getKvtMetadataTasks() {
        return this.kvtMetadataTasks;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public StreamMetadataStore getStreamStore() {
        return this.streamStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BucketStore getBucketStore() {
        return this.bucketStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public StreamMetadataTasks getStreamMetadataTasks() {
        return this.streamMetadataTasks;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public StreamTransactionMetadataTasks getStreamTransactionMetadataTasks() {
        return this.streamTransactionMetadataTasks;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SegmentHelper getSegmentHelper() {
        return this.segmentHelper;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Executor getExecutor() {
        return this.executor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Cluster getCluster() {
        return this.cluster;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RequestTracker getRequestTracker() {
        return this.requestTracker;
    }

    @ConstructorProperties(value={"kvtMetadataStore", "kvtMetadataTasks", "streamStore", "bucketStore", "streamMetadataTasks", "streamTransactionMetadataTasks", "segmentHelper", "executor", "cluster", "requestTracker"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ControllerService(KVTableMetadataStore kvtMetadataStore, TableMetadataTasks kvtMetadataTasks, StreamMetadataStore streamStore, BucketStore bucketStore, StreamMetadataTasks streamMetadataTasks, StreamTransactionMetadataTasks streamTransactionMetadataTasks, SegmentHelper segmentHelper, Executor executor, Cluster cluster, RequestTracker requestTracker) {
        this.kvtMetadataStore = kvtMetadataStore;
        this.kvtMetadataTasks = kvtMetadataTasks;
        this.streamStore = streamStore;
        this.bucketStore = bucketStore;
        this.streamMetadataTasks = streamMetadataTasks;
        this.streamTransactionMetadataTasks = streamTransactionMetadataTasks;
        this.segmentHelper = segmentHelper;
        this.executor = executor;
        this.cluster = cluster;
        this.requestTracker = requestTracker;
    }
}

