/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.Monitor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.function.Callbacks;
import io.pravega.controller.metrics.ZookeeperMetrics;
import io.pravega.controller.server.ControllerServiceConfig;
import io.pravega.controller.server.ControllerServiceStarter;
import io.pravega.controller.store.client.StoreClient;
import io.pravega.controller.store.client.StoreClientFactory;
import io.pravega.controller.store.client.StoreType;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerServiceMain
extends AbstractExecutionThreadService
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ControllerServiceMain.class);
    private final String objectId;
    private final ControllerServiceConfig serviceConfig;
    private final BiFunction<ControllerServiceConfig, StoreClient, ControllerServiceStarter> starterFactory;
    private ControllerServiceStarter starter;
    private final CompletableFuture<Void> serviceStopFuture;
    private StoreClient storeClient;
    private ServiceState serviceState;
    private final Monitor monitor = new Monitor();
    private final Monitor.Guard hasReachedStarting = new HasReachedState(ServiceState.STARTING);
    private final Monitor.Guard hasReachedPausing = new HasReachedState(ServiceState.PAUSING);
    private final ZookeeperMetrics zookeeperMetrics;

    public ControllerServiceMain(ControllerServiceConfig serviceConfig) {
        this(serviceConfig, ControllerServiceStarter::new);
    }

    @VisibleForTesting
    ControllerServiceMain(ControllerServiceConfig serviceConfig, BiFunction<ControllerServiceConfig, StoreClient, ControllerServiceStarter> starterFactory) {
        this.objectId = "ControllerServiceMain";
        this.serviceConfig = serviceConfig;
        this.starterFactory = starterFactory;
        this.serviceStopFuture = new CompletableFuture();
        this.serviceState = ServiceState.NEW;
        this.zookeeperMetrics = new ZookeeperMetrics();
    }

    protected void triggerShutdown() {
        log.info("Shutting down Controller Service.");
        this.serviceStopFuture.complete(null);
    }

    protected void run() throws Exception {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)this.objectId, (Object[])new Object[]{"run"});
        try {
            while (this.isRunning()) {
                log.debug("Creating store client");
                this.storeClient = StoreClientFactory.createStoreClient(this.serviceConfig.getStoreClientConfig());
                this.starter = this.starterFactory.apply(this.serviceConfig, this.storeClient);
                boolean hasZkConnection = this.serviceConfig.getStoreClientConfig().getStoreType().equals((Object)StoreType.Zookeeper) || this.serviceConfig.isControllerClusterListenerEnabled();
                CompletableFuture sessionExpiryFuture = new CompletableFuture();
                if (hasZkConnection) {
                    CuratorFramework client = (CuratorFramework)this.storeClient.getClient();
                    log.debug("Awaiting ZK client connection to ZK server");
                    client.blockUntilConnected();
                    log.debug("Awaiting ZK session expiry or termination trigger for ControllerServiceMain");
                    client.getConnectionStateListenable().addListener((client1, newState) -> {
                        if (newState.equals((Object)ConnectionState.LOST)) {
                            sessionExpiryFuture.complete(null);
                            this.starter.notifySessionExpiration();
                        }
                    });
                }
                log.info("Starting Controller Services.");
                this.notifyServiceStateChange(ServiceState.STARTING);
                this.starter.startAsync();
                this.starter.awaitRunning();
                log.info("Controller Services started successfully.");
                if (hasZkConnection) {
                    CompletableFuture.anyOf(sessionExpiryFuture, this.serviceStopFuture).join();
                    if (sessionExpiryFuture.isDone()) {
                        this.zookeeperMetrics.reportZKSessionExpiration();
                        log.info("ZK session expired. Stopping Controller Services.");
                    }
                } else {
                    this.serviceStopFuture.join();
                    log.info("Stopping Controller Services.");
                }
                this.notifyServiceStateChange(ServiceState.PAUSING);
                this.starter.stopAsync();
                log.debug("Awaiting termination of ControllerServices");
                this.starter.awaitTerminated();
                if (hasZkConnection) {
                    log.debug("Calling close on store client.");
                    this.storeClient.close();
                }
                log.info("Controller Services terminated successfully.");
            }
        }
        catch (Exception e) {
            log.error("Controller Service Main thread exited exceptionally", (Throwable)e);
            throw e;
        }
        finally {
            if (this.storeClient != null) {
                this.storeClient.close();
            }
            LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"run", (long)traceId, (Object[])new Object[0]);
        }
    }

    private void notifyServiceStateChange(ServiceState newState) {
        this.monitor.enter();
        try {
            this.serviceState = newState;
        }
        finally {
            this.monitor.leave();
        }
    }

    @VisibleForTesting
    public ControllerServiceStarter awaitServiceStarting() {
        this.monitor.enterWhenUninterruptibly(this.hasReachedStarting);
        try {
            if (this.serviceState != ServiceState.STARTING) {
                throw new IllegalStateException("Expected state=" + ServiceState.STARTING + ", but actual state=" + this.serviceState);
            }
            ControllerServiceStarter controllerServiceStarter = this.starter;
            return controllerServiceStarter;
        }
        finally {
            this.monitor.leave();
        }
    }

    @VisibleForTesting
    public ControllerServiceStarter awaitServicePausing() {
        this.monitor.enterWhenUninterruptibly(this.hasReachedPausing);
        try {
            if (this.serviceState != ServiceState.PAUSING) {
                throw new IllegalStateException("Expected state=" + ServiceState.PAUSING + ", but actual state=" + this.serviceState);
            }
            ControllerServiceStarter controllerServiceStarter = this.starter;
            return controllerServiceStarter;
        }
        finally {
            this.monitor.leave();
        }
    }

    @VisibleForTesting
    public void forceClientSessionExpiry() throws Exception {
        Preconditions.checkState((boolean)this.serviceConfig.isControllerClusterListenerEnabled(), (Object)"Controller Cluster not enabled");
        this.awaitServiceStarting();
        ((CuratorFramework)this.storeClient.getClient()).getZookeeperClient().getZooKeeper().getTestable().injectSessionExpiration();
    }

    protected void shutDown() throws Exception {
        if (this.starter != null && this.starter.isRunning()) {
            this.triggerShutdown();
            this.starter.awaitTerminated();
        }
        if (this.storeClient != null) {
            this.storeClient.close();
        }
    }

    @Override
    public void close() {
        if (this.starter != null) {
            this.triggerShutdown();
            Callbacks.invokeSafely(this.starter::close, ex -> log.debug("Error closing starter. " + ex.getMessage()));
        }
        if (this.storeClient != null) {
            Callbacks.invokeSafely(this.storeClient::close, ex -> log.debug("Error closing storeClient. " + ex.getMessage()));
        }
    }

    final class HasReachedState
    extends Monitor.Guard {
        private ServiceState desiredState;

        HasReachedState(ServiceState desiredState) {
            super(ControllerServiceMain.this.monitor);
            this.desiredState = desiredState;
        }

        public boolean isSatisfied() {
            return ControllerServiceMain.this.serviceState == this.desiredState;
        }
    }

    static enum ServiceState {
        NEW,
        STARTING,
        PAUSING;

    }
}

