/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.pravega.auth.AuthenticationException;
import io.pravega.auth.TokenExpiredException;
import io.pravega.client.connection.impl.ConnectionPool;
import io.pravega.client.connection.impl.RawClient;
import io.pravega.client.control.impl.ModelHelper;
import io.pravega.client.stream.ScalingPolicy;
import io.pravega.client.stream.impl.ConnectionClosedException;
import io.pravega.client.tables.impl.HashTableIteratorItem;
import io.pravega.client.tables.impl.TableSegmentEntry;
import io.pravega.client.tables.impl.TableSegmentKey;
import io.pravega.client.tables.impl.TableSegmentKeyVersion;
import io.pravega.common.Exceptions;
import io.pravega.common.cluster.Host;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.server.WireCommandFailedException;
import io.pravega.controller.store.host.HostControllerStore;
import io.pravega.controller.store.stream.records.RecordHelper;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import io.pravega.controller.util.Config;
import io.pravega.shared.NameUtils;
import io.pravega.shared.protocol.netty.ConnectionFailedException;
import io.pravega.shared.protocol.netty.PravegaNodeUri;
import io.pravega.shared.protocol.netty.Reply;
import io.pravega.shared.protocol.netty.Request;
import io.pravega.shared.protocol.netty.WireCommand;
import io.pravega.shared.protocol.netty.WireCommandType;
import io.pravega.shared.protocol.netty.WireCommands;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.LoggerFactory;

public class SegmentHelper
implements AutoCloseable {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(SegmentHelper.class));
    private static final Map<Class<? extends Request>, Set<Class<? extends Reply>>> EXPECTED_SUCCESS_REPLIES = ImmutableMap.builder().put(WireCommands.CreateSegment.class, (Object)ImmutableSet.of(WireCommands.SegmentCreated.class, WireCommands.SegmentAlreadyExists.class)).put(WireCommands.CreateTableSegment.class, (Object)ImmutableSet.of(WireCommands.SegmentCreated.class, WireCommands.SegmentAlreadyExists.class)).put(WireCommands.DeleteSegment.class, (Object)ImmutableSet.of(WireCommands.SegmentDeleted.class, WireCommands.NoSuchSegment.class)).put(WireCommands.DeleteTableSegment.class, (Object)ImmutableSet.of(WireCommands.SegmentDeleted.class, WireCommands.NoSuchSegment.class)).put(WireCommands.UpdateSegmentPolicy.class, (Object)ImmutableSet.of(WireCommands.SegmentPolicyUpdated.class)).put(WireCommands.SealSegment.class, (Object)ImmutableSet.of(WireCommands.SegmentSealed.class, WireCommands.SegmentIsSealed.class)).put(WireCommands.TruncateSegment.class, (Object)ImmutableSet.of(WireCommands.SegmentTruncated.class, WireCommands.SegmentIsTruncated.class)).put(WireCommands.GetStreamSegmentInfo.class, (Object)ImmutableSet.of(WireCommands.StreamSegmentInfo.class, WireCommands.SegmentIsTruncated.class)).put(WireCommands.MergeSegments.class, (Object)ImmutableSet.of(WireCommands.SegmentsMerged.class, WireCommands.NoSuchSegment.class)).put(WireCommands.ReadSegment.class, (Object)ImmutableSet.of(WireCommands.SegmentRead.class)).put(WireCommands.GetSegmentAttribute.class, (Object)ImmutableSet.of(WireCommands.SegmentAttribute.class)).put(WireCommands.UpdateSegmentAttribute.class, (Object)ImmutableSet.of(WireCommands.SegmentAttributeUpdated.class)).put(WireCommands.UpdateTableEntries.class, (Object)ImmutableSet.of(WireCommands.TableEntriesUpdated.class)).put(WireCommands.RemoveTableKeys.class, (Object)ImmutableSet.of(WireCommands.TableKeysRemoved.class, WireCommands.TableKeyDoesNotExist.class)).put(WireCommands.ReadTable.class, (Object)ImmutableSet.of(WireCommands.TableRead.class)).put(WireCommands.ReadTableKeys.class, (Object)ImmutableSet.of(WireCommands.TableKeysRead.class)).put(WireCommands.ReadTableEntries.class, (Object)ImmutableSet.of(WireCommands.TableEntriesRead.class)).put(WireCommands.GetTableSegmentInfo.class, (Object)ImmutableSet.of(WireCommands.TableSegmentInfo.class)).build();
    private static final Map<Class<? extends Request>, Set<Class<? extends Reply>>> EXPECTED_FAILING_REPLIES = ImmutableMap.builder().put(WireCommands.GetStreamSegmentInfo.class, (Object)ImmutableSet.of(WireCommands.NoSuchSegment.class)).put(WireCommands.ReadSegment.class, (Object)ImmutableSet.of(WireCommands.NoSuchSegment.class)).put(WireCommands.GetSegmentAttribute.class, (Object)ImmutableSet.of(WireCommands.NoSuchSegment.class)).put(WireCommands.UpdateSegmentAttribute.class, (Object)ImmutableSet.of(WireCommands.NoSuchSegment.class)).put(WireCommands.UpdateTableEntries.class, (Object)ImmutableSet.of(WireCommands.TableKeyDoesNotExist.class, WireCommands.TableKeyBadVersion.class, WireCommands.NoSuchSegment.class)).put(WireCommands.RemoveTableKeys.class, (Object)ImmutableSet.of(WireCommands.TableKeyBadVersion.class, WireCommands.NoSuchSegment.class)).put(WireCommands.DeleteTableSegment.class, (Object)ImmutableSet.of(WireCommands.TableSegmentNotEmpty.class)).put(WireCommands.ReadTable.class, (Object)ImmutableSet.of(WireCommands.NoSuchSegment.class)).put(WireCommands.ReadTableKeys.class, (Object)ImmutableSet.of(WireCommands.NoSuchSegment.class)).put(WireCommands.ReadTableEntries.class, (Object)ImmutableSet.of(WireCommands.NoSuchSegment.class)).put(WireCommands.GetTableSegmentInfo.class, (Object)ImmutableSet.of(WireCommands.NoSuchSegment.class)).build();
    protected final ConnectionPool connectionPool;
    protected final ScheduledExecutorService executorService;
    protected final AtomicReference<Duration> timeout;
    private final HostControllerStore hostStore;

    public SegmentHelper(ConnectionPool connectionPool, HostControllerStore hostStore, ScheduledExecutorService executorService) {
        this.connectionPool = connectionPool;
        this.hostStore = hostStore;
        this.executorService = executorService;
        this.timeout = new AtomicReference<Duration>(Duration.ofSeconds(Config.REQUEST_TIMEOUT_SECONDS_SEGMENT_STORE.intValue()));
    }

    @VisibleForTesting
    void setTimeout(Duration duration) {
        this.timeout.set(duration);
    }

    public Controller.NodeUri getSegmentUri(String scope, String stream, long segmentId) {
        Host host = this.hostStore.getHostForSegment(scope, stream, segmentId);
        return Controller.NodeUri.newBuilder().setEndpoint(host.getIpAddr()).setPort(host.getPort()).build();
    }

    public Controller.NodeUri getTableUri(String tableName) {
        Host host = this.hostStore.getHostForTableSegment(tableName);
        return Controller.NodeUri.newBuilder().setEndpoint(host.getIpAddr()).setPort(host.getPort()).build();
    }

    public CompletableFuture<Void> createSegment(String scope, String stream, long segmentId, ScalingPolicy policy, String controllerToken, long clientRequestId, long rolloverSizeBytes) {
        String qualifiedStreamSegmentName = NameUtils.getQualifiedStreamSegmentName((String)scope, (String)stream, (long)segmentId);
        Controller.NodeUri uri = this.getSegmentUri(scope, stream, segmentId);
        WireCommandType type = WireCommandType.CREATE_SEGMENT;
        RawClient connection = new RawClient(ModelHelper.encode((Controller.NodeUri)uri), this.connectionPool);
        long requestId = connection.getFlow().asLong();
        Pair<Byte, Integer> extracted = this.extractFromPolicy(policy);
        return this.sendRequest(connection, clientRequestId, new WireCommands.CreateSegment(requestId, qualifiedStreamSegmentName, ((Byte)extracted.getLeft()).byteValue(), ((Integer)extracted.getRight()).intValue(), controllerToken, rolloverSizeBytes)).thenAccept(r -> this.handleReply(clientRequestId, (Reply)r, connection, qualifiedStreamSegmentName, (Class<? extends Request>)WireCommands.CreateSegment.class, type));
    }

    public CompletableFuture<Void> truncateSegment(String scope, String stream, long segmentId, long offset, String delegationToken, long clientRequestId) {
        Controller.NodeUri uri = this.getSegmentUri(scope, stream, segmentId);
        String qualifiedStreamSegmentName = NameUtils.getQualifiedStreamSegmentName((String)scope, (String)stream, (long)segmentId);
        WireCommandType type = WireCommandType.TRUNCATE_SEGMENT;
        RawClient connection = new RawClient(ModelHelper.encode((Controller.NodeUri)uri), this.connectionPool);
        long requestId = connection.getFlow().asLong();
        return this.sendRequest(connection, clientRequestId, new WireCommands.TruncateSegment(requestId, qualifiedStreamSegmentName, offset, delegationToken)).thenAccept(r -> this.handleReply(clientRequestId, (Reply)r, connection, qualifiedStreamSegmentName, (Class<? extends Request>)WireCommands.TruncateSegment.class, type));
    }

    public CompletableFuture<Void> deleteSegment(String scope, String stream, long segmentId, String delegationToken, long clientRequestId) {
        Controller.NodeUri uri = this.getSegmentUri(scope, stream, segmentId);
        String qualifiedStreamSegmentName = NameUtils.getQualifiedStreamSegmentName((String)scope, (String)stream, (long)segmentId);
        WireCommandType type = WireCommandType.DELETE_SEGMENT;
        RawClient connection = new RawClient(ModelHelper.encode((Controller.NodeUri)uri), this.connectionPool);
        long requestId = connection.getFlow().asLong();
        return this.sendRequest(connection, clientRequestId, new WireCommands.DeleteSegment(requestId, qualifiedStreamSegmentName, delegationToken)).thenAccept(r -> this.handleReply(clientRequestId, (Reply)r, connection, qualifiedStreamSegmentName, (Class<? extends Request>)WireCommands.DeleteSegment.class, type));
    }

    public CompletableFuture<Void> sealSegment(String scope, String stream, long segmentId, String delegationToken, long clientRequestId) {
        Controller.NodeUri uri = this.getSegmentUri(scope, stream, segmentId);
        String qualifiedName = NameUtils.getQualifiedStreamSegmentName((String)scope, (String)stream, (long)segmentId);
        WireCommandType type = WireCommandType.SEAL_SEGMENT;
        RawClient connection = new RawClient(ModelHelper.encode((Controller.NodeUri)uri), this.connectionPool);
        long requestId = connection.getFlow().asLong();
        return this.sendRequest(connection, clientRequestId, new WireCommands.SealSegment(requestId, qualifiedName, delegationToken)).thenAccept(r -> this.handleReply(clientRequestId, (Reply)r, connection, qualifiedName, (Class<? extends Request>)WireCommands.SealSegment.class, type));
    }

    public CompletableFuture<Void> createTransaction(String scope, String stream, long segmentId, UUID txId, String delegationToken, long clientRequestId, long rolloverSizeBytes) {
        Controller.NodeUri uri = this.getSegmentUri(scope, stream, segmentId);
        String transactionName = this.getTransactionName(scope, stream, segmentId, txId);
        WireCommandType type = WireCommandType.CREATE_SEGMENT;
        RawClient connection = new RawClient(ModelHelper.encode((Controller.NodeUri)uri), this.connectionPool);
        long requestId = connection.getFlow().asLong();
        WireCommands.CreateSegment request = new WireCommands.CreateSegment(requestId, transactionName, WireCommands.CreateSegment.NO_SCALE, 0, delegationToken, rolloverSizeBytes);
        return this.sendRequest(connection, clientRequestId, request).thenAccept(r -> this.handleReply(clientRequestId, (Reply)r, connection, transactionName, (Class<? extends Request>)WireCommands.CreateSegment.class, type));
    }

    private String getTransactionName(String scope, String stream, long segmentId, UUID txId) {
        long generalizedSegmentId = RecordHelper.generalizedSegmentId(segmentId, txId);
        String qualifiedName = NameUtils.getQualifiedStreamSegmentName((String)scope, (String)stream, (long)generalizedSegmentId);
        return NameUtils.getTransactionNameFromId((String)qualifiedName, (UUID)txId);
    }

    public CompletableFuture<Long> commitTransaction(String scope, String stream, long targetSegmentId, long sourceSegmentId, UUID txId, String delegationToken, long clientRequestId) {
        Preconditions.checkArgument((NameUtils.getSegmentNumber((long)targetSegmentId) == NameUtils.getSegmentNumber((long)sourceSegmentId) ? 1 : 0) != 0);
        Controller.NodeUri uri = this.getSegmentUri(scope, stream, sourceSegmentId);
        String qualifiedNameTarget = NameUtils.getQualifiedStreamSegmentName((String)scope, (String)stream, (long)targetSegmentId);
        String transactionName = this.getTransactionName(scope, stream, sourceSegmentId, txId);
        WireCommandType type = WireCommandType.MERGE_SEGMENTS;
        RawClient connection = new RawClient(ModelHelper.encode((Controller.NodeUri)uri), this.connectionPool);
        long requestId = connection.getFlow().asLong();
        WireCommands.MergeSegments request = new WireCommands.MergeSegments(requestId, qualifiedNameTarget, transactionName, delegationToken);
        return this.sendRequest(connection, clientRequestId, request).thenCompose(r -> {
            this.handleReply(clientRequestId, (Reply)r, connection, transactionName, (Class<? extends Request>)WireCommands.MergeSegments.class, type);
            if (r instanceof WireCommands.NoSuchSegment) {
                WireCommands.NoSuchSegment reply = (WireCommands.NoSuchSegment)r;
                if (reply.getSegment().equals(transactionName)) {
                    return this.getSegmentInfo(scope, stream, targetSegmentId, delegationToken, clientRequestId).thenApply(WireCommands.StreamSegmentInfo::getWriteOffset);
                }
                log.warn(clientRequestId, "Commit Transaction: Source segment {} not found.", new Object[]{reply.getSegment()});
                return CompletableFuture.completedFuture(-1L);
            }
            return CompletableFuture.completedFuture(((WireCommands.SegmentsMerged)r).getNewTargetWriteOffset());
        });
    }

    public CompletableFuture<Controller.TxnStatus> abortTransaction(String scope, String stream, long segmentId, UUID txId, String delegationToken, long clientRequestId) {
        String transactionName = this.getTransactionName(scope, stream, segmentId, txId);
        Controller.NodeUri uri = this.getSegmentUri(scope, stream, segmentId);
        WireCommandType type = WireCommandType.DELETE_SEGMENT;
        RawClient connection = new RawClient(ModelHelper.encode((Controller.NodeUri)uri), this.connectionPool);
        long requestId = connection.getFlow().asLong();
        WireCommands.DeleteSegment request = new WireCommands.DeleteSegment(requestId, transactionName, delegationToken);
        return ((CompletableFuture)this.sendRequest(connection, clientRequestId, request).thenAccept(r -> this.handleReply(clientRequestId, (Reply)r, connection, transactionName, (Class<? extends Request>)WireCommands.DeleteSegment.class, type))).thenApply(v -> Controller.TxnStatus.newBuilder().setStatus(Controller.TxnStatus.Status.SUCCESS).build());
    }

    public CompletableFuture<Void> updatePolicy(String scope, String stream, ScalingPolicy policy, long segmentId, String delegationToken, long clientRequestId) {
        String qualifiedName = NameUtils.getQualifiedStreamSegmentName((String)scope, (String)stream, (long)segmentId);
        Controller.NodeUri uri = this.getSegmentUri(scope, stream, segmentId);
        WireCommandType type = WireCommandType.UPDATE_SEGMENT_POLICY;
        Pair<Byte, Integer> extracted = this.extractFromPolicy(policy);
        RawClient connection = new RawClient(ModelHelper.encode((Controller.NodeUri)uri), this.connectionPool);
        long requestId = connection.getFlow().asLong();
        WireCommands.UpdateSegmentPolicy request = new WireCommands.UpdateSegmentPolicy(requestId, qualifiedName, ((Byte)extracted.getLeft()).byteValue(), ((Integer)extracted.getRight()).intValue(), delegationToken);
        return this.sendRequest(connection, clientRequestId, request).thenAccept(r -> this.handleReply(clientRequestId, (Reply)r, connection, qualifiedName, (Class<? extends Request>)WireCommands.UpdateSegmentPolicy.class, type));
    }

    public CompletableFuture<WireCommands.StreamSegmentInfo> getSegmentInfo(String scope, String stream, long segmentId, String delegationToken, long clientRequestId) {
        String qualifiedName = NameUtils.getQualifiedStreamSegmentName((String)scope, (String)stream, (long)segmentId);
        Controller.NodeUri uri = this.getSegmentUri(scope, stream, segmentId);
        return this.getSegmentInfo(qualifiedName, ModelHelper.encode((Controller.NodeUri)uri), delegationToken, clientRequestId);
    }

    public CompletableFuture<WireCommands.StreamSegmentInfo> getSegmentInfo(String qualifiedName, PravegaNodeUri uri, String delegationToken, long clientRequestId) {
        WireCommandType type = WireCommandType.GET_STREAM_SEGMENT_INFO;
        RawClient connection = new RawClient(uri, this.connectionPool);
        long requestId = connection.getFlow().asLong();
        WireCommands.GetStreamSegmentInfo request = new WireCommands.GetStreamSegmentInfo(requestId, qualifiedName, delegationToken);
        return this.sendRequest(connection, clientRequestId, request).thenApply(r -> {
            this.handleReply(clientRequestId, (Reply)r, connection, qualifiedName, (Class<? extends Request>)WireCommands.GetStreamSegmentInfo.class, type);
            assert (r instanceof WireCommands.StreamSegmentInfo);
            return (WireCommands.StreamSegmentInfo)r;
        });
    }

    public CompletableFuture<Void> createTableSegment(String tableName, String delegationToken, long clientRequestId, boolean sortedTableSegment, int keyLength, long rolloverSizeBytes) {
        Controller.NodeUri uri = this.getTableUri(tableName);
        WireCommandType type = WireCommandType.CREATE_TABLE_SEGMENT;
        RawClient connection = new RawClient(ModelHelper.encode((Controller.NodeUri)uri), this.connectionPool);
        long requestId = connection.getFlow().asLong();
        return this.sendRequest(connection, clientRequestId, new WireCommands.CreateTableSegment(requestId, tableName, sortedTableSegment, keyLength, delegationToken, rolloverSizeBytes)).thenAccept(rpl -> this.handleReply(clientRequestId, (Reply)rpl, connection, tableName, (Class<? extends Request>)WireCommands.CreateTableSegment.class, type));
    }

    public CompletableFuture<Void> deleteTableSegment(String tableName, boolean mustBeEmpty, String delegationToken, long clientRequestId) {
        Controller.NodeUri uri = this.getTableUri(tableName);
        WireCommandType type = WireCommandType.DELETE_TABLE_SEGMENT;
        RawClient connection = new RawClient(ModelHelper.encode((Controller.NodeUri)uri), this.connectionPool);
        long requestId = connection.getFlow().asLong();
        return this.sendRequest(connection, clientRequestId, new WireCommands.DeleteTableSegment(requestId, tableName, mustBeEmpty, delegationToken)).thenAccept(rpl -> this.handleReply(clientRequestId, (Reply)rpl, connection, tableName, (Class<? extends Request>)WireCommands.DeleteTableSegment.class, type));
    }

    public CompletableFuture<List<TableSegmentKeyVersion>> updateTableEntries(String tableName, List<TableSegmentEntry> entries, String delegationToken, long clientRequestId) {
        return this.updateTableEntries(tableName, ModelHelper.encode((Controller.NodeUri)this.getTableUri(tableName)), entries, delegationToken, clientRequestId);
    }

    public CompletableFuture<List<TableSegmentKeyVersion>> updateTableEntries(String tableName, PravegaNodeUri uri, List<TableSegmentEntry> entries, String delegationToken, long clientRequestId) {
        WireCommandType type = WireCommandType.UPDATE_TABLE_ENTRIES;
        List wireCommandEntries = entries.stream().map(te -> {
            WireCommands.TableKey key = this.convertToWireCommand(te.getKey());
            WireCommands.TableValue value = new WireCommands.TableValue(te.getValue());
            return new AbstractMap.SimpleImmutableEntry<WireCommands.TableKey, WireCommands.TableValue>(key, value);
        }).collect(Collectors.toList());
        RawClient connection = new RawClient(uri, this.connectionPool);
        long requestId = connection.getFlow().asLong();
        WireCommands.UpdateTableEntries request = new WireCommands.UpdateTableEntries(requestId, tableName, delegationToken, new WireCommands.TableEntries(wireCommandEntries), -1L);
        return this.sendRequest(connection, clientRequestId, request).thenApply(rpl -> {
            this.handleReply(clientRequestId, (Reply)rpl, connection, tableName, (Class<? extends Request>)WireCommands.UpdateTableEntries.class, type);
            return ((WireCommands.TableEntriesUpdated)rpl).getUpdatedVersions().stream().map(TableSegmentKeyVersion::from).collect(Collectors.toList());
        });
    }

    public CompletableFuture<WireCommands.TableSegmentInfo> getTableSegmentInfo(String tableName, String delegationToken, long clientRequestId) {
        Controller.NodeUri uri = this.getTableUri(tableName);
        WireCommandType type = WireCommandType.GET_TABLE_SEGMENT_INFO;
        RawClient connection = new RawClient(ModelHelper.encode((Controller.NodeUri)uri), this.connectionPool);
        long requestId = connection.getFlow().asLong();
        return this.sendRequest(connection, clientRequestId, new WireCommands.GetTableSegmentInfo(requestId, tableName, delegationToken)).thenApply(r -> {
            this.handleReply(clientRequestId, (Reply)r, connection, tableName, (Class<? extends Request>)WireCommands.GetTableSegmentInfo.class, type);
            assert (r instanceof WireCommands.TableSegmentInfo);
            return (WireCommands.TableSegmentInfo)r;
        });
    }

    public CompletableFuture<Long> getTableSegmentEntryCount(String tableName, String delegationToken, long clientRequestId) {
        return this.getTableSegmentInfo(tableName, delegationToken, clientRequestId).thenApply(WireCommands.TableSegmentInfo::getEntryCount);
    }

    public CompletableFuture<Void> removeTableKeys(String tableName, List<TableSegmentKey> keys, String delegationToken, long clientRequestId) {
        Controller.NodeUri uri = this.getTableUri(tableName);
        WireCommandType type = WireCommandType.REMOVE_TABLE_KEYS;
        List keyList = keys.stream().map(x -> {
            WireCommands.TableKey key = this.convertToWireCommand((TableSegmentKey)x);
            return key;
        }).collect(Collectors.toList());
        RawClient connection = new RawClient(ModelHelper.encode((Controller.NodeUri)uri), this.connectionPool);
        long requestId = connection.getFlow().asLong();
        WireCommands.RemoveTableKeys request = new WireCommands.RemoveTableKeys(requestId, tableName, delegationToken, keyList, -1L);
        return this.sendRequest(connection, clientRequestId, request).thenAccept(rpl -> this.handleReply(clientRequestId, (Reply)rpl, connection, tableName, (Class<? extends Request>)WireCommands.RemoveTableKeys.class, type));
    }

    public CompletableFuture<List<TableSegmentEntry>> readTable(String tableName, List<TableSegmentKey> keys, String delegationToken, long clientRequestId) {
        return this.readTable(tableName, ModelHelper.encode((Controller.NodeUri)this.getTableUri(tableName)), keys, delegationToken, clientRequestId);
    }

    public CompletableFuture<List<TableSegmentEntry>> readTable(String tableName, PravegaNodeUri uri, List<TableSegmentKey> keys, String delegationToken, long clientRequestId) {
        WireCommandType type = WireCommandType.READ_TABLE;
        List keyList = keys.stream().map(k -> new WireCommands.TableKey(k.getKey(), k.getVersion().getSegmentVersion())).collect(Collectors.toList());
        RawClient connection = new RawClient(uri, this.connectionPool);
        long requestId = connection.getFlow().asLong();
        WireCommands.ReadTable request = new WireCommands.ReadTable(requestId, tableName, delegationToken, keyList);
        return this.sendRequest(connection, clientRequestId, request).thenApply(rpl -> {
            this.handleReply(clientRequestId, (Reply)rpl, connection, tableName, (Class<? extends Request>)WireCommands.ReadTable.class, type);
            return ((WireCommands.TableRead)rpl).getEntries().getEntries().stream().map(this::convertFromWireCommand).collect(Collectors.toList());
        });
    }

    public CompletableFuture<HashTableIteratorItem<TableSegmentKey>> readTableKeys(String tableName, int suggestedKeyCount, HashTableIteratorItem.State state, String delegationToken, long clientRequestId) {
        Controller.NodeUri uri = this.getTableUri(tableName);
        WireCommandType type = WireCommandType.READ_TABLE_KEYS;
        RawClient connection = new RawClient(ModelHelper.encode((Controller.NodeUri)uri), this.connectionPool);
        long requestId = connection.getFlow().asLong();
        HashTableIteratorItem.State token = state == null ? HashTableIteratorItem.State.EMPTY : state;
        WireCommands.TableIteratorArgs args = new WireCommands.TableIteratorArgs(token.getToken(), Unpooled.EMPTY_BUFFER, Unpooled.EMPTY_BUFFER, Unpooled.EMPTY_BUFFER);
        WireCommands.ReadTableKeys request = new WireCommands.ReadTableKeys(requestId, tableName, delegationToken, suggestedKeyCount, args);
        return this.sendRequest(connection, clientRequestId, request).thenApply(rpl -> {
            this.handleReply(clientRequestId, (Reply)rpl, connection, tableName, (Class<? extends Request>)WireCommands.ReadTableKeys.class, type);
            WireCommands.TableKeysRead tableKeysRead = (WireCommands.TableKeysRead)rpl;
            HashTableIteratorItem.State newState = HashTableIteratorItem.State.fromBytes((ByteBuf)tableKeysRead.getContinuationToken());
            List keys = tableKeysRead.getKeys().stream().map(k -> TableSegmentKey.versioned((ByteBuf)k.getData(), (long)k.getKeyVersion())).collect(Collectors.toList());
            return new HashTableIteratorItem(newState, keys);
        });
    }

    public CompletableFuture<HashTableIteratorItem<TableSegmentEntry>> readTableEntries(String tableName, int suggestedEntryCount, HashTableIteratorItem.State state, String delegationToken, long clientRequestId) {
        return this.readTableEntries(tableName, ModelHelper.encode((Controller.NodeUri)this.getTableUri(tableName)), suggestedEntryCount, state, delegationToken, clientRequestId);
    }

    public CompletableFuture<HashTableIteratorItem<TableSegmentEntry>> readTableEntries(String tableName, PravegaNodeUri uri, int suggestedEntryCount, HashTableIteratorItem.State state, String delegationToken, long clientRequestId) {
        WireCommandType type = WireCommandType.READ_TABLE_ENTRIES;
        RawClient connection = new RawClient(uri, this.connectionPool);
        long requestId = connection.getFlow().asLong();
        HashTableIteratorItem.State token = state == null ? HashTableIteratorItem.State.EMPTY : state;
        WireCommands.TableIteratorArgs args = new WireCommands.TableIteratorArgs(token.getToken(), Unpooled.EMPTY_BUFFER, Unpooled.EMPTY_BUFFER, Unpooled.EMPTY_BUFFER);
        WireCommands.ReadTableEntries request = new WireCommands.ReadTableEntries(requestId, tableName, delegationToken, suggestedEntryCount, args);
        return this.sendRequest(connection, clientRequestId, request).thenApply(rpl -> {
            this.handleReply(clientRequestId, (Reply)rpl, connection, tableName, (Class<? extends Request>)WireCommands.ReadTableEntries.class, type);
            WireCommands.TableEntriesRead tableEntriesRead = (WireCommands.TableEntriesRead)rpl;
            HashTableIteratorItem.State newState = HashTableIteratorItem.State.fromBytes((ByteBuf)tableEntriesRead.getContinuationToken());
            List entries = tableEntriesRead.getEntries().getEntries().stream().map(e -> {
                WireCommands.TableKey k = (WireCommands.TableKey)e.getKey();
                return TableSegmentEntry.versioned((ByteBuf)k.getData(), (ByteBuf)((WireCommands.TableValue)e.getValue()).getData(), (long)k.getKeyVersion());
            }).collect(Collectors.toList());
            return new HashTableIteratorItem(newState, entries);
        });
    }

    public CompletableFuture<WireCommands.SegmentRead> readSegment(String qualifiedName, long offset, int length, PravegaNodeUri uri, String delegationToken) {
        WireCommandType type = WireCommandType.READ_SEGMENT;
        RawClient connection = new RawClient(uri, this.connectionPool);
        long requestId = connection.getFlow().asLong();
        WireCommands.ReadSegment request = new WireCommands.ReadSegment(qualifiedName, offset, length, delegationToken, requestId);
        return this.sendRequest(connection, requestId, request).thenApply(r -> {
            this.handleReply(requestId, (Reply)r, connection, qualifiedName, (Class<? extends Request>)WireCommands.ReadSegment.class, type);
            assert (r instanceof WireCommands.SegmentRead);
            return (WireCommands.SegmentRead)r;
        });
    }

    public CompletableFuture<WireCommands.SegmentAttribute> getSegmentAttribute(String qualifiedName, UUID attributeId, PravegaNodeUri uri, String delegationToken) {
        WireCommandType type = WireCommandType.GET_SEGMENT_ATTRIBUTE;
        RawClient connection = new RawClient(uri, this.connectionPool);
        long requestId = connection.getFlow().asLong();
        WireCommands.GetSegmentAttribute request = new WireCommands.GetSegmentAttribute(requestId, qualifiedName, attributeId, delegationToken);
        return this.sendRequest(connection, requestId, request).thenApply(r -> {
            this.handleReply(requestId, (Reply)r, connection, qualifiedName, (Class<? extends Request>)WireCommands.GetSegmentAttribute.class, type);
            assert (r instanceof WireCommands.SegmentAttribute);
            return (WireCommands.SegmentAttribute)r;
        });
    }

    public CompletableFuture<WireCommands.SegmentAttributeUpdated> updateSegmentAttribute(String qualifiedName, UUID attributeId, long newValue, long existingValue, PravegaNodeUri uri, String delegationToken) {
        WireCommandType type = WireCommandType.UPDATE_SEGMENT_ATTRIBUTE;
        RawClient connection = new RawClient(uri, this.connectionPool);
        long requestId = connection.getFlow().asLong();
        WireCommands.UpdateSegmentAttribute request = new WireCommands.UpdateSegmentAttribute(requestId, qualifiedName, attributeId, newValue, existingValue, delegationToken);
        return this.sendRequest(connection, requestId, request).thenApply(r -> {
            this.handleReply(requestId, (Reply)r, connection, qualifiedName, (Class<? extends Request>)WireCommands.UpdateSegmentAttribute.class, type);
            assert (r instanceof WireCommands.SegmentAttributeUpdated);
            return (WireCommands.SegmentAttributeUpdated)r;
        });
    }

    private WireCommands.TableKey convertToWireCommand(TableSegmentKey k) {
        WireCommands.TableKey key = k.getVersion() == null ? new WireCommands.TableKey(k.getKey(), Long.MIN_VALUE) : new WireCommands.TableKey(k.getKey(), k.getVersion().getSegmentVersion());
        return key;
    }

    private TableSegmentEntry convertFromWireCommand(Map.Entry<WireCommands.TableKey, WireCommands.TableValue> e) {
        if (e.getKey().getKeyVersion() == -1L) {
            return TableSegmentEntry.notExists((ByteBuf)e.getKey().getData(), (ByteBuf)e.getValue().getData());
        }
        return TableSegmentEntry.versioned((ByteBuf)e.getKey().getData(), (ByteBuf)e.getValue().getData(), (long)e.getKey().getKeyVersion());
    }

    private Pair<Byte, Integer> extractFromPolicy(ScalingPolicy policy) {
        byte rateType;
        int desiredRate;
        if (policy.getScaleType().equals((Object)ScalingPolicy.ScaleType.FIXED_NUM_SEGMENTS)) {
            desiredRate = 0;
            rateType = WireCommands.CreateSegment.NO_SCALE;
        } else {
            desiredRate = Math.toIntExact(policy.getTargetRate());
            rateType = policy.getScaleType().equals((Object)ScalingPolicy.ScaleType.BY_RATE_IN_KBYTES_PER_SEC) ? WireCommands.CreateSegment.IN_KBYTES_PER_SEC : WireCommands.CreateSegment.IN_EVENTS_PER_SEC;
        }
        return new ImmutablePair((Object)rateType, (Object)desiredRate);
    }

    private void closeConnection(Reply reply, RawClient client, long callerRequestId) {
        log.debug(callerRequestId, "Closing connection as a result of receiving: flowId: {}: reply: {}", new Object[]{reply.getRequestId(), reply});
        if (client != null) {
            try {
                client.close();
            }
            catch (Exception e) {
                log.warn(callerRequestId, "Exception tearing down connection: ", new Object[]{e});
            }
        }
    }

    protected <T extends Request & WireCommand> CompletableFuture<Reply> sendRequest(RawClient connection, long clientRequestId, T request) {
        log.trace(clientRequestId, "Sending request to segment store with: flowId: {}: request: {}", new Object[]{request.getRequestId(), request});
        CompletableFuture future = Futures.futureWithTimeout(() -> connection.sendRequest(request.getRequestId(), request), (Duration)this.timeout.get(), (String)"request", (ScheduledExecutorService)this.executorService);
        return future.exceptionally(e -> {
            this.processAndRethrowException(clientRequestId, request, (Throwable)e);
            return null;
        });
    }

    @VisibleForTesting
    <T extends Request & WireCommand> void processAndRethrowException(long callerRequestId, T request, Throwable e) {
        Throwable unwrap = Exceptions.unwrap((Throwable)e);
        Object ex = null;
        if (unwrap instanceof ConnectionFailedException || unwrap instanceof ConnectionClosedException) {
            log.warn(callerRequestId, "Connection dropped {}", new Object[]{request.getRequestId()});
            throw new WireCommandFailedException(((WireCommand)request).getType(), WireCommandFailedException.Reason.ConnectionFailed);
        }
        if (unwrap instanceof AuthenticationException) {
            log.warn(callerRequestId, "Authentication Exception {}", new Object[]{request.getRequestId()});
            throw new WireCommandFailedException(((WireCommand)request).getType(), WireCommandFailedException.Reason.AuthFailed);
        }
        if (unwrap instanceof TokenExpiredException) {
            log.warn(callerRequestId, "Token expired {}", new Object[]{request.getRequestId()});
            throw new WireCommandFailedException(((WireCommand)request).getType(), WireCommandFailedException.Reason.AuthFailed);
        }
        if (unwrap instanceof TimeoutException) {
            log.warn(callerRequestId, "Request timed out. {}", new Object[]{request.getRequestId()});
            throw new WireCommandFailedException(((WireCommand)request).getType(), WireCommandFailedException.Reason.ConnectionFailed);
        }
        log.error(callerRequestId, "Request failed {}", new Object[]{request.getRequestId(), e});
        throw new CompletionException(e);
    }

    private void handleReply(long callerRequestId, Reply reply, RawClient client, String qualifiedStreamSegmentName, Class<? extends Request> requestType, WireCommandType type) {
        this.handleExpectedReplies(callerRequestId, reply, client, qualifiedStreamSegmentName, requestType, type, EXPECTED_SUCCESS_REPLIES, EXPECTED_FAILING_REPLIES);
    }

    protected void handleExpectedReplies(long callerRequestId, Reply reply, RawClient client, String qualifiedStreamSegmentName, Class<? extends Request> requestType, WireCommandType type, Map<Class<? extends Request>, Set<Class<? extends Reply>>> expectedSuccessReplies, Map<Class<? extends Request>, Set<Class<? extends Reply>>> expectedFailureReplies) throws ConnectionFailedException {
        this.closeConnection(reply, client, callerRequestId);
        Set<Class<? extends Reply>> expectedReplies = expectedSuccessReplies.get(requestType);
        Set<Class<? extends Reply>> expectedFailingReplies = expectedFailureReplies.get(requestType);
        if (expectedReplies != null && expectedReplies.contains(reply.getClass())) {
            log.debug(callerRequestId, "{} {} {} {}.", new Object[]{requestType.getSimpleName(), qualifiedStreamSegmentName, reply.getClass().getSimpleName(), reply.getRequestId()});
        } else if (expectedFailingReplies != null && expectedFailingReplies.contains(reply.getClass())) {
            log.debug(callerRequestId, "{} {} {} {}.", new Object[]{requestType.getSimpleName(), qualifiedStreamSegmentName, reply.getClass().getSimpleName(), reply.getRequestId()});
            if (reply instanceof WireCommands.NoSuchSegment) {
                throw new WireCommandFailedException(type, WireCommandFailedException.Reason.SegmentDoesNotExist);
            }
            if (reply instanceof WireCommands.TableSegmentNotEmpty) {
                throw new WireCommandFailedException(type, WireCommandFailedException.Reason.TableSegmentNotEmpty);
            }
            if (reply instanceof WireCommands.TableKeyDoesNotExist) {
                throw new WireCommandFailedException(type, WireCommandFailedException.Reason.TableKeyDoesNotExist);
            }
            if (reply instanceof WireCommands.TableKeyBadVersion) {
                throw new WireCommandFailedException(type, WireCommandFailedException.Reason.TableKeyBadVersion);
            }
        } else {
            if (reply instanceof WireCommands.AuthTokenCheckFailed) {
                log.warn(callerRequestId, "Auth Check Failed {} {} {} {} with error code {}.", new Object[]{requestType.getSimpleName(), qualifiedStreamSegmentName, reply.getClass().getSimpleName(), reply.getRequestId(), ((WireCommands.AuthTokenCheckFailed)reply).getErrorCode()});
                throw new WireCommandFailedException(new AuthenticationException(reply.toString()), type, WireCommandFailedException.Reason.AuthFailed);
            }
            if (reply instanceof WireCommands.WrongHost) {
                log.warn(callerRequestId, "Wrong Host {} {} {} {}.", new Object[]{requestType.getSimpleName(), qualifiedStreamSegmentName, reply.getClass().getSimpleName(), reply.getRequestId()});
                throw new WireCommandFailedException(type, WireCommandFailedException.Reason.UnknownHost);
            }
            log.error(callerRequestId, "Unexpected reply {} {} {} {}.", new Object[]{requestType.getSimpleName(), qualifiedStreamSegmentName, reply.getClass().getSimpleName(), reply.getRequestId()});
            throw new ConnectionFailedException("Unexpected reply of " + reply + " when expecting one of " + expectedReplies.stream().map(Object::toString).collect(Collectors.joining(", ")));
        }
    }

    @Override
    public void close() {
        this.connectionPool.close();
    }
}

