/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.bucket;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.Service;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.server.bucket.BucketService;
import io.pravega.controller.store.stream.BucketStore;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BucketManager
extends AbstractService {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BucketManager.class);
    private final String processId;
    private final BucketStore.ServiceType serviceType;
    private final Function<Integer, BucketService> bucketServiceSupplier;
    private final Object lock;
    @GuardedBy(value="lock")
    private final Map<Integer, BucketService> buckets;
    private final ScheduledExecutorService executor;

    BucketManager(String processId, BucketStore.ServiceType serviceType, ScheduledExecutorService executor, Function<Integer, BucketService> bucketServiceSupplier) {
        this.processId = processId;
        this.serviceType = serviceType;
        this.executor = executor;
        this.lock = new Object();
        this.buckets = new HashMap<Integer, BucketService>();
        this.bucketServiceSupplier = bucketServiceSupplier;
    }

    protected void doStart() {
        ((CompletableFuture)((CompletableFuture)this.initializeService().thenCompose(s -> Futures.allOf((Collection)IntStream.range(0, this.getBucketCount()).boxed().map(x -> this.initializeBucket((int)x).thenCompose(v -> this.tryTakeOwnership((int)x))).collect(Collectors.toList())))).thenAccept(x -> this.startBucketOwnershipListener())).whenComplete((r, e) -> {
            if (e != null) {
                this.notifyFailed((Throwable)e);
            } else {
                this.notifyStarted();
            }
        });
    }

    protected abstract int getBucketCount();

    public abstract boolean isHealthy();

    CompletableFuture<Void> tryTakeOwnership(int bucket) {
        return this.takeBucketOwnership(bucket, this.processId, this.executor).thenCompose(isOwner -> {
            if (isOwner.booleanValue()) {
                log.info("{}: Taken ownership for bucket {}", (Object)this.serviceType, (Object)bucket);
                CompletableFuture<Void> bucketFuture = new CompletableFuture<Void>();
                Object object = this.lock;
                synchronized (object) {
                    if (this.buckets.containsKey(bucket)) {
                        bucketFuture.complete(null);
                    } else {
                        BucketService bucketService = this.startNewBucketService(bucket, bucketFuture);
                        this.buckets.put(bucket, bucketService);
                    }
                }
                return bucketFuture;
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private BucketService startNewBucketService(final int bucket, final CompletableFuture<Void> bucketFuture) {
        BucketService bucketService = this.bucketServiceSupplier.apply(bucket);
        bucketService.addListener(new Service.Listener(){

            public void running() {
                super.running();
                log.info("{}: successfully started bucket service bucket: {} ", (Object)BucketManager.this.serviceType, (Object)bucket);
                bucketFuture.complete(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed(Service.State from, Throwable failure) {
                super.failed(from, failure);
                log.error("{}: Failed to start bucket: {} ", (Object)BucketManager.this.serviceType, (Object)bucket);
                Object object = BucketManager.this.lock;
                synchronized (object) {
                    BucketManager.this.buckets.remove(bucket);
                }
                bucketFuture.completeExceptionally(failure);
            }
        }, this.executor);
        bucketService.startAsync();
        return bucketService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        Collection<BucketService> tmp;
        log.info("{}: Stop request received for bucket manager", (Object)this.serviceType);
        Object object = this.lock;
        synchronized (object) {
            tmp = this.buckets.values();
        }
        Futures.allOf((Collection)tmp.stream().map(bucketService -> {
            final CompletableFuture bucketFuture = new CompletableFuture();
            bucketService.addListener(new Service.Listener(){

                public void terminated(Service.State from) {
                    super.terminated(from);
                    bucketFuture.complete(null);
                }

                public void failed(Service.State from, Throwable failure) {
                    super.failed(from, failure);
                    bucketFuture.completeExceptionally(failure);
                }
            }, this.executor);
            bucketService.stopAsync();
            return bucketFuture;
        }).collect(Collectors.toList())).whenComplete((r, e) -> {
            this.stopBucketOwnershipListener();
            if (e != null) {
                log.error("{}: bucket service shutdown failed with exception", (Object)this.serviceType, e);
                this.notifyFailed((Throwable)e);
            } else {
                log.info("{}: bucket service stopped", (Object)this.serviceType);
                this.notifyStopped();
            }
        });
    }

    abstract void startBucketOwnershipListener();

    abstract void stopBucketOwnershipListener();

    abstract CompletableFuture<Void> initializeService();

    abstract CompletableFuture<Void> initializeBucket(int var1);

    abstract CompletableFuture<Boolean> takeBucketOwnership(int var1, String var2, Executor var3);

    @VisibleForTesting
    Map<Integer, BucketService> getBucketServices() {
        return Collections.unmodifiableMap(this.buckets);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected BucketStore.ServiceType getServiceType() {
        return this.serviceType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected ScheduledExecutorService getExecutor() {
        return this.executor;
    }
}

