/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.bucket;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.controller.server.bucket.BucketService;
import io.pravega.controller.server.bucket.BucketWork;
import io.pravega.controller.store.stream.BucketStore;
import io.pravega.controller.store.stream.InMemoryBucketStore;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryBucketService
extends BucketService {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryBucketService.class);
    private final InMemoryBucketStore bucketStore;

    InMemoryBucketService(BucketStore.ServiceType serviceType, int bucketId, InMemoryBucketStore bucketStore, ScheduledExecutorService executor, int maxConcurrentExecutions, Duration executionDuration, BucketWork bucketWork) {
        super(serviceType, bucketId, executor, maxConcurrentExecutions, executionDuration, bucketWork);
        this.bucketStore = bucketStore;
    }

    @Override
    public void startBucketChangeListener() {
        this.bucketStore.registerBucketChangeListener(this.getServiceType(), this.getBucketId(), (x, y, z) -> {
            if (z) {
                this.notify(new BucketService.StreamNotification(x, y, BucketService.NotificationType.StreamAdded));
            } else {
                this.notify(new BucketService.StreamNotification(x, y, BucketService.NotificationType.StreamRemoved));
            }
        });
    }

    @Override
    public void stopBucketChangeListener() {
        this.bucketStore.unregisterBucketChangeListener(this.getServiceType(), this.getBucketId());
    }
}

