/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.bucket;

import io.pravega.client.stream.Stream;
import io.pravega.common.hash.RandomFactory;
import io.pravega.common.tracing.RequestTracker;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.task.Stream.StreamMetadataTasks;
import io.pravega.controller.util.RetryHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.slf4j.LoggerFactory;

public class PeriodicRetention {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(PeriodicRetention.class));
    private final StreamMetadataTasks streamMetadataTasks;
    private final StreamMetadataStore streamMetadataStore;
    private final ScheduledExecutorService executor;
    private final RequestTracker requestTracker;
    private final Supplier<Long> requestIdGenerator = RandomFactory.create()::nextLong;

    public PeriodicRetention(StreamMetadataStore streamMetadataStore, StreamMetadataTasks streamMetadataTasks, ScheduledExecutorService executor, RequestTracker requestTracker) {
        this.streamMetadataTasks = streamMetadataTasks;
        this.streamMetadataStore = streamMetadataStore;
        this.executor = executor;
        this.requestTracker = requestTracker;
    }

    public CompletableFuture<Void> retention(Stream stream) {
        long requestId = this.requestIdGenerator.get();
        String requestDescriptor = RequestTracker.buildRequestDescriptor((String[])new String[]{"truncateStream", stream.getScope(), stream.getStreamName()});
        this.requestTracker.trackRequest(requestDescriptor, requestId);
        OperationContext context = this.streamMetadataStore.createStreamContext(stream.getScope(), stream.getStreamName(), requestId);
        log.debug(requestId, "Periodic background processing for retention called for stream {}/{}", new Object[]{stream.getScope(), stream.getStreamName()});
        return ((CompletableFuture)RetryHelper.withRetriesAsync(() -> ((CompletableFuture)this.streamMetadataStore.getConfiguration(stream.getScope(), stream.getStreamName(), context, this.executor).thenCompose(config -> this.streamMetadataTasks.retention(stream.getScope(), stream.getStreamName(), config.getRetentionPolicy(), System.currentTimeMillis(), context, this.streamMetadataTasks.retrieveDelegationToken()))).exceptionally(e -> {
            log.warn(requestId, "Exception thrown while performing auto retention for stream {} ", new Object[]{stream, e});
            throw new CompletionException((Throwable)e);
        }), RetryHelper.UNCONDITIONAL_PREDICATE, 5, this.executor).exceptionally(e -> {
            log.warn(requestId, "Unable to perform retention for stream {}. Ignoring, retention will be attempted in next cycle.", new Object[]{stream, e});
            return null;
        })).thenRun(() -> this.requestTracker.untrackRequest(requestDescriptor));
    }
}

