/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.bucket;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.controller.server.bucket.BucketManager;
import io.pravega.controller.server.bucket.BucketService;
import io.pravega.controller.store.stream.BucketStore;
import io.pravega.controller.store.stream.ZookeeperBucketStore;
import io.pravega.controller.util.RetryHelper;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import lombok.Generated;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.utils.ZKPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperBucketManager
extends BucketManager {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperBucketManager.class);
    private final ZookeeperBucketStore bucketStore;
    private final ConcurrentMap<BucketStore.ServiceType, PathChildrenCache> bucketOwnershipCacheMap = new ConcurrentHashMap<BucketStore.ServiceType, PathChildrenCache>();

    ZooKeeperBucketManager(String processId, ZookeeperBucketStore bucketStore, BucketStore.ServiceType serviceType, ScheduledExecutorService executor, Function<Integer, BucketService> bucketServiceSupplier) {
        super(processId, serviceType, executor, bucketServiceSupplier);
        this.bucketStore = bucketStore;
    }

    @Override
    public boolean isHealthy() {
        return this.bucketStore.isZKConnected();
    }

    @Override
    protected int getBucketCount() {
        return this.bucketStore.getBucketCount(this.getServiceType());
    }

    @Override
    public void startBucketOwnershipListener() {
        PathChildrenCache pathChildrenCache = this.bucketOwnershipCacheMap.computeIfAbsent(this.getServiceType(), x -> this.bucketStore.getServiceOwnershipPathChildrenCache(this.getServiceType()));
        PathChildrenCacheListener bucketListener = (client, event) -> {
            switch (event.getType()) {
                case CHILD_ADDED: {
                    break;
                }
                case CHILD_REMOVED: {
                    int bucketId = Integer.parseInt(ZKPaths.getNodeFromPath((String)event.getData().getPath()));
                    RetryHelper.withIndefiniteRetriesAsync(() -> this.tryTakeOwnership(bucketId), e -> log.warn("{}: exception while attempting to take ownership for bucket {}: {}", new Object[]{this.getServiceType(), bucketId, e.getMessage()}), this.getExecutor());
                    break;
                }
                case CONNECTION_LOST: {
                    log.warn("{}: Received connectivity error", (Object)this.getServiceType());
                    break;
                }
                default: {
                    log.warn("Received unknown event {} on bucket root {} ", (Object)event.getType(), (Object)this.getServiceType());
                }
            }
        };
        pathChildrenCache.getListenable().addListener((Object)bucketListener);
        log.info("bucket ownership listener registered on bucket root {}", (Object)this.getServiceType());
        try {
            pathChildrenCache.start(PathChildrenCache.StartMode.NORMAL);
        }
        catch (Exception e) {
            log.error("Starting ownership listener for service {} threw exception", (Object)this.getServiceType(), (Object)e);
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    @Override
    public void stopBucketOwnershipListener() {
        PathChildrenCache pathChildrenCache = (PathChildrenCache)this.bucketOwnershipCacheMap.remove((Object)this.getServiceType());
        if (pathChildrenCache != null) {
            try {
                pathChildrenCache.clear();
                pathChildrenCache.close();
            }
            catch (IOException e) {
                log.warn("unable to close listener for bucket ownership", (Throwable)e);
            }
        }
    }

    @Override
    public CompletableFuture<Void> initializeService() {
        return this.bucketStore.createBucketsRoot(this.getServiceType());
    }

    @Override
    public CompletableFuture<Void> initializeBucket(int bucket) {
        Preconditions.checkArgument((bucket < this.bucketStore.getBucketCount(this.getServiceType()) ? 1 : 0) != 0);
        return this.bucketStore.createBucket(this.getServiceType(), bucket);
    }

    @Override
    public CompletableFuture<Boolean> takeBucketOwnership(int bucket, String processId, Executor executor) {
        Preconditions.checkArgument((bucket < this.bucketStore.getBucketCount(this.getServiceType()) ? 1 : 0) != 0);
        return this.bucketStore.takeBucketOwnership(this.getServiceType(), bucket, processId);
    }
}

