/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.bucket;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.impl.StreamImpl;
import io.pravega.common.Exceptions;
import io.pravega.controller.server.bucket.BucketService;
import io.pravega.controller.server.bucket.BucketWork;
import io.pravega.controller.store.stream.BucketStore;
import io.pravega.controller.store.stream.ZookeeperBucketStore;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperBucketService
extends BucketService {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperBucketService.class);
    private final ZookeeperBucketStore bucketStore;
    private final AtomicReference<PathChildrenCache> cacheRef;

    ZooKeeperBucketService(BucketStore.ServiceType serviceType, int bucketId, ZookeeperBucketStore bucketStore, ScheduledExecutorService executor, int maxConcurrentExecutions, Duration executionPeriod, BucketWork bucketWork) {
        super(serviceType, bucketId, executor, maxConcurrentExecutions, executionPeriod, bucketWork);
        this.bucketStore = bucketStore;
        this.cacheRef = new AtomicReference();
    }

    @Override
    public void startBucketChangeListener() {
        PathChildrenCacheListener bucketListener = (client, event) -> {
            switch (event.getType()) {
                case CHILD_ADDED: 
                case CHILD_UPDATED: {
                    StreamImpl stream = this.bucketStore.getStreamFromPath(event.getData().getPath());
                    this.notify(new BucketService.StreamNotification(stream.getScope(), stream.getStreamName(), BucketService.NotificationType.StreamAdded));
                    break;
                }
                case CHILD_REMOVED: {
                    StreamImpl stream = this.bucketStore.getStreamFromPath(event.getData().getPath());
                    this.notify(new BucketService.StreamNotification(stream.getScope(), stream.getStreamName(), BucketService.NotificationType.StreamRemoved));
                    break;
                }
                case CONNECTION_LOST: {
                    this.notify(new BucketService.StreamNotification(null, null, BucketService.NotificationType.ConnectivityError));
                    break;
                }
                default: {
                    log.warn("Received unknown event {} on bucket", (Object)event.getType(), (Object)this.getBucketId());
                }
            }
        };
        PathChildrenCache pathChildrenCache = this.cacheRef.updateAndGet(existing -> {
            if (existing == null) {
                PathChildrenCache cache = this.bucketStore.getBucketPathChildrenCache(this.getServiceType(), this.getBucketId());
                cache.getListenable().addListener((Object)bucketListener);
                log.info("bucket {} change notification listener registered", (Object)this.getBucketId());
                return cache;
            }
            return existing;
        });
        try {
            pathChildrenCache.start(PathChildrenCache.StartMode.NORMAL);
        }
        catch (Exception e) {
            log.error("{}: Starting listener on bucket {} threw exception", new Object[]{this.getServiceType(), this.getBucketId(), e});
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    @Override
    public void stopBucketChangeListener() {
        this.cacheRef.updateAndGet(cache -> {
            if (cache != null) {
                try {
                    cache.clear();
                    cache.close();
                }
                catch (IOException e) {
                    log.warn("{}: unable to close watch on bucket {}. Exception thrown ", new Object[]{this.getServiceType(), this.getBucketId(), e});
                    throw Exceptions.sneakyThrow((Throwable)e);
                }
            }
            return null;
        });
    }
}

