/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractIdleService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.EventStreamClientFactory;
import io.pravega.client.admin.ReaderGroupManager;
import io.pravega.client.admin.impl.ReaderGroupManagerImpl;
import io.pravega.client.connection.impl.ConnectionPool;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.Position;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.stream.impl.AbstractClientFactoryImpl;
import io.pravega.client.stream.impl.ClientFactoryImpl;
import io.pravega.client.stream.impl.PositionImpl;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.concurrent.ExecutorServiceHelpers;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.Retry;
import io.pravega.controller.eventProcessor.CheckpointConfig;
import io.pravega.controller.eventProcessor.EventProcessorConfig;
import io.pravega.controller.eventProcessor.EventProcessorGroup;
import io.pravega.controller.eventProcessor.EventProcessorSystem;
import io.pravega.controller.eventProcessor.EventSerializer;
import io.pravega.controller.eventProcessor.ExceptionHandler;
import io.pravega.controller.eventProcessor.impl.ConcurrentEventProcessor;
import io.pravega.controller.eventProcessor.impl.EventProcessorGroupConfigImpl;
import io.pravega.controller.eventProcessor.impl.EventProcessorSystemImpl;
import io.pravega.controller.fault.FailoverSweeper;
import io.pravega.controller.server.eventProcessor.ControllerEventProcessorConfig;
import io.pravega.controller.server.eventProcessor.requesthandlers.AbortRequestHandler;
import io.pravega.controller.server.eventProcessor.requesthandlers.AutoScaleTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.CommitRequestHandler;
import io.pravega.controller.server.eventProcessor.requesthandlers.CreateReaderGroupTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.DeleteReaderGroupTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.DeleteStreamTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.ScaleOperationTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.SealStreamTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.StreamRequestHandler;
import io.pravega.controller.server.eventProcessor.requesthandlers.TruncateStreamTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.UpdateReaderGroupTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.UpdateStreamTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.kvtable.CreateTableTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.kvtable.DeleteTableTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.kvtable.TableRequestHandler;
import io.pravega.controller.store.checkpoint.CheckpointStore;
import io.pravega.controller.store.checkpoint.CheckpointStoreException;
import io.pravega.controller.store.kvtable.KVTableMetadataStore;
import io.pravega.controller.store.stream.BucketStore;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.task.KeyValueTable.TableMetadataTasks;
import io.pravega.controller.task.Stream.StreamMetadataTasks;
import io.pravega.controller.task.Stream.StreamTransactionMetadataTasks;
import io.pravega.controller.util.Config;
import io.pravega.controller.util.RetryHelper;
import io.pravega.shared.controller.event.AbortEvent;
import io.pravega.shared.controller.event.CommitEvent;
import io.pravega.shared.controller.event.ControllerEvent;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerEventProcessors
extends AbstractIdleService
implements FailoverSweeper,
AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ControllerEventProcessors.class);
    public static final EventSerializer<CommitEvent> COMMIT_EVENT_SERIALIZER = new EventSerializer();
    public static final EventSerializer<AbortEvent> ABORT_EVENT_SERIALIZER = new EventSerializer();
    public static final EventSerializer<ControllerEvent> CONTROLLER_EVENT_SERIALIZER = new EventSerializer();
    private static final long DELAY = 100L;
    private static final int MULTIPLIER = 10;
    private static final long MAX_DELAY = 10000L;
    private static final long TRUNCATION_INTERVAL_MILLIS = Duration.ofMinutes(10L).toMillis();
    private final String objectId;
    private final ControllerEventProcessorConfig config;
    private final CheckpointStore checkpointStore;
    private final EventProcessorSystem system;
    private final Controller controller;
    private final ClientFactoryImpl clientFactory;
    private final ScheduledExecutorService executor;
    private EventProcessorGroup<CommitEvent> commitEventProcessors;
    private EventProcessorGroup<AbortEvent> abortEventProcessors;
    private EventProcessorGroup<ControllerEvent> requestEventProcessors;
    private EventProcessorGroup<ControllerEvent> kvtRequestEventProcessors;
    private final StreamRequestHandler streamRequestHandler;
    private final CommitRequestHandler commitRequestHandler;
    private final AbortRequestHandler abortRequestHandler;
    private final TableRequestHandler kvtRequestHandler;
    private final long rebalanceIntervalMillis;
    private final AtomicLong truncationInterval;
    private ScheduledExecutorService rebalanceExecutor;
    private final AtomicBoolean bootstrapCompleted = new AtomicBoolean(false);

    public ControllerEventProcessors(String host, ControllerEventProcessorConfig config, Controller controller, CheckpointStore checkpointStore, StreamMetadataStore streamMetadataStore, BucketStore bucketStore, ConnectionPool connectionPool, StreamMetadataTasks streamMetadataTasks, StreamTransactionMetadataTasks streamTransactionMetadataTasks, KVTableMetadataStore kvtMetadataStore, TableMetadataTasks kvtMetadataTasks, ScheduledExecutorService executor) {
        this(host, config, controller, checkpointStore, streamMetadataStore, bucketStore, connectionPool, streamMetadataTasks, streamTransactionMetadataTasks, kvtMetadataStore, kvtMetadataTasks, null, executor);
    }

    @VisibleForTesting
    public ControllerEventProcessors(String host, ControllerEventProcessorConfig config, Controller controller, CheckpointStore checkpointStore, StreamMetadataStore streamMetadataStore, BucketStore bucketStore, ConnectionPool connectionPool, StreamMetadataTasks streamMetadataTasks, StreamTransactionMetadataTasks streamTransactionMetadataTasks, KVTableMetadataStore kvtMetadataStore, TableMetadataTasks kvtMetadataTasks, EventProcessorSystem system, ScheduledExecutorService executor) {
        this.objectId = "ControllerEventProcessors";
        this.config = config;
        this.checkpointStore = checkpointStore;
        this.controller = controller;
        this.clientFactory = new ClientFactoryImpl(config.getScopeName(), controller, connectionPool);
        this.system = system == null ? new EventProcessorSystemImpl("Controller", host, config.getScopeName(), (EventStreamClientFactory)this.clientFactory, (ReaderGroupManager)new ReaderGroupManagerImpl(config.getScopeName(), controller, (AbstractClientFactoryImpl)this.clientFactory)) : system;
        this.streamRequestHandler = new StreamRequestHandler(new AutoScaleTask(streamMetadataTasks, streamMetadataStore, executor), new ScaleOperationTask(streamMetadataTasks, streamMetadataStore, executor), new UpdateStreamTask(streamMetadataTasks, streamMetadataStore, bucketStore, executor), new SealStreamTask(streamMetadataTasks, streamTransactionMetadataTasks, streamMetadataStore, executor), new DeleteStreamTask(streamMetadataTasks, streamMetadataStore, bucketStore, executor), new TruncateStreamTask(streamMetadataTasks, streamMetadataStore, executor), new CreateReaderGroupTask(streamMetadataTasks, streamMetadataStore, executor), new DeleteReaderGroupTask(streamMetadataTasks, streamMetadataStore, executor), new UpdateReaderGroupTask(streamMetadataTasks, streamMetadataStore, executor), streamMetadataStore, executor);
        this.commitRequestHandler = new CommitRequestHandler(streamMetadataStore, streamMetadataTasks, streamTransactionMetadataTasks, bucketStore, executor);
        this.abortRequestHandler = new AbortRequestHandler(streamMetadataStore, streamMetadataTasks, executor);
        this.kvtRequestHandler = new TableRequestHandler(new CreateTableTask(kvtMetadataStore, kvtMetadataTasks, executor), new DeleteTableTask(kvtMetadataStore, kvtMetadataTasks, executor), kvtMetadataStore, executor);
        this.executor = executor;
        this.rebalanceIntervalMillis = config.getRebalanceIntervalMillis();
        this.truncationInterval = new AtomicLong(TRUNCATION_INTERVAL_MILLIS);
    }

    public boolean isMetadataServiceConnected() {
        return this.checkpointStore.isHealthy();
    }

    public boolean isBootstrapCompleted() {
        return this.bootstrapCompleted.get();
    }

    @Override
    public boolean isReady() {
        boolean isMetaConnected = this.isMetadataServiceConnected();
        boolean isBootstrapComplete = this.isBootstrapCompleted();
        boolean isSvcRunning = this.isRunning();
        boolean isReady = isMetaConnected && isBootstrapComplete && isSvcRunning;
        log.debug("IsReady={} as isMetaConnected={}, isBootstrapComplete={}, isSvcRunning={}", new Object[]{isReady, isMetaConnected, isBootstrapComplete, isSvcRunning});
        return isReady;
    }

    protected void startUp() throws Exception {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.objectId, (String)"startUp", (Object[])new Object[0]);
        try {
            log.info("Starting controller event processors");
            this.rebalanceExecutor = ExecutorServiceHelpers.newScheduledThreadPool((int)1, (String)"event-processor");
            this.initialize();
            log.info("Controller event processors startUp complete");
        }
        finally {
            LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"startUp", (long)traceId, (Object[])new Object[0]);
        }
    }

    protected void shutDown() {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.objectId, (String)"shutDown", (Object[])new Object[0]);
        try {
            log.info("Stopping controller event processors");
            this.stopEventProcessors();
            this.rebalanceExecutor.shutdownNow();
            this.clientFactory.close();
            log.info("Controller event processors shutDown complete");
        }
        finally {
            LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"shutDown", (long)traceId, (Object[])new Object[0]);
        }
    }

    @Override
    public CompletableFuture<Void> sweepFailedProcesses(Supplier<Set<String>> processes) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        if (this.commitEventProcessors != null) {
            futures.add(this.handleOrphanedReaders(this.commitEventProcessors, processes));
        }
        if (this.abortEventProcessors != null) {
            futures.add(this.handleOrphanedReaders(this.abortEventProcessors, processes));
        }
        if (this.requestEventProcessors != null) {
            futures.add(this.handleOrphanedReaders(this.requestEventProcessors, processes));
        }
        if (this.kvtRequestEventProcessors != null) {
            futures.add(this.handleOrphanedReaders(this.kvtRequestEventProcessors, processes));
        }
        return Futures.allOf(futures);
    }

    @Override
    public CompletableFuture<Void> handleFailedProcess(String process) {
        ArrayList futures = new ArrayList();
        if (this.commitEventProcessors != null) {
            futures.add(RetryHelper.withRetriesAsync(() -> CompletableFuture.runAsync(() -> {
                try {
                    this.commitEventProcessors.notifyProcessFailure(process);
                }
                catch (CheckpointStoreException e) {
                    throw new CompletionException(e);
                }
            }, this.executor), RetryHelper.RETRYABLE_PREDICATE, Integer.MAX_VALUE, this.executor));
        }
        if (this.abortEventProcessors != null) {
            futures.add(RetryHelper.withRetriesAsync(() -> CompletableFuture.runAsync(() -> {
                try {
                    this.abortEventProcessors.notifyProcessFailure(process);
                }
                catch (CheckpointStoreException e) {
                    throw new CompletionException(e);
                }
            }, this.executor), RetryHelper.RETRYABLE_PREDICATE, Integer.MAX_VALUE, this.executor));
        }
        if (this.requestEventProcessors != null) {
            futures.add(RetryHelper.withRetriesAsync(() -> CompletableFuture.runAsync(() -> {
                try {
                    this.requestEventProcessors.notifyProcessFailure(process);
                }
                catch (CheckpointStoreException e) {
                    throw new CompletionException(e);
                }
            }, this.executor), RetryHelper.RETRYABLE_PREDICATE, Integer.MAX_VALUE, this.executor));
        }
        if (this.kvtRequestEventProcessors != null) {
            futures.add(RetryHelper.withRetriesAsync(() -> CompletableFuture.runAsync(() -> {
                try {
                    this.kvtRequestEventProcessors.notifyProcessFailure(process);
                }
                catch (CheckpointStoreException e) {
                    throw new CompletionException(e);
                }
            }, this.executor), RetryHelper.RETRYABLE_PREDICATE, Integer.MAX_VALUE, this.executor));
        }
        return Futures.allOf(futures);
    }

    private CompletableFuture<Void> createStreams() {
        StreamConfiguration commitStreamConfig = StreamConfiguration.builder().scalingPolicy(this.config.getCommitStreamScalingPolicy()).build();
        StreamConfiguration abortStreamConfig = StreamConfiguration.builder().scalingPolicy(this.config.getAbortStreamScalingPolicy()).build();
        StreamConfiguration requestStreamConfig = StreamConfiguration.builder().scalingPolicy(this.config.getRequestStreamScalingPolicy()).build();
        StreamConfiguration kvTableStreamConfig = StreamConfiguration.builder().scalingPolicy(this.config.getKvtStreamScalingPolicy()).build();
        String scope = this.config.getScopeName();
        CompletableFuture<Void> future = this.createScope(scope);
        return future.thenCompose(ignore -> CompletableFuture.allOf(this.createStream(scope, this.config.getCommitStreamName(), commitStreamConfig), this.createStream(scope, this.config.getAbortStreamName(), abortStreamConfig), this.createStream(scope, Config.SCALE_STREAM_NAME, requestStreamConfig), this.createStream(scope, this.config.getKvtStreamName(), kvTableStreamConfig)));
    }

    private CompletableFuture<Void> createScope(String scopeName) {
        return Futures.toVoid((CompletableFuture)Retry.indefinitelyWithExpBackoff((long)100L, (int)10, (long)10000L, e -> log.warn("Error creating event processor scope {} with exception {}", (Object)scopeName, (Object)Exceptions.unwrap((Throwable)e).toString())).runAsync(() -> this.controller.createScope(scopeName).thenAccept(x -> log.info("Created controller scope {}", (Object)scopeName)), this.executor));
    }

    private CompletableFuture<Void> createStream(String scope, String streamName, StreamConfiguration streamConfig) {
        return Futures.toVoid((CompletableFuture)Retry.indefinitelyWithExpBackoff((long)100L, (int)10, (long)10000L, e -> log.warn("Error creating event processor stream {} with exception {}", (Object)streamName, (Object)Exceptions.unwrap((Throwable)e).toString())).runAsync(() -> this.controller.createStream(scope, streamName, streamConfig).thenAccept(x -> log.info("Created stream {}/{}", (Object)scope, (Object)streamName)), this.executor));
    }

    public CompletableFuture<Void> bootstrap(StreamTransactionMetadataTasks streamTransactionMetadataTasks, StreamMetadataTasks streamMetadataTasks, TableMetadataTasks tableMetadataTasks) {
        log.info("Bootstrapping controller event processors");
        return this.createStreams().thenAcceptAsync(x -> {
            streamMetadataTasks.initializeStreamWriters((EventStreamClientFactory)this.clientFactory, this.config.getRequestStreamName());
            streamTransactionMetadataTasks.initializeStreamWriters((EventStreamClientFactory)this.clientFactory, this.config);
            tableMetadataTasks.initializeStreamWriters((EventStreamClientFactory)this.clientFactory, this.config.getKvtStreamName());
            long delay = this.truncationInterval.get();
            Futures.loop(() -> ((ControllerEventProcessors)this).isRunning(), () -> Futures.delayedFuture(() -> this.truncate(this.config.getRequestStreamName(), this.config.getRequestReaderGroupName(), streamMetadataTasks), (long)delay, (ScheduledExecutorService)this.executor), (Executor)this.executor);
            Futures.loop(() -> ((ControllerEventProcessors)this).isRunning(), () -> Futures.delayedFuture(() -> this.truncate(this.config.getCommitStreamName(), this.config.getCommitReaderGroupName(), streamMetadataTasks), (long)delay, (ScheduledExecutorService)this.executor), (Executor)this.executor);
            Futures.loop(() -> ((ControllerEventProcessors)this).isRunning(), () -> Futures.delayedFuture(() -> this.truncate(this.config.getAbortStreamName(), this.config.getAbortReaderGroupName(), streamMetadataTasks), (long)delay, (ScheduledExecutorService)this.executor), (Executor)this.executor);
            Futures.loop(() -> ((ControllerEventProcessors)this).isRunning(), () -> Futures.delayedFuture(() -> this.truncate(this.config.getKvtStreamName(), this.config.getKvtReaderGroupName(), streamMetadataTasks), (long)delay, (ScheduledExecutorService)this.executor), (Executor)this.executor);
            this.bootstrapCompleted.set(true);
            log.info("Completed bootstrapping event processors.");
        }, (Executor)this.executor);
    }

    @VisibleForTesting
    CompletableFuture<Void> truncate(String streamName, String readergroupName, StreamMetadataTasks streamMetadataTasks) {
        Preconditions.checkState((boolean)this.isRunning());
        try {
            HashMap<String, Position> positions = new HashMap<String, Position>();
            for (String process : this.checkpointStore.getProcesses()) {
                positions.putAll(this.checkpointStore.getPositions(process, readergroupName));
            }
            Map streamcut = positions.entrySet().stream().map(x -> x.getValue() == null ? Collections.emptyMap() : this.convertPosition((Map.Entry<String, Position>)x)).reduce(Collections.emptyMap(), (x, y) -> {
                HashMap result = new HashMap(x);
                y.forEach((a, b) -> {
                    if (x.containsKey(a)) {
                        result.put(a, Math.max((Long)x.get(a), b));
                    } else {
                        result.put(a, b);
                    }
                });
                return result;
            });
            return streamMetadataTasks.startTruncation(this.config.getScopeName(), streamName, streamcut, null).handle((r, e) -> {
                if (e != null) {
                    log.warn("Submission for truncation for stream {} failed. Will be retried in next iteration.", (Object)streamName);
                } else if (r.booleanValue()) {
                    log.debug("truncation for stream {} at streamcut {} submitted.", (Object)streamName, (Object)streamcut);
                } else {
                    log.debug("truncation for stream {} at streamcut {} rejected.", (Object)streamName, (Object)streamcut);
                }
                return null;
            });
        }
        catch (Exception e2) {
            Throwable unwrap = Exceptions.unwrap((Throwable)e2);
            log.warn("Encountered exception attempting to truncate stream {}. {}: {}", new Object[]{streamName, unwrap.getClass().getName(), unwrap.getMessage()});
            return CompletableFuture.completedFuture(null);
        }
    }

    private Map<Long, Long> convertPosition(Map.Entry<String, Position> x) {
        return ((PositionImpl)x.getValue().asImpl()).getOwnedSegmentsWithOffsets().entrySet().stream().collect(Collectors.toMap(y -> ((Segment)y.getKey()).getSegmentId(), Map.Entry::getValue));
    }

    private CompletableFuture<Void> handleOrphanedReaders(EventProcessorGroup<? extends ControllerEvent> group, Supplier<Set<String>> processes) {
        return ((CompletableFuture)RetryHelper.withRetriesAsync(() -> CompletableFuture.supplyAsync(() -> {
            try {
                return group.getProcesses();
            }
            catch (CheckpointStoreException e) {
                if (e.getType().equals((Object)CheckpointStoreException.Type.NoNode)) {
                    return Collections.emptySet();
                }
                throw new CompletionException(e);
            }
        }, this.executor), RetryHelper.RETRYABLE_PREDICATE, Integer.MAX_VALUE, this.executor).thenComposeAsync(groupProcesses -> RetryHelper.withRetriesAsync(() -> this.lambda$handleOrphanedReaders$32((Supplier)processes, groupProcesses, group), RetryHelper.RETRYABLE_PREDICATE, Integer.MAX_VALUE, this.executor))).thenComposeAsync(pair -> {
            Set activeProcesses = (Set)pair.getLeft();
            Set registeredProcesses = (Set)pair.getRight();
            if (registeredProcesses == null || registeredProcesses.isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            if (activeProcesses != null) {
                registeredProcesses.removeAll(activeProcesses);
            }
            ArrayList futureList = new ArrayList();
            for (String process : registeredProcesses) {
                futureList.add(RetryHelper.withRetriesAsync(() -> CompletableFuture.runAsync(() -> {
                    try {
                        group.notifyProcessFailure(process);
                    }
                    catch (CheckpointStoreException e) {
                        log.error(String.format("Error notifying failure of process=%s in event processor group %s", process, group.toString()), (Throwable)e);
                        throw new CompletionException(e);
                    }
                }, this.executor), RetryHelper.RETRYABLE_PREDICATE, Integer.MAX_VALUE, this.executor));
            }
            return Futures.allOf(futureList);
        });
    }

    private void initialize() {
        EventProcessorGroupConfigImpl commitReadersConfig = EventProcessorGroupConfigImpl.builder().streamName(this.config.getCommitStreamName()).readerGroupName(this.config.getCommitReaderGroupName()).eventProcessorCount(this.config.getCommitReaderGroupSize()).checkpointConfig(CheckpointConfig.none()).build();
        EventProcessorConfig<CommitEvent> commitConfig = EventProcessorConfig.builder().config(commitReadersConfig).decider(ExceptionHandler.DEFAULT_EXCEPTION_HANDLER).serializer(COMMIT_EVENT_SERIALIZER).supplier(() -> new ConcurrentEventProcessor(this.commitRequestHandler, this.executor)).minRebalanceIntervalMillis(this.rebalanceIntervalMillis).build();
        log.debug("Creating commit event processors");
        Retry.indefinitelyWithExpBackoff((long)100L, (int)10, (long)10000L, e -> log.warn("Error creating commit event processor group", e)).run(() -> {
            this.commitEventProcessors = this.system.createEventProcessorGroup(commitConfig, this.checkpointStore, this.rebalanceExecutor);
            return null;
        });
        EventProcessorGroupConfigImpl abortReadersConfig = EventProcessorGroupConfigImpl.builder().streamName(this.config.getAbortStreamName()).readerGroupName(this.config.getAbortReaderGroupName()).eventProcessorCount(this.config.getAbortReaderGroupSize()).checkpointConfig(CheckpointConfig.none()).build();
        EventProcessorConfig<AbortEvent> abortConfig = EventProcessorConfig.builder().config(abortReadersConfig).decider(ExceptionHandler.DEFAULT_EXCEPTION_HANDLER).serializer(ABORT_EVENT_SERIALIZER).supplier(() -> new ConcurrentEventProcessor(this.abortRequestHandler, this.executor)).minRebalanceIntervalMillis(this.rebalanceIntervalMillis).build();
        log.debug("Creating abort event processors");
        Retry.indefinitelyWithExpBackoff((long)100L, (int)10, (long)10000L, e -> log.warn("Error creating commit event processor group", e)).run(() -> {
            this.abortEventProcessors = this.system.createEventProcessorGroup(abortConfig, this.checkpointStore, this.rebalanceExecutor);
            return null;
        });
        EventProcessorGroupConfigImpl requestReadersConfig = EventProcessorGroupConfigImpl.builder().streamName(this.config.getRequestStreamName()).readerGroupName(this.config.getRequestReaderGroupName()).eventProcessorCount(1).checkpointConfig(CheckpointConfig.none()).build();
        EventProcessorConfig<ControllerEvent> requestConfig = EventProcessorConfig.builder().config(requestReadersConfig).decider(ExceptionHandler.DEFAULT_EXCEPTION_HANDLER).serializer(CONTROLLER_EVENT_SERIALIZER).supplier(() -> new ConcurrentEventProcessor(this.streamRequestHandler, this.executor)).minRebalanceIntervalMillis(this.rebalanceIntervalMillis).build();
        log.debug("Creating stream request event processors");
        Retry.indefinitelyWithExpBackoff((long)100L, (int)10, (long)10000L, e -> log.warn("Error creating request event processor group", e)).run(() -> {
            this.requestEventProcessors = this.system.createEventProcessorGroup(requestConfig, this.checkpointStore, this.rebalanceExecutor);
            return null;
        });
        EventProcessorGroupConfigImpl kvtReadersConfig = EventProcessorGroupConfigImpl.builder().streamName(this.config.getKvtStreamName()).readerGroupName(this.config.getKvtReaderGroupName()).eventProcessorCount(1).checkpointConfig(CheckpointConfig.none()).build();
        EventProcessorConfig<ControllerEvent> kvtRequestConfig = EventProcessorConfig.builder().config(kvtReadersConfig).decider(ExceptionHandler.DEFAULT_EXCEPTION_HANDLER).serializer(CONTROLLER_EVENT_SERIALIZER).supplier(() -> new ConcurrentEventProcessor(this.kvtRequestHandler, this.executor)).minRebalanceIntervalMillis(this.rebalanceIntervalMillis).build();
        log.debug("Creating kvt request event processors");
        Retry.indefinitelyWithExpBackoff((long)100L, (int)10, (long)10000L, e -> log.warn("Error creating request event processor group", e)).run(() -> {
            this.kvtRequestEventProcessors = this.system.createEventProcessorGroup(kvtRequestConfig, this.checkpointStore, this.rebalanceExecutor);
            return null;
        });
        log.info("Awaiting start of event processors...");
        this.commitEventProcessors.awaitRunning();
        log.info("Commit event processor started.");
        this.abortEventProcessors.awaitRunning();
        log.info("Abort event processor started.");
        this.requestEventProcessors.awaitRunning();
        log.info("Stream request event processor started.");
        this.kvtRequestEventProcessors.awaitRunning();
        log.info("KVT request event processor started.");
    }

    private void stopEventProcessors() {
        if (this.commitEventProcessors != null) {
            log.info("Stopping commit event processors");
            this.commitEventProcessors.stopAsync();
        }
        if (this.abortEventProcessors != null) {
            log.info("Stopping abort event processors");
            this.abortEventProcessors.stopAsync();
        }
        if (this.requestEventProcessors != null) {
            log.info("Stopping request event processors");
            this.requestEventProcessors.stopAsync();
        }
        if (this.kvtRequestEventProcessors != null) {
            log.info("Stopping kvt request event processors");
            this.kvtRequestEventProcessors.stopAsync();
        }
        if (this.commitEventProcessors != null) {
            log.info("Awaiting termination of commit event processors");
            this.commitEventProcessors.awaitTerminated();
        }
        if (this.abortEventProcessors != null) {
            log.info("Awaiting termination of abort event processors");
            this.abortEventProcessors.awaitTerminated();
        }
        if (this.requestEventProcessors != null) {
            log.info("Awaiting termination of request event processors");
            this.requestEventProcessors.awaitTerminated();
        }
        if (this.kvtRequestEventProcessors != null) {
            log.info("Awaiting termination of kvt request event processors");
            this.kvtRequestEventProcessors.awaitTerminated();
        }
    }

    @VisibleForTesting
    void setTruncationInterval(long interval) {
        this.truncationInterval.set(interval);
    }

    @Override
    public void close() {
        this.clientFactory.close();
        try {
            this.stopAsync().awaitTerminated(this.config.getShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            log.error("Timeout expired while waiting for service to shut down.", (Throwable)ex);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AtomicBoolean getBootstrapCompleted() {
        return this.bootstrapCompleted;
    }

    private /* synthetic */ CompletableFuture lambda$handleOrphanedReaders$32(Supplier processes, Set groupProcesses, EventProcessorGroup group) {
        return CompletableFuture.supplyAsync(() -> ControllerEventProcessors.lambda$handleOrphanedReaders$31((Supplier)processes, groupProcesses, group), this.executor);
    }

    private static /* synthetic */ ImmutablePair lambda$handleOrphanedReaders$31(Supplier processes, Set groupProcesses, EventProcessorGroup group) {
        try {
            return new ImmutablePair((Object)((Set)processes.get()), (Object)groupProcesses);
        }
        catch (Exception e) {
            log.error(String.format("Error fetching current processes%s", group.toString()), (Throwable)e);
            throw new CompletionException(e);
        }
    }
}

