/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.admin.KeyValueTableInfo;
import io.pravega.client.control.impl.CancellableRequest;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.control.impl.ControllerFailureException;
import io.pravega.client.control.impl.ModelHelper;
import io.pravega.client.control.impl.ReaderGroupConfigRejectedException;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.InvalidStreamException;
import io.pravega.client.stream.PingFailedException;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.ReaderGroupNotFoundException;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.stream.StreamCut;
import io.pravega.client.stream.Transaction;
import io.pravega.client.stream.impl.SegmentWithRange;
import io.pravega.client.stream.impl.StreamImpl;
import io.pravega.client.stream.impl.StreamSegmentSuccessors;
import io.pravega.client.stream.impl.StreamSegments;
import io.pravega.client.stream.impl.StreamSegmentsWithPredecessors;
import io.pravega.client.stream.impl.TxnSegments;
import io.pravega.client.stream.impl.WriterPosition;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.client.tables.impl.KeyValueTableSegments;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.hash.RandomFactory;
import io.pravega.common.util.AsyncIterator;
import io.pravega.common.util.ContinuationTokenAsyncIterator;
import io.pravega.controller.server.ControllerService;
import io.pravega.controller.server.security.auth.GrpcAuthHelper;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import io.pravega.controller.task.Stream.StreamMetadataTasks;
import io.pravega.shared.NameUtils;
import io.pravega.shared.protocol.netty.PravegaNodeUri;
import io.pravega.shared.security.auth.AccessOperation;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalController
implements Controller {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalController.class);
    private static final int PAGE_LIMIT = 1000;
    private ControllerService controller;
    private final String tokenSigningKey;
    private final boolean authorizationEnabled;
    private final Random requestIdGenerator = RandomFactory.create();

    public LocalController(ControllerService controller, boolean authorizationEnabled, String tokenSigningKey) {
        this.controller = controller;
        this.tokenSigningKey = tokenSigningKey;
        this.authorizationEnabled = authorizationEnabled;
    }

    public CompletableFuture<Boolean> checkScopeExists(String scopeName) {
        return Futures.exceptionallyExpecting((CompletableFuture)this.controller.getScope(scopeName, this.requestIdGenerator.nextLong()).thenApply(v -> true), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, (Object)false);
    }

    public AsyncIterator<String> listScopes() {
        Function<String, CompletableFuture> function = token -> this.controller.listScopes((String)token, 1000, this.requestIdGenerator.nextLong()).thenApply(result -> new AbstractMap.SimpleEntry<String, Collection>((String)result.getValue(), (Collection)result.getKey()));
        return new ContinuationTokenAsyncIterator(function, (Object)"");
    }

    public CompletableFuture<Boolean> checkStreamExists(String scopeName, String streamName) {
        return Futures.exceptionallyExpecting((CompletableFuture)this.controller.getStream(scopeName, streamName, this.requestIdGenerator.nextLong()).thenApply(v -> true), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, (Object)false);
    }

    public CompletableFuture<StreamConfiguration> getStreamConfiguration(String scopeName, String streamName) {
        return this.controller.getStream(scopeName, streamName, this.requestIdGenerator.nextLong());
    }

    public CompletableFuture<Boolean> createScope(String scopeName) {
        return this.controller.createScope(scopeName, this.requestIdGenerator.nextLong()).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to create scope: " + scopeName);
                }
                case INVALID_SCOPE_NAME: {
                    throw new IllegalArgumentException("Illegal scope name: " + scopeName);
                }
                case SCOPE_EXISTS: {
                    return false;
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status creating scope " + scopeName + " " + x.getStatus());
        });
    }

    public AsyncIterator<Stream> listStreams(String scopeName) {
        Function<String, CompletableFuture> function = token -> this.controller.listStreams(scopeName, (String)token, 1000, this.requestIdGenerator.nextLong()).thenApply(result -> {
            List asStreamList = ((List)result.getKey()).stream().map(m -> new StreamImpl(scopeName, m)).collect(Collectors.toList());
            return new AbstractMap.SimpleEntry((String)result.getValue(), asStreamList);
        });
        return new ContinuationTokenAsyncIterator(function, (Object)"");
    }

    public AsyncIterator<Stream> listStreamsForTag(String scopeName, String tag) {
        Function<String, CompletableFuture> function = token -> this.controller.listStreamsForTag(scopeName, tag, (String)token, this.requestIdGenerator.nextLong()).thenApply(result -> {
            List asStreamList = ((List)result.getKey()).stream().map(m -> new StreamImpl(scopeName, m)).collect(Collectors.toList());
            return new AbstractMap.SimpleEntry((String)result.getValue(), asStreamList);
        });
        return new ContinuationTokenAsyncIterator(function, (Object)"");
    }

    public CompletableFuture<Boolean> deleteScope(String scopeName) {
        return this.controller.deleteScope(scopeName, this.requestIdGenerator.nextLong()).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to delete scope: " + scopeName);
                }
                case SCOPE_NOT_EMPTY: {
                    throw new IllegalStateException("Scope " + scopeName + " is not empty.");
                }
                case SCOPE_NOT_FOUND: {
                    return false;
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status deleting scope " + scopeName + " " + x.getStatus());
        });
    }

    public CompletableFuture<Boolean> createStream(String scope, String streamName, StreamConfiguration streamConfig) {
        return this.controller.createStream(scope, streamName, streamConfig, System.currentTimeMillis(), this.requestIdGenerator.nextLong()).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to create stream: " + streamConfig);
                }
                case INVALID_STREAM_NAME: {
                    throw new IllegalArgumentException("Illegal stream name: " + streamName + " config: " + streamConfig);
                }
                case SCOPE_NOT_FOUND: {
                    throw new IllegalArgumentException("Scope does not exist: " + scope + " config: " + streamConfig);
                }
                case STREAM_EXISTS: {
                    return false;
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status creating stream " + streamConfig + " " + x.getStatus());
        });
    }

    public CompletableFuture<Boolean> updateStream(String scope, String streamName, StreamConfiguration streamConfig) {
        return this.controller.updateStream(scope, streamName, streamConfig, this.requestIdGenerator.nextLong()).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to update stream: " + streamConfig);
                }
                case SCOPE_NOT_FOUND: {
                    throw new IllegalArgumentException("Scope does not exist: " + scope + " config: " + streamConfig);
                }
                case STREAM_NOT_FOUND: {
                    throw new IllegalArgumentException("Stream does not exist: " + streamName + " in scope: " + scope + " config: " + streamConfig);
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status updating stream " + streamConfig + " " + x.getStatus());
        });
    }

    public CompletableFuture<ReaderGroupConfig> createReaderGroup(String scopeName, String rgName, ReaderGroupConfig config) {
        StreamMetadataTasks streamMetadataTasks = this.controller.getStreamMetadataTasks();
        return streamMetadataTasks.createReaderGroupInternal(scopeName, rgName, config, System.currentTimeMillis(), this.requestIdGenerator.nextLong()).thenApply(x -> {
            String scopedRGName = NameUtils.getScopedReaderGroupName((String)scopeName, (String)rgName);
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to create ReaderGroup: " + scopedRGName);
                }
                case INVALID_RG_NAME: {
                    throw new IllegalArgumentException("Illegal ReaderGroup name: " + rgName);
                }
                case SCOPE_NOT_FOUND: {
                    throw new IllegalArgumentException("Scope does not exist: " + scopeName + " config: " + scopeName);
                }
                case SUCCESS: {
                    return ModelHelper.encode((Controller.ReaderGroupConfiguration)x.getConfig());
                }
            }
            throw new ControllerFailureException("Unknown return status creating ReaderGroup " + scopedRGName + " " + x);
        });
    }

    public CompletableFuture<Long> updateReaderGroup(String scopeName, String rgName, ReaderGroupConfig config) {
        return this.controller.updateReaderGroup(scopeName, rgName, config, this.requestIdGenerator.nextLong()).thenApply(x -> {
            String scopedRGName = NameUtils.getScopedReaderGroupName((String)scopeName, (String)rgName);
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to create ReaderGroup: " + scopedRGName);
                }
                case INVALID_CONFIG: {
                    throw new ReaderGroupConfigRejectedException("Invalid Reader Group Config: " + config.toString());
                }
                case RG_NOT_FOUND: {
                    throw new ReaderGroupNotFoundException("Scope does not exist: " + scopeName + " config: " + scopedRGName);
                }
                case SUCCESS: {
                    return x.getGeneration();
                }
            }
            throw new ControllerFailureException("Unknown return status creating ReaderGroup " + scopedRGName + " " + x.getStatus());
        });
    }

    public CompletableFuture<ReaderGroupConfig> getReaderGroupConfig(String scopeName, String rgName) {
        return this.controller.getReaderGroupConfig(scopeName, rgName, this.requestIdGenerator.nextLong()).thenApply(x -> {
            String scopedRGName = NameUtils.getScopedReaderGroupName((String)scopeName, (String)rgName);
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to get Config for ReaderGroup: " + scopedRGName);
                }
                case RG_NOT_FOUND: {
                    throw new ReaderGroupNotFoundException("Could not find Reader Group: " + scopedRGName);
                }
                case SUCCESS: {
                    return ModelHelper.encode((Controller.ReaderGroupConfiguration)x.getConfig());
                }
            }
            throw new ControllerFailureException("Unknown return status getting config for ReaderGroup " + scopedRGName + " " + x.getStatus());
        });
    }

    public CompletableFuture<Boolean> deleteReaderGroup(String scopeName, String rgName, UUID readerGroupId) {
        return this.controller.deleteReaderGroup(scopeName, rgName, readerGroupId.toString(), this.requestIdGenerator.nextLong()).thenApply(x -> {
            String scopedRGName = NameUtils.getScopedReaderGroupName((String)scopeName, (String)rgName);
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to create ReaderGroup: " + scopedRGName);
                }
                case RG_NOT_FOUND: {
                    throw new ReaderGroupNotFoundException("Reader group not found: " + scopedRGName);
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status creating ReaderGroup " + scopedRGName + " " + x.getStatus());
        });
    }

    public CompletableFuture<List<String>> listSubscribers(String scope, String streamName) {
        return this.controller.listSubscribers(scope, streamName, this.requestIdGenerator.nextLong()).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to listSubscribers for stream: " + scope + "/" + streamName);
                }
                case STREAM_NOT_FOUND: {
                    throw new IllegalArgumentException("Stream does not exist: " + streamName);
                }
                case SUCCESS: {
                    return new ArrayList(x.getSubscribersList());
                }
            }
            throw new ControllerFailureException(String.format("Unknown return status for listSubscribers on stream %s/%s %s", scope, streamName, x.getStatus()));
        });
    }

    public CompletableFuture<Boolean> updateSubscriberStreamCut(String scope, String streamName, String subscriber, UUID readerGroupId, long generation, StreamCut streamCut) {
        return this.controller.updateSubscriberStreamCut(scope, streamName, subscriber, readerGroupId.toString(), generation, (ImmutableMap<Long, Long>)ModelHelper.getStreamCutMap((StreamCut)streamCut), this.requestIdGenerator.nextLong()).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to update streamcut: " + scope + "/" + streamName);
                }
                case STREAM_NOT_FOUND: {
                    throw new IllegalArgumentException("Stream does not exist: " + streamName);
                }
                case SUBSCRIBER_NOT_FOUND: {
                    throw new IllegalArgumentException("Subscriber does not exist: " + subscriber);
                }
                case GENERATION_MISMATCH: {
                    throw new IllegalArgumentException("Subscriber generation does not match: " + subscriber);
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException(String.format("Unknown return status updating truncation streamcut for subscriber %s, on stream %s/%s %s", subscriber, scope, streamName, x.getStatus()));
        });
    }

    public CompletableFuture<Boolean> truncateStream(String scope, String stream, StreamCut streamCut) {
        Map<Long, Long> segmentToOffsetMap = streamCut.asImpl().getPositions().entrySet().stream().collect(Collectors.toMap(e -> ((Segment)e.getKey()).getSegmentId(), Map.Entry::getValue));
        return this.truncateStream(scope, stream, segmentToOffsetMap);
    }

    public CompletableFuture<Boolean> truncateStream(String scope, String stream, Map<Long, Long> streamCut) {
        return this.controller.truncateStream(scope, stream, streamCut, this.requestIdGenerator.nextLong()).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to truncate stream: " + stream);
                }
                case SCOPE_NOT_FOUND: {
                    throw new IllegalArgumentException("Scope does not exist: " + scope);
                }
                case STREAM_NOT_FOUND: {
                    throw new IllegalArgumentException("Stream does not exist: " + stream + " in scope: " + scope);
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status truncating stream " + stream + " " + x.getStatus());
        });
    }

    public CompletableFuture<Boolean> sealStream(String scope, String streamName) {
        return this.controller.sealStream(scope, streamName, this.requestIdGenerator.nextLong()).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to seal stream: " + streamName);
                }
                case SCOPE_NOT_FOUND: {
                    throw new InvalidStreamException("Scope does not exist: " + scope);
                }
                case STREAM_NOT_FOUND: {
                    throw new InvalidStreamException("Stream does not exist: " + streamName + " in scope: " + scope);
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status scealing stream " + streamName + " " + x.getStatus());
        });
    }

    public CompletableFuture<Boolean> deleteStream(String scope, String streamName) {
        return this.controller.deleteStream(scope, streamName, this.requestIdGenerator.nextLong()).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to delete stream: " + streamName);
                }
                case STREAM_NOT_FOUND: {
                    return false;
                }
                case STREAM_NOT_SEALED: {
                    throw new IllegalArgumentException("Stream is not sealed: " + streamName);
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status deleting stream " + streamName + " " + x.getStatus());
        });
    }

    public CancellableRequest<Boolean> scaleStream(Stream stream, List<Long> sealedSegments, Map<Double, Double> newKeyRanges, ScheduledExecutorService executor) {
        CancellableRequest cancellableRequest = new CancellableRequest();
        this.startScaleInternal(stream, sealedSegments, newKeyRanges).whenComplete((startScaleResponse, e) -> {
            if (e != null) {
                cancellableRequest.start(() -> Futures.failedFuture((Throwable)e), any -> true, executor);
            } else {
                boolean started = startScaleResponse.getStatus().equals((Object)Controller.ScaleResponse.ScaleStreamStatus.STARTED);
                cancellableRequest.start(() -> {
                    if (started) {
                        return this.checkScaleStatus(stream, startScaleResponse.getEpoch());
                    }
                    return CompletableFuture.completedFuture(false);
                }, isDone -> !started || isDone != false, executor);
            }
        });
        return cancellableRequest;
    }

    public CompletableFuture<Boolean> startScale(Stream stream, List<Long> sealedSegments, Map<Double, Double> newKeyRanges) {
        return this.startScaleInternal(stream, sealedSegments, newKeyRanges).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to scale stream: " + stream);
                }
                case PRECONDITION_FAILED: {
                    return false;
                }
                case STARTED: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status scaling stream " + stream + " " + x.getStatus());
        });
    }

    public CompletableFuture<Boolean> checkScaleStatus(Stream stream, int epoch) {
        return this.controller.checkScale(stream.getScope(), stream.getStreamName(), epoch, this.requestIdGenerator.nextLong()).thenApply(response -> {
            switch (response.getStatus()) {
                case IN_PROGRESS: {
                    return false;
                }
                case SUCCESS: {
                    return true;
                }
                case INVALID_INPUT: {
                    throw new ControllerFailureException("invalid input");
                }
            }
            throw new ControllerFailureException("unknown error");
        });
    }

    private CompletableFuture<Controller.ScaleResponse> startScaleInternal(Stream stream, List<Long> sealedSegments, Map<Double, Double> newKeyRanges) {
        Preconditions.checkNotNull((Object)stream, (Object)"stream");
        Preconditions.checkNotNull(sealedSegments, (Object)"sealedSegments");
        Preconditions.checkNotNull(newKeyRanges, (Object)"newKeyRanges");
        return this.controller.scale(stream.getScope(), stream.getStreamName(), sealedSegments, newKeyRanges, System.currentTimeMillis(), this.requestIdGenerator.nextLong());
    }

    public CompletableFuture<StreamSegments> getCurrentSegments(String scope, String streamName) {
        return this.controller.getCurrentSegments(scope, streamName, this.requestIdGenerator.nextLong()).thenApply(this::getStreamSegments);
    }

    public CompletableFuture<StreamSegments> getEpochSegments(String scope, String streamName, int epoch) {
        return this.controller.getEpochSegments(scope, streamName, epoch, this.requestIdGenerator.nextLong()).thenApply(this::getStreamSegments);
    }

    private StreamSegments getStreamSegments(List<Controller.SegmentRange> ranges) {
        return new StreamSegments(this.getRangeMap(ranges));
    }

    public CompletableFuture<TxnSegments> createTransaction(Stream stream, long lease) {
        return this.controller.createTransaction(stream.getScope(), stream.getStreamName(), lease, this.requestIdGenerator.nextLong()).thenApply(pair -> new TxnSegments(this.getStreamSegments((List)pair.getRight()), (UUID)pair.getKey()));
    }

    public CompletableFuture<Transaction.PingStatus> pingTransaction(Stream stream, UUID txId, long lease) {
        return this.controller.pingTransaction(stream.getScope(), stream.getStreamName(), txId, lease, this.requestIdGenerator.nextLong()).thenApply(status -> {
            try {
                return ModelHelper.encode((Controller.PingTxnStatus.Status)status.getStatus(), (String)(stream + " " + txId));
            }
            catch (PingFailedException ex) {
                throw new CompletionException(ex);
            }
        });
    }

    public CompletableFuture<Void> commitTransaction(Stream stream, String writerId, Long timestamp, UUID txnId) {
        long time = Optional.ofNullable(timestamp).orElse(Long.MIN_VALUE);
        return this.controller.commitTransaction(stream.getScope(), stream.getStreamName(), txnId, writerId, time, this.requestIdGenerator.nextLong()).thenApply(x -> null);
    }

    public CompletableFuture<Void> abortTransaction(Stream stream, UUID txnId) {
        return this.controller.abortTransaction(stream.getScope(), stream.getStreamName(), txnId, this.requestIdGenerator.nextLong()).thenApply(x -> null);
    }

    public CompletableFuture<Transaction.Status> checkTransactionStatus(Stream stream, UUID txnId) {
        return this.controller.checkTransactionStatus(stream.getScope(), stream.getStreamName(), txnId, this.requestIdGenerator.nextLong()).thenApply(status -> ModelHelper.encode((Controller.TxnState.State)status.getState(), (String)(stream + " " + txnId)));
    }

    public CompletableFuture<Map<Segment, Long>> getSegmentsAtTime(Stream stream, long timestamp) {
        return this.controller.getSegmentsAtHead(stream.getScope(), stream.getStreamName(), this.requestIdGenerator.nextLong()).thenApply(segments -> segments.entrySet().stream().collect(Collectors.toMap(entry -> ModelHelper.encode((Controller.SegmentId)((Controller.SegmentId)entry.getKey())), Map.Entry::getValue)));
    }

    public CompletableFuture<StreamSegmentsWithPredecessors> getSuccessors(Segment segment) {
        return this.controller.getSegmentsImmediatelyFollowing(ModelHelper.decode((Segment)segment), this.requestIdGenerator.nextLong()).thenApply(x -> {
            HashMap map = new HashMap();
            x.forEach((segmentId, list) -> map.put(ModelHelper.encode((Controller.SegmentRange)segmentId), list));
            return new StreamSegmentsWithPredecessors(map, this.retrieveDelegationToken());
        });
    }

    public CompletableFuture<StreamSegmentSuccessors> getSuccessors(StreamCut from) {
        return this.getSegments(from, StreamCut.UNBOUNDED);
    }

    public CompletableFuture<StreamSegmentSuccessors> getSegments(StreamCut fromStreamCut, StreamCut toStreamCut) {
        Stream stream = fromStreamCut.asImpl().getStream();
        return ((CompletableFuture)this.controller.getSegmentsBetweenStreamCuts(ModelHelper.decode((String)stream.getScope(), (String)stream.getStreamName(), this.getStreamCutMap(fromStreamCut), this.getStreamCutMap(toStreamCut)), this.requestIdGenerator.nextLong()).thenApply(segments -> ModelHelper.createStreamCutRangeResponse((String)stream.getScope(), (String)stream.getStreamName(), segments.stream().map(x -> ModelHelper.createSegmentId((String)stream.getScope(), (String)stream.getStreamName(), (long)x.segmentId())).collect(Collectors.toList()), (String)this.retrieveDelegationToken()))).thenApply(response -> new StreamSegmentSuccessors(response.getSegmentsList().stream().map(ModelHelper::encode).collect(Collectors.toSet()), response.getDelegationToken()));
    }

    public CompletableFuture<PravegaNodeUri> getEndpointForSegment(String qualifiedSegmentName) {
        Segment segment = Segment.fromScopedName((String)qualifiedSegmentName);
        return this.controller.getURI(ModelHelper.createSegmentId((String)segment.getScope(), (String)segment.getStreamName(), (long)segment.getSegmentId())).thenApply(ModelHelper::encode);
    }

    public CompletableFuture<Boolean> isSegmentOpen(Segment segment) {
        return this.controller.isSegmentValid(segment.getScope(), segment.getStreamName(), segment.getSegmentId(), this.requestIdGenerator.nextLong());
    }

    public void close() {
    }

    public String retrieveDelegationToken() {
        if (this.authorizationEnabled) {
            return GrpcAuthHelper.retrieveMasterToken(this.tokenSigningKey);
        }
        return "";
    }

    public CompletableFuture<String> getOrRefreshDelegationTokenFor(String scope, String streamName, AccessOperation accessOperation) {
        String retVal = "";
        if (this.authorizationEnabled) {
            retVal = GrpcAuthHelper.retrieveMasterToken(this.tokenSigningKey);
        }
        return CompletableFuture.completedFuture(retVal);
    }

    private Map<Long, Long> getStreamCutMap(StreamCut streamCut) {
        if (streamCut.equals(StreamCut.UNBOUNDED)) {
            return Collections.emptyMap();
        }
        return streamCut.asImpl().getPositions().entrySet().stream().collect(Collectors.toMap(x -> ((Segment)x.getKey()).getSegmentId(), Map.Entry::getValue));
    }

    public CompletableFuture<Void> noteTimestampFromWriter(String writer, Stream stream, long timestamp, WriterPosition lastWrittenPosition) {
        Map map = ModelHelper.createStreamCut((Stream)stream, (WriterPosition)lastWrittenPosition).getCutMap();
        return Futures.toVoid(this.controller.noteTimestampFromWriter(stream.getScope(), stream.getStreamName(), writer, timestamp, map, this.requestIdGenerator.nextLong()));
    }

    public CompletableFuture<Void> removeWriter(String writerId, Stream stream) {
        return Futures.toVoid(this.controller.removeWriter(stream.getScope(), stream.getStreamName(), writerId, this.requestIdGenerator.nextLong()));
    }

    public CompletableFuture<Boolean> createKeyValueTable(String scope, String kvtName, KeyValueTableConfiguration kvtConfig) {
        return this.controller.createKeyValueTable(scope, kvtName, kvtConfig, System.currentTimeMillis(), this.requestIdGenerator.nextLong()).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to create KeyValueTable: " + kvtName);
                }
                case INVALID_TABLE_NAME: {
                    throw new IllegalArgumentException("Illegal KeyValueTable name: " + kvtName);
                }
                case SCOPE_NOT_FOUND: {
                    throw new IllegalArgumentException("Scope does not exist: " + scope);
                }
                case TABLE_EXISTS: {
                    return false;
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status creating kvtable " + kvtName + " " + x.getStatus());
        });
    }

    public AsyncIterator<KeyValueTableInfo> listKeyValueTables(String scopeName) {
        Function<String, CompletableFuture> function = token -> this.controller.listKeyValueTables(scopeName, (String)token, 1000, this.requestIdGenerator.nextLong()).thenApply(result -> {
            List kvTablesList = ((List)result.getLeft()).stream().map(kvt -> new KeyValueTableInfo(scopeName, kvt)).collect(Collectors.toList());
            return new AbstractMap.SimpleEntry((String)result.getValue(), kvTablesList);
        });
        return new ContinuationTokenAsyncIterator(function, (Object)"");
    }

    public CompletableFuture<KeyValueTableConfiguration> getKeyValueTableConfiguration(String scope, String kvtName) {
        return this.controller.getKeyValueTableConfiguration(scope, kvtName, this.requestIdGenerator.nextLong()).thenApply(x -> {
            String scopedKvtName = NameUtils.getScopedKeyValueTableName((String)scope, (String)kvtName);
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to get configuration for key-value table: " + scopedKvtName);
                }
                case TABLE_NOT_FOUND: {
                    throw new IllegalArgumentException("Key-value table does not exist: " + scopedKvtName);
                }
                case SUCCESS: {
                    return ModelHelper.encode((Controller.KeyValueTableConfig)x.getConfig());
                }
            }
            throw new ControllerFailureException("Unknown return status getting key-value table configuration " + scopedKvtName + " " + x.getStatus());
        });
    }

    public CompletableFuture<Boolean> deleteKeyValueTable(String scope, String kvtName) {
        return this.controller.deleteKeyValueTable(scope, kvtName, this.requestIdGenerator.nextLong()).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to delete KeyValueTable: " + kvtName);
                }
                case TABLE_NOT_FOUND: {
                    return false;
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status deleting KeyValueTable " + kvtName + " " + x.getStatus());
        });
    }

    public CompletableFuture<KeyValueTableSegments> getCurrentSegmentsForKeyValueTable(String scope, String kvtName) {
        return this.controller.getCurrentSegmentsKeyValueTable(scope, kvtName, this.requestIdGenerator.nextLong()).thenApply(this::getKeyValueTableSegments);
    }

    private KeyValueTableSegments getKeyValueTableSegments(List<Controller.SegmentRange> ranges) {
        return new KeyValueTableSegments(this.getRangeMap(ranges));
    }

    private NavigableMap<Double, SegmentWithRange> getRangeMap(List<Controller.SegmentRange> ranges) {
        TreeMap<Double, SegmentWithRange> rangeMap = new TreeMap<Double, SegmentWithRange>();
        for (Controller.SegmentRange r : ranges) {
            rangeMap.put(r.getMaxKey(), new SegmentWithRange(ModelHelper.encode((Controller.SegmentId)r.getSegmentId()), r.getMinKey(), r.getMaxKey()));
        }
        return rangeMap;
    }
}

