/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.ScalingPolicy;
import io.pravega.common.Exceptions;
import io.pravega.controller.eventProcessor.CheckpointConfig;
import io.pravega.controller.server.eventProcessor.ControllerEventProcessorConfig;
import io.pravega.controller.util.Config;
import io.pravega.shared.NameUtils;
import java.time.Duration;
import lombok.Generated;

public class ControllerEventProcessorConfigImpl
implements ControllerEventProcessorConfig {
    private final String scopeName;
    private final String commitStreamName;
    private final ScalingPolicy commitStreamScalingPolicy;
    private final String abortStreamName;
    private final ScalingPolicy abortStreamScalingPolicy;
    private final String scaleStreamName;
    private final ScalingPolicy scaleStreamScalingPolicy;
    private final String kvtStreamName;
    private final ScalingPolicy kvtStreamScalingPolicy;
    private final String commitReaderGroupName;
    private final int commitReaderGroupSize;
    private final String abortReaderGroupName;
    private final int abortReaderGroupSize;
    private final String scaleReaderGroupName;
    private final int scaleReaderGroupSize;
    private final String kvtReaderGroupName;
    private final int kvtReaderGroupSize;
    private final CheckpointConfig commitCheckpointConfig;
    private final CheckpointConfig abortCheckpointConfig;
    private final CheckpointConfig scaleCheckpointConfig;
    private final long rebalanceIntervalMillis;
    private final Duration shutdownTimeout;

    ControllerEventProcessorConfigImpl(String scopeName, String commitStreamName, ScalingPolicy commitStreamScalingPolicy, String abortStreamName, ScalingPolicy abortStreamScalingPolicy, String commitReaderGroupName, int commitReaderGroupSize, String abortReaderGroupName, int abortReaderGroupSize, String kvtStreamName, String kvtReaderGroupName, int kvtReaderGroupSize, ScalingPolicy kvtStreamScalingPolicy, CheckpointConfig commitCheckpointConfig, CheckpointConfig abortCheckpointConfig, ScalingPolicy scaleStreamScalingPolicy, long rebalanceIntervalMillis, Duration shutdownTimeout) {
        Exceptions.checkNotNullOrEmpty((String)scopeName, (String)"scopeName");
        Exceptions.checkNotNullOrEmpty((String)commitStreamName, (String)"commitStreamName");
        Exceptions.checkNotNullOrEmpty((String)abortStreamName, (String)"abortStreamName");
        Exceptions.checkNotNullOrEmpty((String)kvtStreamName, (String)"kvTableStreamName");
        Exceptions.checkNotNullOrEmpty((String)commitReaderGroupName, (String)"commitReaderGroupName");
        Exceptions.checkNotNullOrEmpty((String)abortReaderGroupName, (String)"abortReaderGroupName");
        Exceptions.checkNotNullOrEmpty((String)kvtReaderGroupName, (String)"kvTableReaderGroupName");
        Preconditions.checkArgument((commitReaderGroupSize > 0 ? 1 : 0) != 0, (Object)"commitReaderGroupSize should be a positive integer");
        Preconditions.checkArgument((abortReaderGroupSize > 0 ? 1 : 0) != 0, (Object)"abortReaderGroupSize should be a positive integer");
        Preconditions.checkArgument((kvtReaderGroupSize > 0 ? 1 : 0) != 0, (Object)"kvTableReaderGroupSize should be a positive integer");
        Preconditions.checkNotNull((Object)commitStreamScalingPolicy, (Object)"commitStreamScalingPolicy");
        Preconditions.checkNotNull((Object)abortStreamScalingPolicy, (Object)"abortStreamScalingPolicy");
        Preconditions.checkNotNull((Object)scaleStreamScalingPolicy, (Object)"scaleStreamScalingPolicy");
        Preconditions.checkNotNull((Object)commitCheckpointConfig, (Object)"commitCheckpointConfig");
        Preconditions.checkNotNull((Object)abortCheckpointConfig, (Object)"abortCheckpointConfig");
        this.scopeName = scopeName;
        this.commitStreamName = commitStreamName;
        this.commitStreamScalingPolicy = commitStreamScalingPolicy;
        this.abortStreamName = abortStreamName;
        this.abortStreamScalingPolicy = abortStreamScalingPolicy;
        this.kvtStreamName = kvtStreamName;
        this.kvtStreamScalingPolicy = kvtStreamScalingPolicy;
        this.commitReaderGroupName = commitReaderGroupName;
        this.commitReaderGroupSize = commitReaderGroupSize;
        this.abortReaderGroupName = abortReaderGroupName;
        this.abortReaderGroupSize = abortReaderGroupSize;
        this.kvtReaderGroupName = kvtReaderGroupName;
        this.kvtReaderGroupSize = kvtReaderGroupSize;
        this.commitCheckpointConfig = commitCheckpointConfig;
        this.abortCheckpointConfig = abortCheckpointConfig;
        this.scaleStreamName = Config.SCALE_STREAM_NAME;
        this.scaleStreamScalingPolicy = scaleStreamScalingPolicy;
        this.scaleReaderGroupName = Config.SCALE_READER_GROUP;
        this.scaleReaderGroupSize = 1;
        this.scaleCheckpointConfig = CheckpointConfig.none();
        this.rebalanceIntervalMillis = rebalanceIntervalMillis;
        this.shutdownTimeout = shutdownTimeout == null ? Duration.ofSeconds(10L) : shutdownTimeout;
    }

    public static ControllerEventProcessorConfig withDefault() {
        return ControllerEventProcessorConfigImpl.withDefaultBuilder().build();
    }

    public static ControllerEventProcessorConfigImplBuilder withDefaultBuilder() {
        return ControllerEventProcessorConfigImpl.builder().scopeName("_system").commitStreamName(NameUtils.getInternalNameForStream((String)"commitStream")).abortStreamName(NameUtils.getInternalNameForStream((String)"abortStream")).kvtStreamName(NameUtils.getInternalNameForStream((String)"kvTableStream")).commitStreamScalingPolicy(ScalingPolicy.fixed((int)2)).abortStreamScalingPolicy(ScalingPolicy.fixed((int)2)).scaleStreamScalingPolicy(ScalingPolicy.fixed((int)2)).kvtStreamScalingPolicy(ScalingPolicy.fixed((int)5)).commitReaderGroupName("commitStreamReaders").commitReaderGroupSize(1).abortReaderGroupName("abortStreamReaders").abortReaderGroupSize(1).kvtReaderGroupName("kvtStreamReaders").kvtReaderGroupSize(1).commitCheckpointConfig(CheckpointConfig.periodic(10, 10)).abortCheckpointConfig(CheckpointConfig.periodic(10, 10)).rebalanceIntervalMillis(Duration.ofMinutes(2L).toMillis());
    }

    @Override
    public String getRequestStreamName() {
        return this.scaleStreamName;
    }

    @Override
    public String getRequestReaderGroupName() {
        return this.scaleReaderGroupName;
    }

    @Override
    public ScalingPolicy getRequestStreamScalingPolicy() {
        return this.scaleStreamScalingPolicy;
    }

    @Override
    public CheckpointConfig getRequestStreamCheckpointConfig() {
        return this.scaleCheckpointConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ControllerEventProcessorConfigImplBuilder builder() {
        return new ControllerEventProcessorConfigImplBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ControllerEventProcessorConfigImpl(scopeName=" + this.getScopeName() + ", commitStreamName=" + this.getCommitStreamName() + ", commitStreamScalingPolicy=" + this.getCommitStreamScalingPolicy() + ", abortStreamName=" + this.getAbortStreamName() + ", abortStreamScalingPolicy=" + this.getAbortStreamScalingPolicy() + ", scaleStreamName=" + this.getScaleStreamName() + ", scaleStreamScalingPolicy=" + this.getScaleStreamScalingPolicy() + ", kvtStreamName=" + this.getKvtStreamName() + ", kvtStreamScalingPolicy=" + this.getKvtStreamScalingPolicy() + ", commitReaderGroupName=" + this.getCommitReaderGroupName() + ", commitReaderGroupSize=" + this.getCommitReaderGroupSize() + ", abortReaderGroupName=" + this.getAbortReaderGroupName() + ", abortReaderGroupSize=" + this.getAbortReaderGroupSize() + ", scaleReaderGroupName=" + this.getScaleReaderGroupName() + ", scaleReaderGroupSize=" + this.getScaleReaderGroupSize() + ", kvtReaderGroupName=" + this.getKvtReaderGroupName() + ", kvtReaderGroupSize=" + this.getKvtReaderGroupSize() + ", commitCheckpointConfig=" + this.getCommitCheckpointConfig() + ", abortCheckpointConfig=" + this.getAbortCheckpointConfig() + ", scaleCheckpointConfig=" + this.getScaleCheckpointConfig() + ", rebalanceIntervalMillis=" + this.getRebalanceIntervalMillis() + ", shutdownTimeout=" + this.getShutdownTimeout() + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScopeName() {
        return this.scopeName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCommitStreamName() {
        return this.commitStreamName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScalingPolicy getCommitStreamScalingPolicy() {
        return this.commitStreamScalingPolicy;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAbortStreamName() {
        return this.abortStreamName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScalingPolicy getAbortStreamScalingPolicy() {
        return this.abortStreamScalingPolicy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScaleStreamName() {
        return this.scaleStreamName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScalingPolicy getScaleStreamScalingPolicy() {
        return this.scaleStreamScalingPolicy;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKvtStreamName() {
        return this.kvtStreamName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScalingPolicy getKvtStreamScalingPolicy() {
        return this.kvtStreamScalingPolicy;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCommitReaderGroupName() {
        return this.commitReaderGroupName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getCommitReaderGroupSize() {
        return this.commitReaderGroupSize;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAbortReaderGroupName() {
        return this.abortReaderGroupName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getAbortReaderGroupSize() {
        return this.abortReaderGroupSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScaleReaderGroupName() {
        return this.scaleReaderGroupName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getScaleReaderGroupSize() {
        return this.scaleReaderGroupSize;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKvtReaderGroupName() {
        return this.kvtReaderGroupName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getKvtReaderGroupSize() {
        return this.kvtReaderGroupSize;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CheckpointConfig getCommitCheckpointConfig() {
        return this.commitCheckpointConfig;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CheckpointConfig getAbortCheckpointConfig() {
        return this.abortCheckpointConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CheckpointConfig getScaleCheckpointConfig() {
        return this.scaleCheckpointConfig;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRebalanceIntervalMillis() {
        return this.rebalanceIntervalMillis;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ControllerEventProcessorConfigImplBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String scopeName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String commitStreamName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ScalingPolicy commitStreamScalingPolicy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String abortStreamName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ScalingPolicy abortStreamScalingPolicy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String commitReaderGroupName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int commitReaderGroupSize;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String abortReaderGroupName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int abortReaderGroupSize;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String kvtStreamName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String kvtReaderGroupName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int kvtReaderGroupSize;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ScalingPolicy kvtStreamScalingPolicy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private CheckpointConfig commitCheckpointConfig;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private CheckpointConfig abortCheckpointConfig;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ScalingPolicy scaleStreamScalingPolicy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long rebalanceIntervalMillis;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Duration shutdownTimeout;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ControllerEventProcessorConfigImplBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder scopeName(String scopeName) {
            this.scopeName = scopeName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder commitStreamName(String commitStreamName) {
            this.commitStreamName = commitStreamName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder commitStreamScalingPolicy(ScalingPolicy commitStreamScalingPolicy) {
            this.commitStreamScalingPolicy = commitStreamScalingPolicy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder abortStreamName(String abortStreamName) {
            this.abortStreamName = abortStreamName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder abortStreamScalingPolicy(ScalingPolicy abortStreamScalingPolicy) {
            this.abortStreamScalingPolicy = abortStreamScalingPolicy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder commitReaderGroupName(String commitReaderGroupName) {
            this.commitReaderGroupName = commitReaderGroupName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder commitReaderGroupSize(int commitReaderGroupSize) {
            this.commitReaderGroupSize = commitReaderGroupSize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder abortReaderGroupName(String abortReaderGroupName) {
            this.abortReaderGroupName = abortReaderGroupName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder abortReaderGroupSize(int abortReaderGroupSize) {
            this.abortReaderGroupSize = abortReaderGroupSize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder kvtStreamName(String kvtStreamName) {
            this.kvtStreamName = kvtStreamName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder kvtReaderGroupName(String kvtReaderGroupName) {
            this.kvtReaderGroupName = kvtReaderGroupName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder kvtReaderGroupSize(int kvtReaderGroupSize) {
            this.kvtReaderGroupSize = kvtReaderGroupSize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder kvtStreamScalingPolicy(ScalingPolicy kvtStreamScalingPolicy) {
            this.kvtStreamScalingPolicy = kvtStreamScalingPolicy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder commitCheckpointConfig(CheckpointConfig commitCheckpointConfig) {
            this.commitCheckpointConfig = commitCheckpointConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder abortCheckpointConfig(CheckpointConfig abortCheckpointConfig) {
            this.abortCheckpointConfig = abortCheckpointConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder scaleStreamScalingPolicy(ScalingPolicy scaleStreamScalingPolicy) {
            this.scaleStreamScalingPolicy = scaleStreamScalingPolicy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder rebalanceIntervalMillis(long rebalanceIntervalMillis) {
            this.rebalanceIntervalMillis = rebalanceIntervalMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImplBuilder shutdownTimeout(Duration shutdownTimeout) {
            this.shutdownTimeout = shutdownTimeout;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerEventProcessorConfigImpl build() {
            return new ControllerEventProcessorConfigImpl(this.scopeName, this.commitStreamName, this.commitStreamScalingPolicy, this.abortStreamName, this.abortStreamScalingPolicy, this.commitReaderGroupName, this.commitReaderGroupSize, this.abortReaderGroupName, this.abortReaderGroupSize, this.kvtStreamName, this.kvtReaderGroupName, this.kvtReaderGroupSize, this.kvtStreamScalingPolicy, this.commitCheckpointConfig, this.abortCheckpointConfig, this.scaleStreamScalingPolicy, this.rebalanceIntervalMillis, this.shutdownTimeout);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ControllerEventProcessorConfigImpl.ControllerEventProcessorConfigImplBuilder(scopeName=" + this.scopeName + ", commitStreamName=" + this.commitStreamName + ", commitStreamScalingPolicy=" + this.commitStreamScalingPolicy + ", abortStreamName=" + this.abortStreamName + ", abortStreamScalingPolicy=" + this.abortStreamScalingPolicy + ", commitReaderGroupName=" + this.commitReaderGroupName + ", commitReaderGroupSize=" + this.commitReaderGroupSize + ", abortReaderGroupName=" + this.abortReaderGroupName + ", abortReaderGroupSize=" + this.abortReaderGroupSize + ", kvtStreamName=" + this.kvtStreamName + ", kvtReaderGroupName=" + this.kvtReaderGroupName + ", kvtReaderGroupSize=" + this.kvtReaderGroupSize + ", kvtStreamScalingPolicy=" + this.kvtStreamScalingPolicy + ", commitCheckpointConfig=" + this.commitCheckpointConfig + ", abortCheckpointConfig=" + this.abortCheckpointConfig + ", scaleStreamScalingPolicy=" + this.scaleStreamScalingPolicy + ", rebalanceIntervalMillis=" + this.rebalanceIntervalMillis + ", shutdownTimeout=" + this.shutdownTimeout + ")";
        }
    }
}

