/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers;

import com.google.common.annotations.VisibleForTesting;
import io.pravega.common.Timer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.eventProcessor.impl.SerializedRequestHandler;
import io.pravega.controller.metrics.TransactionMetrics;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.store.stream.records.StreamSegmentRecord;
import io.pravega.controller.task.Stream.StreamMetadataTasks;
import io.pravega.shared.controller.event.AbortEvent;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class AbortRequestHandler
extends SerializedRequestHandler<AbortEvent> {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(AbortRequestHandler.class));
    private final StreamMetadataStore streamMetadataStore;
    private final StreamMetadataTasks streamMetadataTasks;
    private final ScheduledExecutorService executor;
    private final BlockingQueue<AbortEvent> processedEvents;

    @VisibleForTesting
    public AbortRequestHandler(StreamMetadataStore streamMetadataStore, StreamMetadataTasks streamMetadataTasks, ScheduledExecutorService executor, BlockingQueue<AbortEvent> queue) {
        super(executor);
        this.streamMetadataStore = streamMetadataStore;
        this.streamMetadataTasks = streamMetadataTasks;
        this.executor = executor;
        this.processedEvents = queue;
    }

    public AbortRequestHandler(StreamMetadataStore streamMetadataStore, StreamMetadataTasks streamMetadataTasks, ScheduledExecutorService executor) {
        super(executor);
        this.streamMetadataStore = streamMetadataStore;
        this.streamMetadataTasks = streamMetadataTasks;
        this.executor = executor;
        this.processedEvents = null;
    }

    @Override
    public CompletableFuture<Void> processEvent(AbortEvent event) {
        String scope = event.getScope();
        String stream = event.getStream();
        int epoch = event.getEpoch();
        UUID txId = event.getTxid();
        Timer timer = new Timer();
        long requestId = this.streamMetadataTasks.getRequestId(null);
        OperationContext context = this.streamMetadataStore.createStreamContext(scope, stream, requestId);
        log.info(requestId, "Aborting transaction {} on stream {}/{}", new Object[]{event.getTxid(), event.getScope(), event.getStream()});
        return Futures.toVoid((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.streamMetadataStore.getSegmentsInEpoch(event.getScope(), event.getStream(), epoch, context, this.executor).thenApply(segments -> segments.stream().map(StreamSegmentRecord::segmentId).collect(Collectors.toList()))).thenCompose(segments -> this.streamMetadataTasks.notifyTxnAbort(scope, stream, (List<Long>)segments, txId, requestId))).thenCompose(x -> this.streamMetadataStore.abortTransaction(scope, stream, txId, context, this.executor))).whenComplete((result, error) -> {
            if (error != null) {
                log.warn(requestId, "Failed aborting transaction {} on stream {}/{}", new Object[]{event.getTxid(), event.getScope(), event.getStream()});
                TransactionMetrics.getInstance().abortTransactionFailed(scope, stream, event.getTxid().toString());
            } else {
                log.info(requestId, "Successfully aborted transaction {} on stream {}/{}", new Object[]{event.getTxid(), event.getScope(), event.getStream()});
                if (this.processedEvents != null) {
                    this.processedEvents.offer(event);
                }
                TransactionMetrics.getInstance().abortTransaction(scope, stream, timer.getElapsed());
            }
        }));
    }
}

