/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.Retry;
import io.pravega.controller.eventProcessor.impl.EventProcessorHelper;
import io.pravega.controller.eventProcessor.impl.SerializedRequestHandler;
import io.pravega.controller.server.eventProcessor.requesthandlers.RequestUnsupportedException;
import io.pravega.controller.server.eventProcessor.requesthandlers.StreamTask;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.shared.controller.event.AbortEvent;
import io.pravega.shared.controller.event.AutoScaleEvent;
import io.pravega.shared.controller.event.CommitEvent;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.CreateReaderGroupEvent;
import io.pravega.shared.controller.event.DeleteReaderGroupEvent;
import io.pravega.shared.controller.event.DeleteStreamEvent;
import io.pravega.shared.controller.event.RequestProcessor;
import io.pravega.shared.controller.event.ScaleOpEvent;
import io.pravega.shared.controller.event.SealStreamEvent;
import io.pravega.shared.controller.event.StreamRequestProcessor;
import io.pravega.shared.controller.event.TruncateStreamEvent;
import io.pravega.shared.controller.event.UpdateReaderGroupEvent;
import io.pravega.shared.controller.event.UpdateStreamEvent;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestProcessor<T extends ControllerEvent>
extends SerializedRequestHandler<T>
implements StreamRequestProcessor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRequestProcessor.class);
    protected static final Predicate<Throwable> OPERATION_NOT_ALLOWED_PREDICATE = e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.OperationNotAllowedException;
    protected final StreamMetadataStore streamMetadataStore;

    public AbstractRequestProcessor(StreamMetadataStore streamMetadataStore, ScheduledExecutorService executor) {
        super(executor);
        Preconditions.checkNotNull((Object)streamMetadataStore);
        this.streamMetadataStore = streamMetadataStore;
    }

    public String getProcessorName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public CompletableFuture<Void> processEvent(ControllerEvent controllerEvent) {
        return controllerEvent.process((RequestProcessor)this);
    }

    public CompletableFuture<Void> processAbortTxnRequest(AbortEvent abortEvent) {
        return Futures.failedFuture((Throwable)new RequestUnsupportedException("Request Unsupported"));
    }

    public CompletableFuture<Void> processCommitTxnRequest(CommitEvent commitEvent) {
        return Futures.failedFuture((Throwable)new RequestUnsupportedException("Request Unsupported"));
    }

    public CompletableFuture<Void> processAutoScaleRequest(AutoScaleEvent autoScaleEvent) {
        return Futures.failedFuture((Throwable)new RequestUnsupportedException("Request Unsupported"));
    }

    public CompletableFuture<Void> processScaleOpRequest(ScaleOpEvent scaleOpEvent) {
        return Futures.failedFuture((Throwable)new RequestUnsupportedException("Request Unsupported"));
    }

    public CompletableFuture<Void> processUpdateStream(UpdateStreamEvent updateStreamEvent) {
        return Futures.failedFuture((Throwable)new RequestUnsupportedException("Request Unsupported"));
    }

    public CompletableFuture<Void> processTruncateStream(TruncateStreamEvent truncateStreamEvent) {
        return Futures.failedFuture((Throwable)new RequestUnsupportedException("Request Unsupported"));
    }

    public CompletableFuture<Void> processSealStream(SealStreamEvent sealStreamEvent) {
        return Futures.failedFuture((Throwable)new RequestUnsupportedException("Request Unsupported"));
    }

    public CompletableFuture<Void> processDeleteStream(DeleteStreamEvent deleteStreamEvent) {
        return Futures.failedFuture((Throwable)new RequestUnsupportedException("Request Unsupported"));
    }

    public CompletableFuture<Void> processCreateReaderGroup(CreateReaderGroupEvent createRGEvent) {
        return Futures.failedFuture((Throwable)new RequestUnsupportedException("Request Unsupported"));
    }

    public CompletableFuture<Void> processDeleteReaderGroup(DeleteReaderGroupEvent deleteRGEvent) {
        return Futures.failedFuture((Throwable)new RequestUnsupportedException("Request Unsupported"));
    }

    public CompletableFuture<Void> processUpdateReaderGroup(UpdateReaderGroupEvent updateRGEvent) {
        return Futures.failedFuture((Throwable)new RequestUnsupportedException("Request Unsupported"));
    }

    protected <T extends ControllerEvent> CompletableFuture<Void> withCompletion(StreamTask<T> task, T event, String scope, String stream, Predicate<Throwable> writeBackPredicate) {
        Preconditions.checkNotNull(task);
        Preconditions.checkNotNull(event);
        Preconditions.checkNotNull((Object)scope);
        Preconditions.checkNotNull((Object)stream);
        Preconditions.checkNotNull(writeBackPredicate);
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        OperationContext context = this.streamMetadataStore.createStreamContext(scope, stream, 0L);
        CompletableFuture<Object> waitingProcFuture = this.suppressException(this.streamMetadataStore.getWaitingRequestProcessor(scope, stream, context, this.executor), null, "Exception while trying to fetch waiting request. Logged and ignored.");
        CompletableFuture<Boolean> hasTaskStarted = task.hasTaskStarted(event);
        ((CompletableFuture)CompletableFuture.allOf(waitingProcFuture, hasTaskStarted).thenAccept(v -> {
            boolean hasStarted = (Boolean)hasTaskStarted.join();
            String waitingRequestProcessor = (String)waitingProcFuture.join();
            if (hasStarted || waitingRequestProcessor == null || waitingRequestProcessor.equals(this.getProcessorName())) {
                EventProcessorHelper.withRetries(() -> task.execute(event), this.executor).whenComplete((r, ex) -> {
                    if (ex != null && writeBackPredicate.test((Throwable)ex)) {
                        this.suppressException(this.streamMetadataStore.createWaitingRequestIfAbsent(scope, stream, this.getProcessorName(), context, this.executor), null, "Exception while trying to create waiting request. Logged and ignored.").thenCompose(ignore -> this.retryIndefinitelyThenComplete(() -> task.writeBack(event), resultFuture, (Throwable)ex));
                    } else {
                        this.retryIndefinitelyThenComplete(() -> this.streamMetadataStore.deleteWaitingRequestConditionally(scope, stream, this.getProcessorName(), context, this.executor), resultFuture, (Throwable)ex);
                    }
                });
            } else {
                log.debug("Found another processing requested by a different processor {}. Will postpone the event {}.", (Object)waitingRequestProcessor, (Object)event);
                this.retryIndefinitelyThenComplete(() -> task.writeBack(event), resultFuture, StoreException.create(StoreException.Type.OPERATION_NOT_ALLOWED, "Postponed " + event + " so that waiting processor" + waitingRequestProcessor + " can work. "));
            }
        })).exceptionally(e -> {
            resultFuture.completeExceptionally((Throwable)e);
            return null;
        });
        return resultFuture;
    }

    private <R> CompletableFuture<R> suppressException(CompletableFuture<R> future, R returnOnException, String message) {
        return Futures.exceptionallyExpecting(future, e -> {
            log.warn("{}. Exception {}", (Object)message, (Object)Exceptions.unwrap((Throwable)e).toString());
            return true;
        }, returnOnException);
    }

    private CompletableFuture<Void> retryIndefinitelyThenComplete(Supplier<CompletableFuture<Void>> futureSupplier, CompletableFuture<Void> toComplete, Throwable e) {
        String failureMessage = String.format("Error writing event back into stream from processor %s", this.getProcessorName());
        return Retry.indefinitelyWithExpBackoff((String)failureMessage).runAsync(futureSupplier, this.executor).thenRun(() -> {
            if (e != null) {
                toComplete.completeExceptionally(e);
            } else {
                toComplete.complete(null);
            }
        });
    }
}

