/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.pravega.client.stream.ScalingPolicy;
import io.pravega.common.Exceptions;
import io.pravega.common.Timer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.metrics.TransactionMetrics;
import io.pravega.controller.server.eventProcessor.requesthandlers.AbstractRequestProcessor;
import io.pravega.controller.server.eventProcessor.requesthandlers.StreamTask;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.stream.BucketStore;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.State;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.store.stream.TxnWriterMark;
import io.pravega.controller.store.stream.records.CommittingTransactionsRecord;
import io.pravega.controller.store.stream.records.EpochRecord;
import io.pravega.controller.task.Stream.StreamMetadataTasks;
import io.pravega.controller.task.Stream.StreamTransactionMetadataTasks;
import io.pravega.shared.NameUtils;
import io.pravega.shared.controller.event.CommitEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.curator.shaded.com.google.common.base.Strings;
import org.slf4j.LoggerFactory;

public class CommitRequestHandler
extends AbstractRequestProcessor<CommitEvent>
implements StreamTask<CommitEvent> {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(CommitRequestHandler.class));
    private static final int MAX_TRANSACTION_COMMIT_BATCH_SIZE = 100;
    private final StreamMetadataTasks streamMetadataTasks;
    private final StreamTransactionMetadataTasks streamTransactionMetadataTasks;
    private final BucketStore bucketStore;
    private final ScheduledExecutorService executor;
    private final BlockingQueue<CommitEvent> processedEvents;

    public CommitRequestHandler(StreamMetadataStore streamMetadataStore, StreamMetadataTasks streamMetadataTasks, StreamTransactionMetadataTasks streamTransactionMetadataTasks, BucketStore bucketStore, ScheduledExecutorService executor) {
        this(streamMetadataStore, streamMetadataTasks, streamTransactionMetadataTasks, bucketStore, executor, null);
    }

    @VisibleForTesting
    public CommitRequestHandler(StreamMetadataStore streamMetadataStore, StreamMetadataTasks streamMetadataTasks, StreamTransactionMetadataTasks streamTransactionMetadataTasks, BucketStore bucketStore, ScheduledExecutorService executor, BlockingQueue<CommitEvent> queue) {
        super(streamMetadataStore, executor);
        this.bucketStore = bucketStore;
        Preconditions.checkNotNull((Object)streamMetadataStore);
        Preconditions.checkNotNull((Object)streamMetadataTasks);
        Preconditions.checkNotNull((Object)executor);
        this.streamMetadataTasks = streamMetadataTasks;
        this.streamTransactionMetadataTasks = streamTransactionMetadataTasks;
        this.executor = executor;
        this.processedEvents = queue;
    }

    @Override
    public CompletableFuture<Void> processCommitTxnRequest(CommitEvent event) {
        return this.withCompletion(this, event, event.getScope(), event.getStream(), OPERATION_NOT_ALLOWED_PREDICATE);
    }

    @Override
    public CompletableFuture<Void> execute(CommitEvent event) {
        String scope = event.getScope();
        String stream = event.getStream();
        long requestId = this.streamMetadataTasks.getRequestId(null);
        OperationContext context = this.streamMetadataStore.createStreamContext(scope, stream, requestId);
        log.debug(requestId, "Attempting to commit available transactions on stream {}/{}", new Object[]{event.getScope(), event.getStream()});
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.tryCommitTransactions(scope, stream, context).whenComplete((r, e) -> {
            if (e != null) {
                Throwable cause = Exceptions.unwrap((Throwable)e);
                if (cause instanceof StoreException.OperationNotAllowedException) {
                    log.debug(requestId, "Cannot commit transaction on stream {}/{}. Postponing", new Object[]{scope, stream});
                } else {
                    log.warn(requestId, "Exception while attempting to commit transaction on stream {}/{}", new Object[]{scope, stream, e});
                    TransactionMetrics.getInstance().commitTransactionFailed(scope, stream);
                }
                future.completeExceptionally(cause);
            } else {
                if (r >= 0) {
                    log.info(requestId, "Successfully committed transactions on epoch {} on stream {}/{}", new Object[]{r, scope, stream});
                } else {
                    log.info(requestId, "No transactions found in committing state on stream {}/{}", new Object[]{scope, stream});
                }
                if (this.processedEvents != null) {
                    try {
                        this.processedEvents.offer(event);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                future.complete(null);
            }
        });
        return future;
    }

    private CompletableFuture<Integer> tryCommitTransactions(String scope, String stream, OperationContext context) {
        Timer timer = new Timer();
        HashMap writerMarks = new HashMap();
        HashMap txnIdToWriterId = new HashMap();
        return this.streamMetadataStore.getVersionedState(scope, stream, context, this.executor).thenComposeAsync(state -> {
            AtomicReference<VersionedMetadata> stateRecord = new AtomicReference<VersionedMetadata>((VersionedMetadata)state);
            CompletionStage commitFuture = this.streamMetadataStore.startCommitTransactions(scope, stream, 100, context, this.executor).thenComposeAsync(txnsTuple -> {
                VersionedMetadata committingTxnsRecord = (VersionedMetadata)txnsTuple.getKey();
                if (((CommittingTransactionsRecord)committingTxnsRecord.getObject()).equals(CommittingTransactionsRecord.EMPTY)) {
                    return CompletableFuture.completedFuture(committingTxnsRecord);
                }
                int txnEpoch = ((CommittingTransactionsRecord)committingTxnsRecord.getObject()).getEpoch();
                ImmutableList<UUID> txnList = ((CommittingTransactionsRecord)committingTxnsRecord.getObject()).getTransactionsToCommit();
                log.info(context.getRequestId(), "Committing {} transactions on epoch {} on stream {}/{}", new Object[]{txnList, txnEpoch, scope, stream});
                CompletionStage<Object> future = ((State)((Object)((Object)((Object)state.getObject())))).equals((Object)State.SEALING) ? CompletableFuture.completedFuture(null) : this.streamMetadataStore.updateVersionedState(scope, stream, State.COMMITTING_TXN, (VersionedMetadata<State>)state, context, this.executor).thenAccept(stateRecord::set);
                ((List)txnsTuple.getValue()).forEach(txn -> {
                    if (!Strings.isNullOrEmpty((String)txn.getWriterId())) {
                        txnIdToWriterId.put(txn.getId(), txn.getWriterId());
                        if (!writerMarks.containsKey(txn.getWriterId()) || ((TxnWriterMark)writerMarks.get(txn.getWriterId())).getTimestamp() < txn.getCommitTime()) {
                            writerMarks.put(txn.getWriterId(), new TxnWriterMark(txn.getCommitTime(), (Map<Long, Long>)ImmutableMap.of(), txn.getId()));
                        }
                    }
                });
                return future.thenCompose(v -> this.getEpochRecords(scope, stream, txnEpoch, context).thenCompose(records -> {
                    EpochRecord txnEpochRecord = (EpochRecord)records.get(0);
                    EpochRecord activeEpochRecord = (EpochRecord)records.get(1);
                    if (activeEpochRecord.getEpoch() == txnEpoch || activeEpochRecord.getReferenceEpoch() == txnEpochRecord.getReferenceEpoch()) {
                        return this.commitTransactions(scope, stream, (List<Long>)new ArrayList<Long>(activeEpochRecord.getSegmentIds()), (List<UUID>)txnList, context, txnIdToWriterId, writerMarks).thenApply(txnOffsets -> committingTxnsRecord);
                    }
                    return this.rollTransactions(scope, stream, txnEpochRecord, activeEpochRecord, committingTxnsRecord, context, txnIdToWriterId, writerMarks);
                }));
            }, (Executor)this.executor);
            return ((CompletableFuture)commitFuture).thenCompose(committingTxnsRecord -> ((CompletableFuture)((CompletableFuture)this.streamMetadataStore.completeCommitTransactions(scope, stream, (VersionedMetadata<CommittingTransactionsRecord>)committingTxnsRecord, context, this.executor, writerMarks).thenCompose(v -> this.resetStateConditionally(scope, stream, (VersionedMetadata)stateRecord.get(), context))).thenRun(() -> TransactionMetrics.getInstance().commitTransaction(scope, stream, timer.getElapsed()))).thenApply(v -> ((CommittingTransactionsRecord)committingTxnsRecord.getObject()).getEpoch()));
        }, (Executor)this.executor);
    }

    private CompletableFuture<VersionedMetadata<CommittingTransactionsRecord>> rollTransactions(String scope, String stream, EpochRecord txnEpoch, EpochRecord activeEpoch, VersionedMetadata<CommittingTransactionsRecord> existing, OperationContext context, Map<UUID, String> txnIdToWriterId, Map<String, TxnWriterMark> writerMarks) {
        CompletionStage<VersionedMetadata<CommittingTransactionsRecord>> future = CompletableFuture.completedFuture(existing);
        if (!existing.getObject().isRollingTxnRecord()) {
            future = future.thenCompose(x -> this.streamMetadataStore.startRollingTxn(scope, stream, activeEpoch.getEpoch(), existing, context, this.executor));
        }
        return future.thenCompose(record -> {
            if (activeEpoch.getEpoch() > ((CommittingTransactionsRecord)record.getObject()).getCurrentEpoch()) {
                return CompletableFuture.completedFuture(record);
            }
            return this.runRollingTxn(scope, stream, txnEpoch, activeEpoch, (VersionedMetadata<CommittingTransactionsRecord>)record, context, txnIdToWriterId, writerMarks).thenApply(v -> record);
        });
    }

    private CompletableFuture<Void> runRollingTxn(String scope, String stream, EpochRecord txnEpoch, EpochRecord activeEpoch, VersionedMetadata<CommittingTransactionsRecord> existing, OperationContext context, Map<UUID, String> txnIdToWriterId, Map<String, TxnWriterMark> writerMarks) {
        String delegationToken = this.streamMetadataTasks.retrieveDelegationToken();
        long timestamp = System.currentTimeMillis();
        int newTxnEpoch = existing.getObject().getNewTxnEpoch();
        int newActiveEpoch = existing.getObject().getNewActiveEpoch();
        List<Long> txnEpochDuplicate = txnEpoch.getSegments().stream().map(segment -> NameUtils.computeSegmentId((int)segment.getSegmentNumber(), (int)newTxnEpoch)).collect(Collectors.toList());
        ArrayList<Long> activeEpochSegmentIds = new ArrayList<Long>(activeEpoch.getSegmentIds());
        List activeEpochDuplicate = activeEpoch.getSegments().stream().map(segment -> NameUtils.computeSegmentId((int)segment.getSegmentNumber(), (int)newActiveEpoch)).collect(Collectors.toList());
        ImmutableList<UUID> transactionsToCommit = existing.getObject().getTransactionsToCommit();
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.copyTxnEpochSegmentsAndCommitTxns(scope, stream, (List<UUID>)transactionsToCommit, txnEpochDuplicate, context, txnIdToWriterId, writerMarks).thenCompose(v -> this.streamMetadataTasks.notifyNewSegments(scope, stream, activeEpochDuplicate, context, delegationToken, context.getRequestId()))).thenCompose(v -> this.streamMetadataTasks.getSealedSegmentsSize(scope, stream, txnEpochDuplicate, delegationToken, context.getRequestId()))).thenCompose(sealedSegmentsMap -> {
            log.info(context.getRequestId(), "Rolling transaction, created duplicate of active epoch {} for stream {}/{}", new Object[]{activeEpoch, scope, stream});
            return this.streamMetadataStore.rollingTxnCreateDuplicateEpochs(scope, stream, (Map<Long, Long>)sealedSegmentsMap, timestamp, existing, context, this.executor);
        })).thenCompose(v -> ((CompletableFuture)this.streamMetadataTasks.notifySealedSegments(scope, stream, activeEpochSegmentIds, delegationToken, context.getRequestId()).thenCompose(x -> this.streamMetadataTasks.getSealedSegmentsSize(scope, stream, activeEpochSegmentIds, delegationToken, context.getRequestId()))).thenCompose(sealedSegmentsMap -> {
            log.info(context.getRequestId(), "Rolling transaction, sealed active epoch {} for stream {}/{}", new Object[]{activeEpoch, scope, stream});
            return this.streamMetadataStore.completeRollingTxn(scope, stream, (Map<Long, Long>)sealedSegmentsMap, existing, context, this.executor);
        }));
    }

    private CompletableFuture<Void> copyTxnEpochSegmentsAndCommitTxns(String scope, String stream, List<UUID> transactionsToCommit, List<Long> segmentIds, OperationContext context, Map<UUID, String> txnIdToWriterId, Map<String, TxnWriterMark> writerMarks) {
        String delegationToken = this.streamMetadataTasks.retrieveDelegationToken();
        CompletableFuture createSegmentsFuture = Futures.allOf((Collection)segmentIds.stream().map(segment -> this.streamMetadataStore.getConfiguration(scope, stream, context, this.executor).thenCompose(config -> this.streamMetadataTasks.notifyNewSegment(scope, stream, (long)segment, ScalingPolicy.fixed((int)1), delegationToken, context.getRequestId(), config.getRolloverSizeBytes()))).collect(Collectors.toList()));
        return ((CompletableFuture)createSegmentsFuture.thenCompose(v -> {
            log.info(context.getRequestId(), "Rolling transaction, successfully created duplicate txn epoch {} for stream {}/{}", new Object[]{segmentIds, scope, stream});
            return this.commitTransactions(scope, stream, segmentIds, transactionsToCommit, context, txnIdToWriterId, writerMarks);
        })).thenAccept(v -> this.streamMetadataTasks.notifySealedSegments(scope, stream, segmentIds, delegationToken, context.getRequestId()));
    }

    private CompletableFuture<Void> commitTransactions(String scope, String stream, List<Long> segments, List<UUID> transactionsToCommit, OperationContext context, Map<UUID, String> txnIdToWriterId, Map<String, TxnWriterMark> writerMarks) {
        boolean noteTime = writerMarks.size() > 0;
        CompletionStage<Object> future = CompletableFuture.completedFuture(null);
        for (UUID txnId : transactionsToCommit) {
            log.info(context.getRequestId(), "Committing transaction {} on stream {}/{}", new Object[]{txnId, scope, stream});
            future = ((CompletableFuture)future.thenCompose(v -> this.streamMetadataTasks.notifyTxnCommit(scope, stream, segments, txnId, context.getRequestId()))).thenAccept(txnOffsets -> {
                String writerId = (String)txnIdToWriterId.get(txnId);
                if (!Strings.isNullOrEmpty((String)writerId) && ((TxnWriterMark)writerMarks.get(writerId)).getTransactionId().equals(txnId)) {
                    TxnWriterMark mark = (TxnWriterMark)writerMarks.get(writerId);
                    writerMarks.put(writerId, new TxnWriterMark(mark.getTimestamp(), (Map<Long, Long>)txnOffsets, mark.getTransactionId()));
                }
            });
        }
        return future.thenAcceptAsync(x -> {
            if (noteTime) {
                this.bucketStore.addStreamToBucketStore(BucketStore.ServiceType.WatermarkingService, scope, stream, this.executor);
            }
        });
    }

    private CompletableFuture<List<EpochRecord>> getEpochRecords(String scope, String stream, int epoch, OperationContext context) {
        ArrayList<CompletableFuture<EpochRecord>> list = new ArrayList<CompletableFuture<EpochRecord>>();
        list.add(this.streamMetadataStore.getEpoch(scope, stream, epoch, context, this.executor));
        list.add(this.streamMetadataStore.getActiveEpoch(scope, stream, context, true, this.executor));
        return Futures.allOfWithResults(list);
    }

    @Override
    public CompletableFuture<Void> writeBack(CommitEvent event) {
        return this.streamTransactionMetadataTasks.writeCommitEvent(event);
    }

    private CompletableFuture<Void> resetStateConditionally(String scope, String stream, VersionedMetadata<State> state, OperationContext context) {
        if (state.getObject().equals((Object)State.COMMITTING_TXN)) {
            return Futures.toVoid(this.streamMetadataStore.updateVersionedState(scope, stream, State.ACTIVE, state, context, this.executor));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Boolean> hasTaskStarted(CommitEvent event) {
        return this.streamMetadataStore.getState(event.getScope(), event.getStream(), true, null, this.executor).thenApply(state -> state.equals((Object)State.COMMITTING_TXN) || state.equals((Object)State.SEALING));
    }
}

