/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers;

import com.google.common.base.Preconditions;
import io.pravega.client.control.impl.ModelHelper;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamCut;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.retryable.RetryableException;
import io.pravega.controller.server.eventProcessor.requesthandlers.ReaderGroupTask;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.task.Stream.StreamMetadataTasks;
import io.pravega.controller.util.RetryHelper;
import io.pravega.shared.controller.event.CreateReaderGroupEvent;
import io.pravega.shared.controller.event.RGStreamCutRecord;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class CreateReaderGroupTask
implements ReaderGroupTask<CreateReaderGroupEvent> {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(CreateReaderGroupTask.class));
    private final StreamMetadataStore streamMetadataStore;
    private final StreamMetadataTasks streamMetadataTasks;
    private final ScheduledExecutorService executor;

    public CreateReaderGroupTask(StreamMetadataTasks streamMetaTasks, StreamMetadataStore streamMetaStore, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)streamMetaStore);
        Preconditions.checkNotNull((Object)streamMetaTasks);
        Preconditions.checkNotNull((Object)executor);
        this.streamMetadataStore = streamMetaStore;
        this.streamMetadataTasks = streamMetaTasks;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Void> execute(CreateReaderGroupEvent request) {
        String scope = request.getScope();
        String readerGroup = request.getRgName();
        UUID readerGroupId = request.getReaderGroupId();
        ReaderGroupConfig config = this.getConfigFromEvent(request);
        long requestId = request.getRequestId();
        OperationContext context = this.streamMetadataStore.createRGContext(scope, readerGroup, requestId);
        return RetryHelper.withRetriesAsync(() -> this.streamMetadataStore.getReaderGroupId(scope, readerGroup, context, this.executor).thenCompose(rgId -> {
            if (!rgId.equals(readerGroupId)) {
                log.warn(requestId, "Skipping processing of CreateReaderGroupEvent with stale UUID.", new Object[0]);
                return CompletableFuture.completedFuture(null);
            }
            return this.streamMetadataTasks.isRGCreationComplete(scope, readerGroup, context).thenCompose(complete -> {
                if (!complete.booleanValue()) {
                    return Futures.toVoid(this.streamMetadataTasks.createReaderGroupTasks(scope, readerGroup, config, request.getCreateTimeStamp(), context));
                }
                return CompletableFuture.completedFuture(null);
            });
        }), e -> Exceptions.unwrap((Throwable)e) instanceof RetryableException, Integer.MAX_VALUE, this.executor);
    }

    private ReaderGroupConfig getConfigFromEvent(CreateReaderGroupEvent request) {
        Map<Stream, StreamCut> startStreamCut = this.getStreamCutMapFromRecord(request.getStartingStreamCuts());
        Map<Stream, StreamCut> endStreamCut = this.getStreamCutMapFromRecord(request.getEndingStreamCuts());
        ReaderGroupConfig conf = ReaderGroupConfig.builder().groupRefreshTimeMillis(request.getGroupRefreshTimeMillis()).automaticCheckpointIntervalMillis(request.getAutomaticCheckpointIntervalMillis()).maxOutstandingCheckpointRequest(request.getMaxOutstandingCheckpointRequest()).retentionType(ReaderGroupConfig.StreamDataRetention.values()[request.getRetentionTypeOrdinal()]).startingStreamCuts(startStreamCut).endingStreamCuts(endStreamCut).build();
        return ReaderGroupConfig.cloneConfig((ReaderGroupConfig)conf, (UUID)request.getReaderGroupId(), (long)request.getGeneration());
    }

    private Map<Stream, StreamCut> getStreamCutMapFromRecord(Map<String, RGStreamCutRecord> streamCutMap) {
        return streamCutMap.entrySet().stream().collect(Collectors.toMap(e -> Stream.of((String)((String)e.getKey())), e -> ModelHelper.generateStreamCut((String)Stream.of((String)((String)e.getKey())).getScope(), (String)Stream.of((String)((String)e.getKey())).getStreamName(), (Map)((RGStreamCutRecord)e.getValue()).getStreamCut())));
    }
}

