/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers;

import com.google.common.base.Preconditions;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.Stream;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.server.eventProcessor.requesthandlers.ReaderGroupTask;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.store.stream.records.ReaderGroupConfigRecord;
import io.pravega.controller.task.Stream.StreamMetadataTasks;
import io.pravega.shared.NameUtils;
import io.pravega.shared.controller.event.DeleteReaderGroupEvent;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.LoggerFactory;

public class DeleteReaderGroupTask
implements ReaderGroupTask<DeleteReaderGroupEvent> {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(DeleteReaderGroupTask.class));
    private final StreamMetadataStore streamMetadataStore;
    private final StreamMetadataTasks streamMetadataTasks;
    private final ScheduledExecutorService executor;

    public DeleteReaderGroupTask(StreamMetadataTasks streamMetaTasks, StreamMetadataStore streamMetaStore, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)streamMetaStore);
        Preconditions.checkNotNull((Object)streamMetaTasks);
        Preconditions.checkNotNull((Object)executor);
        this.streamMetadataStore = streamMetaStore;
        this.streamMetadataTasks = streamMetaTasks;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Void> execute(DeleteReaderGroupEvent request) {
        String scope = request.getScope();
        String readerGroup = request.getRgName();
        long requestId = request.getRequestId();
        UUID readerGroupId = request.getReaderGroupId();
        OperationContext context = this.streamMetadataStore.createRGContext(scope, readerGroup, requestId);
        return this.streamMetadataStore.getReaderGroupId(scope, readerGroup, context, this.executor).thenCompose(id -> {
            if (!id.equals(readerGroupId)) {
                log.warn(requestId, "Skipping processing of Reader Group delete request {} as UUIDs did not match.", new Object[]{requestId});
                return CompletableFuture.completedFuture(null);
            }
            return ((CompletableFuture)((CompletableFuture)this.streamMetadataStore.getReaderGroupConfigRecord(scope, readerGroup, context, this.executor).thenCompose(configRecord -> {
                if (!ReaderGroupConfig.StreamDataRetention.values()[((ReaderGroupConfigRecord)configRecord.getObject()).getRetentionTypeOrdinal()].equals((Object)ReaderGroupConfig.StreamDataRetention.NONE)) {
                    String scopedRGName = NameUtils.getScopedReaderGroupName((String)scope, (String)readerGroup);
                    Iterator<String> streamIter = ((ReaderGroupConfigRecord)configRecord.getObject()).getStartingStreamCuts().keySet().iterator();
                    return Futures.loop(streamIter::hasNext, () -> {
                        Stream stream = Stream.of((String)((String)streamIter.next()));
                        OperationContext streamContext = this.streamMetadataStore.createStreamContext(stream.getScope(), stream.getStreamName(), requestId);
                        return this.streamMetadataStore.deleteSubscriber(stream.getScope(), stream.getStreamName(), scopedRGName, ((ReaderGroupConfigRecord)configRecord.getObject()).getGeneration(), streamContext, this.executor);
                    }, (Executor)this.executor);
                }
                return CompletableFuture.completedFuture(null);
            })).thenCompose(v -> {
                String rgStreamContext = NameUtils.getStreamForReaderGroup((String)readerGroup);
                OperationContext streamContext = this.streamMetadataStore.createStreamContext(scope, rgStreamContext, requestId);
                return this.streamMetadataTasks.sealStream(scope, rgStreamContext, streamContext).thenCompose(z -> this.streamMetadataTasks.deleteStream(scope, rgStreamContext, streamContext));
            })).thenCompose(v1 -> this.streamMetadataStore.deleteReaderGroup(scope, readerGroup, context, this.executor));
        });
    }
}

