/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.common.util.RetriesExhaustedException;
import io.pravega.controller.server.eventProcessor.requesthandlers.StreamTask;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.stream.EpochTransitionOperationExceptions;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.State;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.store.stream.records.EpochTransitionRecord;
import io.pravega.controller.store.stream.records.RecordHelper;
import io.pravega.controller.task.Stream.StreamMetadataTasks;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.ScaleOpEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.LoggerFactory;

public class ScaleOperationTask
implements StreamTask<ScaleOpEvent> {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(ScaleOperationTask.class));
    private final StreamMetadataTasks streamMetadataTasks;
    private final StreamMetadataStore streamMetadataStore;
    private final ScheduledExecutorService executor;

    public ScaleOperationTask(StreamMetadataTasks streamMetadataTasks, StreamMetadataStore streamMetadataStore, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)streamMetadataStore);
        Preconditions.checkNotNull((Object)streamMetadataTasks);
        Preconditions.checkNotNull((Object)executor);
        this.streamMetadataTasks = streamMetadataTasks;
        this.streamMetadataStore = streamMetadataStore;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Void> execute(ScaleOpEvent request) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        long requestId = request.getRequestId();
        OperationContext context = this.streamMetadataStore.createStreamContext(request.getScope(), request.getStream(), requestId);
        log.info(requestId, "starting scale request for {}/{} segments {} to new ranges {}", new Object[]{request.getScope(), request.getStream(), request.getSegmentsToSeal(), request.getNewRanges()});
        this.runScale(request, request.isRunOnlyIfStarted(), context).whenCompleteAsync((res, e) -> {
            if (e != null) {
                Throwable cause = Exceptions.unwrap((Throwable)e);
                if (cause instanceof RetriesExhaustedException) {
                    cause = cause.getCause();
                }
                if (cause instanceof EpochTransitionOperationExceptions.PreConditionFailureException) {
                    log.info(requestId, "processing scale request for {}/{} segments {} failed {}", new Object[]{request.getScope(), request.getStream(), request.getSegmentsToSeal(), cause.getClass().getName()});
                    result.complete(null);
                } else {
                    log.warn(requestId, "processing scale request for {}/{} segments {} failed {}", new Object[]{request.getScope(), request.getStream(), request.getSegmentsToSeal(), cause});
                    result.completeExceptionally(cause);
                }
            } else {
                log.info(requestId, "scale request for {}/{} segments {} to new ranges {} completed successfully.", new Object[]{request.getScope(), request.getStream(), request.getSegmentsToSeal(), request.getNewRanges()});
                result.complete(null);
            }
        }, (Executor)this.executor);
        return result;
    }

    @Override
    public CompletableFuture<Void> writeBack(ScaleOpEvent event) {
        return this.streamMetadataTasks.writeEvent((ControllerEvent)event);
    }

    @VisibleForTesting
    public CompletableFuture<Void> runScale(ScaleOpEvent scaleInput, boolean isManualScale, OperationContext context) {
        String scope = scaleInput.getScope();
        String stream = scaleInput.getStream();
        long requestId = scaleInput.getRequestId();
        return this.streamMetadataStore.getVersionedState(scope, stream, context, this.executor).thenCompose(state -> this.streamMetadataStore.getEpochTransition(scope, stream, context, this.executor).thenCompose(record -> {
            AtomicReference<VersionedMetadata> reference = new AtomicReference<VersionedMetadata>((VersionedMetadata)state);
            CompletionStage<VersionedMetadata<Object>> future = CompletableFuture.completedFuture(record);
            if (((EpochTransitionRecord)record.getObject()).equals(EpochTransitionRecord.EMPTY)) {
                if (((State)((Object)((Object)((Object)state.getObject())))).equals((Object)State.SCALING)) {
                    future = this.streamMetadataStore.updateVersionedState(scope, stream, State.ACTIVE, (VersionedMetadata<State>)state, context, this.executor).thenApply(updatedState -> {
                        reference.set((VersionedMetadata)updatedState);
                        return record;
                    });
                }
                if (isManualScale) {
                    log.info(requestId, "Found empty epoch transition record, scale processing is already completed.", new Object[0]);
                    return Futures.toVoid(future);
                }
                future = future.thenCompose(r -> this.streamMetadataStore.submitScale(scope, stream, scaleInput.getSegmentsToSeal(), (List<Map.Entry<Double, Double>>)new ArrayList<Map.Entry<Double, Double>>(scaleInput.getNewRanges()), scaleInput.getScaleTime(), (VersionedMetadata<EpochTransitionRecord>)record, context, this.executor));
            } else if (!RecordHelper.verifyRecordMatchesInput(scaleInput.getSegmentsToSeal(), scaleInput.getNewRanges(), isManualScale, (EpochTransitionRecord)record.getObject())) {
                if (isManualScale) {
                    log.info(requestId, "Scale for stream {}/{} for segments {} already completed.", new Object[]{scaleInput.getScope(), scaleInput.getStream(), scaleInput.getSegmentsToSeal()});
                    return CompletableFuture.completedFuture(null);
                }
                log.info(requestId, "Scale for stream {}/{} for segments {} cannot be started as another scale is ongoing.", new Object[]{scaleInput.getScope(), scaleInput.getStream(), scaleInput.getSegmentsToSeal()});
                throw new EpochTransitionOperationExceptions.ConflictException();
            }
            return future.thenCompose(versionedMetadata -> this.processScale(scope, stream, isManualScale, (VersionedMetadata<EpochTransitionRecord>)versionedMetadata, (VersionedMetadata)reference.get(), context, requestId));
        }));
    }

    private CompletableFuture<Void> processScale(String scope, String stream, boolean isManualScale, VersionedMetadata<EpochTransitionRecord> metadata, VersionedMetadata<State> state, OperationContext context, long requestId) {
        return this.streamMetadataStore.updateVersionedState(scope, stream, State.SCALING, state, context, this.executor).thenCompose(updatedState -> this.streamMetadataStore.startScale(scope, stream, isManualScale, metadata, (VersionedMetadata<State>)updatedState, context, this.executor).thenCompose(record -> ((CompletableFuture)this.streamMetadataTasks.processScale(scope, stream, metadata, context, requestId, this.streamMetadataStore).thenCompose(r -> this.streamMetadataStore.updateVersionedState(scope, stream, State.ACTIVE, (VersionedMetadata<State>)updatedState, context, this.executor))).thenAccept(y -> log.info(requestId, "scale processing for {}/{} epoch {} completed.", new Object[]{scope, stream, ((EpochTransitionRecord)record.getObject()).getActiveEpoch()}))));
    }

    @Override
    public CompletableFuture<Boolean> hasTaskStarted(ScaleOpEvent event) {
        return this.streamMetadataStore.getState(event.getScope(), event.getStream(), true, null, this.executor).thenApply(state -> state.equals((Object)State.SCALING));
    }
}

