/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers;

import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.server.eventProcessor.requesthandlers.AbstractRequestProcessor;
import io.pravega.controller.server.eventProcessor.requesthandlers.AutoScaleTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.CreateReaderGroupTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.DeleteReaderGroupTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.DeleteStreamTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.ScaleOperationTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.SealStreamTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.TruncateStreamTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.UpdateReaderGroupTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.UpdateStreamTask;
import io.pravega.controller.store.stream.EpochTransitionOperationExceptions;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.shared.controller.event.AutoScaleEvent;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.CreateReaderGroupEvent;
import io.pravega.shared.controller.event.DeleteReaderGroupEvent;
import io.pravega.shared.controller.event.DeleteStreamEvent;
import io.pravega.shared.controller.event.ScaleOpEvent;
import io.pravega.shared.controller.event.SealStreamEvent;
import io.pravega.shared.controller.event.TruncateStreamEvent;
import io.pravega.shared.controller.event.UpdateReaderGroupEvent;
import io.pravega.shared.controller.event.UpdateStreamEvent;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.LoggerFactory;

public class StreamRequestHandler
extends AbstractRequestProcessor<ControllerEvent> {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(StreamRequestHandler.class));
    private final AutoScaleTask autoScaleTask;
    private final ScaleOperationTask scaleOperationTask;
    private final UpdateStreamTask updateStreamTask;
    private final SealStreamTask sealStreamTask;
    private final DeleteStreamTask deleteStreamTask;
    private final TruncateStreamTask truncateStreamTask;
    private final CreateReaderGroupTask createRGTask;
    private final DeleteReaderGroupTask deleteRGTask;
    private final UpdateReaderGroupTask updateRGTask;

    public StreamRequestHandler(AutoScaleTask autoScaleTask, ScaleOperationTask scaleOperationTask, UpdateStreamTask updateStreamTask, SealStreamTask sealStreamTask, DeleteStreamTask deleteStreamTask, TruncateStreamTask truncateStreamTask, CreateReaderGroupTask createRGTask, DeleteReaderGroupTask deleteRGTask, UpdateReaderGroupTask updateRGTask, StreamMetadataStore streamMetadataStore, ScheduledExecutorService executor) {
        super(streamMetadataStore, executor);
        this.autoScaleTask = autoScaleTask;
        this.scaleOperationTask = scaleOperationTask;
        this.updateStreamTask = updateStreamTask;
        this.sealStreamTask = sealStreamTask;
        this.deleteStreamTask = deleteStreamTask;
        this.truncateStreamTask = truncateStreamTask;
        this.createRGTask = createRGTask;
        this.deleteRGTask = deleteRGTask;
        this.updateRGTask = updateRGTask;
    }

    @Override
    public CompletableFuture<Void> processAutoScaleRequest(AutoScaleEvent autoScaleEvent) {
        return this.autoScaleTask.execute(autoScaleEvent);
    }

    @Override
    public CompletableFuture<Void> processScaleOpRequest(ScaleOpEvent scaleOpEvent) {
        log.info(scaleOpEvent.getRequestId(), "Processing scale request for stream {}/{}", new Object[]{scaleOpEvent.getScope(), scaleOpEvent.getStream()});
        return this.withCompletion(this.scaleOperationTask, scaleOpEvent, scaleOpEvent.getScope(), scaleOpEvent.getStream(), OPERATION_NOT_ALLOWED_PREDICATE.or(e -> e instanceof EpochTransitionOperationExceptions.ConflictException)).thenAccept(v -> log.info(scaleOpEvent.getRequestId(), "Processing scale request for stream {}/{} complete", new Object[]{scaleOpEvent.getScope(), scaleOpEvent.getStream()}));
    }

    @Override
    public CompletableFuture<Void> processUpdateStream(UpdateStreamEvent updateStreamEvent) {
        log.info(updateStreamEvent.getRequestId(), "Processing update request for stream {}/{}", new Object[]{updateStreamEvent.getScope(), updateStreamEvent.getStream()});
        return this.withCompletion(this.updateStreamTask, updateStreamEvent, updateStreamEvent.getScope(), updateStreamEvent.getStream(), OPERATION_NOT_ALLOWED_PREDICATE).thenAccept(v -> log.info(updateStreamEvent.getRequestId(), "Processing update request for stream {}/{} complete", new Object[]{updateStreamEvent.getScope(), updateStreamEvent.getStream()}));
    }

    @Override
    public CompletableFuture<Void> processTruncateStream(TruncateStreamEvent truncateStreamEvent) {
        log.info(truncateStreamEvent.getRequestId(), "Processing truncate request for stream {}/{}", new Object[]{truncateStreamEvent.getScope(), truncateStreamEvent.getStream()});
        return this.withCompletion(this.truncateStreamTask, truncateStreamEvent, truncateStreamEvent.getScope(), truncateStreamEvent.getStream(), OPERATION_NOT_ALLOWED_PREDICATE).thenAccept(v -> log.info(truncateStreamEvent.getRequestId(), "Processing truncate request for stream {}/{} complete", new Object[]{truncateStreamEvent.getScope(), truncateStreamEvent.getStream()}));
    }

    @Override
    public CompletableFuture<Void> processSealStream(SealStreamEvent sealStreamEvent) {
        log.info(sealStreamEvent.getRequestId(), "Processing seal request for stream {}/{}", new Object[]{sealStreamEvent.getScope(), sealStreamEvent.getStream()});
        return this.withCompletion(this.sealStreamTask, sealStreamEvent, sealStreamEvent.getScope(), sealStreamEvent.getStream(), OPERATION_NOT_ALLOWED_PREDICATE).thenAccept(v -> log.info(sealStreamEvent.getRequestId(), "Processing seal request for stream {}/{} complete", new Object[]{sealStreamEvent.getScope(), sealStreamEvent.getStream()}));
    }

    @Override
    public CompletableFuture<Void> processDeleteStream(DeleteStreamEvent deleteStreamEvent) {
        log.info(deleteStreamEvent.getRequestId(), "Processing delete request for stream {}/{}", new Object[]{deleteStreamEvent.getScope(), deleteStreamEvent.getStream()});
        return this.withCompletion(this.deleteStreamTask, deleteStreamEvent, deleteStreamEvent.getScope(), deleteStreamEvent.getStream(), OPERATION_NOT_ALLOWED_PREDICATE).thenAccept(v -> log.info(deleteStreamEvent.getRequestId(), "Processing delete request for stream {}/{} complete", new Object[]{deleteStreamEvent.getScope(), deleteStreamEvent.getStream()}));
    }

    @Override
    public CompletableFuture<Void> processCreateReaderGroup(CreateReaderGroupEvent createRGEvent) {
        log.info(createRGEvent.getRequestId(), "Processing create request for ReaderGroup {}/{}", new Object[]{createRGEvent.getScope(), createRGEvent.getRgName()});
        return ((CompletableFuture)this.createRGTask.execute(createRGEvent).thenAccept(v -> log.info(createRGEvent.getRequestId(), "Processing of create event for Reader Group {}/{} completed successfully.", new Object[]{createRGEvent.getScope(), createRGEvent.getRgName()}))).exceptionally(ex -> {
            log.error(createRGEvent.getRequestId(), String.format("Error processing create event for Reader Group %s/%s. Unexpected exception.", createRGEvent.getScope(), createRGEvent.getRgName()), new Object[]{ex});
            throw new CompletionException((Throwable)ex);
        });
    }

    @Override
    public CompletableFuture<Void> processDeleteReaderGroup(DeleteReaderGroupEvent deleteRGEvent) {
        log.info(deleteRGEvent.getRequestId(), "Processing delete request for ReaderGroup {}/{}", new Object[]{deleteRGEvent.getScope(), deleteRGEvent.getRgName()});
        return ((CompletableFuture)this.deleteRGTask.execute(deleteRGEvent).thenAccept(v -> log.info(deleteRGEvent.getRequestId(), "Processing of delete event for Reader Group {}/{} completed successfully.", new Object[]{deleteRGEvent.getScope(), deleteRGEvent.getRgName()}))).exceptionally(ex -> {
            log.error(deleteRGEvent.getRequestId(), String.format("Error processing delete event for Reader Group %s/%s. Unexpected exception.", deleteRGEvent.getScope(), deleteRGEvent.getRgName()), new Object[]{ex});
            throw new CompletionException((Throwable)ex);
        });
    }

    @Override
    public CompletableFuture<Void> processUpdateReaderGroup(UpdateReaderGroupEvent updateRGEvent) {
        log.info(updateRGEvent.getRequestId(), "Processing update request for ReaderGroup {}/{}", new Object[]{updateRGEvent.getScope(), updateRGEvent.getRgName()});
        return ((CompletableFuture)this.updateRGTask.execute(updateRGEvent).thenAccept(v -> log.info(updateRGEvent.getRequestId(), "Processing of update event for Reader Group {}/{} completed successfully.", new Object[]{updateRGEvent.getScope(), updateRGEvent.getRgName()}))).exceptionally(ex -> {
            log.error(updateRGEvent.getRequestId(), String.format("Error processing update event for Reader Group %s/%s. Unexpected exception.", updateRGEvent.getScope(), updateRGEvent.getRgName()), new Object[]{ex});
            throw new CompletionException((Throwable)ex);
        });
    }
}

