/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers;

import com.google.common.base.Preconditions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.server.eventProcessor.requesthandlers.StreamTask;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.State;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.store.stream.records.StreamTruncationRecord;
import io.pravega.controller.task.Stream.StreamMetadataTasks;
import io.pravega.shared.MetricsTags;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.TruncateStreamEvent;
import io.pravega.shared.metrics.DynamicLogger;
import io.pravega.shared.metrics.MetricsProvider;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

public class TruncateStreamTask
implements StreamTask<TruncateStreamEvent> {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(TruncateStreamTask.class));
    private static final DynamicLogger DYNAMIC_LOGGER = MetricsProvider.getDynamicLogger();
    private final StreamMetadataTasks streamMetadataTasks;
    private final StreamMetadataStore streamMetadataStore;
    private final ScheduledExecutorService executor;

    public TruncateStreamTask(StreamMetadataTasks streamMetadataTasks, StreamMetadataStore streamMetadataStore, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)streamMetadataStore);
        Preconditions.checkNotNull((Object)streamMetadataTasks);
        Preconditions.checkNotNull((Object)executor);
        this.streamMetadataTasks = streamMetadataTasks;
        this.streamMetadataStore = streamMetadataStore;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Void> execute(TruncateStreamEvent request) {
        String scope = request.getScope();
        String stream = request.getStream();
        long requestId = request.getRequestId();
        OperationContext context = this.streamMetadataStore.createStreamContext(scope, stream, requestId);
        return this.streamMetadataStore.getVersionedState(scope, stream, context, this.executor).thenCompose(versionedState -> this.streamMetadataStore.getTruncationRecord(scope, stream, context, this.executor).thenCompose(versionedMetadata -> {
            if (!((StreamTruncationRecord)versionedMetadata.getObject()).isUpdating()) {
                if (((State)((Object)((Object)((Object)versionedState.getObject())))).equals((Object)State.TRUNCATING)) {
                    return Futures.toVoid(this.streamMetadataStore.updateVersionedState(scope, stream, State.ACTIVE, (VersionedMetadata<State>)versionedState, context, this.executor));
                }
                return CompletableFuture.completedFuture(null);
            }
            return this.processTruncate(scope, stream, (VersionedMetadata<StreamTruncationRecord>)versionedMetadata, (VersionedMetadata<State>)versionedState, context, requestId);
        }));
    }

    private CompletableFuture<Void> processTruncate(String scope, String stream, VersionedMetadata<StreamTruncationRecord> versionedTruncationRecord, VersionedMetadata<State> versionedState, OperationContext context, long requestId) {
        String delegationToken = this.streamMetadataTasks.retrieveDelegationToken();
        StreamTruncationRecord truncationRecord = versionedTruncationRecord.getObject();
        log.info(requestId, "Truncating stream {}/{} at stream cut: {}", new Object[]{scope, stream, truncationRecord.getStreamCut()});
        return Futures.toVoid((CompletableFuture)this.streamMetadataStore.updateVersionedState(scope, stream, State.TRUNCATING, versionedState, context, this.executor).thenCompose(update -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.notifyTruncateSegments(scope, stream, (Map<Long, Long>)truncationRecord.getStreamCut(), delegationToken, requestId).thenCompose(x -> this.notifyDeleteSegments(scope, stream, (Set<Long>)truncationRecord.getToDelete(), delegationToken, requestId))).thenAccept(x -> DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.retention.truncated_size", (Number)((StreamTruncationRecord)versionedTruncationRecord.getObject()).getSizeTill(), MetricsTags.streamTags((String)scope, (String)stream)))).thenCompose(deleted -> this.streamMetadataStore.completeTruncation(scope, stream, versionedTruncationRecord, context, this.executor))).thenCompose(x -> this.streamMetadataStore.updateVersionedState(scope, stream, State.ACTIVE, (VersionedMetadata<State>)update, context, this.executor))));
    }

    private CompletableFuture<Void> notifyDeleteSegments(String scope, String stream, Set<Long> segmentsToDelete, String delegationToken, long requestId) {
        log.debug(requestId, "{}/{} deleting segments {}", new Object[]{scope, stream, segmentsToDelete});
        return Futures.allOf((Collection)((Stream)segmentsToDelete.stream().parallel()).map(segment -> this.streamMetadataTasks.notifyDeleteSegment(scope, stream, (long)segment, delegationToken, requestId)).collect(Collectors.toList()));
    }

    private CompletableFuture<Void> notifyTruncateSegments(String scope, String stream, Map<Long, Long> streamCut, String delegationToken, long requestId) {
        log.debug(requestId, "{}/{} truncating segments", new Object[]{scope, stream});
        return Futures.allOf((Collection)((Stream)streamCut.entrySet().stream().parallel()).map(segmentCut -> this.streamMetadataTasks.notifyTruncateSegment(scope, stream, (Map.Entry<Long, Long>)segmentCut, delegationToken, requestId)).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Void> writeBack(TruncateStreamEvent event) {
        return this.streamMetadataTasks.writeEvent((ControllerEvent)event);
    }

    @Override
    public CompletableFuture<Boolean> hasTaskStarted(TruncateStreamEvent event) {
        return this.streamMetadataStore.getState(event.getScope(), event.getStream(), true, null, this.executor).thenApply(state -> state.equals((Object)State.TRUNCATING));
    }
}

