/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.Stream;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.retryable.RetryableException;
import io.pravega.controller.server.eventProcessor.requesthandlers.ReaderGroupTask;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.store.stream.records.ReaderGroupConfigRecord;
import io.pravega.controller.task.Stream.StreamMetadataTasks;
import io.pravega.controller.util.RetryHelper;
import io.pravega.shared.NameUtils;
import io.pravega.shared.controller.event.UpdateReaderGroupEvent;
import io.pravega.shared.protocol.netty.ConnectionFailedException;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import org.slf4j.LoggerFactory;

public class UpdateReaderGroupTask
implements ReaderGroupTask<UpdateReaderGroupEvent> {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(UpdateReaderGroupTask.class));
    private static final Predicate<Throwable> UPDATE_RETRY_PREDICATE = e -> {
        Throwable t = Exceptions.unwrap((Throwable)e);
        return t instanceof RetryableException || t instanceof ConnectionFailedException;
    };
    private final StreamMetadataStore streamMetadataStore;
    private final StreamMetadataTasks streamMetadataTasks;
    private final ScheduledExecutorService executor;

    public UpdateReaderGroupTask(StreamMetadataTasks streamMetaTasks, StreamMetadataStore streamMetaStore, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)streamMetaStore);
        Preconditions.checkNotNull((Object)streamMetaTasks);
        Preconditions.checkNotNull((Object)executor);
        this.streamMetadataStore = streamMetaStore;
        this.streamMetadataTasks = streamMetaTasks;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Void> execute(UpdateReaderGroupEvent request) {
        String scope = request.getScope();
        String readerGroup = request.getRgName();
        long requestId = request.getRequestId();
        long generation = request.getGeneration();
        UUID readerGroupId = request.getReaderGroupId();
        boolean isTransition = request.isTransitionToFromSubscriber();
        ImmutableSet streamsToBeUnsubscribed = request.getRemoveStreams();
        OperationContext context = this.streamMetadataStore.createRGContext(scope, readerGroup, requestId);
        return RetryHelper.withRetriesAsync(() -> this.streamMetadataStore.getReaderGroupId(scope, readerGroup, context, this.executor).thenCompose(id -> {
            if (!id.equals(readerGroupId)) {
                log.warn(requestId, "Skipping processing of Reader Group update request {} as UUID did not match.", new Object[]{requestId});
                return CompletableFuture.completedFuture(null);
            }
            return this.streamMetadataStore.getReaderGroupConfigRecord(scope, readerGroup, context, this.executor).thenCompose(rgConfigRecord -> {
                if (((ReaderGroupConfigRecord)rgConfigRecord.getObject()).getGeneration() != generation) {
                    log.warn(requestId, "Skipping processing of Reader Group update request as generation did not match.", new Object[0]);
                    return CompletableFuture.completedFuture(null);
                }
                if (((ReaderGroupConfigRecord)rgConfigRecord.getObject()).isUpdating()) {
                    if (isTransition) {
                        Iterator<String> streamIter = ((ReaderGroupConfigRecord)rgConfigRecord.getObject()).getStartingStreamCuts().keySet().iterator();
                        String scopedRGName = NameUtils.getScopedReaderGroupName((String)scope, (String)readerGroup);
                        Iterator removeStreamsIter = streamsToBeUnsubscribed.stream().iterator();
                        return ((CompletableFuture)Futures.loop(removeStreamsIter::hasNext, () -> {
                            Stream stream = Stream.of((String)((String)removeStreamsIter.next()));
                            return this.streamMetadataStore.deleteSubscriber(stream.getScope(), stream.getStreamName(), scopedRGName, ((ReaderGroupConfigRecord)rgConfigRecord.getObject()).getGeneration(), context, this.executor);
                        }, (Executor)this.executor).thenCompose(v -> {
                            if (!ReaderGroupConfig.StreamDataRetention.NONE.equals((Object)ReaderGroupConfig.StreamDataRetention.values()[((ReaderGroupConfigRecord)rgConfigRecord.getObject()).getRetentionTypeOrdinal()])) {
                                return Futures.loop(streamIter::hasNext, () -> {
                                    Stream stream = Stream.of((String)((String)streamIter.next()));
                                    return this.streamMetadataStore.addSubscriber(stream.getScope(), stream.getStreamName(), scopedRGName, ((ReaderGroupConfigRecord)rgConfigRecord.getObject()).getGeneration(), context, this.executor);
                                }, (Executor)this.executor);
                            }
                            return CompletableFuture.completedFuture(null);
                        })).thenCompose(v -> this.streamMetadataStore.completeRGConfigUpdate(scope, readerGroup, (VersionedMetadata<ReaderGroupConfigRecord>)rgConfigRecord, context, this.executor));
                    }
                    return this.streamMetadataStore.completeRGConfigUpdate(scope, readerGroup, (VersionedMetadata<ReaderGroupConfigRecord>)rgConfigRecord, context, this.executor);
                }
                return CompletableFuture.completedFuture(null);
            });
        }), UPDATE_RETRY_PREDICATE, Integer.MAX_VALUE, this.executor);
    }
}

