/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers;

import com.google.common.base.Preconditions;
import io.pravega.client.stream.ScalingPolicy;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.server.eventProcessor.requesthandlers.StreamTask;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.stream.BucketStore;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.State;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.store.stream.records.EpochRecord;
import io.pravega.controller.store.stream.records.EpochTransitionRecord;
import io.pravega.controller.store.stream.records.StreamConfigurationRecord;
import io.pravega.controller.store.stream.records.StreamSegmentRecord;
import io.pravega.controller.task.Stream.StreamMetadataTasks;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.UpdateStreamEvent;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.LoggerFactory;

public class UpdateStreamTask
implements StreamTask<UpdateStreamEvent> {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(UpdateStreamTask.class));
    private final StreamMetadataTasks streamMetadataTasks;
    private final StreamMetadataStore streamMetadataStore;
    private final BucketStore bucketStore;
    private final ScheduledExecutorService executor;

    public UpdateStreamTask(StreamMetadataTasks streamMetadataTasks, StreamMetadataStore streamMetadataStore, BucketStore bucketStore, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)streamMetadataStore);
        Preconditions.checkNotNull((Object)streamMetadataTasks);
        Preconditions.checkNotNull((Object)bucketStore);
        Preconditions.checkNotNull((Object)executor);
        this.streamMetadataTasks = streamMetadataTasks;
        this.streamMetadataStore = streamMetadataStore;
        this.bucketStore = bucketStore;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Void> execute(UpdateStreamEvent request) {
        String scope = request.getScope();
        String stream = request.getStream();
        long requestId = request.getRequestId();
        OperationContext context = this.streamMetadataStore.createStreamContext(scope, stream, requestId);
        return this.streamMetadataStore.getVersionedState(scope, stream, context, this.executor).thenCompose(versionedState -> this.streamMetadataStore.getConfigurationRecord(scope, stream, context, this.executor).thenCompose(versionedMetadata -> {
            if (!((StreamConfigurationRecord)versionedMetadata.getObject()).isUpdating()) {
                if (((State)((Object)((Object)((Object)versionedState.getObject())))).equals((Object)State.UPDATING)) {
                    return Futures.toVoid(this.streamMetadataStore.updateVersionedState(scope, stream, State.ACTIVE, (VersionedMetadata<State>)versionedState, context, this.executor));
                }
                return CompletableFuture.completedFuture(null);
            }
            return this.processUpdate(scope, stream, (VersionedMetadata<StreamConfigurationRecord>)versionedMetadata, (VersionedMetadata<State>)versionedState, context, requestId);
        }));
    }

    private CompletableFuture<Void> processUpdate(String scope, String stream, VersionedMetadata<StreamConfigurationRecord> record, VersionedMetadata<State> state, OperationContext context, long requestId) {
        StreamConfigurationRecord configProperty = record.getObject();
        return Futures.toVoid((CompletableFuture)this.streamMetadataStore.getEpochTransition(scope, stream, context, this.executor).thenCompose(etr -> this.streamMetadataStore.updateVersionedState(scope, stream, State.UPDATING, state, context, this.executor).thenCompose(updated -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.updateStreamForAutoStreamCut(scope, stream, configProperty, (VersionedMetadata<State>)updated).thenCompose(x -> this.notifyPolicyUpdate(context, scope, stream, configProperty.getStreamConfiguration(), requestId))).thenCompose(x -> this.handleSegmentCountUpdates(scope, stream, configProperty, (VersionedMetadata<EpochTransitionRecord>)etr, context, this.executor, requestId))).thenCompose(x -> this.streamMetadataStore.removeTagsFromIndex(scope, stream, configProperty.getRemoveTags(), context, this.executor))).thenCompose(x -> this.streamMetadataStore.addStreamTagsToIndex(scope, stream, configProperty.getStreamConfiguration(), context, this.executor))).thenCompose(x -> this.streamMetadataStore.completeUpdateConfiguration(scope, stream, record, context, this.executor))).thenCompose(x -> this.streamMetadataStore.updateVersionedState(scope, stream, State.ACTIVE, (VersionedMetadata<State>)updated, context, this.executor)))));
    }

    private CompletableFuture<Void> handleSegmentCountUpdates(String scope, String stream, StreamConfigurationRecord config, VersionedMetadata<EpochTransitionRecord> etr, OperationContext context, ScheduledExecutorService executor, long requestId) {
        return this.streamMetadataStore.getActiveEpoch(scope, stream, context, true, executor).thenCompose(activeEpoch -> {
            ScalingPolicy scalingPolicy = config.getStreamConfiguration().getScalingPolicy();
            int minNumSegments = scalingPolicy.getMinNumSegments();
            if (scalingPolicy.getScaleType() == ScalingPolicy.ScaleType.FIXED_NUM_SEGMENTS && activeEpoch.getSegments().size() != minNumSegments || activeEpoch.getSegments().size() < minNumSegments) {
                return this.processScale(scope, stream, minNumSegments, etr, (EpochRecord)activeEpoch, context, requestId);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private CompletableFuture<Void> processScale(String scope, String stream, int numSegments, VersionedMetadata<EpochTransitionRecord> etr, EpochRecord activeEpoch, OperationContext context, long requestId) {
        double keyRangeChunk = 1.0 / (double)numSegments;
        List newRange = IntStream.range(0, numSegments).boxed().map(x -> new AbstractMap.SimpleEntry<Double, Double>((double)x.intValue() * keyRangeChunk, (double)(x + 1) * keyRangeChunk)).collect(Collectors.toList());
        log.debug("{} Scaling stream to update minimum number of segments to {}", (Object)requestId, (Object)numSegments);
        return ((CompletableFuture)this.streamMetadataStore.resetEpochTransition(scope, stream, etr, context, this.executor).thenCompose(reset -> this.streamMetadataStore.submitScale(scope, stream, (List<Long>)new ArrayList<Long>(activeEpoch.getSegmentIds()), newRange, System.currentTimeMillis(), (VersionedMetadata<EpochTransitionRecord>)reset, context, this.executor))).thenCompose(updated -> this.streamMetadataTasks.processScale(scope, stream, (VersionedMetadata<EpochTransitionRecord>)updated, context, requestId, this.streamMetadataStore).thenAccept(r -> log.info("{} Stream scaled to epoch {} to update minimum number of segments to {}", new Object[]{requestId, ((EpochTransitionRecord)updated.getObject()).getActiveEpoch(), numSegments})));
    }

    private CompletableFuture<Void> updateStreamForAutoStreamCut(String scope, String stream, StreamConfigurationRecord configProperty, VersionedMetadata<State> updated) {
        if (configProperty.getStreamConfiguration().getRetentionPolicy() != null) {
            return this.bucketStore.addStreamToBucketStore(BucketStore.ServiceType.RetentionService, scope, stream, this.executor);
        }
        return this.bucketStore.removeStreamFromBucketStore(BucketStore.ServiceType.RetentionService, scope, stream, this.executor);
    }

    private CompletableFuture<Boolean> notifyPolicyUpdate(OperationContext context, String scope, String stream, StreamConfiguration newConfig, long requestId) {
        return ((CompletableFuture)this.streamMetadataStore.getActiveSegments(scope, stream, context, this.executor).thenCompose(activeSegments -> this.streamMetadataTasks.notifyPolicyUpdates(scope, stream, (List<StreamSegmentRecord>)activeSegments, newConfig.getScalingPolicy(), this.streamMetadataTasks.retrieveDelegationToken(), requestId))).handle((res, ex) -> {
            if (ex == null) {
                return true;
            }
            throw new CompletionException((Throwable)ex);
        });
    }

    @Override
    public CompletableFuture<Void> writeBack(UpdateStreamEvent event) {
        return this.streamMetadataTasks.writeEvent((ControllerEvent)event);
    }

    @Override
    public CompletableFuture<Boolean> hasTaskStarted(UpdateStreamEvent event) {
        return this.streamMetadataStore.getState(event.getScope(), event.getStream(), true, null, this.executor).thenApply(state -> state.equals((Object)State.UPDATING));
    }
}

