/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers.kvtable;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.eventProcessor.impl.SerializedRequestHandler;
import io.pravega.controller.server.eventProcessor.requesthandlers.RequestUnsupportedException;
import io.pravega.controller.store.kvtable.KVTableMetadataStore;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.RequestProcessor;
import io.pravega.shared.controller.event.kvtable.CreateTableEvent;
import io.pravega.shared.controller.event.kvtable.DeleteTableEvent;
import io.pravega.shared.controller.event.kvtable.TableRequestProcessor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableRequestProcessor<T extends ControllerEvent>
extends SerializedRequestHandler<T>
implements TableRequestProcessor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTableRequestProcessor.class);
    protected final KVTableMetadataStore metadataStore;

    public AbstractTableRequestProcessor(KVTableMetadataStore store, ScheduledExecutorService executor) {
        super(executor);
        Preconditions.checkNotNull((Object)store);
        this.metadataStore = store;
    }

    public String getProcessorName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public CompletableFuture<Void> processEvent(ControllerEvent controllerEvent) {
        return controllerEvent.process((RequestProcessor)this);
    }

    public CompletableFuture<Void> processCreateKVTable(CreateTableEvent createTableEvent) {
        return Futures.failedFuture((Throwable)new RequestUnsupportedException("Request Unsupported"));
    }

    public CompletableFuture<Void> processDeleteKVTable(DeleteTableEvent deleteTableEvent) {
        return Futures.failedFuture((Throwable)new RequestUnsupportedException("Request Unsupported"));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KVTableMetadataStore getMetadataStore() {
        return this.metadataStore;
    }
}

