/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers.kvtable;

import com.google.common.base.Preconditions;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.common.Exceptions;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.retryable.RetryableException;
import io.pravega.controller.server.eventProcessor.requesthandlers.kvtable.TableTask;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.kvtable.CreateKVTableResponse;
import io.pravega.controller.store.kvtable.KVTOperationContext;
import io.pravega.controller.store.kvtable.KVTableMetadataStore;
import io.pravega.controller.store.kvtable.KVTableState;
import io.pravega.controller.store.kvtable.KeyValueTable;
import io.pravega.controller.task.KeyValueTable.TableMetadataTasks;
import io.pravega.controller.util.RetryHelper;
import io.pravega.shared.NameUtils;
import io.pravega.shared.controller.event.kvtable.CreateTableEvent;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.LoggerFactory;

public class CreateTableTask
implements TableTask<CreateTableEvent> {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(CreateTableTask.class));
    private final KVTableMetadataStore kvtMetadataStore;
    private final TableMetadataTasks kvtMetadataTasks;
    private final ScheduledExecutorService executor;

    public CreateTableTask(KVTableMetadataStore kvtMetaStore, TableMetadataTasks kvtMetaTasks, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)kvtMetaStore);
        Preconditions.checkNotNull((Object)kvtMetaTasks);
        Preconditions.checkNotNull((Object)executor);
        this.kvtMetadataStore = kvtMetaStore;
        this.kvtMetadataTasks = kvtMetaTasks;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Void> execute(CreateTableEvent request) {
        String scope = request.getScopeName();
        String kvt = request.getKvtName();
        int partitionCount = request.getPartitionCount();
        int primaryKeyLength = request.getPrimaryKeyLength();
        int secondaryKeyLength = request.getSecondaryKeyLength();
        long creationTime = request.getTimestamp();
        long requestId = request.getRequestId();
        long rolloverSize = request.getRolloverSizeBytes();
        String kvTableId = request.getTableId().toString();
        KeyValueTableConfiguration config = KeyValueTableConfiguration.builder().partitionCount(partitionCount).primaryKeyLength(primaryKeyLength).secondaryKeyLength(secondaryKeyLength).rolloverSizeBytes(rolloverSize).build();
        KVTOperationContext context = this.kvtMetadataStore.createContext(scope, kvt, requestId);
        return RetryHelper.withRetriesAsync(() -> ((CompletableFuture)this.getKeyValueTable(scope, kvt).thenCompose(table -> table.getId(context))).thenCompose(id -> {
            if (!id.equals(kvTableId)) {
                log.debug(requestId, "Skipped processing create event for KeyValueTable {}/{} with Id:{} as UUIDs did not match.", new Object[]{scope, kvt, id});
                return CompletableFuture.completedFuture(null);
            }
            return this.kvtMetadataStore.createKeyValueTable(scope, kvt, config, creationTime, context, this.executor).thenComposeAsync(response -> {
                if (response.getStatus().equals((Object)CreateKVTableResponse.CreateStatus.NEW) || response.getStatus().equals((Object)CreateKVTableResponse.CreateStatus.EXISTS_CREATING)) {
                    int startingSegmentNumber = response.getStartingSegmentNumber();
                    int minNumSegments = response.getConfiguration().getPartitionCount();
                    int keyLength = response.getConfiguration().getPrimaryKeyLength() + response.getConfiguration().getSecondaryKeyLength();
                    List<Long> newSegments = IntStream.range(startingSegmentNumber, startingSegmentNumber + minNumSegments).boxed().map(x -> NameUtils.computeSegmentId((int)x, (int)0)).collect(Collectors.toList());
                    this.kvtMetadataTasks.createNewSegments(scope, kvt, newSegments, keyLength, requestId, config.getRolloverSizeBytes()).thenCompose(y -> {
                        this.kvtMetadataStore.getVersionedState(scope, kvt, context, this.executor).thenCompose(state -> {
                            if (((KVTableState)((Object)((Object)((Object)((Object)((Object)((Object)state.getObject()))))))).equals((Object)KVTableState.CREATING)) {
                                this.kvtMetadataStore.updateVersionedState(scope, kvt, KVTableState.ACTIVE, (VersionedMetadata<KVTableState>)state, context, this.executor);
                            }
                            return CompletableFuture.completedFuture(null);
                        });
                        return CompletableFuture.completedFuture(null);
                    });
                }
                return CompletableFuture.completedFuture(null);
            }, (Executor)this.executor);
        }), e -> Exceptions.unwrap((Throwable)e) instanceof RetryableException, Integer.MAX_VALUE, this.executor);
    }

    private CompletableFuture<KeyValueTable> getKeyValueTable(String scope, String kvt) {
        return CompletableFuture.completedFuture(this.kvtMetadataStore.getKVTable(scope, kvt, null));
    }
}

