/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers.kvtable;

import com.google.common.base.Preconditions;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.retryable.RetryableException;
import io.pravega.controller.server.eventProcessor.requesthandlers.kvtable.TableTask;
import io.pravega.controller.store.kvtable.KVTOperationContext;
import io.pravega.controller.store.kvtable.KVTableMetadataStore;
import io.pravega.controller.store.kvtable.KeyValueTable;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.task.KeyValueTable.TableMetadataTasks;
import io.pravega.controller.util.RetryHelper;
import io.pravega.shared.controller.event.kvtable.DeleteTableEvent;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.LoggerFactory;

public class DeleteTableTask
implements TableTask<DeleteTableEvent> {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(DeleteTableTask.class));
    private final KVTableMetadataStore kvtMetadataStore;
    private final TableMetadataTasks kvtMetadataTasks;
    private final ScheduledExecutorService executor;

    public DeleteTableTask(KVTableMetadataStore kvtMetaStore, TableMetadataTasks kvtMetaTasks, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)kvtMetaStore);
        Preconditions.checkNotNull((Object)kvtMetaTasks);
        Preconditions.checkNotNull((Object)executor);
        this.kvtMetadataStore = kvtMetaStore;
        this.kvtMetadataTasks = kvtMetaTasks;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Void> execute(DeleteTableEvent request) {
        String scope = request.getScope();
        String kvt = request.getKvtName();
        long requestId = request.getRequestId();
        String kvTableId = request.getTableId().toString();
        KVTOperationContext context = this.kvtMetadataStore.createContext(scope, kvt, requestId);
        return RetryHelper.withRetriesAsync(() -> ((CompletableFuture)this.getKeyValueTable(scope, kvt).thenCompose(table -> table.getId(context))).thenCompose(id -> {
            if (!id.equals(kvTableId)) {
                log.debug(requestId, "Skipped processing delete event for KeyValueTable {}/{} with Id:{} as UUIDs did not match.", new Object[]{scope, kvt, id});
                return CompletableFuture.completedFuture(null);
            }
            return Futures.exceptionallyExpecting((CompletableFuture)this.kvtMetadataStore.getAllSegmentIds(scope, kvt, context, this.executor).thenComposeAsync(allSegments -> this.kvtMetadataTasks.deleteSegments(scope, kvt, (Set<Long>)allSegments, this.kvtMetadataTasks.retrieveDelegationToken(), requestId), (Executor)this.executor), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, null).thenCompose(v -> this.kvtMetadataStore.deleteKeyValueTable(scope, kvt, context, this.executor));
        }), e -> Exceptions.unwrap((Throwable)e) instanceof RetryableException, Integer.MAX_VALUE, this.executor);
    }

    private CompletableFuture<KeyValueTable> getKeyValueTable(String scope, String kvt) {
        return CompletableFuture.completedFuture(this.kvtMetadataStore.getKVTable(scope, kvt, null));
    }
}

