/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers.kvtable;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.controller.server.eventProcessor.requesthandlers.kvtable.AbstractTableRequestProcessor;
import io.pravega.controller.server.eventProcessor.requesthandlers.kvtable.CreateTableTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.kvtable.DeleteTableTask;
import io.pravega.controller.store.kvtable.KVTableMetadataStore;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.kvtable.CreateTableEvent;
import io.pravega.shared.controller.event.kvtable.DeleteTableEvent;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRequestHandler
extends AbstractTableRequestProcessor<ControllerEvent> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableRequestHandler.class);
    private final CreateTableTask createTask;
    private final DeleteTableTask deleteTask;

    public TableRequestHandler(CreateTableTask createTask, DeleteTableTask deleteTask, KVTableMetadataStore store, ScheduledExecutorService executor) {
        super(store, executor);
        this.createTask = createTask;
        this.deleteTask = deleteTask;
    }

    @Override
    public CompletableFuture<Void> processCreateKVTable(CreateTableEvent createKVTEvent) {
        log.info("Processing create request {} for KeyValueTable {}/{}", new Object[]{createKVTEvent.getRequestId(), createKVTEvent.getScopeName(), createKVTEvent.getKvtName()});
        return this.createTask.execute(createKVTEvent);
    }

    @Override
    public CompletableFuture<Void> processDeleteKVTable(DeleteTableEvent deleteKVTEvent) {
        log.info("Processing delete request {} for KeyValueTable {}/{}", new Object[]{deleteKVTEvent.getRequestId(), deleteKVTEvent.getScope(), deleteKVTEvent.getKvtName()});
        return this.deleteTask.execute(deleteKVTEvent);
    }
}

