/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.health;

import com.google.common.base.Preconditions;
import io.pravega.controller.server.eventProcessor.ControllerEventProcessors;
import io.pravega.shared.health.Health;
import io.pravega.shared.health.Status;
import io.pravega.shared.health.impl.AbstractHealthContributor;

public class EventProcessorHealthContributor
extends AbstractHealthContributor {
    private final ControllerEventProcessors controllerEventProcessors;

    public EventProcessorHealthContributor(String name, ControllerEventProcessors controllerEventProcessors) {
        super(name);
        this.controllerEventProcessors = (ControllerEventProcessors)Preconditions.checkNotNull((Object)controllerEventProcessors, (Object)"controllerEventProcessors");
    }

    public Status doHealthCheck(Health.HealthBuilder builder) throws Exception {
        Status status = Status.DOWN;
        if (this.controllerEventProcessors.isRunning()) {
            status = Status.NEW;
            if (this.controllerEventProcessors.isReady()) {
                status = Status.UP;
            }
        }
        return status;
    }
}

