/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.health;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.controller.server.bucket.BucketManager;
import io.pravega.shared.health.Health;
import io.pravega.shared.health.Status;
import io.pravega.shared.health.impl.AbstractHealthContributor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatermarkingServiceHealthContributor
extends AbstractHealthContributor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WatermarkingServiceHealthContributor.class);
    private final BucketManager watermarkingService;

    public WatermarkingServiceHealthContributor(String name, BucketManager watermarkingService) {
        super(name);
        this.watermarkingService = (BucketManager)((Object)Preconditions.checkNotNull((Object)((Object)watermarkingService), (Object)"watermarkingService"));
    }

    public Status doHealthCheck(Health.HealthBuilder builder) throws Exception {
        Status status = Status.DOWN;
        if (this.watermarkingService.isRunning()) {
            status = Status.NEW;
            if (this.watermarkingService.isHealthy()) {
                status = Status.UP;
            }
        }
        return status;
    }
}

