/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rest;

import io.pravega.client.stream.RetentionPolicy;
import io.pravega.client.stream.ScalingPolicy;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.controller.server.rest.generated.model.CreateStreamRequest;
import io.pravega.controller.server.rest.generated.model.RetentionConfig;
import io.pravega.controller.server.rest.generated.model.ScalingConfig;
import io.pravega.controller.server.rest.generated.model.StreamProperty;
import io.pravega.controller.server.rest.generated.model.TagsList;
import io.pravega.controller.server.rest.generated.model.TimeBasedRetention;
import io.pravega.controller.server.rest.generated.model.UpdateStreamRequest;
import io.pravega.controller.store.stream.records.ReaderGroupConfigRecord;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import io.pravega.shared.controller.event.RGStreamCutRecord;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;

public class ModelHelper {
    public static final int MILLIS_TO_MINUTES = 60000;
    public static final int MB_TO_BYTES = 0x100000;

    public static final StreamConfiguration getCreateStreamConfig(CreateStreamRequest createStreamRequest) {
        ScalingPolicy scalingPolicy = createStreamRequest.getScalingPolicy().getType() == ScalingConfig.TypeEnum.FIXED_NUM_SEGMENTS ? ScalingPolicy.fixed((int)createStreamRequest.getScalingPolicy().getMinSegments()) : (createStreamRequest.getScalingPolicy().getType() == ScalingConfig.TypeEnum.BY_RATE_IN_EVENTS_PER_SEC ? ScalingPolicy.byEventRate((int)createStreamRequest.getScalingPolicy().getTargetRate(), (int)createStreamRequest.getScalingPolicy().getScaleFactor(), (int)createStreamRequest.getScalingPolicy().getMinSegments()) : ScalingPolicy.byDataRate((int)createStreamRequest.getScalingPolicy().getTargetRate(), (int)createStreamRequest.getScalingPolicy().getScaleFactor(), (int)createStreamRequest.getScalingPolicy().getMinSegments()));
        RetentionPolicy retentionPolicy = null;
        if (createStreamRequest.getRetentionPolicy() != null) {
            switch (createStreamRequest.getRetentionPolicy().getType()) {
                case LIMITED_SIZE_MB: {
                    if (createStreamRequest.getRetentionPolicy().getMaxValue() == null) {
                        retentionPolicy = RetentionPolicy.bySizeBytes((long)(createStreamRequest.getRetentionPolicy().getValue() * 0x100000L));
                        break;
                    }
                    retentionPolicy = RetentionPolicy.bySizeBytes((long)(createStreamRequest.getRetentionPolicy().getValue() * 0x100000L), (long)(createStreamRequest.getRetentionPolicy().getMaxValue() * 0x100000L));
                    break;
                }
                case LIMITED_DAYS: {
                    if (createStreamRequest.getRetentionPolicy().getMaxValue() == null && createStreamRequest.getRetentionPolicy().getMaxTimeBasedRetention() == null) {
                        retentionPolicy = ModelHelper.getRetentionPolicy(createStreamRequest.getRetentionPolicy().getTimeBasedRetention(), createStreamRequest.getRetentionPolicy().getValue());
                        break;
                    }
                    retentionPolicy = ModelHelper.getRetentionPolicy(createStreamRequest.getRetentionPolicy().getTimeBasedRetention(), createStreamRequest.getRetentionPolicy().getValue(), createStreamRequest.getRetentionPolicy().getMaxTimeBasedRetention(), createStreamRequest.getRetentionPolicy().getMaxValue() == null ? 0L : createStreamRequest.getRetentionPolicy().getMaxValue());
                    break;
                }
                default: {
                    throw new NotImplementedException("retention policy type not supported");
                }
            }
        }
        TagsList tagsList = new TagsList();
        if (createStreamRequest.getStreamTags() != null) {
            tagsList = createStreamRequest.getStreamTags();
        }
        StreamConfiguration.StreamConfigurationBuilder builder = StreamConfiguration.builder().scalingPolicy(scalingPolicy).retentionPolicy(retentionPolicy).tags((Collection)tagsList);
        if (createStreamRequest.getTimestampAggregationTimeout() != null) {
            builder.timestampAggregationTimeout(createStreamRequest.getTimestampAggregationTimeout().longValue());
        }
        if (createStreamRequest.getRolloverSizeBytes() != null) {
            builder.rolloverSizeBytes(createStreamRequest.getRolloverSizeBytes().longValue());
        }
        return builder.build();
    }

    public static final StreamConfiguration getUpdateStreamConfig(UpdateStreamRequest updateStreamRequest) {
        ScalingPolicy scalingPolicy = updateStreamRequest.getScalingPolicy().getType() == ScalingConfig.TypeEnum.FIXED_NUM_SEGMENTS ? ScalingPolicy.fixed((int)updateStreamRequest.getScalingPolicy().getMinSegments()) : (updateStreamRequest.getScalingPolicy().getType() == ScalingConfig.TypeEnum.BY_RATE_IN_EVENTS_PER_SEC ? ScalingPolicy.byEventRate((int)updateStreamRequest.getScalingPolicy().getTargetRate(), (int)updateStreamRequest.getScalingPolicy().getScaleFactor(), (int)updateStreamRequest.getScalingPolicy().getMinSegments()) : ScalingPolicy.byDataRate((int)updateStreamRequest.getScalingPolicy().getTargetRate(), (int)updateStreamRequest.getScalingPolicy().getScaleFactor(), (int)updateStreamRequest.getScalingPolicy().getMinSegments()));
        RetentionPolicy retentionPolicy = null;
        if (updateStreamRequest.getRetentionPolicy() != null) {
            switch (updateStreamRequest.getRetentionPolicy().getType()) {
                case LIMITED_SIZE_MB: {
                    retentionPolicy = RetentionPolicy.bySizeBytes((long)(updateStreamRequest.getRetentionPolicy().getValue() * 1024L * 1024L));
                    break;
                }
                case LIMITED_DAYS: {
                    retentionPolicy = ModelHelper.getRetentionPolicy(updateStreamRequest.getRetentionPolicy().getTimeBasedRetention(), updateStreamRequest.getRetentionPolicy().getValue());
                    break;
                }
                default: {
                    throw new NotImplementedException("retention policy type not supported");
                }
            }
        }
        TagsList tagsList = new TagsList();
        if (updateStreamRequest.getStreamTags() != null) {
            tagsList = updateStreamRequest.getStreamTags();
        }
        StreamConfiguration.StreamConfigurationBuilder builder = StreamConfiguration.builder().scalingPolicy(scalingPolicy).retentionPolicy(retentionPolicy).tags((Collection)tagsList);
        if (updateStreamRequest.getTimestampAggregationTimeout() != null) {
            builder.timestampAggregationTimeout(updateStreamRequest.getTimestampAggregationTimeout().longValue());
        }
        if (updateStreamRequest.getRolloverSizeBytes() != null) {
            builder.rolloverSizeBytes(updateStreamRequest.getRolloverSizeBytes().longValue());
        }
        return builder.build();
    }

    public static final StreamProperty encodeStreamResponse(String scope, String streamName, StreamConfiguration streamConfiguration) {
        ScalingConfig scalingPolicy = new ScalingConfig();
        if (streamConfiguration.getScalingPolicy().getScaleType() == ScalingPolicy.ScaleType.FIXED_NUM_SEGMENTS) {
            scalingPolicy.setType(ScalingConfig.TypeEnum.valueOf(streamConfiguration.getScalingPolicy().getScaleType().name()));
            scalingPolicy.setMinSegments(streamConfiguration.getScalingPolicy().getMinNumSegments());
        } else {
            scalingPolicy.setType(ScalingConfig.TypeEnum.valueOf(streamConfiguration.getScalingPolicy().getScaleType().name()));
            scalingPolicy.setTargetRate(streamConfiguration.getScalingPolicy().getTargetRate());
            scalingPolicy.setScaleFactor(streamConfiguration.getScalingPolicy().getScaleFactor());
            scalingPolicy.setMinSegments(streamConfiguration.getScalingPolicy().getMinNumSegments());
        }
        RetentionConfig retentionConfig = null;
        if (streamConfiguration.getRetentionPolicy() != null) {
            retentionConfig = new RetentionConfig();
            switch (streamConfiguration.getRetentionPolicy().getRetentionType()) {
                case SIZE: {
                    retentionConfig.setType(RetentionConfig.TypeEnum.LIMITED_SIZE_MB);
                    retentionConfig.setValue(streamConfiguration.getRetentionPolicy().getRetentionParam() / 0x100000L);
                    break;
                }
                case TIME: {
                    retentionConfig.setType(RetentionConfig.TypeEnum.LIMITED_DAYS);
                    TimeBasedRetention timeRetention = new TimeBasedRetention();
                    long totalMilliSecs = streamConfiguration.getRetentionPolicy().getRetentionParam();
                    long days = Duration.ofMillis(streamConfiguration.getRetentionPolicy().getRetentionParam()).toDays();
                    long daysInMs = Duration.ofDays(days).toMillis();
                    long hours = 0L;
                    long minutes = 0L;
                    if (totalMilliSecs == daysInMs) {
                        hours = 0L;
                        minutes = 0L;
                        retentionConfig.setValue(days);
                    } else {
                        hours = TimeUnit.MILLISECONDS.toHours(totalMilliSecs - daysInMs);
                        minutes = ModelHelper.getMinsFromMillis(totalMilliSecs, daysInMs, hours);
                        retentionConfig.setValue(0L);
                    }
                    retentionConfig.setTimeBasedRetention(timeRetention.days(days).hours(hours).minutes(minutes));
                    break;
                }
                default: {
                    throw new NotImplementedException("consumption type not supported");
                }
            }
        }
        TagsList tagList = new TagsList();
        tagList.addAll(streamConfiguration.getTags());
        StreamProperty streamProperty = new StreamProperty();
        streamProperty.setScopeName(scope);
        streamProperty.setStreamName(streamName);
        streamProperty.setScalingPolicy(scalingPolicy);
        streamProperty.setRetentionPolicy(retentionConfig);
        streamProperty.setTags(tagList);
        streamProperty.setTimestampAggregationTimeout(streamConfiguration.getTimestampAggregationTimeout());
        streamProperty.setRolloverSizeBytes(streamConfiguration.getRolloverSizeBytes());
        return streamProperty;
    }

    public static final Controller.ReaderGroupConfiguration encodeReaderGroupConfigRecord(String scope, String rgName, ReaderGroupConfigRecord rgConfig, UUID rgId) {
        List startStreamCuts = rgConfig.getStartingStreamCuts().entrySet().stream().map(e -> Controller.StreamCut.newBuilder().setStreamInfo(io.pravega.client.control.impl.ModelHelper.createStreamInfo((String)Stream.of((String)((String)e.getKey())).getScope(), (String)Stream.of((String)((String)e.getKey())).getStreamName())).putAllCut(((RGStreamCutRecord)e.getValue()).getStreamCut()).build()).collect(Collectors.toList());
        List endStreamCuts = rgConfig.getEndingStreamCuts().entrySet().stream().map(e -> Controller.StreamCut.newBuilder().setStreamInfo(io.pravega.client.control.impl.ModelHelper.createStreamInfo((String)Stream.of((String)((String)e.getKey())).getScope(), (String)Stream.of((String)((String)e.getKey())).getStreamName())).putAllCut(((RGStreamCutRecord)e.getValue()).getStreamCut()).build()).collect(Collectors.toList());
        Controller.ReaderGroupConfiguration.Builder builder = Controller.ReaderGroupConfiguration.newBuilder().setScope(scope).setReaderGroupName(rgName).setGroupRefreshTimeMillis(rgConfig.getGroupRefreshTimeMillis()).setAutomaticCheckpointIntervalMillis(rgConfig.getAutomaticCheckpointIntervalMillis()).setMaxOutstandingCheckpointRequest(rgConfig.getMaxOutstandingCheckpointRequest()).setRetentionType(rgConfig.getRetentionTypeOrdinal()).setGeneration(rgConfig.getGeneration()).setReaderGroupId(rgId.toString()).addAllStartingStreamCuts(startStreamCuts).addAllEndingStreamCuts(endStreamCuts);
        return builder.build();
    }

    private static RetentionPolicy getRetentionPolicy(TimeBasedRetention timeRetention, long retentionInDays) {
        Duration retentionDuration = timeRetention != null && retentionInDays == 0L ? Duration.ofDays(timeRetention.getDays()).plusHours(timeRetention.getHours()).plusMinutes(timeRetention.getMinutes()) : Duration.ofDays(retentionInDays);
        return RetentionPolicy.byTime((Duration)retentionDuration);
    }

    private static RetentionPolicy getRetentionPolicy(TimeBasedRetention timeRetention, long retentionInDays, TimeBasedRetention maxTimeRetention, long maxRetentionInDays) {
        Duration retentionDurationMin = timeRetention != null && retentionInDays == 0L ? Duration.ofDays(timeRetention.getDays()).plusHours(timeRetention.getHours()).plusMinutes(timeRetention.getMinutes()) : Duration.ofDays(retentionInDays);
        Duration retentionDurationMax = maxTimeRetention != null && maxRetentionInDays == 0L ? Duration.ofDays(maxTimeRetention.getDays()).plusHours(maxTimeRetention.getHours()).plusMinutes(maxTimeRetention.getMinutes()) : Duration.ofDays(maxRetentionInDays);
        return RetentionPolicy.byTime((Duration)retentionDurationMin, (Duration)retentionDurationMax);
    }

    private static long getMinsFromMillis(long totalDurationInMs, long daysInMs, long hours) {
        long remainderMs = 0L;
        if (hours > 0L) {
            long hoursInMs = Duration.ofHours(hours).toMillis();
            remainderMs = totalDurationInMs - (daysInMs + hoursInMs);
        } else {
            remainderMs = totalDurationInMs - daysInMs;
        }
        return TimeUnit.MILLISECONDS.toMinutes(remainderMs);
    }
}

