/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rest.generated.api;

import io.pravega.controller.server.rest.generated.api.NotFoundException;
import io.pravega.controller.server.rest.generated.api.ScopesApiService;
import io.pravega.controller.server.rest.generated.api.factories.ScopesApiServiceFactory;
import io.pravega.controller.server.rest.generated.model.CreateScopeRequest;
import io.pravega.controller.server.rest.generated.model.CreateStreamRequest;
import io.pravega.controller.server.rest.generated.model.ReaderGroupProperty;
import io.pravega.controller.server.rest.generated.model.ReaderGroupsList;
import io.pravega.controller.server.rest.generated.model.ScalingEventList;
import io.pravega.controller.server.rest.generated.model.ScopeProperty;
import io.pravega.controller.server.rest.generated.model.ScopesList;
import io.pravega.controller.server.rest.generated.model.StreamProperty;
import io.pravega.controller.server.rest.generated.model.StreamState;
import io.pravega.controller.server.rest.generated.model.StreamsList;
import io.pravega.controller.server.rest.generated.model.UpdateStreamRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.ServletConfig;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/scopes")
@Api(description="the scopes API")
public class ScopesApi {
    private final ScopesApiService delegate;

    public ScopesApi(@Context ServletConfig servletContext) {
        String implClass;
        ScopesApiService delegate = null;
        if (servletContext != null && (implClass = servletContext.getInitParameter("ScopesApi.implementation")) != null && !"".equals(implClass.trim())) {
            try {
                delegate = (ScopesApiService)Class.forName(implClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (delegate == null) {
            delegate = ScopesApiServiceFactory.getScopesApi();
        }
        this.delegate = delegate;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Create a new scope", response=ScopeProperty.class, tags={"Scopes"})
    @ApiResponses(value={@ApiResponse(code=201, message="Successfully created the scope", response=ScopeProperty.class), @ApiResponse(code=409, message="Scope with the given name already exists", response=ScopeProperty.class), @ApiResponse(code=500, message="Internal server error while creating a scope", response=ScopeProperty.class)})
    public Response createScope(@ApiParam(value="The scope configuration", required=true) CreateScopeRequest createScopeRequest, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.createScope(createScopeRequest, securityContext);
    }

    @POST
    @Path(value="/{scopeName}/streams")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Create a new stream", response=StreamProperty.class, tags={"Streams"})
    @ApiResponses(value={@ApiResponse(code=201, message="Successfully created the stream with the given configuration", response=StreamProperty.class), @ApiResponse(code=404, message="Scope not found", response=StreamProperty.class), @ApiResponse(code=409, message="Stream with given name already exists", response=StreamProperty.class), @ApiResponse(code=500, message="Internal server error while creating a stream", response=StreamProperty.class)})
    public Response createStream(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String scopeName, @ApiParam(value="The stream configuration", required=true) CreateStreamRequest createStreamRequest, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.createStream(scopeName, createStreamRequest, securityContext);
    }

    @DELETE
    @Path(value="/{scopeName}")
    @ApiOperation(value="", notes="Delete a scope", response=void.class, tags={"Scopes"})
    @ApiResponses(value={@ApiResponse(code=204, message="Successfully deleted the scope", response=void.class), @ApiResponse(code=404, message="Scope not found", response=void.class), @ApiResponse(code=412, message="Cannot delete scope since it has non-empty list of streams", response=void.class), @ApiResponse(code=500, message="Internal server error while deleting a scope", response=void.class)})
    public Response deleteScope(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String scopeName, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.deleteScope(scopeName, securityContext);
    }

    @DELETE
    @Path(value="/{scopeName}/streams/{streamName}")
    @ApiOperation(value="", notes="Delete a stream", response=void.class, tags={"Streams"})
    @ApiResponses(value={@ApiResponse(code=204, message="Successfully deleted the stream", response=void.class), @ApiResponse(code=404, message="Stream not found", response=void.class), @ApiResponse(code=412, message="Cannot delete stream since it is not sealed", response=void.class), @ApiResponse(code=500, message="Internal server error while deleting the stream", response=void.class)})
    public Response deleteStream(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String scopeName, @ApiParam(value="Stream name", required=true) @PathParam(value="streamName") String streamName, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.deleteStream(scopeName, streamName, securityContext);
    }

    @GET
    @Path(value="/{scopeName}/readergroups/{readerGroupName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Fetch the properties of an existing reader group", response=ReaderGroupProperty.class, tags={"ReaderGroups"})
    @ApiResponses(value={@ApiResponse(code=200, message="Found reader group properties", response=ReaderGroupProperty.class), @ApiResponse(code=404, message="Scope or reader group with given name not found", response=ReaderGroupProperty.class), @ApiResponse(code=500, message="Internal server error while fetching reader group details", response=ReaderGroupProperty.class)})
    public Response getReaderGroup(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String scopeName, @ApiParam(value="Reader group name", required=true) @PathParam(value="readerGroupName") String readerGroupName, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.getReaderGroup(scopeName, readerGroupName, securityContext);
    }

    @GET
    @Path(value="/{scopeName}/streams/{streamName}/scaling-events")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Get scaling events for a given datetime period.", response=ScalingEventList.class, tags={"Streams"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched list of scaling events.", response=ScalingEventList.class), @ApiResponse(code=404, message="Scope/Stream not found.", response=ScalingEventList.class), @ApiResponse(code=500, message="Internal Server error while fetching scaling events.", response=ScalingEventList.class)})
    public Response getScalingEvents(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String scopeName, @ApiParam(value="Stream name", required=true) @PathParam(value="streamName") String streamName, @ApiParam(value="Parameter to display scaling events from that particular datetime. Input should be milliseconds from Jan 1 1970.", required=true) @QueryParam(value="from") Long from, @ApiParam(value="Parameter to display scaling events to that particular datetime. Input should be milliseconds from Jan 1 1970.", required=true) @QueryParam(value="to") Long to, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.getScalingEvents(scopeName, streamName, from, to, securityContext);
    }

    @GET
    @Path(value="/{scopeName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Retrieve details of an existing scope", response=ScopeProperty.class, tags={"Scopes"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved the scope details", response=ScopeProperty.class), @ApiResponse(code=404, message="Scope with the given name not found", response=ScopeProperty.class), @ApiResponse(code=500, message="Internal server error while fetching scope details", response=ScopeProperty.class)})
    public Response getScope(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String scopeName, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.getScope(scopeName, securityContext);
    }

    @GET
    @Path(value="/{scopeName}/streams/{streamName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Fetch the properties of an existing stream", response=StreamProperty.class, tags={"Streams"})
    @ApiResponses(value={@ApiResponse(code=200, message="Found stream properties", response=StreamProperty.class), @ApiResponse(code=404, message="Scope or stream with given name not found", response=StreamProperty.class), @ApiResponse(code=500, message="Internal server error while fetching stream details", response=StreamProperty.class)})
    public Response getStream(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String scopeName, @ApiParam(value="Stream name", required=true) @PathParam(value="streamName") String streamName, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.getStream(scopeName, streamName, securityContext);
    }

    @GET
    @Path(value="/{scopeName}/readergroups")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="List reader groups within the given scope", response=ReaderGroupsList.class, tags={"ReaderGroups"})
    @ApiResponses(value={@ApiResponse(code=200, message="List of all reader groups configured for the given scope", response=ReaderGroupsList.class), @ApiResponse(code=404, message="Scope not found", response=ReaderGroupsList.class), @ApiResponse(code=500, message="Internal server error while fetching the list of reader groups for the given scope", response=ReaderGroupsList.class)})
    public Response listReaderGroups(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String scopeName, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.listReaderGroups(scopeName, securityContext);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="List all available scopes in pravega", response=ScopesList.class, tags={"Scopes"})
    @ApiResponses(value={@ApiResponse(code=200, message="List of currently available scopes", response=ScopesList.class), @ApiResponse(code=500, message="Internal server error while fetching list of scopes", response=ScopesList.class)})
    public Response listScopes(@Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.listScopes(securityContext);
    }

    @GET
    @Path(value="/{scopeName}/streams")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="List streams within the given scope", response=StreamsList.class, tags={"Streams"})
    @ApiResponses(value={@ApiResponse(code=200, message="List of all streams configured for the given scope", response=StreamsList.class), @ApiResponse(code=404, message="Scope not found", response=StreamsList.class), @ApiResponse(code=500, message="Internal server error while fetching the list of streams for the given scope", response=StreamsList.class)})
    public Response listStreams(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String scopeName, @ApiParam(value="Filter options", allowableValues="showInternalStreams, tag") @QueryParam(value="filter_type") String filterType, @ApiParam(value="value to be passed. must match the type passed with it.") @QueryParam(value="filter_value") String filterValue, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.listStreams(scopeName, filterType, filterValue, securityContext);
    }

    @PUT
    @Path(value="/{scopeName}/streams/{streamName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Update configuration of an existing stream", response=StreamProperty.class, tags={"Streams"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully updated the stream configuration", response=StreamProperty.class), @ApiResponse(code=404, message="Scope or stream with given name not found", response=StreamProperty.class), @ApiResponse(code=500, message="Internal server error while updating the stream", response=StreamProperty.class)})
    public Response updateStream(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String scopeName, @ApiParam(value="Stream name", required=true) @PathParam(value="streamName") String streamName, @ApiParam(value="The new stream configuration", required=true) UpdateStreamRequest updateStreamRequest, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.updateStream(scopeName, streamName, updateStreamRequest, securityContext);
    }

    @PUT
    @Path(value="/{scopeName}/streams/{streamName}/state")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Updates the current state of the stream", response=StreamState.class, tags={"Streams"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully updated the stream state", response=StreamState.class), @ApiResponse(code=404, message="Scope or stream with given name not found", response=StreamState.class), @ApiResponse(code=500, message="Internal server error while updating the stream state", response=StreamState.class)})
    public Response updateStreamState(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String scopeName, @ApiParam(value="Stream name", required=true) @PathParam(value="streamName") String streamName, @ApiParam(value="The state info to be updated", required=true) StreamState updateStreamStateRequest, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.updateStreamState(scopeName, streamName, updateStreamStateRequest, securityContext);
    }
}

