/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rest.resources;

import io.pravega.auth.AuthException;
import io.pravega.auth.AuthHandler;
import io.pravega.client.ClientConfig;
import io.pravega.client.admin.ReaderGroupManager;
import io.pravega.client.admin.impl.ReaderGroupManagerImpl;
import io.pravega.client.connection.impl.ConnectionFactory;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.stream.ReaderGroup;
import io.pravega.client.stream.ReaderGroupNotFoundException;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.stream.impl.AbstractClientFactoryImpl;
import io.pravega.client.stream.impl.ClientFactoryImpl;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.server.ControllerService;
import io.pravega.controller.server.eventProcessor.LocalController;
import io.pravega.controller.server.rest.ModelHelper;
import io.pravega.controller.server.rest.generated.model.CreateScopeRequest;
import io.pravega.controller.server.rest.generated.model.CreateStreamRequest;
import io.pravega.controller.server.rest.generated.model.ReaderGroupProperty;
import io.pravega.controller.server.rest.generated.model.ReaderGroupsList;
import io.pravega.controller.server.rest.generated.model.ReaderGroupsListReaderGroups;
import io.pravega.controller.server.rest.generated.model.ScopeProperty;
import io.pravega.controller.server.rest.generated.model.ScopesList;
import io.pravega.controller.server.rest.generated.model.StreamProperty;
import io.pravega.controller.server.rest.generated.model.StreamState;
import io.pravega.controller.server.rest.generated.model.StreamsList;
import io.pravega.controller.server.rest.generated.model.UpdateStreamRequest;
import io.pravega.controller.server.rest.v1.ApiV1;
import io.pravega.controller.store.stream.ScaleMetadata;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import io.pravega.shared.NameUtils;
import io.pravega.shared.rest.security.AuthHandlerManager;
import io.pravega.shared.rest.security.RESTAuthHelper;
import io.pravega.shared.security.auth.AuthorizationResource;
import io.pravega.shared.security.auth.AuthorizationResourceImpl;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamMetadataResourceImpl
implements ApiV1.ScopesApi {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(StreamMetadataResourceImpl.class));
    @Context
    HttpHeaders headers;
    private final ControllerService controllerService;
    private final RESTAuthHelper restAuthHelper;
    private final LocalController localController;
    private final ConnectionFactory connectionFactory;
    private final AuthorizationResource authorizationResource = new AuthorizationResourceImpl();
    private final Random requestIdGenerator = new Random();
    private final ClientConfig clientConfig;

    public StreamMetadataResourceImpl(LocalController localController, ControllerService controllerService, AuthHandlerManager pravegaAuthManager, ConnectionFactory connectionFactory, ClientConfig clientConfig) {
        this.localController = localController;
        this.controllerService = controllerService;
        this.restAuthHelper = new RESTAuthHelper(pravegaAuthManager);
        this.connectionFactory = connectionFactory;
        this.clientConfig = clientConfig;
    }

    @Override
    public void createScope(CreateScopeRequest createScopeRequest, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long requestId = this.requestIdGenerator.nextLong();
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"createScope", (Object[])new Object[0]);
        try {
            NameUtils.validateUserScopeName((String)createScopeRequest.getScopeName());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.warn(requestId, "Create scope failed due to invalid scope name {}", new Object[]{createScopeRequest.getScopeName()});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"createScope", (long)traceId, (Object[])new Object[0]);
            return;
        }
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), this.authorizationResource.ofScopes(), AuthHandler.Permissions.READ_UPDATE);
        }
        catch (AuthException e) {
            log.warn(requestId, "Create scope for {} failed due to authentication failure {}.", new Object[]{createScopeRequest.getScopeName(), e});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"createScope", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.createScope(createScopeRequest.getScopeName(), requestId).thenApply(scopeStatus -> {
            if (scopeStatus.getStatus() == Controller.CreateScopeStatus.Status.SUCCESS) {
                log.info(requestId, "Successfully created new scope: {}", new Object[]{createScopeRequest.getScopeName()});
                return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new ScopeProperty().scopeName(createScopeRequest.getScopeName())).build();
            }
            if (scopeStatus.getStatus() == Controller.CreateScopeStatus.Status.SCOPE_EXISTS) {
                log.warn(requestId, "Scope name: {} already exists", new Object[]{createScopeRequest.getScopeName()});
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            log.warn(requestId, "Failed to create scope: {}", new Object[]{createScopeRequest.getScopeName()});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).exceptionally(exception -> {
            log.warn(requestId, "createScope for scope: {} failed, exception: {}", new Object[]{createScopeRequest.getScopeName(), exception});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"createScope", (long)traceId, (Object[])new Object[0]));
    }

    private List<String> getAuthorizationHeader() {
        return this.headers.getRequestHeader("Authorization");
    }

    @Override
    public void createStream(String scopeName, CreateStreamRequest createStreamRequest, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"createStream", (Object[])new Object[0]);
        long requestId = this.requestIdGenerator.nextLong();
        String streamName = createStreamRequest.getStreamName();
        try {
            NameUtils.validateUserStreamName((String)streamName);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.warn(requestId, "Create stream failed due to invalid stream name {}", new Object[]{streamName});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"createStream", (long)traceId, (Object[])new Object[0]);
            return;
        }
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), this.authorizationResource.ofStreamsInScope(scopeName), AuthHandler.Permissions.READ_UPDATE);
        }
        catch (AuthException e) {
            log.warn(requestId, "Create stream for {} failed due to authentication failure.", new Object[]{streamName});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"createStream", (long)traceId, (Object[])new Object[0]);
            return;
        }
        StreamConfiguration streamConfiguration = ModelHelper.getCreateStreamConfig(createStreamRequest);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.createStream(scopeName, streamName, streamConfiguration, System.currentTimeMillis(), requestId).thenApply(streamStatus -> {
            Response resp = null;
            if (streamStatus.getStatus() == Controller.CreateStreamStatus.Status.SUCCESS) {
                log.info(requestId, "Successfully created stream: {}/{}", new Object[]{scopeName, streamName});
                resp = Response.status((Response.Status)Response.Status.CREATED).entity((Object)ModelHelper.encodeStreamResponse(scopeName, streamName, streamConfiguration)).build();
            } else if (streamStatus.getStatus() == Controller.CreateStreamStatus.Status.STREAM_EXISTS) {
                log.warn(requestId, "Stream already exists: {}/{}", new Object[]{scopeName, streamName});
                resp = Response.status((Response.Status)Response.Status.CONFLICT).build();
            } else if (streamStatus.getStatus() == Controller.CreateStreamStatus.Status.SCOPE_NOT_FOUND) {
                log.warn(requestId, "Scope not found: {}", new Object[]{scopeName});
                resp = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            } else if (streamStatus.getStatus() == Controller.CreateStreamStatus.Status.INVALID_STREAM_NAME) {
                log.warn(requestId, "Invalid stream name: {}", new Object[]{streamName});
                resp = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            } else {
                log.warn(requestId, "createStream failed for : {}/{}", new Object[]{scopeName, streamName});
                resp = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            return resp;
        })).exceptionally(exception -> {
            log.warn(requestId, "createStream for {}/{} failed: ", new Object[]{scopeName, streamName, exception});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"createStream", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void deleteScope(String scopeName, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"deleteScope", (Object[])new Object[0]);
        long requestId = this.requestIdGenerator.nextLong();
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), this.authorizationResource.ofScopes(), AuthHandler.Permissions.READ_UPDATE);
        }
        catch (AuthException e) {
            log.warn(requestId, "Delete scope for {} failed due to authentication failure.", new Object[]{scopeName});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"createStream", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.deleteScope(scopeName, requestId).thenApply(scopeStatus -> {
            if (scopeStatus.getStatus() == Controller.DeleteScopeStatus.Status.SUCCESS) {
                log.info(requestId, "Successfully deleted scope: {}", new Object[]{scopeName});
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            if (scopeStatus.getStatus() == Controller.DeleteScopeStatus.Status.SCOPE_NOT_FOUND) {
                log.warn(requestId, "Scope: {} not found", new Object[]{scopeName});
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (scopeStatus.getStatus() == Controller.DeleteScopeStatus.Status.SCOPE_NOT_EMPTY) {
                log.warn(requestId, "Cannot delete scope: {} with non-empty streams", new Object[]{scopeName});
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            log.warn(requestId, "deleteScope for {} failed", new Object[]{scopeName});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).exceptionally(exception -> {
            log.warn(requestId, "deleteScope for {} failed with exception: {}", new Object[]{scopeName, exception});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"deleteScope", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void deleteStream(String scopeName, String streamName, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"deleteStream", (Object[])new Object[0]);
        long requestId = this.requestIdGenerator.nextLong();
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), this.authorizationResource.ofStreamInScope(scopeName, streamName), AuthHandler.Permissions.READ_UPDATE);
        }
        catch (AuthException e) {
            log.warn(requestId, "Delete stream for {} failed due to authentication failure.", new Object[]{streamName});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"deleteStream", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.deleteStream(scopeName, streamName, requestId).thenApply(deleteStreamStatus -> {
            if (deleteStreamStatus.getStatus() == Controller.DeleteStreamStatus.Status.SUCCESS) {
                log.info(requestId, "Successfully deleted stream: {}", new Object[]{streamName});
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            if (deleteStreamStatus.getStatus() == Controller.DeleteStreamStatus.Status.STREAM_NOT_FOUND) {
                log.warn(requestId, "Scope: {}, Stream {} not found", new Object[]{scopeName, streamName});
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (deleteStreamStatus.getStatus() == Controller.DeleteStreamStatus.Status.STREAM_NOT_SEALED) {
                log.warn(requestId, "Cannot delete unsealed stream: {}", new Object[]{streamName});
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            log.warn(requestId, "deleteStream for {} failed", new Object[]{streamName});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).exceptionally(exception -> {
            log.warn(requestId, "deleteStream for {} failed with exception: {}", new Object[]{streamName, exception});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"deleteStream", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void getReaderGroup(String scopeName, String readerGroupName, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"getReaderGroup", (Object[])new Object[0]);
        long requestId = this.requestIdGenerator.nextLong();
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), this.authorizationResource.ofReaderGroupInScope(scopeName, readerGroupName), AuthHandler.Permissions.READ);
        }
        catch (AuthException e) {
            log.warn(requestId, "Get reader group for {} failed due to authentication failure.", new Object[]{scopeName + "/" + readerGroupName});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"getReaderGroup", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ClientFactoryImpl clientFactory = new ClientFactoryImpl(scopeName, (Controller)this.localController, this.clientConfig);
        ReaderGroupManagerImpl readerGroupManager = new ReaderGroupManagerImpl(scopeName, (Controller)this.localController, (AbstractClientFactoryImpl)clientFactory);
        ReaderGroupProperty readerGroupProperty = new ReaderGroupProperty();
        readerGroupProperty.setScopeName(scopeName);
        readerGroupProperty.setReaderGroupName(readerGroupName);
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> StreamMetadataResourceImpl.lambda$getReaderGroup$12((ReaderGroupManager)readerGroupManager, readerGroupName, readerGroupProperty), this.controllerService.getExecutor()).exceptionally(exception -> {
            log.warn(requestId, "getReaderGroup for {} failed with exception: ", new Object[]{readerGroupName, exception});
            if (exception.getCause() instanceof ReaderGroupNotFoundException) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenAccept(arg_0 -> StreamMetadataResourceImpl.lambda$getReaderGroup$14(asyncResponse, (ReaderGroupManager)readerGroupManager, clientFactory, traceId, arg_0));
    }

    @Override
    public void getScope(String scopeName, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"getScope", (Object[])new Object[0]);
        long requestId = this.requestIdGenerator.nextLong();
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), this.authorizationResource.ofScope(scopeName), AuthHandler.Permissions.READ);
        }
        catch (AuthException e) {
            log.warn(requestId, "Get scope for {} failed due to authentication failure.", new Object[]{scopeName});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"getScope", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.getScope(scopeName, requestId).thenApply(scope -> Response.status((Response.Status)Response.Status.OK).entity((Object)new ScopeProperty().scopeName((String)scope)).build())).exceptionally(exception -> {
            if (exception.getCause() instanceof StoreException.DataNotFoundException) {
                log.warn(requestId, "Scope: {} not found", new Object[]{scopeName});
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            log.warn(requestId, "getScope for {} failed with exception: {}", new Object[]{scopeName, exception});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"getScope", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void getStream(String scopeName, String streamName, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"getStream", (Object[])new Object[0]);
        long requestId = this.requestIdGenerator.nextLong();
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), this.authorizationResource.ofStreamInScope(scopeName, streamName), AuthHandler.Permissions.READ);
        }
        catch (AuthException e) {
            log.warn(requestId, "Get stream for {} failed due to authentication failure.", new Object[]{scopeName + "/" + streamName});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"getStream", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.getStream(scopeName, streamName, requestId).thenApply(streamConfig -> Response.status((Response.Status)Response.Status.OK).entity((Object)ModelHelper.encodeStreamResponse(scopeName, streamName, streamConfig)).build())).exceptionally(exception -> {
            if (exception.getCause() instanceof StoreException.DataNotFoundException || exception instanceof StoreException.DataNotFoundException) {
                log.warn(requestId, "Stream: {}/{} not found", new Object[]{scopeName, streamName});
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            log.warn(requestId, "getStream for {}/{} failed with exception: {}", new Object[]{scopeName, streamName, exception});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"getStream", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void listReaderGroups(String scopeName, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"listReaderGroups", (Object[])new Object[0]);
        long requestId = this.requestIdGenerator.nextLong();
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), this.authorizationResource.ofReaderGroupsInScope(scopeName), AuthHandler.Permissions.READ);
        }
        catch (AuthException e) {
            log.warn(requestId, "Get reader groups for {} failed due to authentication failure.", new Object[]{scopeName});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"listReaderGroups", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.listStreamsInScope(scopeName, requestId).thenApply(streamsList -> {
            ReaderGroupsList readerGroups = new ReaderGroupsList();
            streamsList.forEach((stream, config) -> {
                if (stream.startsWith("_RG")) {
                    ReaderGroupsListReaderGroups readerGroup = new ReaderGroupsListReaderGroups();
                    readerGroup.setReaderGroupName(stream.substring("_RG".length()));
                    readerGroups.addReaderGroupsItem(readerGroup);
                }
            });
            log.info(requestId, "Successfully fetched readerGroups for scope: {}", new Object[]{scopeName});
            return Response.status((Response.Status)Response.Status.OK).entity((Object)readerGroups).build();
        })).exceptionally(exception -> {
            if (exception.getCause() instanceof StoreException.DataNotFoundException || exception instanceof StoreException.DataNotFoundException) {
                log.warn(requestId, "Scope name: {} not found", new Object[]{scopeName});
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            log.warn(requestId, "listReaderGroups for {} failed with exception: ", new Object[]{scopeName, exception});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"listReaderGroups", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void listScopes(SecurityContext securityContext, AsyncResponse asyncResponse) {
        Principal principal;
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"listScopes", (Object[])new Object[0]);
        long requestId = this.requestIdGenerator.nextLong();
        List<String> authHeader = this.getAuthorizationHeader();
        try {
            principal = this.restAuthHelper.authenticate(authHeader);
            this.restAuthHelper.authorize(authHeader, this.authorizationResource.ofScopes(), principal, AuthHandler.Permissions.READ);
        }
        catch (AuthException e) {
            log.warn(requestId, "Get scopes failed due to authentication failure.", new Object[]{e});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"listScopes", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)this.controllerService.listScopes(requestId).thenApply(scopesList -> {
            ScopesList scopes = new ScopesList();
            scopesList.forEach(scope -> {
                try {
                    if (this.restAuthHelper.isAuthorized(authHeader, this.authorizationResource.ofScope(scope), principal, AuthHandler.Permissions.READ)) {
                        scopes.addScopesItem(new ScopeProperty().scopeName((String)scope));
                    }
                }
                catch (AuthException e) {
                    log.warn(requestId, e.getMessage(), new Object[]{e});
                }
            });
            return Response.status((Response.Status)Response.Status.OK).entity((Object)scopes).build();
        })).exceptionally(exception -> {
            log.warn(requestId, "listScopes failed with exception: ", new Object[]{exception});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(response -> {
            asyncResponse.resume(response);
            LoggerHelpers.traceLeave((Logger)log, (String)"listScopes", (long)traceId, (Object[])new Object[0]);
            return response;
        });
    }

    @Override
    public void listStreams(String scopeName, String filterType, String filterValue, SecurityContext securityContext, AsyncResponse asyncResponse) {
        boolean showStreamsWithTag;
        Principal principal;
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"listStreams", (Object[])new Object[0]);
        long requestId = this.requestIdGenerator.nextLong();
        List<String> authHeader = this.getAuthorizationHeader();
        try {
            principal = this.restAuthHelper.authenticate(authHeader);
            this.restAuthHelper.authorize(authHeader, this.authorizationResource.ofStreamsInScope(scopeName), principal, AuthHandler.Permissions.READ);
        }
        catch (AuthException e) {
            log.warn(requestId, "List streams for {} failed due to authentication failure.", new Object[]{scopeName});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"listStreams", (long)traceId, (Object[])new Object[0]);
            return;
        }
        boolean showOnlyInternalStreams = filterType != null && filterType.equals("showInternalStreams");
        boolean bl = showStreamsWithTag = filterType != null && filterType.equals("tag");
        if (showStreamsWithTag && filterValue != null) {
            String tag = filterValue;
            ArrayList streams = new ArrayList();
            String finalTag = tag;
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.localController.listStreamsForTag(scopeName, tag).collectRemaining(streams::add).thenCompose(v -> {
                List streamConfigFutureList = streams.stream().filter(stream -> {
                    boolean isAuthorized = false;
                    try {
                        isAuthorized = this.restAuthHelper.isAuthorized(authHeader, this.authorizationResource.ofStreamInScope(scopeName, stream.getStreamName()), principal, AuthHandler.Permissions.READ);
                    }
                    catch (AuthException e) {
                        log.warn(requestId, "List Streams with tag {} for scope {} failed due to authentication failure.", new Object[]{finalTag, scopeName});
                    }
                    return isAuthorized;
                }).map(stream -> this.localController.getStreamConfiguration(scopeName, stream.getStreamName()).thenApply(config -> new ImmutablePair(stream, config))).collect(Collectors.toList());
                return Futures.allOfWithResults(streamConfigFutureList);
            })).thenApply(streamConfigPairs -> {
                StreamsList responseStreams = new StreamsList();
                responseStreams.setStreams(new ArrayList<StreamProperty>());
                streamConfigPairs.forEach(pair -> responseStreams.addStreamsItem(ModelHelper.encodeStreamResponse(((Stream)pair.left).getScope(), ((Stream)pair.left).getStreamName(), (StreamConfiguration)pair.right)));
                log.info(requestId, "Successfully fetched streams for scope: {} with tag: {}", new Object[]{scopeName, finalTag});
                return Response.status((Response.Status)Response.Status.OK).entity((Object)responseStreams).build();
            })).exceptionally(exception -> {
                if (exception.getCause() instanceof StoreException.DataNotFoundException || exception instanceof StoreException.DataNotFoundException) {
                    log.warn(requestId, "Scope name: {} not found", new Object[]{scopeName});
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                log.warn(requestId, "listStreams for {} with tag {} failed with exception: {}", new Object[]{scopeName, finalTag, exception});
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"listStreams", (long)traceId, (Object[])new Object[0]));
        } else {
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.listStreamsInScope(scopeName, requestId).thenApply(streamsList -> {
                StreamsList streams = new StreamsList();
                streams.setStreams(new ArrayList<StreamProperty>());
                streamsList.forEach((stream, config) -> {
                    try {
                        if (this.restAuthHelper.isAuthorized(authHeader, this.authorizationResource.ofStreamInScope(scopeName, stream), principal, AuthHandler.Permissions.READ) && !showOnlyInternalStreams ^ stream.startsWith("_")) {
                            streams.addStreamsItem(ModelHelper.encodeStreamResponse(scopeName, stream, config));
                        }
                    }
                    catch (AuthException e) {
                        log.warn(requestId, "Read internal streams for scope {} failed due to authentication failure.", new Object[]{scopeName});
                    }
                });
                log.info(requestId, "Successfully fetched streams for scope: {}", new Object[]{scopeName});
                return Response.status((Response.Status)Response.Status.OK).entity((Object)streams).build();
            })).exceptionally(exception -> {
                if (exception.getCause() instanceof StoreException.DataNotFoundException || exception instanceof StoreException.DataNotFoundException) {
                    log.warn(requestId, "Scope name: {} not found", new Object[]{scopeName});
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                log.warn(requestId, "listStreams for {} failed with exception: {}", new Object[]{scopeName, exception});
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"listStreams", (long)traceId, (Object[])new Object[0]));
        }
    }

    @Override
    public void updateStream(String scopeName, String streamName, UpdateStreamRequest updateStreamRequest, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"updateStream", (Object[])new Object[0]);
        long requestId = this.requestIdGenerator.nextLong();
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), this.authorizationResource.ofStreamInScope(scopeName, streamName), AuthHandler.Permissions.READ_UPDATE);
        }
        catch (AuthException e) {
            log.warn(requestId, "Update stream for {} failed due to authentication failure.", new Object[]{scopeName + "/" + streamName});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"Update stream", (long)traceId, (Object[])new Object[0]);
            return;
        }
        StreamConfiguration streamConfiguration = ModelHelper.getUpdateStreamConfig(updateStreamRequest);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.updateStream(scopeName, streamName, streamConfiguration, requestId).thenApply(streamStatus -> {
            if (streamStatus.getStatus() == Controller.UpdateStreamStatus.Status.SUCCESS) {
                log.info(requestId, "Successfully updated stream config for: {}/{}", new Object[]{scopeName, streamName});
                return Response.status((Response.Status)Response.Status.OK).entity((Object)ModelHelper.encodeStreamResponse(scopeName, streamName, streamConfiguration)).build();
            }
            if (streamStatus.getStatus() == Controller.UpdateStreamStatus.Status.STREAM_NOT_FOUND || streamStatus.getStatus() == Controller.UpdateStreamStatus.Status.SCOPE_NOT_FOUND) {
                log.warn(requestId, "Stream: {}/{} not found", new Object[]{scopeName, streamName});
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            log.warn(requestId, "updateStream failed for {}/{}", new Object[]{scopeName, streamName});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).exceptionally(exception -> {
            log.warn(requestId, "updateStream for {}/{} failed with exception: {}", new Object[]{scopeName, streamName, exception});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"updateStream", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void updateStreamState(String scopeName, String streamName, StreamState updateStreamStateRequest, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"updateStreamState", (Object[])new Object[0]);
        long requestId = this.requestIdGenerator.nextLong();
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), this.authorizationResource.ofStreamInScope(scopeName, streamName), AuthHandler.Permissions.READ_UPDATE);
        }
        catch (AuthException e) {
            log.warn(requestId, "Update stream for {} failed due to authentication failure.", new Object[]{scopeName + "/" + streamName});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"Update stream", (long)traceId, (Object[])new Object[0]);
            return;
        }
        if (updateStreamStateRequest.getStreamState() != StreamState.StreamStateEnum.SEALED) {
            log.warn(requestId, "Received invalid stream state: {} from client for stream {}/{}", new Object[]{updateStreamStateRequest.getStreamState(), scopeName, streamName});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.sealStream(scopeName, streamName, requestId).thenApply(updateStreamStatus -> {
            if (updateStreamStatus.getStatus() == Controller.UpdateStreamStatus.Status.SUCCESS) {
                log.info(requestId, "Successfully sealed stream: {}", new Object[]{streamName});
                return Response.status((Response.Status)Response.Status.OK).entity((Object)updateStreamStateRequest).build();
            }
            if (updateStreamStatus.getStatus() == Controller.UpdateStreamStatus.Status.SCOPE_NOT_FOUND || updateStreamStatus.getStatus() == Controller.UpdateStreamStatus.Status.STREAM_NOT_FOUND) {
                log.warn(requestId, "Scope: {} or Stream {} not found", new Object[]{scopeName, streamName});
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            log.warn(requestId, "updateStreamState for {} failed", new Object[]{streamName});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).exceptionally(exception -> {
            log.warn(requestId, "updateStreamState for {} failed with exception: {}", new Object[]{streamName, exception});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"updateStreamState", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void getScalingEvents(String scopeName, String streamName, Long from, Long to, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"getScalingEvents", (Object[])new Object[0]);
        long requestId = this.requestIdGenerator.nextLong();
        if (from == null || to == null) {
            log.warn(requestId, "Received an invalid request with missing query parameters for scopeName/streamName: {}/{}", new Object[]{scopeName, streamName});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"getScalingEvents", (long)traceId, (Object[])new Object[0]);
            return;
        }
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), this.authorizationResource.ofStreamInScope(scopeName, streamName), AuthHandler.Permissions.READ);
        }
        catch (AuthException e) {
            log.warn(requestId, "Get scaling events for {} failed due to authentication failure.", new Object[]{scopeName + "/" + streamName});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"Get scaling events", (long)traceId, (Object[])new Object[0]);
            return;
        }
        if (from < 0L || to < 0L || from > to) {
            log.warn(requestId, "Received invalid request from client for scopeName/streamName: {}/{} ", new Object[]{scopeName, streamName});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"getScalingEvents", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.getScaleRecords(scopeName, streamName, from, to, requestId).thenApply(listScaleMetadata -> {
            Iterator metadataIterator = listScaleMetadata.iterator();
            ArrayList<ScaleMetadata> finalScaleMetadataList = new ArrayList<ScaleMetadata>();
            ScaleMetadata referenceEvent = null;
            while (metadataIterator.hasNext()) {
                ScaleMetadata scaleMetadata = (ScaleMetadata)metadataIterator.next();
                if (scaleMetadata.getTimestamp() >= from && scaleMetadata.getTimestamp() <= to) {
                    finalScaleMetadataList.add(scaleMetadata);
                    continue;
                }
                if (scaleMetadata.getTimestamp() >= from || referenceEvent != null && referenceEvent.getTimestamp() > scaleMetadata.getTimestamp()) continue;
                referenceEvent = scaleMetadata;
            }
            if (referenceEvent != null) {
                finalScaleMetadataList.add(0, referenceEvent);
            }
            log.info(requestId, "Successfully fetched required scaling events for scope: {}, stream: {}", new Object[]{scopeName, streamName});
            return Response.status((Response.Status)Response.Status.OK).entity(finalScaleMetadataList).build();
        })).exceptionally(exception -> {
            if (exception.getCause() instanceof StoreException.DataNotFoundException || exception instanceof StoreException.DataNotFoundException) {
                log.warn(requestId, "Stream/Scope name: {}/{} not found", new Object[]{scopeName, streamName});
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            log.warn(requestId, "getScalingEvents for scopeName/streamName: {}/{} failed with exception ", new Object[]{scopeName, streamName, exception});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"getScalingEvents", (long)traceId, (Object[])new Object[0]));
    }

    private static /* synthetic */ void lambda$getReaderGroup$14(AsyncResponse asyncResponse, ReaderGroupManager readerGroupManager, ClientFactoryImpl clientFactory, long traceId, Response response) {
        asyncResponse.resume((Object)response);
        readerGroupManager.close();
        clientFactory.close();
        LoggerHelpers.traceLeave((Logger)log, (String)"getReaderGroup", (long)traceId, (Object[])new Object[0]);
    }

    private static /* synthetic */ Response lambda$getReaderGroup$12(ReaderGroupManager readerGroupManager, String readerGroupName, ReaderGroupProperty readerGroupProperty) {
        ReaderGroup readerGroup = readerGroupManager.getReaderGroup(readerGroupName);
        readerGroupProperty.setOnlineReaderIds(new ArrayList<String>(readerGroup.getOnlineReaders()));
        readerGroupProperty.setStreamList(new ArrayList<String>(readerGroup.getStreamNames()));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)readerGroupProperty).build();
    }
}

