/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rpc.grpc;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.AbstractIdleService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContext;
import io.pravega.auth.ServerConfig;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.tracing.RequestTracker;
import io.pravega.controller.server.ControllerService;
import io.pravega.controller.server.rpc.grpc.GRPCServerConfig;
import io.pravega.controller.server.rpc.grpc.v1.ControllerServiceImpl;
import io.pravega.controller.server.security.auth.GrpcAuthHelper;
import io.pravega.shared.controller.tracing.RPCTracingHelpers;
import io.pravega.shared.rest.security.AuthHandlerManager;
import java.io.File;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCServer
extends AbstractIdleService {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GRPCServer.class);
    private final String objectId;
    private final Server server;
    private final GRPCServerConfig config;
    private final AuthHandlerManager authHandlerManager;

    public GRPCServer(ControllerService controllerService, GRPCServerConfig serverConfig, RequestTracker requestTracker) {
        this.objectId = "gRPCServer";
        this.config = serverConfig;
        GrpcAuthHelper authHelper = new GrpcAuthHelper(serverConfig.isAuthorizationEnabled(), serverConfig.getTokenSigningKey(), serverConfig.getAccessTokenTTLInSeconds());
        ServerBuilder builder = NettyServerBuilder.forPort((int)serverConfig.getPort()).withChildOption(ChannelOption.SO_REUSEADDR, (Object)true).addService(ServerInterceptors.intercept((BindableService)new ControllerServiceImpl(controllerService, authHelper, requestTracker, serverConfig.isReplyWithStackTraceOnError(), serverConfig.isRGWritesWithReadPermEnabled()), (ServerInterceptor[])new ServerInterceptor[]{RPCTracingHelpers.getServerInterceptor((RequestTracker)requestTracker)}));
        if (serverConfig.isAuthorizationEnabled()) {
            this.authHandlerManager = new AuthHandlerManager((ServerConfig)serverConfig);
            GrpcAuthHelper.registerInterceptors(this.authHandlerManager.getHandlerMap(), builder);
        } else {
            this.authHandlerManager = null;
        }
        if (serverConfig.isTlsEnabled() && !Strings.isNullOrEmpty((String)serverConfig.getTlsCertFile())) {
            builder = builder.useTransportSecurity(new File(serverConfig.getTlsCertFile()), new File(serverConfig.getTlsKeyFile()));
            SslContext ctx = this.getSSLContext(serverConfig);
            ((NettyServerBuilder)builder).sslContext(ctx);
        }
        this.server = builder.build();
    }

    private SslContext getSSLContext(GRPCServerConfig serverConfig) {
        return GrpcSslContexts.forServer((File)new File(serverConfig.getTlsCertFile()), (File)new File(serverConfig.getTlsKeyFile())).protocols(serverConfig.getTlsProtocolVersion()).build();
    }

    protected void startUp() throws Exception {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.objectId, (String)"startUp", (Object[])new Object[0]);
        try {
            log.info("Starting gRPC server listening on port: {}", (Object)this.config.getPort());
            this.server.start();
        }
        finally {
            LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"startUp", (long)traceId, (Object[])new Object[0]);
        }
    }

    protected void shutDown() throws Exception {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.objectId, (String)"shutDown", (Object[])new Object[0]);
        try {
            log.info("Stopping gRPC server listening on port: {}", (Object)this.config.getPort());
            this.server.shutdown();
            log.info("Awaiting termination of gRPC server");
            this.server.awaitTermination();
            log.info("gRPC server terminated");
        }
        finally {
            LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"shutDown", (long)traceId, (Object[])new Object[0]);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AuthHandlerManager getAuthHandlerManager() {
        return this.authHandlerManager;
    }
}

