/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rpc.grpc.v1;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import io.pravega.auth.AuthHandler;
import io.pravega.auth.AuthenticationException;
import io.pravega.auth.AuthorizationException;
import io.pravega.client.control.impl.ModelHelper;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.common.Exceptions;
import io.pravega.common.hash.RandomFactory;
import io.pravega.common.tracing.RequestTag;
import io.pravega.common.tracing.RequestTracker;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.server.ControllerService;
import io.pravega.controller.server.security.auth.GrpcAuthHelper;
import io.pravega.controller.server.security.auth.StreamAuthParams;
import io.pravega.controller.server.security.auth.handler.AuthContext;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.task.LockFailedException;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import io.pravega.controller.stream.api.grpc.v1.ControllerServiceGrpc;
import io.pravega.shared.NameUtils;
import io.pravega.shared.security.auth.AccessOperation;
import io.pravega.shared.security.auth.AuthorizationResource;
import io.pravega.shared.security.auth.AuthorizationResourceImpl;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.LoggerFactory;

public class ControllerServiceImpl
extends ControllerServiceGrpc.ControllerServiceImplBase {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(ControllerServiceImpl.class));
    private static final int PAGE_LIMIT = 1000;
    private final ControllerService controllerService;
    private final GrpcAuthHelper grpcAuthHelper;
    private final RequestTracker requestTracker;
    private final boolean replyWithStackTraceOnError;
    private final boolean isRGStreamWritesWithReadPermEnabled;
    private final Random requestIdGenerator = RandomFactory.create();
    private final int pageLimit;
    private final AuthorizationResource authorizationResource = new AuthorizationResourceImpl();

    public ControllerServiceImpl(ControllerService controllerService, GrpcAuthHelper authHelper, RequestTracker requestTracker, boolean replyWithStackTraceOnError, boolean isRGStreamWritesWithReadPermEnabled) {
        this(controllerService, authHelper, requestTracker, replyWithStackTraceOnError, isRGStreamWritesWithReadPermEnabled, 1000);
    }

    public void getControllerServerList(Controller.ServerRequest request, StreamObserver<Controller.ServerResponse> responseObserver) {
        log.trace("getControllerServerList called.");
        this.authenticateExecuteAndProcessResults(() -> "", delegationToken -> this.controllerService.getControllerServerList().thenApply(servers -> Controller.ServerResponse.newBuilder().addAllNodeURI((Iterable)servers).build()), responseObserver);
    }

    public void createReaderGroup(Controller.ReaderGroupConfiguration request, StreamObserver<Controller.CreateReaderGroupResponse> responseObserver) {
        String scope = request.getScope();
        String rgName = request.getReaderGroupName();
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"createReaderGroup", scope, rgName});
        log.info(requestTag.getRequestId(), "createReaderGroup called for ReaderGroup {}/{}.", new Object[]{scope, rgName});
        AuthHandler.Permissions requiredPermission = this.isRGStreamWritesWithReadPermEnabled ? AuthHandler.Permissions.READ : AuthHandler.Permissions.READ_UPDATE;
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorizationAndCreateToken(this.authorizationResource.ofReaderGroupsInScope(scope), requiredPermission), delegationToken -> this.controllerService.createReaderGroup(scope, rgName, ModelHelper.encode((Controller.ReaderGroupConfiguration)request), System.currentTimeMillis(), requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void updateReaderGroup(Controller.ReaderGroupConfiguration request, StreamObserver<Controller.UpdateReaderGroupResponse> responseObserver) {
        String scope = request.getScope();
        String rgName = request.getReaderGroupName();
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"updateReaderGroup", scope, rgName});
        log.info(requestTag.getRequestId(), "updateReaderGroup called for ReaderGroup {}/{}.", new Object[]{scope, rgName});
        AuthHandler.Permissions requiredPermission = this.isRGStreamWritesWithReadPermEnabled ? AuthHandler.Permissions.READ : AuthHandler.Permissions.READ_UPDATE;
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorizationAndCreateToken(this.authorizationResource.ofReaderGroupsInScope(scope), requiredPermission), delegationToken -> this.controllerService.updateReaderGroup(scope, rgName, ModelHelper.encode((Controller.ReaderGroupConfiguration)request), requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void getReaderGroupConfig(Controller.ReaderGroupInfo request, StreamObserver<Controller.ReaderGroupConfigResponse> responseObserver) {
        String scope = request.getScope();
        String rgName = request.getReaderGroup();
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"getReaderGroupConfig", scope, rgName});
        log.info(requestTag.getRequestId(), "getReaderGroupConfig called for Reader Group {}/{}.", new Object[]{scope, rgName});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorizationAndCreateToken(this.authorizationResource.ofReaderGroupsInScope(scope), AuthHandler.Permissions.READ), delegationToken -> this.controllerService.getReaderGroupConfig(scope, rgName, requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void deleteReaderGroup(Controller.ReaderGroupInfo request, StreamObserver<Controller.DeleteReaderGroupStatus> responseObserver) {
        String scope = request.getScope();
        String rgName = request.getReaderGroup();
        String rgId = request.getReaderGroupId();
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"deleteReaderGroup", scope, rgName});
        log.info(requestTag.getRequestId(), "deleteReaderGroup called for Reader Group {}/{}.", new Object[]{scope, rgName});
        AuthHandler.Permissions requiredPermission = this.isRGStreamWritesWithReadPermEnabled ? AuthHandler.Permissions.READ : AuthHandler.Permissions.READ_UPDATE;
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorizationAndCreateToken(this.authorizationResource.ofReaderGroupsInScope(scope), requiredPermission), delegationToken -> this.controllerService.deleteReaderGroup(scope, rgName, rgId, requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void createKeyValueTable(Controller.KeyValueTableConfig request, StreamObserver<Controller.CreateKeyValueTableStatus> responseObserver) {
        String scope = request.getScope();
        String kvt = request.getKvtName();
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"createKeyValueTable", scope, kvt});
        log.info(requestTag.getRequestId(), "createKeyValueTable called for KVTable {}/{}.", new Object[]{scope, kvt});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorizationAndCreateToken(this.authorizationResource.ofKeyValueTablesInScope(scope), AuthHandler.Permissions.READ_UPDATE), delegationToken -> this.controllerService.createKeyValueTable(scope, kvt, ModelHelper.encode((Controller.KeyValueTableConfig)request), System.currentTimeMillis(), requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void getCurrentSegmentsKeyValueTable(Controller.KeyValueTableInfo request, StreamObserver<Controller.SegmentRanges> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"getCurrentSegmentsKeyValueTable", request.getScope(), request.getKvtName()});
        log.info(requestTag.getRequestId(), "getCurrentSegmentsKeyValueTable called for kvtable {}/{}.", new Object[]{request.getScope(), request.getKvtName()});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorizationAndCreateToken(this.authorizationResource.ofKeyValueTableInScope(request.getScope(), request.getKvtName()), AuthHandler.Permissions.READ_UPDATE), delegationToken -> {
            this.logIfEmpty((String)delegationToken, "getCurrentSegmentsKeyValueTable", request.getScope(), request.getKvtName());
            return this.controllerService.getCurrentSegmentsKeyValueTable(request.getScope(), request.getKvtName(), requestTag.getRequestId()).thenApply(segmentRanges -> Controller.SegmentRanges.newBuilder().addAllSegmentRanges((Iterable)segmentRanges).setDelegationToken(delegationToken).build());
        }, responseObserver);
    }

    public void listKeyValueTablesInScope(Controller.KVTablesInScopeRequest request, StreamObserver<Controller.KVTablesInScopeResponse> responseObserver) {
        String scopeName = request.getScope().getScope();
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"listKeyValueTables", scopeName});
        log.info(requestTag.getRequestId(), "listKeyValueTables called for scope {}.", new Object[]{scopeName});
        AuthContext ctx = this.grpcAuthHelper.isAuthEnabled() ? AuthContext.current() : null;
        Function streamsFn = delegationToken -> this.listWithFilter(request.getContinuationToken().getToken(), this.pageLimit, (x, y) -> this.controllerService.listKeyValueTables(scopeName, (String)x, (int)y, requestTag.getRequestId()), x -> this.grpcAuthHelper.isAuthorized(this.authorizationResource.ofKeyValueTableInScope(scopeName, x), AuthHandler.Permissions.READ, ctx), x -> Controller.KeyValueTableInfo.newBuilder().setScope(scopeName).setKvtName(x).build(), requestTag.getRequestId()).handle((response, ex) -> {
            if (ex != null) {
                if (Exceptions.unwrap((Throwable)ex) instanceof StoreException.DataNotFoundException) {
                    return Controller.KVTablesInScopeResponse.newBuilder().setStatus(Controller.KVTablesInScopeResponse.Status.SCOPE_NOT_FOUND).build();
                }
                throw new CompletionException((Throwable)ex);
            }
            return Controller.KVTablesInScopeResponse.newBuilder().addAllKvtables((Iterable)response.getKey()).setContinuationToken(Controller.ContinuationToken.newBuilder().setToken((String)response.getValue()).build()).setStatus(Controller.KVTablesInScopeResponse.Status.SUCCESS).build();
        });
        this.authenticateExecuteAndProcessResults(() -> {
            String result = this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofScope(scopeName), AuthHandler.Permissions.READ, ctx);
            log.debug("Result of authorization for [{}] and READ permission is: [{}]", (Object)this.authorizationResource.ofScope(scopeName), (Object)result);
            return result;
        }, streamsFn, responseObserver, requestTag);
    }

    public void getKeyValueTableConfiguration(Controller.KeyValueTableInfo request, StreamObserver<Controller.KeyValueTableConfigResponse> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"getKeyValueTableConfiguration", request.getScope(), request.getKvtName()});
        log.info(requestTag.getRequestId(), "{} called for {}/{}.", new Object[]{"getKeyValueTableConfiguration", request.getScope(), request.getKvtName()});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofKeyValueTableInScope(request.getScope(), request.getKvtName()), AuthHandler.Permissions.READ), delegationToken -> this.controllerService.getKeyValueTableConfiguration(request.getScope(), request.getKvtName(), requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void deleteKeyValueTable(Controller.KeyValueTableInfo request, StreamObserver<Controller.DeleteKVTableStatus> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"deleteKeyValueTable", request.getScope(), request.getKvtName()});
        log.info(requestTag.getRequestId(), "deleteKeyValueTable called for KVTable {}/{}.", new Object[]{request.getScope(), request.getKvtName()});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofKeyValueTableInScope(request.getScope(), request.getKvtName()), AuthHandler.Permissions.READ_UPDATE), delegationToken -> this.controllerService.deleteKeyValueTable(request.getScope(), request.getKvtName(), requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void createStream(Controller.StreamConfig request, StreamObserver<Controller.CreateStreamStatus> responseObserver) {
        String scope = request.getStreamInfo().getScope();
        String stream = request.getStreamInfo().getStream();
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"createStream", scope, stream});
        log.info(requestTag.getRequestId(), "createStream called for stream {}/{}.", new Object[]{scope, stream});
        StreamAuthParams streamAuthParams = new StreamAuthParams(scope, stream, this.isRGStreamWritesWithReadPermEnabled);
        AuthHandler.Permissions requiredPermission = streamAuthParams.requiredPermissionForWrites();
        log.debug(requestTag.getRequestId(), "requiredPermission is [{}], for scope [{}] and stream [{}]", new Object[]{requiredPermission, scope, stream});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorizationAndCreateToken(this.authorizationResource.ofStreamsInScope(scope), requiredPermission), delegationToken -> this.controllerService.createStream(scope, stream, ModelHelper.encode((Controller.StreamConfig)request), System.currentTimeMillis(), requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void listSubscribers(Controller.StreamInfo request, StreamObserver<Controller.SubscribersResponse> responseObserver) {
        String scope = request.getScope();
        String stream = request.getStream();
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"listSubscribers", scope, stream});
        log.info(requestTag.getRequestId(), "listSubscribers called for stream {}/{}.", new Object[]{scope, stream});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(scope, stream), AuthHandler.Permissions.READ_UPDATE), delegationToken -> this.controllerService.listSubscribers(scope, stream, requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void updateSubscriberStreamCut(Controller.SubscriberStreamCut request, StreamObserver<Controller.UpdateSubscriberStatus> responseObserver) {
        String scope = request.getStreamCut().getStreamInfo().getScope();
        String stream = request.getStreamCut().getStreamInfo().getStream();
        String subscriber = request.getSubscriber();
        String readerGroupId = request.getReaderGroupId();
        long generation = request.getGeneration();
        Controller.StreamCut streamCut = request.getStreamCut();
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"updateTruncationStreamCut", scope, stream});
        log.info(requestTag.getRequestId(), "updateSubscriberStreamCut called for stream {}/{}.", new Object[]{scope, stream});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(scope, stream), AuthHandler.Permissions.READ_UPDATE), delegationToken -> this.controllerService.updateSubscriberStreamCut(scope, stream, subscriber, readerGroupId, generation, (ImmutableMap<Long, Long>)ImmutableMap.copyOf((Map)ModelHelper.encode((Controller.StreamCut)streamCut)), requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void updateStream(Controller.StreamConfig request, StreamObserver<Controller.UpdateStreamStatus> responseObserver) {
        String scope = request.getStreamInfo().getScope();
        String stream = request.getStreamInfo().getStream();
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"updateStream", scope, stream});
        log.info(requestTag.getRequestId(), "updateStream called for stream {}/{}.", new Object[]{scope, stream});
        Supplier<String> authorizationSupplier = () -> this.grpcAuthHelper.checkAuthorization(StreamAuthParams.toResourceString(scope, stream), AuthHandler.Permissions.READ_UPDATE);
        this.authenticateExecuteAndProcessResults(authorizationSupplier, authorizationResult -> this.controllerService.updateStream(scope, stream, ModelHelper.encode((Controller.StreamConfig)request), requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void truncateStream(Controller.StreamCut request, StreamObserver<Controller.UpdateStreamStatus> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"truncateStream", request.getStreamInfo().getScope(), request.getStreamInfo().getStream()});
        log.info(requestTag.getRequestId(), "truncateStream called for stream {}/{}.", new Object[]{request.getStreamInfo().getScope(), request.getStreamInfo().getStream()});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(request.getStreamInfo().getScope(), request.getStreamInfo().getStream()), AuthHandler.Permissions.READ_UPDATE), delegationToken -> this.controllerService.truncateStream(request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), ModelHelper.encode((Controller.StreamCut)request), requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void sealStream(Controller.StreamInfo request, StreamObserver<Controller.UpdateStreamStatus> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"sealStream", request.getScope(), request.getStream()});
        log.info(requestTag.getRequestId(), "sealStream called for stream {}/{}.", new Object[]{request.getScope(), request.getStream()});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(request.getScope(), request.getStream()), AuthHandler.Permissions.READ_UPDATE), delegationToken -> this.controllerService.sealStream(request.getScope(), request.getStream(), requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void deleteStream(Controller.StreamInfo request, StreamObserver<Controller.DeleteStreamStatus> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"deleteStream", request.getScope(), request.getStream()});
        log.info(requestTag.getRequestId(), "deleteStream called for stream {}/{}.", new Object[]{request.getScope(), request.getStream()});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(request.getScope(), request.getStream()), AuthHandler.Permissions.READ_UPDATE), delegationToken -> this.controllerService.deleteStream(request.getScope(), request.getStream(), requestTag.getRequestId()), responseObserver, requestTag);
    }

    private AccessOperation translate(@NonNull Controller.StreamInfo.AccessOperation accessOperation) {
        if (accessOperation == null) {
            throw new NullPointerException("accessOperation is marked non-null but is null");
        }
        return AccessOperation.valueOf((String)accessOperation.name());
    }

    public void getCurrentSegments(Controller.StreamInfo request, StreamObserver<Controller.SegmentRanges> responseObserver) {
        String scope = request.getScope();
        String stream = request.getStream();
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"getCurrentSegments", request.getScope(), request.getStream()});
        log.info(requestTag.getRequestId(), "getCurrentSegments called for stream {}/{}.", new Object[]{scope, stream});
        String resource = StreamAuthParams.toResourceString(scope, stream);
        boolean isDelegationTokenRequested = !request.getAccessOperation().equals((Object)Controller.StreamInfo.AccessOperation.NONE);
        this.authenticateExecuteAndProcessResults(() -> {
            if (isDelegationTokenRequested) {
                return this.grpcAuthHelper.checkAuthorizationAndCreateToken(resource, AuthHandler.Permissions.READ_UPDATE);
            }
            return this.grpcAuthHelper.checkAuthorization(resource, AuthHandler.Permissions.READ);
        }, authorizationResult -> {
            this.logIfEmpty((String)authorizationResult, "getCurrentSegments", scope, stream);
            return this.controllerService.getCurrentSegments(scope, stream, requestTag.getRequestId()).thenApply(segmentRanges -> {
                Controller.SegmentRanges.Builder builder = Controller.SegmentRanges.newBuilder().addAllSegmentRanges((Iterable)segmentRanges);
                if (isDelegationTokenRequested) {
                    builder.setDelegationToken(authorizationResult);
                }
                return builder.build();
            });
        }, responseObserver, requestTag);
    }

    @VisibleForTesting
    public Supplier<String> delegationTokenSupplier(Controller.StreamInfo request) {
        return () -> {
            AuthHandler.Permissions tokenPermission;
            String tokenResource;
            if (!this.isAuthEnabled()) {
                return "";
            }
            StreamAuthParams authParams = new StreamAuthParams(request.getScope(), request.getStream(), this.translate(request.getAccessOperation()), this.isRGStreamWritesWithReadPermEnabled);
            String streamResource = authParams.streamResourceString();
            String resource = authParams.resourceString();
            if (authParams.isAccessOperationUnspecified()) {
                log.debug("Access operation was unspecified for request with scope {} and stream {}", (Object)request.getScope(), (Object)request.getStream());
                AuthHandler.Permissions authAndTokenPermission = AuthHandler.Permissions.READ_UPDATE;
                this.grpcAuthHelper.checkAuthorization(resource, authAndTokenPermission);
                return this.grpcAuthHelper.createDelegationToken(streamResource, authAndTokenPermission);
            }
            log.trace("Access operation was {} for request with scope {} and stream {}", new Object[]{this.translate(request.getAccessOperation()), request.getScope(), request.getStream()});
            AuthHandler.Permissions requestedPermissions = authParams.requestedPermission();
            if (authParams.isStreamUserDefined()) {
                AuthHandler.Permissions minimumPermissions = AuthHandler.Permissions.READ;
                if (requestedPermissions.equals((Object)AuthHandler.Permissions.READ_UPDATE) || requestedPermissions.equals((Object)minimumPermissions)) {
                    this.grpcAuthHelper.checkAuthorization(streamResource, requestedPermissions);
                    tokenResource = streamResource;
                    tokenPermission = requestedPermissions;
                } else {
                    this.grpcAuthHelper.checkAuthorization(streamResource, minimumPermissions);
                    this.grpcAuthHelper.checkAuthorization(streamResource, requestedPermissions);
                    tokenResource = streamResource;
                    tokenPermission = requestedPermissions;
                }
            } else {
                AuthHandler.Permissions authorizationPermission;
                if (requestedPermissions.equals((Object)AuthHandler.Permissions.READ_UPDATE)) {
                    authorizationPermission = authParams.requiredPermissionForWrites();
                    tokenPermission = AuthHandler.Permissions.READ_UPDATE;
                } else if (requestedPermissions.equals((Object)AuthHandler.Permissions.READ)) {
                    authorizationPermission = AuthHandler.Permissions.READ;
                    tokenPermission = requestedPermissions;
                } else {
                    authorizationPermission = AuthHandler.Permissions.READ;
                    tokenPermission = AuthHandler.Permissions.READ;
                }
                log.trace("resource: {}, authorizationPermission: {}", (Object)authParams.resourceString(), (Object)authorizationPermission);
                this.grpcAuthHelper.checkAuthorization(authParams.resourceString(), authorizationPermission);
                tokenResource = streamResource;
            }
            return this.grpcAuthHelper.createDelegationToken(tokenResource, tokenPermission);
        };
    }

    public void getEpochSegments(Controller.GetEpochSegmentsRequest request, StreamObserver<Controller.SegmentRanges> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"getEpochSegments", request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), Integer.toString(request.getEpoch())});
        log.info(requestTag.getRequestId(), "getEpochSegments called for stream {}/{} and epoch {}", new Object[]{request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), request.getEpoch()});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorizationAndCreateToken(this.authorizationResource.ofStreamInScope(request.getStreamInfo().getScope(), request.getStreamInfo().getStream()), AuthHandler.Permissions.READ_UPDATE), delegationToken -> {
            this.logIfEmpty((String)delegationToken, "getEpochSegments", request.getStreamInfo().getScope(), request.getStreamInfo().getStream());
            return this.controllerService.getEpochSegments(request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), request.getEpoch(), requestTag.getRequestId()).thenApply(segmentRanges -> Controller.SegmentRanges.newBuilder().addAllSegmentRanges((Iterable)segmentRanges).setDelegationToken(delegationToken).build());
        }, responseObserver, requestTag);
    }

    public void getSegments(Controller.GetSegmentsRequest request, StreamObserver<Controller.SegmentsAtTime> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"getSegmentsAtTime", request.getStreamInfo().getScope(), request.getStreamInfo().getStream()});
        Controller.StreamInfo streamInfo = request.getStreamInfo();
        String scope = streamInfo.getScope();
        String stream = streamInfo.getStream();
        log.debug(requestTag.getRequestId(), "getSegments called for stream " + scope + "/" + stream, new Object[0]);
        boolean shouldReturnDelegationToken = !streamInfo.getAccessOperation().equals((Object)Controller.StreamInfo.AccessOperation.NONE);
        this.authenticateExecuteAndProcessResults(() -> {
            if (shouldReturnDelegationToken) {
                return this.grpcAuthHelper.checkAuthorizationAndCreateToken(this.authorizationResource.ofStreamInScope(scope, stream), AuthHandler.Permissions.READ_UPDATE);
            }
            return this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(scope, stream), AuthHandler.Permissions.READ);
        }, authorizationResult -> {
            this.logIfEmpty((String)authorizationResult, "getSegments", scope, stream);
            return this.controllerService.getSegmentsAtHead(scope, stream, requestTag.getRequestId()).thenApply(segments -> {
                Controller.SegmentsAtTime.Builder builder = Controller.SegmentsAtTime.newBuilder();
                if (shouldReturnDelegationToken) {
                    builder.setDelegationToken(authorizationResult);
                }
                for (Map.Entry entry : segments.entrySet()) {
                    builder.addSegments(Controller.SegmentsAtTime.SegmentLocation.newBuilder().setSegmentId((Controller.SegmentId)entry.getKey()).setOffset(((Long)entry.getValue()).longValue()).build());
                }
                return builder.build();
            });
        }, responseObserver);
    }

    public void getSegmentsImmediatelyFollowing(Controller.SegmentId segmentId, StreamObserver<Controller.SuccessorResponse> responseObserver) {
        String segment = NameUtils.getQualifiedStreamSegmentName((String)segmentId.getStreamInfo().getScope(), (String)segmentId.getStreamInfo().getStream(), (long)segmentId.getSegmentId());
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"getSegmentsImmediatelyFollowing", segment});
        log.info(requestTag.getRequestId(), "getSegmentsImmediatelyFollowing called for segment {} ", new Object[]{segment});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(segmentId.getStreamInfo().getScope(), segmentId.getStreamInfo().getStream()), AuthHandler.Permissions.READ), delegationToken -> ((CompletableFuture)this.controllerService.getSegmentsImmediatelyFollowing(segmentId, requestTag.getRequestId()).thenApply(ModelHelper::createSuccessorResponse)).thenApply(response -> {
            response.setDelegationToken(delegationToken);
            return response.build();
        }), responseObserver);
    }

    public void getSegmentsImmediatlyFollowing(Controller.SegmentId segmentId, StreamObserver<Controller.SuccessorResponse> responseObserver) {
        this.getSegmentsImmediatelyFollowing(segmentId, responseObserver);
    }

    public void getSegmentsBetween(Controller.StreamCutRange request, StreamObserver<Controller.StreamCutRangeResponse> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"getSegmentsBetweenStreamCuts", request.getStreamInfo().getScope(), request.getStreamInfo().getStream()});
        log.info(requestTag.getRequestId(), "getSegmentsBetweenStreamCuts called for stream {} for cuts from {} to {}", new Object[]{request.getStreamInfo(), request.getFromMap(), request.getToMap()});
        String scope = request.getStreamInfo().getScope();
        String stream = request.getStreamInfo().getStream();
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorizationAndCreateToken(this.authorizationResource.ofStreamInScope(scope, stream), AuthHandler.Permissions.READ), delegationToken -> {
            this.logIfEmpty((String)delegationToken, "getSegmentsBetween", request.getStreamInfo().getScope(), request.getStreamInfo().getStream());
            return this.controllerService.getSegmentsBetweenStreamCuts(request, requestTag.getRequestId()).thenApply(segments -> ModelHelper.createStreamCutRangeResponse((String)scope, (String)stream, segments.stream().map(x -> ModelHelper.createSegmentId((String)scope, (String)stream, (long)x.segmentId())).collect(Collectors.toList()), (String)delegationToken));
        }, responseObserver);
    }

    public void scale(Controller.ScaleRequest request, StreamObserver<Controller.ScaleResponse> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"scaleStream", request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), String.valueOf(request.getScaleTimestamp())});
        log.info(requestTag.getRequestId(), "scale called for stream {}/{}.", new Object[]{request.getStreamInfo().getScope(), request.getStreamInfo().getStream()});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(request.getStreamInfo().getScope(), request.getStreamInfo().getStream()), AuthHandler.Permissions.READ_UPDATE), delegationToken -> this.controllerService.scale(request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), request.getSealedSegmentsList(), request.getNewKeyRangesList().stream().collect(Collectors.toMap(Controller.ScaleRequest.KeyRangeEntry::getStart, Controller.ScaleRequest.KeyRangeEntry::getEnd)), request.getScaleTimestamp(), requestTag.getRequestId()), responseObserver);
    }

    public void checkScale(Controller.ScaleStatusRequest request, StreamObserver<Controller.ScaleStatusResponse> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"checkScale", request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), Integer.toString(request.getEpoch())});
        log.debug(requestTag.getRequestId(), "check scale status called for stream {}/{}.", new Object[]{request.getStreamInfo().getScope(), request.getStreamInfo().getStream()});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(request.getStreamInfo().getScope(), request.getStreamInfo().getStream()), AuthHandler.Permissions.READ), delegationToken -> this.controllerService.checkScale(request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), request.getEpoch(), requestTag.getRequestId()), responseObserver);
    }

    public void getURI(Controller.SegmentId request, StreamObserver<Controller.NodeUri> responseObserver) {
        String segment = NameUtils.getQualifiedStreamSegmentName((String)request.getStreamInfo().getScope(), (String)request.getStreamInfo().getStream(), (long)request.getSegmentId());
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"getURI", segment});
        log.info(requestTag.getRequestId(), "getURI called for segment {}.", new Object[]{segment});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(StreamAuthParams.toResourceString(request.getStreamInfo().getScope(), request.getStreamInfo().getStream()), AuthHandler.Permissions.READ), delegationToken -> this.controllerService.getURI(request), responseObserver);
    }

    public void isSegmentValid(Controller.SegmentId request, StreamObserver<Controller.SegmentValidityResponse> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"isSegmentOpen", request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), Long.toString(request.getSegmentId())});
        log.info(requestTag.getRequestId(), "isSegmentValid called for segment {}/{}/{}.", new Object[]{request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), request.getSegmentId()});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(request.getStreamInfo().getScope(), request.getStreamInfo().getStream()), AuthHandler.Permissions.READ), delegationToken -> this.controllerService.isSegmentValid(request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), request.getSegmentId(), requestTag.getRequestId()).thenApply(bRes -> Controller.SegmentValidityResponse.newBuilder().setResponse(bRes.booleanValue()).build()), responseObserver);
    }

    public void isStreamCutValid(Controller.StreamCut request, StreamObserver<Controller.StreamCutValidityResponse> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"isStreamCutValid", request.getStreamInfo().getScope(), request.getStreamInfo().getStream()});
        log.info(requestTag.getRequestId(), "isStreamCutValid called for stream {}/{} streamcut {}.", new Object[]{request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), request.getCutMap()});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorizationAndCreateToken(this.authorizationResource.ofStreamInScope(request.getStreamInfo().getScope(), request.getStreamInfo().getStream()), AuthHandler.Permissions.READ), delegationToken -> this.controllerService.isStreamCutValid(request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), request.getCutMap(), requestTag.getRequestId()).thenApply(bRes -> Controller.StreamCutValidityResponse.newBuilder().setResponse(bRes.booleanValue()).build()), responseObserver);
    }

    public void createTransaction(Controller.CreateTxnRequest request, StreamObserver<Controller.CreateTxnResponse> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"createTransaction", request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), Long.toString(request.getLease())});
        log.info(requestTag.getRequestId(), "createTransaction called for stream {}/{}.", new Object[]{request.getStreamInfo().getScope(), request.getStreamInfo().getStream()});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorizationAndCreateToken(this.authorizationResource.ofStreamInScope(request.getStreamInfo().getScope(), request.getStreamInfo().getStream()), AuthHandler.Permissions.READ_UPDATE), delegationToken -> this.controllerService.createTransaction(request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), request.getLease(), requestTag.getRequestId()).thenApply(pair -> Controller.CreateTxnResponse.newBuilder().setDelegationToken(delegationToken).setTxnId(ModelHelper.decode((UUID)((UUID)pair.getKey()))).addAllActiveSegments((Iterable)pair.getValue()).build()), responseObserver, requestTag);
    }

    public void commitTransaction(Controller.TxnRequest request, StreamObserver<Controller.TxnStatus> responseObserver) {
        UUID txnId = ModelHelper.encode((Controller.TxnId)request.getTxnId());
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"commitTransaction", request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), txnId.toString()});
        log.info(requestTag.getRequestId(), "commitTransaction called for stream {}/{}, txnId={}.", new Object[]{request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), txnId});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(request.getStreamInfo().getScope(), request.getStreamInfo().getStream()), AuthHandler.Permissions.READ_UPDATE), delegationToken -> this.controllerService.commitTransaction(request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), txnId, request.getWriterId(), request.getTimestamp(), requestTag.getRequestId()), responseObserver);
    }

    public void abortTransaction(Controller.TxnRequest request, StreamObserver<Controller.TxnStatus> responseObserver) {
        UUID txnId = ModelHelper.encode((Controller.TxnId)request.getTxnId());
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"abortTransaction", request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), txnId.toString()});
        log.info(requestTag.getRequestId(), "abortTransaction called for stream {}/{}, txnId={}.", new Object[]{request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), txnId});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(request.getStreamInfo().getScope(), request.getStreamInfo().getStream()), AuthHandler.Permissions.READ_UPDATE), delegationToken -> this.controllerService.abortTransaction(request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), txnId, requestTag.getRequestId()), responseObserver);
    }

    public void pingTransaction(Controller.PingTxnRequest request, StreamObserver<Controller.PingTxnStatus> responseObserver) {
        UUID txnId = ModelHelper.encode((Controller.TxnId)request.getTxnId());
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"pingTransaction", request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), txnId.toString()});
        log.info(requestTag.getRequestId(), "pingTransaction called for stream {}/{}, txnId={}", new Object[]{request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), txnId});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(request.getStreamInfo().getScope(), request.getStreamInfo().getStream()), AuthHandler.Permissions.READ_UPDATE), delegationToken -> this.controllerService.pingTransaction(request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), txnId, request.getLease(), requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void checkTransactionState(Controller.TxnRequest request, StreamObserver<Controller.TxnState> responseObserver) {
        UUID txnId = ModelHelper.encode((Controller.TxnId)request.getTxnId());
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"checkTransactionState", request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), txnId.toString()});
        log.info(requestTag.getRequestId(), "checkTransactionState called for stream {}/{}, txnId={}.", new Object[]{request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), txnId});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(request.getStreamInfo().getScope(), request.getStreamInfo().getStream()), AuthHandler.Permissions.READ), delegationToken -> this.controllerService.checkTransactionStatus(request.getStreamInfo().getScope(), request.getStreamInfo().getStream(), txnId, requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void createScope(Controller.ScopeInfo request, StreamObserver<Controller.CreateScopeStatus> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"createScope", request.getScope()});
        log.info(requestTag.getRequestId(), "createScope called for scope {}.", new Object[]{request.getScope()});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofScopes(), AuthHandler.Permissions.READ_UPDATE), delegationToken -> this.controllerService.createScope(request.getScope(), requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void listScopes(Controller.ScopesRequest request, StreamObserver<Controller.ScopesResponse> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"listScopes"});
        log.info(requestTag.getRequestId(), "listScope called.", new Object[0]);
        AuthContext ctx = this.grpcAuthHelper.isAuthEnabled() ? AuthContext.current() : null;
        Supplier<String> stringSupplier = () -> {
            String result = this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofScopes(), AuthHandler.Permissions.READ, ctx);
            log.debug("Result of authorization for [{}] and READ permission is: [{}]", (Object)this.authorizationResource.ofScopes(), (Object)result);
            return result;
        };
        Function scopesFn = delegationToken -> this.listWithFilter(request.getContinuationToken().getToken(), this.pageLimit, (x, y) -> this.controllerService.listScopes((String)x, (int)y, requestTag.getRequestId()), x -> this.grpcAuthHelper.isAuthorized(this.authorizationResource.ofScope(x), AuthHandler.Permissions.READ, ctx), x -> x, requestTag.getRequestId()).thenApply(response -> Controller.ScopesResponse.newBuilder().addAllScopes((Iterable)response.getKey()).setContinuationToken(Controller.ContinuationToken.newBuilder().setToken((String)response.getValue()).build()).build());
        this.authenticateExecuteAndProcessResults(stringSupplier, scopesFn, responseObserver, requestTag);
    }

    public void checkScopeExists(Controller.ScopeInfo request, StreamObserver<Controller.ExistsResponse> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"checkScopeExists", request.getScope()});
        String scope = request.getScope();
        log.info(requestTag.getRequestId(), "checkScopeExists called for scope {}.", new Object[]{request});
        AuthContext ctx = this.grpcAuthHelper.isAuthEnabled() ? AuthContext.current() : null;
        Supplier<String> stringSupplier = () -> {
            String result = this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofScope(scope), AuthHandler.Permissions.READ, ctx);
            log.debug("Result of authorization for [{}] and READ permission is: [{}]", (Object)this.authorizationResource.ofScopes(), (Object)result);
            return result;
        };
        Function scopeFn = delegationToken -> this.controllerService.getScope(scope, requestTag.getRequestId()).handle((response, e) -> {
            boolean exists;
            if (e != null) {
                if (!(Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException)) throw new CompletionException((Throwable)e);
                exists = false;
                return Controller.ExistsResponse.newBuilder().setExists(exists).build();
            } else {
                exists = true;
            }
            return Controller.ExistsResponse.newBuilder().setExists(exists).build();
        });
        this.authenticateExecuteAndProcessResults(stringSupplier, scopeFn, responseObserver, requestTag);
    }

    public void checkStreamExists(Controller.StreamInfo request, StreamObserver<Controller.ExistsResponse> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"checkStreamExists"});
        String scope = request.getScope();
        String stream = request.getStream();
        log.info(requestTag.getRequestId(), "checkStream exists called for {}/{}.", new Object[]{scope, stream});
        AuthContext ctx = this.grpcAuthHelper.isAuthEnabled() ? AuthContext.current() : null;
        Supplier<String> stringSupplier = () -> {
            String result = this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(scope, stream), AuthHandler.Permissions.READ, ctx);
            log.debug("Result of authorization for [{}] and READ permission is: [{}]", (Object)this.authorizationResource.ofScopes(), (Object)result);
            return result;
        };
        Function streamFn = delegationToken -> this.controllerService.getStream(scope, stream, requestTag.getRequestId()).handle((response, e) -> {
            boolean exists;
            if (e != null) {
                if (!(Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException)) throw new CompletionException((Throwable)e);
                exists = false;
                return Controller.ExistsResponse.newBuilder().setExists(exists).build();
            } else {
                exists = true;
            }
            return Controller.ExistsResponse.newBuilder().setExists(exists).build();
        });
        this.authenticateExecuteAndProcessResults(stringSupplier, streamFn, responseObserver, requestTag);
    }

    public void getStreamConfiguration(Controller.StreamInfo request, StreamObserver<Controller.StreamConfig> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"getStreamConfiguration"});
        String scope = request.getScope();
        String stream = request.getStream();
        log.info(requestTag.getRequestId(), "{} called for {}/{}.", new Object[]{"getStreamConfiguration", scope, stream});
        AuthContext ctx = this.grpcAuthHelper.isAuthEnabled() ? AuthContext.current() : null;
        Supplier<String> stringSupplier = () -> {
            String result = this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(scope, stream), AuthHandler.Permissions.READ, ctx);
            log.debug("Result of authorization for [{}] and READ permission is: [{}]", (Object)this.authorizationResource.ofScopes(), (Object)result);
            return result;
        };
        Function streamFn = delegationToken -> this.controllerService.getStream(scope, stream, requestTag.getRequestId()).handle((response, e) -> {
            if (e != null) {
                throw new CompletionException((Throwable)e);
            }
            return ModelHelper.decode((String)scope, (String)stream, (StreamConfiguration)response);
        });
        this.authenticateExecuteAndProcessResults(stringSupplier, streamFn, responseObserver, requestTag);
    }

    public void listStreamsInScope(Controller.StreamsInScopeRequest request, StreamObserver<Controller.StreamsInScopeResponse> responseObserver) {
        String scopeName = request.getScope().getScope();
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"listStreamsInScope", scopeName});
        log.info(requestTag.getRequestId(), "listStream called for scope {}.", new Object[]{scopeName});
        AuthContext ctx = this.grpcAuthHelper.isAuthEnabled() ? AuthContext.current() : null;
        Function streamsFn = delegationToken -> this.listWithFilter(request.getContinuationToken().getToken(), this.pageLimit, (x, y) -> this.controllerService.listStreams(scopeName, (String)x, (int)y, requestTag.getRequestId()), x -> this.grpcAuthHelper.isAuthorized(this.authorizationResource.ofStreamInScope(scopeName, x), AuthHandler.Permissions.READ, ctx), x -> Controller.StreamInfo.newBuilder().setScope(scopeName).setStream(x).build(), requestTag.getRequestId()).handle((response, ex) -> {
            if (ex != null) {
                if (Exceptions.unwrap((Throwable)ex) instanceof StoreException.DataNotFoundException) {
                    return Controller.StreamsInScopeResponse.newBuilder().setStatus(Controller.StreamsInScopeResponse.Status.SCOPE_NOT_FOUND).build();
                }
                throw new CompletionException((Throwable)ex);
            }
            return Controller.StreamsInScopeResponse.newBuilder().addAllStreams((Iterable)response.getKey()).setContinuationToken(Controller.ContinuationToken.newBuilder().setToken((String)response.getValue()).build()).setStatus(Controller.StreamsInScopeResponse.Status.SUCCESS).build();
        });
        this.authenticateExecuteAndProcessResults(() -> {
            String result = this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofScope(scopeName), AuthHandler.Permissions.READ, ctx);
            log.debug("Result of authorization for [{}] and READ permission is: [{}]", (Object)this.authorizationResource.ofScope(scopeName), (Object)result);
            return result;
        }, streamsFn, responseObserver, requestTag);
    }

    public void listStreamsInScopeForTag(Controller.StreamsInScopeWithTagRequest request, StreamObserver<Controller.StreamsInScopeResponse> responseObserver) {
        String scopeName = request.getScope().getScope();
        String tag = request.getTag();
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"listStreamsInScopeForTag", scopeName});
        log.info(requestTag.getRequestId(), "{} called for scope {} and tags {}", new Object[]{"listStreamsInScopeForTag", scopeName, tag});
        AuthContext ctx = this.grpcAuthHelper.isAuthEnabled() ? AuthContext.current() : null;
        Function streamsFn = delegationToken -> this.listWithFilter(request.getContinuationToken().getToken(), this.pageLimit, (x, y) -> this.controllerService.listStreamsForTag(scopeName, tag, (String)x, requestTag.getRequestId()), x -> this.grpcAuthHelper.isAuthorized(this.authorizationResource.ofStreamInScope(scopeName, x), AuthHandler.Permissions.READ, ctx), x -> Controller.StreamInfo.newBuilder().setScope(scopeName).setStream(x).build(), requestTag.getRequestId()).handle((response, ex) -> {
            if (ex != null) {
                if (Exceptions.unwrap((Throwable)ex) instanceof StoreException.DataNotFoundException) {
                    return Controller.StreamsInScopeResponse.newBuilder().setStatus(Controller.StreamsInScopeResponse.Status.SCOPE_NOT_FOUND).build();
                }
                throw new CompletionException((Throwable)ex);
            }
            return Controller.StreamsInScopeResponse.newBuilder().addAllStreams((Iterable)response.getKey()).setContinuationToken(Controller.ContinuationToken.newBuilder().setToken((String)response.getValue()).build()).setStatus(Controller.StreamsInScopeResponse.Status.SUCCESS).build();
        });
        this.authenticateExecuteAndProcessResults(() -> {
            String result = this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofScope(scopeName), AuthHandler.Permissions.READ, ctx);
            log.debug("Result of authorization for [{}] and READ permission is: [{}]", (Object)this.authorizationResource.ofScope(scopeName), (Object)result);
            return result;
        }, streamsFn, responseObserver, requestTag);
    }

    public void deleteScope(Controller.ScopeInfo request, StreamObserver<Controller.DeleteScopeStatus> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"deleteScope", request.getScope()});
        log.info(requestTag.getRequestId(), "deleteScope called for scope {}.", new Object[]{request.getScope()});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofScopes(), AuthHandler.Permissions.READ_UPDATE), delegationToken -> this.controllerService.deleteScope(request.getScope(), requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void getDelegationToken(Controller.StreamInfo request, StreamObserver<Controller.DelegationToken> responseObserver) {
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"getOrRefreshDelegationTokenFor", request.getScope(), request.getStream()});
        log.info(requestTag.getRequestId(), "getDelegationToken called for stream {}/{}.", new Object[]{request.getScope(), request.getStream()});
        this.authenticateExecuteAndProcessResults(this.delegationTokenSupplier(request), delegationToken -> {
            this.logIfEmpty((String)delegationToken, "getDelegationToken", request.getScope(), request.getStream());
            return CompletableFuture.completedFuture(Controller.DelegationToken.newBuilder().setDelegationToken(delegationToken).build());
        }, responseObserver);
    }

    public void noteTimestampFromWriter(Controller.TimestampFromWriter request, StreamObserver<Controller.TimestampResponse> responseObserver) {
        Controller.StreamInfo streamInfo = request.getPosition().getStreamInfo();
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"noteTimestampFromWriter", streamInfo.getScope(), streamInfo.getStream(), request.getWriter()});
        log.info(requestTag.getRequestId(), "noteWriterMark called for stream {}/{}, writer={} time={}", new Object[]{streamInfo.getScope(), streamInfo.getStream(), request.getWriter(), request.getTimestamp()});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(streamInfo.getScope(), streamInfo.getStream()), AuthHandler.Permissions.READ_UPDATE), delegationToken -> this.controllerService.noteTimestampFromWriter(streamInfo.getScope(), streamInfo.getStream(), request.getWriter(), request.getTimestamp(), request.getPosition().getCutMap(), requestTag.getRequestId()), responseObserver, requestTag);
    }

    public void removeWriter(Controller.RemoveWriterRequest request, StreamObserver<Controller.RemoveWriterResponse> responseObserver) {
        Controller.StreamInfo streamInfo = request.getStream();
        RequestTag requestTag = this.requestTracker.initializeAndTrackRequestTag(this.requestIdGenerator.nextLong(), new String[]{"removeWriter", streamInfo.getScope(), streamInfo.getStream(), request.getWriter()});
        log.info(requestTag.getRequestId(), "writerShutdown called for stream {}/{}, writer={}", new Object[]{streamInfo.getScope(), streamInfo.getStream(), request.getWriter()});
        this.authenticateExecuteAndProcessResults(() -> this.grpcAuthHelper.checkAuthorization(this.authorizationResource.ofStreamInScope(streamInfo.getScope(), streamInfo.getStream()), AuthHandler.Permissions.READ_UPDATE), delegationToken -> this.controllerService.removeWriter(streamInfo.getScope(), streamInfo.getStream(), request.getWriter(), requestTag.getRequestId()), responseObserver, requestTag);
    }

    private void logIfEmpty(String delegationToken, String requestName, String scopeName, String name) {
        if (this.isAuthEnabled() && Strings.isNullOrEmpty((String)delegationToken)) {
            log.warn("Delegation token for request [{}] for artifact [{}]/[{}], is: [{}]", new Object[]{requestName, scopeName, name, delegationToken});
        }
    }

    private <T> void authenticateExecuteAndProcessResults(Supplier<String> authenticator, Function<String, CompletableFuture<T>> call, StreamObserver<T> streamObserver, RequestTag requestTag) {
        try {
            String delegationToken = authenticator.get();
            CompletableFuture<T> result = call.apply(delegationToken);
            result.whenComplete((value, ex) -> {
                log.debug("result =  {}", value);
                if (ex != null) {
                    Throwable cause = Exceptions.unwrap((Throwable)ex);
                    this.logError(requestTag, cause);
                    String stackTrace = "controllerStackTrace=" + Throwables.getStackTraceAsString((Throwable)ex);
                    Object errorDescription = this.replyWithStackTraceOnError ? stackTrace : cause.getMessage();
                    streamObserver.onError((Throwable)this.getStatusFromException(cause).withCause(cause).withDescription((String)errorDescription).asRuntimeException());
                } else if (value != null) {
                    streamObserver.onNext(value);
                    streamObserver.onCompleted();
                }
                this.logAndUntrackRequestTag(requestTag);
            });
        }
        catch (AuthenticationException e) {
            this.handleException((Exception)((Object)e), streamObserver, requestTag, Status.UNAUTHENTICATED, "Authentication failed");
        }
        catch (AuthorizationException e) {
            this.handleException((Exception)((Object)e), streamObserver, requestTag, Status.PERMISSION_DENIED, "Authorization failed");
        }
        catch (Exception e) {
            this.handleException(e, streamObserver, requestTag, Status.INTERNAL, "Internal exception occurred");
        }
    }

    private <T> void authenticateExecuteAndProcessResults(Supplier<String> authenticator, Function<String, CompletableFuture<T>> call, StreamObserver<T> streamObserver) {
        this.authenticateExecuteAndProcessResults(authenticator, call, streamObserver, null);
    }

    private void handleException(Exception e, StreamObserver<?> streamObserver, RequestTag requestTag, Status status, String message) {
        log.error("Encountered {} in authenticateExecuteAndProcessResults", (Object)e.getClass().getSimpleName(), (Object)e);
        this.logAndUntrackRequestTag(requestTag);
        streamObserver.onError((Throwable)status.withDescription(message).asRuntimeException());
    }

    private Status getStatusFromException(Throwable cause) {
        if (cause instanceof StoreException.DataExistsException) {
            return Status.ALREADY_EXISTS;
        }
        if (cause instanceof StoreException.DataNotFoundException) {
            return Status.NOT_FOUND;
        }
        if (cause instanceof StoreException.DataNotEmptyException) {
            return Status.FAILED_PRECONDITION;
        }
        if (cause instanceof StoreException.WriteConflictException) {
            return Status.FAILED_PRECONDITION;
        }
        if (cause instanceof StoreException.IllegalStateException) {
            return Status.INTERNAL;
        }
        if (cause instanceof StoreException.OperationNotAllowedException) {
            return Status.PERMISSION_DENIED;
        }
        if (cause instanceof StoreException.StoreConnectionException) {
            return Status.INTERNAL;
        }
        if (cause instanceof TimeoutException) {
            return Status.DEADLINE_EXCEEDED;
        }
        return Status.UNKNOWN;
    }

    private void logAndUntrackRequestTag(RequestTag requestTag) {
        if (requestTag != null) {
            log.debug(this.requestTracker.untrackRequest(requestTag.getRequestDescriptor()), "Untracking request: {}.", new Object[]{requestTag.getRequestDescriptor()});
        }
    }

    private void logError(RequestTag requestTag, Throwable cause) {
        long requestId;
        String tag = requestTag == null ? "none" : requestTag.getRequestDescriptor();
        long l = requestId = requestTag == null ? 0L : requestTag.getRequestId();
        if (cause instanceof LockFailedException) {
            log.warn(requestId, "Controller API call with tag {} failed with: {}", new Object[]{tag, cause.getMessage()});
        } else {
            log.error(requestId, "Controller API call with tag {} failed with error: ", new Object[]{tag, cause});
        }
    }

    private <T> CompletableFuture<Pair<List<T>, String>> listWithFilter(String continuationToken, int limit, BiFunction<String, Integer, CompletableFuture<Pair<List<String>, String>>> fetcher, Predicate<String> filter, Function<String, T> tCreator, long requestId) {
        ArrayList results = new ArrayList();
        return fetcher.apply(continuationToken, limit).thenCompose(response -> {
            log.debug(requestId, "All entries with continuation token: {}", new Object[]{response});
            boolean filtered = false;
            for (String key : (List)response.getKey()) {
                if (filter.test(key)) {
                    results.add(tCreator.apply(key));
                    continue;
                }
                filtered = true;
            }
            if (filtered) {
                return this.listWithFilter((String)response.getValue(), limit - results.size(), fetcher, filter, tCreator, requestId).thenApply(result -> {
                    results.addAll((Collection)result.getKey());
                    return new ImmutablePair((Object)results, (Object)((String)result.getValue()));
                });
            }
            return CompletableFuture.completedFuture(new ImmutablePair((Object)results, (Object)((String)response.getValue())));
        });
    }

    private boolean isAuthEnabled() {
        return this.grpcAuthHelper.isAuthEnabled();
    }

    @ConstructorProperties(value={"controllerService", "grpcAuthHelper", "requestTracker", "replyWithStackTraceOnError", "isRGStreamWritesWithReadPermEnabled", "pageLimit"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ControllerServiceImpl(ControllerService controllerService, GrpcAuthHelper grpcAuthHelper, RequestTracker requestTracker, boolean replyWithStackTraceOnError, boolean isRGStreamWritesWithReadPermEnabled, int pageLimit) {
        this.controllerService = controllerService;
        this.grpcAuthHelper = grpcAuthHelper;
        this.requestTracker = requestTracker;
        this.replyWithStackTraceOnError = replyWithStackTraceOnError;
        this.isRGStreamWritesWithReadPermEnabled = isRGStreamWritesWithReadPermEnabled;
        this.pageLimit = pageLimit;
    }
}

