/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.security.auth;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.pravega.auth.AuthHandler;
import io.pravega.auth.AuthenticationException;
import io.pravega.auth.AuthorizationException;
import io.pravega.controller.server.security.auth.handler.AuthContext;
import io.pravega.controller.server.security.auth.handler.AuthInterceptor;
import io.pravega.shared.security.token.JsonWebToken;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcAuthHelper {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrpcAuthHelper.class);
    private final boolean isAuthEnabled;
    private final String tokenSigningKey;
    private final Integer accessTokenTTLInSeconds;

    @VisibleForTesting
    public static GrpcAuthHelper getDisabledAuthHelper() {
        return new GrpcAuthHelper(false, "", -1);
    }

    public boolean isAuthorized(String resource, AuthHandler.Permissions permission, AuthContext authContext) {
        if (this.isAuthEnabled) {
            AuthHandler.Permissions allowedLevel;
            if (authContext == null || authContext.getAuthHandler() == null) {
                log.warn("Auth is enabled but 'authContext'  is null. Defaulting to no permissions.");
                allowedLevel = AuthHandler.Permissions.NONE;
            } else {
                allowedLevel = authContext.getAuthHandler().authorize(resource, authContext.getPrincipal());
            }
            return allowedLevel.ordinal() >= permission.ordinal();
        }
        log.debug("Since auth is disabled, returning [true]");
        return true;
    }

    public String checkAuthorization(String resource, AuthHandler.Permissions expectedLevel, AuthContext ctx) {
        if (this.isAuthorized(resource, expectedLevel, ctx)) {
            log.trace("Successfully authorized principal {} for {} access to resource {}", new Object[]{ctx == null ? null : ctx.getPrincipal(), expectedLevel, resource});
            return "";
        }
        if (ctx == null || ctx.getPrincipal() == null) {
            throw new AuthenticationException("Couldn't extract Principal");
        }
        String message = String.format("Principal [%s] not allowed [%s] access for resource [%s]", ctx.getPrincipal(), expectedLevel, resource);
        throw new AuthorizationException(message);
    }

    public String checkAuthorization(String resource, AuthHandler.Permissions expectedLevel) {
        return this.checkAuthorization(resource, expectedLevel, AuthContext.current());
    }

    public String checkAuthorizationAndCreateToken(String resource, AuthHandler.Permissions expectedLevel) {
        if (this.isAuthEnabled) {
            try {
                this.checkAuthorization(resource, expectedLevel);
            }
            catch (RuntimeException e) {
                log.warn("Authorization failed", (Throwable)e);
                throw e;
            }
            return this.createDelegationToken(resource, expectedLevel, this.tokenSigningKey);
        }
        return "";
    }

    public String createDelegationToken(String resource, AuthHandler.Permissions expectedLevel) {
        return this.createDelegationToken(resource, expectedLevel, this.tokenSigningKey);
    }

    private String createDelegationToken(String resource, AuthHandler.Permissions expectedLevel, String tokenSigningKey) {
        if (this.isAuthEnabled) {
            HashMap<String, String> claims = new HashMap<String, String>();
            claims.put(resource, String.valueOf(expectedLevel));
            return new JsonWebToken("segmentstoreresource", "segmentstore", tokenSigningKey.getBytes(), claims, this.accessTokenTTLInSeconds).toCompactString();
        }
        return "";
    }

    public String retrieveMasterToken() {
        if (this.isAuthEnabled) {
            return GrpcAuthHelper.retrieveMasterToken(this.tokenSigningKey);
        }
        return "";
    }

    public static String retrieveMasterToken(String tokenSigningKey) {
        HashMap<String, String> customClaims = new HashMap<String, String>();
        customClaims.put("*", String.valueOf(AuthHandler.Permissions.READ_UPDATE));
        return new JsonWebToken("segmentstoreresource", "segmentstore", tokenSigningKey.getBytes(), customClaims, null).toCompactString();
    }

    public static void registerInterceptors(Map<String, AuthHandler> handlers, ServerBuilder<?> builder) {
        for (Map.Entry<String, AuthHandler> handler : handlers.entrySet()) {
            builder.intercept((ServerInterceptor)new AuthInterceptor(handler.getValue()));
        }
    }

    @ConstructorProperties(value={"isAuthEnabled", "tokenSigningKey", "accessTokenTTLInSeconds"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GrpcAuthHelper(boolean isAuthEnabled, String tokenSigningKey, Integer accessTokenTTLInSeconds) {
        this.isAuthEnabled = isAuthEnabled;
        this.tokenSigningKey = tokenSigningKey;
        this.accessTokenTTLInSeconds = accessTokenTTLInSeconds;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAuthEnabled() {
        return this.isAuthEnabled;
    }
}

