/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.security.auth;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.auth.AuthHandler;
import io.pravega.shared.NameUtils;
import io.pravega.shared.security.auth.AccessOperation;
import io.pravega.shared.security.auth.AuthorizationResource;
import io.pravega.shared.security.auth.AuthorizationResourceImpl;
import io.pravega.shared.security.auth.PermissionsHelper;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamAuthParams {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamAuthParams.class);
    private static final AuthorizationResource AUTH_RESOURCE = new AuthorizationResourceImpl();
    private final String scope;
    private final String stream;
    private final AccessOperation accessOperation;
    private final boolean isRGWritesWithReadPermEnabled;
    private final boolean isMarkStream;
    @VisibleForTesting
    private final boolean isInternalStream;

    @VisibleForTesting
    StreamAuthParams(@NonNull String scope, @NonNull String stream) {
        this(scope, stream, AccessOperation.READ, true);
        if (scope == null) {
            throw new NullPointerException("scope is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
    }

    public StreamAuthParams(@NonNull String scope, @NonNull String stream, boolean isRGWritesWithReadPermEnabled) {
        this(scope, stream, AccessOperation.UNSPECIFIED, isRGWritesWithReadPermEnabled);
        if (scope == null) {
            throw new NullPointerException("scope is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
    }

    public StreamAuthParams(@NonNull String scope, @NonNull String stream, @NonNull AccessOperation accessOperation, boolean isRGWritesWithReadPermEnabled) {
        if (scope == null) {
            throw new NullPointerException("scope is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (accessOperation == null) {
            throw new NullPointerException("accessOperation is marked non-null but is null");
        }
        this.scope = scope;
        this.stream = stream;
        this.isRGWritesWithReadPermEnabled = isRGWritesWithReadPermEnabled;
        this.accessOperation = accessOperation;
        this.isInternalStream = stream.startsWith("_");
        this.isMarkStream = stream.startsWith(NameUtils.getMARK_PREFIX());
    }

    public AuthHandler.Permissions requestedPermission() {
        return PermissionsHelper.parse((AccessOperation)this.accessOperation, (AuthHandler.Permissions)AuthHandler.Permissions.READ);
    }

    public AuthHandler.Permissions requiredPermissionForWrites() {
        if (this.isStreamUserDefined()) {
            return AuthHandler.Permissions.READ_UPDATE;
        }
        if (this.isRGWritesWithReadPermEnabled && this.stream.startsWith("_RG")) {
            return AuthHandler.Permissions.READ;
        }
        if (this.isMarkStream()) {
            return AuthHandler.Permissions.READ;
        }
        return AuthHandler.Permissions.READ_UPDATE;
    }

    public String resourceString() {
        return StreamAuthParams.toResourceString(this.scope, this.stream);
    }

    public boolean isAccessOperationUnspecified() {
        return this.accessOperation.equals((Object)AccessOperation.UNSPECIFIED);
    }

    public String streamResourceString() {
        return AUTH_RESOURCE.ofStreamInScope(this.scope, this.stream);
    }

    private static String toResourceString(String scope, String stream, boolean isStreamInternal) {
        return isStreamInternal ? AUTH_RESOURCE.ofInternalStream(scope, stream) : AUTH_RESOURCE.ofStreamInScope(scope, stream);
    }

    public static String toResourceString(String scope, String stream) {
        return StreamAuthParams.toResourceString(scope, stream, stream.startsWith("_"));
    }

    public boolean isStreamUserDefined() {
        return !this.isInternalStream;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScope() {
        return this.scope;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getStream() {
        return this.stream;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isMarkStream() {
        return this.isMarkStream;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isInternalStream() {
        return this.isInternalStream;
    }
}

