/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.security.auth.handler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.auth.AuthHandler;
import io.pravega.controller.server.security.auth.handler.AuthInterceptor;
import java.security.Principal;
import lombok.Generated;

public class AuthContext {
    private final Principal principal;
    private final AuthHandler authHandler;

    private AuthContext(Principal principal, AuthHandler authHandler) {
        this.principal = principal;
        this.authHandler = authHandler;
    }

    public static AuthContext current() {
        Principal principal = (Principal)AuthInterceptor.PRINCIPAL_OBJECT_KEY.get();
        AuthInterceptor serverAuthInterceptor = (AuthInterceptor)AuthInterceptor.AUTH_INTERCEPTOR_OBJECT_KEY.get();
        AuthHandler authHandler = null;
        if (serverAuthInterceptor != null) {
            authHandler = serverAuthInterceptor.getHandler();
        }
        return new AuthContext(principal, authHandler);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Principal getPrincipal() {
        return this.principal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AuthHandler getAuthHandler() {
        return this.authHandler;
    }
}

