/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.store.Scope;
import io.pravega.controller.store.kvtable.InMemoryKVTable;
import io.pravega.controller.store.kvtable.KeyValueTable;
import io.pravega.controller.store.stream.InMemoryReaderGroup;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.StoreException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class InMemoryScope
implements Scope {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    private final String scopeName;
    @GuardedBy(value="$lock")
    private TreeMap<Integer, String> sortedStreamsInScope;
    private HashMap<String, Integer> streamsPositionMap;
    @GuardedBy(value="$lock")
    private final TreeMap<String, InMemoryKVTable> kvTablesMap = new TreeMap();
    @GuardedBy(value="$lock")
    private final TreeMap<String, InMemoryReaderGroup> readerGroupsMap = new TreeMap();

    public InMemoryScope(String scopeName) {
        this.scopeName = scopeName;
    }

    @Override
    public String getName() {
        return this.scopeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> createScope(OperationContext context) {
        Object object = this.$lock;
        synchronized (object) {
            this.sortedStreamsInScope = new TreeMap(Integer::compare);
            this.streamsPositionMap = new HashMap();
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> deleteScope(OperationContext context) {
        Object object = this.$lock;
        synchronized (object) {
            this.sortedStreamsInScope.clear();
            this.sortedStreamsInScope = null;
            this.streamsPositionMap.clear();
            this.streamsPositionMap = null;
            this.kvTablesMap.clear();
            this.readerGroupsMap.clear();
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> addStreamToScope(String stream, OperationContext context) {
        Object object = this.$lock;
        synchronized (object) {
            int next = this.streamsPositionMap.size();
            this.streamsPositionMap.putIfAbsent(stream, next);
            Integer position = this.streamsPositionMap.get(stream);
            this.sortedStreamsInScope.put(position, stream);
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> removeStreamFromScope(String stream, OperationContext context) {
        Object object = this.$lock;
        synchronized (object) {
            Integer position = this.streamsPositionMap.get(stream);
            if (position != null) {
                this.sortedStreamsInScope.remove(position);
                this.streamsPositionMap.remove(stream);
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<List<String>> listStreamsInScope(OperationContext context) {
        Object object = this.$lock;
        synchronized (object) {
            return CompletableFuture.completedFuture(Lists.newArrayList(this.sortedStreamsInScope.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Pair<List<String>, String>> listStreams(int limit, String continuationToken, Executor executor, OperationContext context) {
        Object object = this.$lock;
        synchronized (object) {
            String newContinuationToken;
            List limited;
            InMemoryScope inMemoryScope = this;
            synchronized (inMemoryScope) {
                if (this.sortedStreamsInScope == null) {
                    return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, "scope not found"));
                }
                if (Strings.isNullOrEmpty((String)continuationToken)) {
                    limited = this.sortedStreamsInScope.entrySet().stream().limit(limit).collect(Collectors.toList());
                } else {
                    int lastPos = Strings.isNullOrEmpty((String)continuationToken) ? 0 : Integer.parseInt(continuationToken);
                    limited = this.sortedStreamsInScope.tailMap(lastPos, false).entrySet().stream().limit(limit).collect(Collectors.toList());
                }
                newContinuationToken = limited.isEmpty() ? continuationToken : ((Integer)((Map.Entry)limited.get(limited.size() - 1)).getKey()).toString();
            }
            List result = limited.stream().map(Map.Entry::getValue).collect(Collectors.toList());
            return CompletableFuture.completedFuture(new ImmutablePair(result, (Object)newContinuationToken));
        }
    }

    @Override
    public CompletableFuture<Pair<List<String>, String>> listStreamsForTag(String tag, String continuationToken, Executor executor, OperationContext context) {
        return Futures.failedFuture((Throwable)new UnsupportedOperationException("Not implmemented"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> addKVTableToScope(String kvt, UUID id) {
        Object object = this.$lock;
        synchronized (object) {
            this.kvTablesMap.putIfAbsent(kvt, new InMemoryKVTable(this.scopeName, kvt, id));
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTableExists(String kvt) {
        Object object = this.$lock;
        synchronized (object) {
            return this.kvTablesMap.containsKey(kvt);
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public CompletableFuture<Pair<List<String>, String>> listKeyValueTables(int limit, String continuationToken, Executor executor, OperationContext context) {
        if (this.kvTablesMap.size() == 0) {
            return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, this.scopeName));
        }
        List sortedKVTablesList = this.kvTablesMap.keySet().stream().collect(Collectors.toList());
        int start = 0;
        if (!continuationToken.isEmpty()) {
            start = Integer.parseInt(continuationToken);
        }
        int end = start + limit >= sortedKVTablesList.size() ? sortedKVTablesList.size() : start + limit;
        List nextBatchOfTables = sortedKVTablesList.subList(start, end);
        return CompletableFuture.completedFuture(new ImmutablePair(nextBatchOfTables, (Object)String.valueOf(end)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<UUID> getReaderGroupId(String rgName, OperationContext context) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.readerGroupsMap.containsKey(rgName)) {
                return CompletableFuture.completedFuture(this.readerGroupsMap.get(rgName).getId());
            }
            return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, "reader group not found in scope."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> removeKVTableFromScope(String kvtName) {
        Object object = this.$lock;
        synchronized (object) {
            this.kvTablesMap.remove(kvtName);
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyValueTable getKeyValueTable(String name) {
        Object object = this.$lock;
        synchronized (object) {
            return this.kvTablesMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Boolean> addReaderGroupToScope(String readerGroup, UUID readerGroupId) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.readerGroupsMap.containsKey(readerGroup)) {
                return CompletableFuture.completedFuture(Boolean.FALSE);
            }
            this.readerGroupsMap.put(readerGroup, new InMemoryReaderGroup(this.scopeName, readerGroup, readerGroupId));
            return CompletableFuture.completedFuture(Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> removeReaderGroupFromScope(String readerGroup) {
        Object object = this.$lock;
        synchronized (object) {
            this.readerGroupsMap.remove(readerGroup);
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Boolean> checkReaderGroupExistsInScope(String rgName) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.readerGroupsMap.containsKey(rgName)) {
                return CompletableFuture.completedFuture(Boolean.TRUE);
            }
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
    }
}

