/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.pravega.client.tables.impl.TableSegmentEntry;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.hash.HashHelper;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.store.PravegaTablesStoreHelper;
import io.pravega.controller.store.Scope;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.PravegaTablesStreamMetadataStore;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.records.TagRecord;
import io.pravega.shared.NameUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.LoggerFactory;

public class PravegaTablesScope
implements Scope {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(PravegaTablesScope.class));
    private static final String KVTABLES_IN_SCOPE_TABLE_FORMAT = "kvTablesInScope.#.%s";
    private static final String READER_GROUPS_IN_SCOPE_TABLE_FORMAT = "readerGroupsInScope.#.%s";
    private static final String STREAMS_IN_SCOPE_TABLE_FORMAT = "streamsInScope.#.%s";
    private static final String STREAM_TAGS_IN_SCOPE = "streamTagsInScope.#.%s.#.%s";
    private static final HashHelper HASH = HashHelper.seededWith((String)"StreamTags");
    private static final int MAX_STREAM_TAG_CHUNKS = 25;
    private static final String LAST_TAG_CHUNK = ".#.24";
    private final String scopeName;
    private final PravegaTablesStoreHelper storeHelper;
    private final AtomicReference<UUID> idRef;

    public PravegaTablesScope(String scopeName, PravegaTablesStoreHelper storeHelper) {
        this.scopeName = scopeName;
        this.storeHelper = storeHelper;
        this.idRef = new AtomicReference<Object>(null);
    }

    @Override
    public String getName() {
        return this.scopeName;
    }

    @Override
    public CompletableFuture<Void> createScope(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return Futures.handleCompose(this.withCreateTableIfAbsent(() -> this.storeHelper.addNewEntry(PravegaTablesStreamMetadataStore.SCOPES_TABLE, this.scopeName, this.newId(), PravegaTablesStoreHelper.UUID_TO_BYTES_FUNCTION, context.getRequestId()), PravegaTablesStreamMetadataStore.SCOPES_TABLE, context), (r, e) -> {
            if (e == null || Exceptions.unwrap((Throwable)e) instanceof StoreException.DataExistsException) {
                return CompletableFuture.allOf(new CompletableFuture[]{this.getStreamsInScopeTableName(context).thenCompose(streamsTableName -> this.storeHelper.createTable((String)streamsTableName, context.getRequestId()).thenAccept(v -> {
                    log.debug(context.getRequestId(), "table for streams created {}", new Object[]{streamsTableName});
                    if (e != null) {
                        throw new CompletionException((Throwable)e);
                    }
                })), this.getKVTablesInScopeTableName(context).thenCompose(kvtsTableName -> this.storeHelper.createTable((String)kvtsTableName, context.getRequestId()).thenAccept(v -> {
                    log.debug(context.getRequestId(), "table for kvts created {}", new Object[]{kvtsTableName});
                    if (e != null) {
                        throw new CompletionException((Throwable)e);
                    }
                })), this.getReaderGroupsInScopeTableName(context).thenCompose(rgTableName -> this.storeHelper.createTable((String)rgTableName, context.getRequestId()).thenAccept(v -> {
                    log.debug(context.getRequestId(), "table for reader groups created {}", new Object[]{rgTableName});
                    if (e != null) {
                        throw new CompletionException((Throwable)e);
                    }
                })), ((CompletableFuture)this.getAllStreamTagsInScopeTableNames(context).thenCompose(tagTableNames -> {
                    ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
                    for (String tableName : tagTableNames) {
                        futures.add(this.storeHelper.createTable(tableName, context.getRequestId()));
                    }
                    return Futures.allOf(futures);
                })).thenAccept(v -> {
                    if (e != null) {
                        throw new CompletionException((Throwable)e);
                    }
                })});
            }
            throw new CompletionException((Throwable)e);
        });
    }

    public CompletableFuture<String> getStreamsInScopeTableName(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getStreamsInScopeTableName(true, context);
    }

    public CompletableFuture<String> getStreamsInScopeTableName(boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        if (ignoreCached) {
            this.storeHelper.invalidateCache(PravegaTablesStreamMetadataStore.SCOPES_TABLE, this.scopeName);
        }
        return this.getId(context).thenApply(id -> NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{this.scopeName, String.format(STREAMS_IN_SCOPE_TABLE_FORMAT, id.toString())}));
    }

    public CompletableFuture<String> getKVTablesInScopeTableName(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getKVTablesInScopeTableName(true, context);
    }

    public CompletableFuture<String> getKVTablesInScopeTableName(boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        if (ignoreCached) {
            this.storeHelper.invalidateCache(PravegaTablesStreamMetadataStore.SCOPES_TABLE, this.scopeName);
        }
        return this.getId(context).thenApply(id -> NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{this.scopeName, String.format(KVTABLES_IN_SCOPE_TABLE_FORMAT, id.toString())}));
    }

    public CompletableFuture<String> getAllStreamTagsInScopeTableNames(String stream, OperationContext context) {
        return this.getId(context).thenApply(id -> NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{this.scopeName, String.format(STREAM_TAGS_IN_SCOPE, id.toString(), HASH.hashToBucket(stream, 25))}));
    }

    public CompletableFuture<List<String>> getAllStreamTagsInScopeTableNames(OperationContext context) {
        return this.getId(context).thenApply(id -> IntStream.range(0, 25).boxed().map(chunkId -> NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{this.scopeName, String.format(STREAM_TAGS_IN_SCOPE, id.toString(), chunkId)})).collect(Collectors.toList()));
    }

    public CompletableFuture<String> getReaderGroupsInScopeTableName(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getReaderGroupsInScopeTableName(true, context);
    }

    public CompletableFuture<String> getReaderGroupsInScopeTableName(boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        if (ignoreCached) {
            this.storeHelper.invalidateCache(PravegaTablesStreamMetadataStore.SCOPES_TABLE, this.scopeName);
        }
        return this.getId(context).thenApply(id -> NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{this.scopeName, String.format(READER_GROUPS_IN_SCOPE_TABLE_FORMAT, id.toString())}));
    }

    CompletableFuture<UUID> getId(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        UUID id = this.idRef.get();
        if (Objects.isNull(id)) {
            return this.storeHelper.getCachedOrLoad(PravegaTablesStreamMetadataStore.SCOPES_TABLE, this.scopeName, PravegaTablesStoreHelper.BYTES_TO_UUID_FUNCTION, 0L, context.getRequestId()).thenCompose(entry -> {
                UUID uuid = (UUID)entry.getObject();
                this.idRef.compareAndSet(null, uuid);
                return this.getId(context);
            });
        }
        return CompletableFuture.completedFuture(id);
    }

    @Override
    public CompletableFuture<Void> deleteScope(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        CompletableFuture<String> streamsInScopeTableNameFuture = this.getStreamsInScopeTableName(true, context);
        CompletableFuture<String> rgsInScopeTableNameFuture = this.getReaderGroupsInScopeTableName(context);
        CompletableFuture<String> kvtsInScopeTableNameFuture = this.getKVTablesInScopeTableName(context);
        CompletableFuture<List<String>> streamTagsInScopeTableNameFuture = this.getAllStreamTagsInScopeTableNames(context);
        return ((CompletableFuture)CompletableFuture.allOf(streamsInScopeTableNameFuture, rgsInScopeTableNameFuture, kvtsInScopeTableNameFuture, streamTagsInScopeTableNameFuture).thenCompose(x -> {
            String streamsInScopeTableName = (String)streamsInScopeTableNameFuture.join();
            String kvtsInScopeTableName = (String)kvtsInScopeTableNameFuture.join();
            String rgsInScopeTableName = (String)rgsInScopeTableNameFuture.join();
            List streamTagsInScopeTableNames = (List)streamTagsInScopeTableNameFuture.join();
            List deleteTagTablesFut = streamTagsInScopeTableNames.stream().map(tableName -> this.storeHelper.deleteTable((String)tableName, false, context.getRequestId())).collect(Collectors.toList());
            return CompletableFuture.allOf(this.storeHelper.deleteTable(streamsInScopeTableName, true, context.getRequestId()), this.storeHelper.deleteTable(kvtsInScopeTableName, true, context.getRequestId()), this.storeHelper.deleteTable(rgsInScopeTableName, true, context.getRequestId()), Futures.allOf(deleteTagTablesFut)).thenAccept(v -> log.debug("tables deleted {} {} {}", new Object[]{streamsInScopeTableName, kvtsInScopeTableName, rgsInScopeTableName}));
        })).thenCompose(deleted -> this.storeHelper.removeEntry(PravegaTablesStreamMetadataStore.SCOPES_TABLE, this.scopeName, context.getRequestId()));
    }

    @Override
    public CompletableFuture<Pair<List<String>, String>> listStreams(int limit, String continuationToken, Executor executor, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getStreamsInScopeTableName(context).thenCompose(streamsInScopeTable -> this.readAll(limit, continuationToken, (String)streamsInScopeTable, context));
    }

    @Override
    public CompletableFuture<Pair<List<String>, String>> listStreamsForTag(String tag, String continuationToken, Executor executor, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getStreamsFromNextTagChunk(tag, continuationToken, context).thenCompose(pair -> {
            if (((List)pair.getLeft()).isEmpty() && !((String)pair.getRight()).endsWith(LAST_TAG_CHUNK)) {
                return this.listStreamsForTag(tag, (String)pair.getRight(), executor, context);
            }
            return CompletableFuture.completedFuture(pair);
        });
    }

    CompletableFuture<Pair<List<String>, String>> getStreamsFromNextTagChunk(String tag, String token, OperationContext context) {
        if (token.endsWith(LAST_TAG_CHUNK)) {
            return CompletableFuture.completedFuture(new ImmutablePair(Collections.emptyList(), (Object)token));
        }
        return ((CompletableFuture)this.getAllStreamTagsInScopeTableNames(context).thenApply(chunkTableList -> {
            if (token.isEmpty()) {
                return (String)chunkTableList.get(0);
            }
            return (String)chunkTableList.get(chunkTableList.indexOf(token) + 1);
        })).thenCompose(table -> this.storeHelper.expectingDataNotFound(this.storeHelper.getEntry((String)table, tag, TagRecord::fromBytes, context.getRequestId()).thenApply(ver -> new ImmutablePair(new ArrayList<String>(((TagRecord)ver.getObject()).getStreams()), table)), new ImmutablePair(Collections.emptyList(), table)));
    }

    @Override
    public CompletableFuture<List<String>> listStreamsInScope(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        ArrayList result = new ArrayList();
        return this.getStreamsInScopeTableName(context).thenCompose(tableName -> Futures.exceptionallyExpecting((CompletableFuture)this.storeHelper.getAllKeys((String)tableName, context.getRequestId()).collectRemaining(result::add).thenApply(v -> result), (Predicate)PravegaTablesStreamMetadataStore.DATA_NOT_FOUND_PREDICATE, Collections.emptyList()));
    }

    @Override
    public void refresh() {
        this.idRef.set(null);
    }

    public CompletableFuture<Void> addStreamToScope(String stream, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getStreamsInScopeTableName(context).thenCompose(tableName -> Futures.toVoid(this.withCreateTableIfAbsent(() -> this.storeHelper.addNewEntryIfAbsent((String)tableName, stream, this.newId(), PravegaTablesStoreHelper.UUID_TO_BYTES_FUNCTION, context.getRequestId()), (String)tableName, context)));
    }

    public CompletableFuture<Void> addTagsUnderScope(String stream, Set<String> tags, OperationContext context) {
        return this.getAllStreamTagsInScopeTableNames(stream, context).thenCompose(table -> Futures.allOf((Collection)((Stream)tags.stream().parallel()).map(key -> {
            log.debug(context.getRequestId(), "Adding stream {} to tag {} index on table {}", new Object[]{stream, key, table});
            return this.storeHelper.getAndUpdateEntry((String)table, (String)key, e -> this.appendStreamToEntry((String)key, stream, (TableSegmentEntry)e), e -> false, context.getRequestId());
        }).collect(Collectors.toList())));
    }

    private TableSegmentEntry appendStreamToEntry(String tag, String appendValue, TableSegmentEntry entry) {
        byte[] updatedBytes;
        byte[] array = this.storeHelper.getArray(entry.getValue());
        if (array.length == 0) {
            updatedBytes = TagRecord.builder().tagName(tag).stream(appendValue).build().toBytes();
        } else {
            TagRecord record = TagRecord.fromBytes(array);
            updatedBytes = record.toBuilder().stream(appendValue).build().toBytes();
        }
        return TableSegmentEntry.versioned((byte[])tag.getBytes(StandardCharsets.UTF_8), (byte[])updatedBytes, (long)entry.getKey().getVersion().getSegmentVersion());
    }

    public CompletableFuture<Void> removeTagsUnderScope(String stream, Set<String> tags, OperationContext context) {
        return this.getAllStreamTagsInScopeTableNames(stream, context).thenCompose(table -> Futures.allOf((Collection)((Stream)tags.stream().parallel()).map(key -> {
            log.debug(context.getRequestId(), "Removing stream {} from tag {} index on table {}", new Object[]{stream, key, table});
            return this.storeHelper.getAndUpdateEntry((String)table, (String)key, e -> this.removeStreamFromEntry((String)key, stream, (TableSegmentEntry)e), this::isEmptyTagRecord, context.getRequestId());
        }).collect(Collectors.toList())));
    }

    private TableSegmentEntry removeStreamFromEntry(String tag, String removeValue, TableSegmentEntry currentEntry) {
        byte[] array = this.storeHelper.getArray(currentEntry.getValue());
        byte[] updatedBytes = new byte[]{};
        if (array.length != 0) {
            TagRecord record = TagRecord.fromBytes(array);
            TagRecord updatedRecord = record.toBuilder().removeStream(removeValue).build();
            updatedBytes = updatedRecord.toBytes();
        }
        return TableSegmentEntry.versioned((byte[])tag.getBytes(StandardCharsets.UTF_8), (byte[])updatedBytes, (long)currentEntry.getKey().getVersion().getSegmentVersion());
    }

    private boolean isEmptyTagRecord(TableSegmentEntry entry) {
        byte[] array = this.storeHelper.getArray(entry.getValue());
        return array.length == 0 || TagRecord.fromBytes(array).getStreams().isEmpty();
    }

    public CompletableFuture<Void> removeStreamFromScope(String stream, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getStreamsInScopeTableName(context).thenCompose(tableName -> Futures.toVoid(this.storeHelper.removeEntry((String)tableName, stream, context.getRequestId())));
    }

    public CompletableFuture<Boolean> checkStreamExistsInScope(String stream, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getStreamsInScopeTableName(context).thenCompose(tableName -> this.storeHelper.expectingDataNotFound(this.storeHelper.getEntry((String)tableName, stream, x -> x, context.getRequestId()).thenApply(v -> true), false));
    }

    public CompletableFuture<Boolean> checkKeyValueTableExistsInScope(String kvt, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getKVTablesInScopeTableName(context).thenCompose(tableName -> this.storeHelper.expectingDataNotFound(this.storeHelper.getEntry((String)tableName, kvt, x -> x, context.getRequestId()).thenApply(v -> true), false));
    }

    public CompletableFuture<Boolean> checkReaderGroupExistsInScope(String readerGroupName, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getReaderGroupsInScopeTableName(context).thenCompose(tableName -> this.storeHelper.expectingDataNotFound(this.storeHelper.getEntry((String)tableName, readerGroupName, x -> x, context.getRequestId()).thenApply(v -> true), false));
    }

    public CompletableFuture<Void> addKVTableToScope(String kvt, UUID id, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getKVTablesInScopeTableName(context).thenCompose(tableName -> Futures.toVoid(this.withCreateTableIfAbsent(() -> this.storeHelper.addNewEntryIfAbsent((String)tableName, kvt, id, PravegaTablesStoreHelper.UUID_TO_BYTES_FUNCTION, context.getRequestId()), (String)tableName, context)));
    }

    public CompletableFuture<Void> removeKVTableFromScope(String kvt, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getKVTablesInScopeTableName(context).thenCompose(tableName -> Futures.toVoid(this.storeHelper.removeEntry((String)tableName, kvt, context.getRequestId())));
    }

    public CompletableFuture<Void> addReaderGroupToScope(String readerGroupName, UUID readerGroupId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getReaderGroupsInScopeTableName(context).thenCompose(tableName -> Futures.toVoid(this.withCreateTableIfAbsent(() -> this.storeHelper.addNewEntryIfAbsent((String)tableName, readerGroupName, readerGroupId, PravegaTablesStoreHelper.UUID_TO_BYTES_FUNCTION, context.getRequestId()), (String)tableName, context)));
    }

    public CompletableFuture<Void> removeReaderGroupFromScope(String readerGroup, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getReaderGroupsInScopeTableName(context).thenCompose(tableName -> Futures.toVoid(this.storeHelper.removeEntry((String)tableName, readerGroup, context.getRequestId())));
    }

    @Override
    public CompletableFuture<UUID> getReaderGroupId(String readerGroupName, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getReaderGroupsInScopeTableName(context).thenCompose(tableName -> this.storeHelper.getEntry((String)tableName, readerGroupName, PravegaTablesStoreHelper.BYTES_TO_UUID_FUNCTION, context.getRequestId()).thenApply(VersionedMetadata::getObject));
    }

    @Override
    public CompletableFuture<Pair<List<String>, String>> listKeyValueTables(int limit, String continuationToken, Executor executor, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getKVTablesInScopeTableName(context).thenCompose(kvtablesInScopeTable -> this.readAll(limit, continuationToken, (String)kvtablesInScopeTable, context));
    }

    private <T> CompletableFuture<T> withCreateTableIfAbsent(Supplier<CompletableFuture<T>> futureSupplier, String tableName, OperationContext context) {
        return Futures.exceptionallyComposeExpecting(futureSupplier.get(), (Predicate)PravegaTablesStreamMetadataStore.DATA_NOT_FOUND_PREDICATE, () -> this.storeHelper.createTable(tableName, context.getRequestId()).thenCompose(arg_0 -> PravegaTablesScope.lambda$withCreateTableIfAbsent$55((Supplier)futureSupplier, arg_0)));
    }

    private CompletableFuture<Pair<List<String>, String>> readAll(int limit, String continuationToken, String tableName, OperationContext context) {
        ArrayList taken = new ArrayList();
        AtomicReference<String> token = new AtomicReference<String>(continuationToken);
        AtomicBoolean canContinue = new AtomicBoolean(true);
        return Futures.exceptionallyExpecting((CompletableFuture)this.storeHelper.getKeysPaginated(tableName, Unpooled.wrappedBuffer((byte[])Base64.getDecoder().decode(token.get())), limit, context.getRequestId()).thenApply(result -> {
            if (((List)result.getValue()).isEmpty()) {
                canContinue.set(false);
            } else {
                taken.addAll((Collection)result.getValue());
            }
            token.set(Base64.getEncoder().encodeToString(((ByteBuf)result.getKey()).array()));
            return new ImmutablePair((Object)taken, (Object)((String)token.get()));
        }), (Predicate)PravegaTablesStreamMetadataStore.DATA_NOT_FOUND_PREDICATE, (Object)new ImmutablePair(Collections.emptyList(), (Object)token.get()));
    }

    private static /* synthetic */ CompletionStage lambda$withCreateTableIfAbsent$55(Supplier futureSupplier, Void v) {
        return (CompletionStage)futureSupplier.get();
    }
}

