/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store;

import io.pravega.common.util.BitConverter;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.common.util.StructuredWritableBuffer;
import io.pravega.controller.store.stream.OperationContext;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.tuple.Pair;

public interface Scope {
    public String getName();

    public CompletableFuture<Void> createScope(OperationContext var1);

    public CompletableFuture<Void> deleteScope(OperationContext var1);

    public CompletableFuture<Pair<List<String>, String>> listStreams(int var1, String var2, Executor var3, OperationContext var4);

    public CompletableFuture<Pair<List<String>, String>> listStreamsForTag(String var1, String var2, Executor var3, OperationContext var4);

    public CompletableFuture<List<String>> listStreamsInScope(OperationContext var1);

    public void refresh();

    public CompletableFuture<Pair<List<String>, String>> listKeyValueTables(int var1, String var2, Executor var3, OperationContext var4);

    public CompletableFuture<UUID> getReaderGroupId(String var1, OperationContext var2);

    default public UUID newId() {
        return UUID.randomUUID();
    }

    default public byte[] getIdInBytes(UUID id) {
        byte[] b = new byte[16];
        BitConverter.writeUUID((StructuredWritableBuffer)new ByteArraySegment(b), (UUID)id);
        return b;
    }
}

