/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.controller.store.Version;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.stream.Cache;
import io.pravega.controller.store.stream.StoreException;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CreateBuilder;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKStoreHelper {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZKStoreHelper.class);
    private final CuratorFramework client;
    private final Executor executor;
    @VisibleForTesting
    private final Cache cache;
    private final AtomicBoolean isZKConnected = new AtomicBoolean(false);

    public ZKStoreHelper(CuratorFramework cf, Executor executor) {
        this.client = cf;
        this.executor = executor;
        this.cache = new Cache();
        this.isZKConnected.set(this.client.getZookeeperClient().isConnected());
        this.client.getConnectionStateListenable().addListener((curatorClient, newState) -> this.isZKConnected.set(newState.isConnected()));
    }

    public boolean isZKConnected() {
        return this.isZKConnected.get();
    }

    public CompletableFuture<List<String>> listScopes() {
        return this.getChildren("/store");
    }

    CompletableFuture<Void> addNode(String path) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            ((ErrorListenerPathAndBytesable)this.client.create().creatingParentsIfNeeded().inBackground(this.callback(x -> result.complete(null), result::completeExceptionally, path), this.executor)).forPath(path);
        }
        catch (Exception e) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e, path));
        }
        return result;
    }

    public CompletableFuture<Void> deleteNode(String path) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            ((ErrorListenerPathable)this.client.delete().inBackground(this.callback(x -> result.complete(null), result::completeExceptionally, path), this.executor)).forPath(path);
        }
        catch (Exception e) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e, path));
        }
        return result;
    }

    public CompletableFuture<Void> deleteNode(String path, Version version) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            ((ErrorListenerPathable)((BackgroundPathable)this.client.delete().withVersion(version.asIntVersion().getIntValue())).inBackground(this.callback(x -> result.complete(null), e -> {
                if (e instanceof StoreException.DataNotFoundException) {
                    result.complete(null);
                } else {
                    result.completeExceptionally((Throwable)e);
                }
            }, path), this.executor)).forPath(path);
        }
        catch (Exception e2) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e2, path));
        }
        return result;
    }

    public CompletableFuture<Void> deletePath(String path, boolean deleteEmptyContainer) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        CompletableFuture deleteNode = new CompletableFuture();
        try {
            ((ErrorListenerPathable)this.client.delete().inBackground(this.callback(event -> deleteNode.complete(null), e -> {
                if (e instanceof StoreException.DataNotFoundException) {
                    deleteNode.complete(null);
                } else {
                    deleteNode.completeExceptionally((Throwable)e);
                }
            }, path), this.executor)).forPath(path);
        }
        catch (Exception e2) {
            deleteNode.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e2, path));
        }
        deleteNode.whenComplete((res, ex) -> {
            if (ex != null) {
                result.completeExceptionally((Throwable)ex);
            } else if (deleteEmptyContainer) {
                String container = ZKPaths.getPathAndNode((String)path).getPath();
                try {
                    ((ErrorListenerPathable)this.client.delete().inBackground(this.callback(event -> result.complete(null), e -> {
                        if (e instanceof StoreException.DataNotFoundException) {
                            result.complete(null);
                        } else if (e instanceof StoreException.DataNotEmptyException) {
                            result.complete(null);
                        } else {
                            result.completeExceptionally((Throwable)e);
                        }
                    }, path), this.executor)).forPath(container);
                }
                catch (Exception e2) {
                    result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e2, path));
                }
            } else {
                result.complete(null);
            }
        });
        return result;
    }

    public CompletableFuture<Void> deleteTree(String path) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            ((ErrorListenerPathable)this.client.delete().deletingChildrenIfNeeded().inBackground(this.callback(event -> result.complete(null), result::completeExceptionally, path), this.executor)).forPath(path);
        }
        catch (Exception e) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e, path));
        }
        return result;
    }

    public <T> CompletableFuture<VersionedMetadata<T>> getData(String path, Function<byte[], T> fromBytes) {
        CompletableFuture result = new CompletableFuture();
        try {
            ((ErrorListenerPathable)this.client.getData().inBackground(this.callback(event -> {
                try {
                    Object deserialized = fromBytes.apply(event.getData());
                    result.complete(new VersionedMetadata(deserialized, new Version.IntVersion(event.getStat().getVersion())));
                }
                catch (Exception e) {
                    log.error("Exception thrown while deserializing the data", (Throwable)e);
                    result.completeExceptionally(e);
                }
            }, result::completeExceptionally, path), this.executor)).forPath(path);
        }
        catch (Exception e) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e, path));
        }
        return result;
    }

    public CompletableFuture<List<String>> getChildren(String path) {
        return this.getChildren(path, true);
    }

    CompletableFuture<List<String>> getChildren(String path, boolean ignoreDataNotFound) {
        CompletableFuture<List<String>> result = new CompletableFuture<List<String>>();
        try {
            ((ErrorListenerPathable)this.client.getChildren().inBackground(this.callback(event -> result.complete(event.getChildren()), e -> {
                if (ignoreDataNotFound && e instanceof StoreException.DataNotFoundException) {
                    result.complete(Collections.emptyList());
                } else {
                    result.completeExceptionally((Throwable)e);
                }
            }, path), this.executor)).forPath(path);
        }
        catch (Exception e2) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e2, path));
        }
        return result;
    }

    public CompletableFuture<Integer> setData(String path, byte[] data, Version version) {
        CompletableFuture<Integer> result = new CompletableFuture<Integer>();
        try {
            if (version == null) {
                ((ErrorListenerPathAndBytesable)this.client.setData().inBackground(this.callback(event -> result.complete(event.getStat().getVersion()), result::completeExceptionally, path), this.executor)).forPath(path, data);
            } else {
                ((ErrorListenerPathAndBytesable)((BackgroundPathAndBytesable)this.client.setData().withVersion(version.asIntVersion().getIntValue())).inBackground(this.callback(event -> result.complete(event.getStat().getVersion()), result::completeExceptionally, path), this.executor)).forPath(path, data);
            }
        }
        catch (Exception e) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e, path));
        }
        return result;
    }

    public CompletableFuture<Integer> createZNode(String path, byte[] data) {
        CompletableFuture<Integer> result = new CompletableFuture<Integer>();
        try {
            CreateBuilder createBuilder = this.client.create();
            BackgroundCallback callback = this.callback(x -> result.complete(x.getStat().getVersion()), e -> result.completeExceptionally((Throwable)e), path);
            ((ErrorListenerPathAndBytesable)createBuilder.creatingParentsIfNeeded().inBackground(callback, this.executor)).forPath(path, data);
        }
        catch (Exception e2) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e2, path));
        }
        return result;
    }

    public CompletableFuture<Integer> createZNodeIfNotExist(String path, byte[] data) {
        return this.createZNodeIfNotExist(path, data, true);
    }

    public CompletableFuture<Integer> createZNodeIfNotExist(String path, byte[] data, boolean createParent) {
        CompletableFuture<Integer> result = new CompletableFuture<Integer>();
        try {
            CreateBuilder createBuilder = this.client.create();
            BackgroundCallback callback = this.callback(x -> result.complete(x.getStat().getVersion()), e -> {
                if (e instanceof StoreException.DataExistsException) {
                    result.complete(null);
                } else {
                    result.completeExceptionally((Throwable)e);
                }
            }, path);
            if (createParent) {
                ((ErrorListenerPathAndBytesable)createBuilder.creatingParentsIfNeeded().inBackground(callback, this.executor)).forPath(path, data);
            } else {
                ((ErrorListenerPathAndBytesable)createBuilder.inBackground(callback, this.executor)).forPath(path, data);
            }
        }
        catch (Exception e2) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e2, path));
        }
        return result;
    }

    public CompletableFuture<Integer> createZNodeIfNotExist(String path) {
        return this.createZNodeIfNotExist(path, true);
    }

    private CompletableFuture<Integer> createZNodeIfNotExist(String path, boolean createParent) {
        CompletableFuture<Integer> result = new CompletableFuture<Integer>();
        try {
            CreateBuilder createBuilder = this.client.create();
            BackgroundCallback callback = this.callback(x -> result.complete(x.getStat().getVersion()), e -> {
                if (e instanceof StoreException.DataExistsException) {
                    result.complete(null);
                } else {
                    result.completeExceptionally((Throwable)e);
                }
            }, path);
            if (createParent) {
                ((ErrorListenerPathAndBytesable)createBuilder.creatingParentsIfNeeded().inBackground(callback, this.executor)).forPath(path);
            } else {
                ((ErrorListenerPathAndBytesable)createBuilder.inBackground(callback, this.executor)).forPath(path);
            }
        }
        catch (Exception e2) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e2, path));
        }
        return result;
    }

    public CompletableFuture<Boolean> createEphemeralZNode(String path, byte[] data) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        try {
            CreateBuilder createBuilder = this.client.create();
            BackgroundCallback callback = this.callback(x -> result.complete(true), e -> {
                if (e instanceof StoreException.DataExistsException) {
                    result.complete(false);
                } else {
                    result.completeExceptionally((Throwable)e);
                }
            }, path);
            ((ErrorListenerPathAndBytesable)((ACLBackgroundPathAndBytesable)createBuilder.creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).inBackground(callback, this.executor)).forPath(path, data);
        }
        catch (Exception e2) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e2, path));
        }
        return result;
    }

    CompletableFuture<String> createEphemeralSequentialZNode(String path) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        try {
            CreateBuilder createBuilder = this.client.create();
            BackgroundCallback callback = this.callback(x -> result.complete(x.getName()), result::completeExceptionally, path);
            ((ErrorListenerPathAndBytesable)((ACLBackgroundPathAndBytesable)createBuilder.creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).inBackground(callback, this.executor)).forPath(path);
        }
        catch (Exception e) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e, path));
        }
        return result;
    }

    public CompletableFuture<String> createPersistentSequentialZNode(String path, byte[] data) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        try {
            CreateBuilder createBuilder = this.client.create();
            BackgroundCallback callback = this.callback(x -> result.complete(x.getName()), result::completeExceptionally, path);
            ((ErrorListenerPathAndBytesable)((ACLBackgroundPathAndBytesable)createBuilder.creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).inBackground(callback, this.executor)).forPath(path, data);
        }
        catch (Exception e) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e, path));
        }
        return result;
    }

    public CompletableFuture<Void> sync(String path) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            BackgroundCallback callback = this.callback(x -> result.complete(null), result::completeExceptionally, path);
            ((ErrorListenerPathable)this.client.sync().inBackground(callback, this.executor)).forPath(path);
        }
        catch (Exception e) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e, path));
        }
        return result;
    }

    public CompletableFuture<Boolean> checkExists(String path) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        try {
            ((ErrorListenerPathable)this.client.checkExists().inBackground(this.callback(x -> result.complete(x.getStat() != null), ex -> {
                if (ex instanceof StoreException.DataNotFoundException) {
                    result.complete(false);
                } else {
                    result.completeExceptionally((Throwable)ex);
                }
            }, path), this.executor)).forPath(path);
        }
        catch (Exception e) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e, path));
        }
        return result;
    }

    private BackgroundCallback callback(Consumer<CuratorEvent> result, Consumer<Throwable> exception, String path) {
        return (client, event) -> {
            if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                result.accept(event);
            } else if (event.getResultCode() == KeeperException.Code.CONNECTIONLOSS.intValue() || event.getResultCode() == KeeperException.Code.SESSIONEXPIRED.intValue() || event.getResultCode() == KeeperException.Code.SESSIONMOVED.intValue() || event.getResultCode() == KeeperException.Code.OPERATIONTIMEOUT.intValue()) {
                exception.accept(StoreException.create(StoreException.Type.CONNECTION_ERROR, path));
            } else if (event.getResultCode() == KeeperException.Code.NODEEXISTS.intValue()) {
                exception.accept(StoreException.create(StoreException.Type.DATA_EXISTS, path));
            } else if (event.getResultCode() == KeeperException.Code.BADVERSION.intValue()) {
                exception.accept(StoreException.create(StoreException.Type.WRITE_CONFLICT, path));
            } else if (event.getResultCode() == KeeperException.Code.NONODE.intValue()) {
                exception.accept(StoreException.create(StoreException.Type.DATA_NOT_FOUND, path));
            } else if (event.getResultCode() == KeeperException.Code.NOTEMPTY.intValue()) {
                exception.accept(StoreException.create(StoreException.Type.DATA_CONTAINS_ELEMENTS, path));
            } else {
                exception.accept(StoreException.create(StoreException.Type.UNKNOWN, (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)event.getResultCode()), (String)path)));
            }
        };
    }

    public PathChildrenCache getPathChildrenCache(String path, boolean cacheData) {
        return new PathChildrenCache(this.client, path, cacheData);
    }

    public <T> CompletableFuture<VersionedMetadata<T>> getCachedData(String path, String id, Function<byte[], T> fromBytes) {
        ZkCacheKey cacheKey = new ZkCacheKey(path, id, fromBytes);
        VersionedMetadata<?> cached = this.cache.getCachedData(cacheKey);
        if (cached != null) {
            return CompletableFuture.completedFuture(this.getVersionedMetadata(cached));
        }
        long time = System.currentTimeMillis();
        return this.getData(path, fromBytes).thenApply(v -> {
            VersionedMetadata record = new VersionedMetadata(v.getObject(), v.getVersion());
            this.cache.put(cacheKey, record, time);
            return record;
        });
    }

    private <T> VersionedMetadata<T> getVersionedMetadata(VersionedMetadata v) {
        return new VersionedMetadata(v.getObject(), v.getVersion());
    }

    public void invalidateCache(String path, String id) {
        this.cache.invalidateCache(new ZkCacheKey<Object>(path, id, x -> null));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CuratorFramework getClient() {
        return this.client;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Cache getCache() {
        return this.cache;
    }

    public static class ZkCacheKey<T>
    implements Cache.CacheKey {
        private final String path;
        private final String id;
        private final Function<byte[], T> fromBytesFunc;

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.path.hashCode();
            result = 31 * result + this.id.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof ZkCacheKey && this.path.equals(((ZkCacheKey)obj).path) && this.id.equals(((ZkCacheKey)obj).id);
        }

        @ConstructorProperties(value={"path", "id", "fromBytesFunc"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ZkCacheKey(String path, String id, Function<byte[], T> fromBytesFunc) {
            this.path = path;
            this.id = id;
            this.fromBytesFunc = fromBytesFunc;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getPath() {
            return this.path;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getId() {
            return this.id;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Function<byte[], T> getFromBytesFunc() {
            return this.fromBytesFunc;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ZKStoreHelper.ZkCacheKey(path=" + this.getPath() + ", id=" + this.getId() + ", fromBytesFunc=" + this.getFromBytesFunc() + ")";
        }
    }
}

