/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.checkpoint;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.Position;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.impl.JavaSerializer;
import io.pravega.common.Exceptions;
import io.pravega.common.util.Retry;
import io.pravega.controller.store.checkpoint.CheckpointStore;
import io.pravega.controller.store.checkpoint.CheckpointStoreException;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKCheckpointStore
implements CheckpointStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZKCheckpointStore.class);
    private static final String ROOT = "eventProcessors";
    private final CuratorFramework client;
    private final Serializer<Position> positionSerializer;
    private final JavaSerializer<ReaderGroupData> groupDataSerializer;
    private final AtomicBoolean isZKConnected = new AtomicBoolean(false);

    ZKCheckpointStore(CuratorFramework client) {
        this.client = client;
        this.positionSerializer = new Serializer<Position>(){

            public ByteBuffer serialize(Position value) {
                return value.toBytes();
            }

            public Position deserialize(ByteBuffer serializedValue) {
                return Position.fromBytes((ByteBuffer)serializedValue);
            }
        };
        this.groupDataSerializer = new JavaSerializer();
        this.isZKConnected.set(client.getZookeeperClient().isConnected());
        client.getConnectionStateListenable().addListener((curatorClient, newState) -> this.isZKConnected.set(newState.isConnected()));
    }

    @Override
    public boolean isHealthy() {
        return this.isZKConnected.get();
    }

    @Override
    public void setPosition(String process, String readerGroup, String readerId, Position position) throws CheckpointStoreException {
        this.updateNode(this.getReaderPath(process, readerGroup, readerId), this.positionSerializer.serialize((Object)position).array());
    }

    @Override
    public Map<String, Position> getPositions(String process, String readerGroup) throws CheckpointStoreException {
        HashMap<String, Position> map = new HashMap<String, Position>();
        String path = this.getReaderGroupPath(process, readerGroup);
        ReaderGroupData rgData = (ReaderGroupData)this.groupDataSerializer.deserialize(ByteBuffer.wrap(this.getData(path)));
        rgData.getReaderIds().forEach(x -> map.put((String)x, (Position)null));
        for (String child : this.getChildren(path)) {
            Position position = null;
            byte[] data = this.getData(path + "/" + child);
            if (data != null && data.length > 0) {
                position = (Position)this.positionSerializer.deserialize(ByteBuffer.wrap(data));
            }
            map.put(child, position);
        }
        return map;
    }

    @Override
    public void addReaderGroup(String process, String readerGroup) throws CheckpointStoreException {
        ReaderGroupData data = new ReaderGroupData(ReaderGroupData.State.Active, new ArrayList<String>());
        this.addNode(this.getReaderGroupPath(process, readerGroup), this.groupDataSerializer.serialize((Serializable)data).array());
    }

    @Override
    public Map<String, Position> sealReaderGroup(String process, String readerGroup) throws CheckpointStoreException {
        String path = this.getReaderGroupPath(process, readerGroup);
        try {
            this.updateReaderGroupData(path, groupData -> new ReaderGroupData(ReaderGroupData.State.Sealed, groupData.getReaderIds()));
            return this.getPositions(process, readerGroup);
        }
        catch (KeeperException.NoNodeException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.NoNode, (Throwable)e);
        }
        catch (KeeperException.ConnectionLossException | KeeperException.OperationTimeoutException | KeeperException.SessionExpiredException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.Connectivity, e);
        }
        catch (Exception e) {
            throw new CheckpointStoreException(e);
        }
    }

    @Override
    public void removeReaderGroup(String process, String readerGroup) throws CheckpointStoreException {
        byte[] data;
        String path = this.getReaderGroupPath(process, readerGroup);
        try {
            data = this.getData(path);
        }
        catch (CheckpointStoreException e) {
            if (e.getType().equals((Object)CheckpointStoreException.Type.NoNode)) {
                return;
            }
            throw e;
        }
        ReaderGroupData groupData = (ReaderGroupData)this.groupDataSerializer.deserialize(ByteBuffer.wrap(data));
        if (groupData.getState() == ReaderGroupData.State.Active) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.Active, "ReaderGroup is active.");
        }
        if (!groupData.getReaderIds().isEmpty()) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.NodeNotEmpty, "ReaderGroup is not empty.");
        }
        this.removeEmptyNode(path);
    }

    @Override
    public Map<String, Position> removeProcessFromGroup(String process, String readerGroup) throws CheckpointStoreException {
        String path = this.getReaderGroupPath(process, readerGroup);
        try {
            this.updateReaderGroupData(path, groupData -> new ReaderGroupData(ReaderGroupData.State.Sealed, groupData.getReaderIds()));
            Map<String, Position> result = this.getPositions(process, readerGroup);
            for (String readerId : result.keySet()) {
                this.removeReader(process, readerGroup, readerId);
            }
            this.removeReaderGroup(process, readerGroup);
            return result;
        }
        catch (KeeperException.NoNodeException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.NoNode, (Throwable)e);
        }
        catch (KeeperException.ConnectionLossException | KeeperException.OperationTimeoutException | KeeperException.SessionExpiredException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.Connectivity, e);
        }
        catch (Exception e) {
            throw new CheckpointStoreException(e);
        }
    }

    @Override
    public List<String> getReaderGroups(String process) throws CheckpointStoreException {
        return this.getChildren(this.getProcessPath(process));
    }

    @Override
    public void addReader(String process, String readerGroup, String readerId) throws CheckpointStoreException {
        String path = this.getReaderGroupPath(process, readerGroup);
        try {
            this.updateReaderGroupData(path, groupData -> {
                if (groupData.getState() == ReaderGroupData.State.Sealed) {
                    throw Exceptions.sneakyThrow((Throwable)new CheckpointStoreException(CheckpointStoreException.Type.Sealed, "ReaderGroup is sealed"));
                }
                List<String> list = groupData.getReaderIds();
                if (list.contains(readerId)) {
                    throw Exceptions.sneakyThrow((Throwable)new CheckpointStoreException(CheckpointStoreException.Type.NodeExists, "Duplicate readerId"));
                }
                list.add(readerId);
                return new ReaderGroupData(groupData.getState(), list);
            });
            this.addNode(this.getReaderPath(process, readerGroup, readerId));
        }
        catch (KeeperException.NoNodeException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.NoNode, (Throwable)e);
        }
        catch (KeeperException.ConnectionLossException | KeeperException.OperationTimeoutException | KeeperException.SessionExpiredException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.Connectivity, e);
        }
        catch (CheckpointStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CheckpointStoreException(e);
        }
    }

    @Override
    public void removeReader(String process, String readerGroup, String readerId) throws CheckpointStoreException {
        String path = this.getReaderGroupPath(process, readerGroup);
        try {
            this.removeEmptyNode(this.getReaderPath(process, readerGroup, readerId));
            this.updateReaderGroupData(path, groupData -> {
                List<String> list = groupData.getReaderIds();
                if (list.contains(readerId)) {
                    list.remove(readerId);
                    return new ReaderGroupData(groupData.getState(), list);
                }
                return groupData;
            });
        }
        catch (KeeperException.NoNodeException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.NoNode, (Throwable)e);
        }
        catch (KeeperException.ConnectionLossException | KeeperException.OperationTimeoutException | KeeperException.SessionExpiredException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.Connectivity, e);
        }
        catch (CheckpointStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CheckpointStoreException(e);
        }
    }

    @Override
    public Set<String> getProcesses() throws CheckpointStoreException {
        return this.getChildren(this.getRootPath()).stream().collect(Collectors.toSet());
    }

    private String getReaderPath(String process, String readerGroup, String readerId) {
        return String.format("/%s/%s/%s/%s", ROOT, process, readerGroup, readerId);
    }

    private String getReaderGroupPath(String process, String readerGroup) {
        return String.format("/%s/%s/%s", ROOT, process, readerGroup);
    }

    private String getProcessPath(String process) {
        return String.format("/%s/%s", ROOT, process);
    }

    private String getRootPath() {
        return String.format("/%s", ROOT);
    }

    private void updateReaderGroupData(String path, Function<ReaderGroupData, ReaderGroupData> updater) throws Exception {
        long initialMillis = 100L;
        int multiplier = 2;
        int attempts = 10;
        long maxDelay = 2000L;
        Stat stat = new Stat();
        Retry.withExpBackoff((long)100L, (int)2, (int)10, (long)2000L).retryingOn(KeeperException.BadVersionException.class).throwingOn(Exception.class).run(() -> {
            byte[] data = (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(path);
            ReaderGroupData groupData = (ReaderGroupData)this.groupDataSerializer.deserialize(ByteBuffer.wrap(data));
            groupData = (ReaderGroupData)updater.apply(groupData);
            byte[] newData = this.groupDataSerializer.serialize((Serializable)groupData).array();
            ((BackgroundPathAndBytesable)this.client.setData().withVersion(stat.getVersion())).forPath(path, newData);
            return null;
        });
    }

    private void addNode(String path) throws CheckpointStoreException {
        this.addNode(path, new byte[0]);
    }

    private void addNode(String path, byte[] data) throws CheckpointStoreException {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(path, data);
        }
        catch (KeeperException.NodeExistsException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.NodeExists, (Throwable)e);
        }
        catch (KeeperException.ConnectionLossException | KeeperException.OperationTimeoutException | KeeperException.SessionExpiredException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.Connectivity, e);
        }
        catch (Exception e) {
            throw new CheckpointStoreException(e);
        }
    }

    private void removeEmptyNode(String path) throws CheckpointStoreException {
        try {
            this.client.delete().forPath(path);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (KeeperException.NotEmptyException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.NodeNotEmpty, (Throwable)e);
        }
        catch (KeeperException.ConnectionLossException | KeeperException.OperationTimeoutException | KeeperException.SessionExpiredException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.Connectivity, e);
        }
        catch (Exception e) {
            throw new CheckpointStoreException(e);
        }
    }

    private void updateNode(String path, byte[] data) throws CheckpointStoreException {
        try {
            this.client.setData().forPath(path, data);
        }
        catch (KeeperException.NoNodeException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.NoNode, (Throwable)e);
        }
        catch (KeeperException.ConnectionLossException | KeeperException.OperationTimeoutException | KeeperException.SessionExpiredException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.Connectivity, e);
        }
        catch (Exception e) {
            throw new CheckpointStoreException(e);
        }
    }

    private List<String> getChildren(String path) throws CheckpointStoreException {
        try {
            return (List)this.client.getChildren().forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return Collections.emptyList();
        }
        catch (KeeperException.ConnectionLossException | KeeperException.OperationTimeoutException | KeeperException.SessionExpiredException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.Connectivity, e);
        }
        catch (Exception e) {
            throw new CheckpointStoreException(e);
        }
    }

    private byte[] getData(String path) throws CheckpointStoreException {
        try {
            return (byte[])this.client.getData().forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.NoNode, (Throwable)e);
        }
        catch (KeeperException.ConnectionLossException | KeeperException.OperationTimeoutException | KeeperException.SessionExpiredException e) {
            throw new CheckpointStoreException(CheckpointStoreException.Type.Connectivity, e);
        }
        catch (Exception e) {
            throw new CheckpointStoreException(e);
        }
    }

    private static class ReaderGroupData
    implements Serializable {
        private final State state;
        private final List<String> readerIds;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public State getState() {
            return this.state;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<String> getReaderIds() {
            return this.readerIds;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReaderGroupData)) {
                return false;
            }
            ReaderGroupData other = (ReaderGroupData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            State this$state = this.getState();
            State other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
                return false;
            }
            List<String> this$readerIds = this.getReaderIds();
            List<String> other$readerIds = other.getReaderIds();
            return !(this$readerIds == null ? other$readerIds != null : !((Object)this$readerIds).equals(other$readerIds));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReaderGroupData;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            State $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
            List<String> $readerIds = this.getReaderIds();
            result = result * 59 + ($readerIds == null ? 43 : ((Object)$readerIds).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ZKCheckpointStore.ReaderGroupData(state=" + this.getState() + ", readerIds=" + this.getReaderIds() + ")";
        }

        @ConstructorProperties(value={"state", "readerIds"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReaderGroupData(State state, List<String> readerIds) {
            this.state = state;
            this.readerIds = readerIds;
        }

        static enum State {
            Active,
            Sealed;

        }
    }
}

