/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.client.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.controller.store.client.StoreClientConfig;
import io.pravega.controller.store.client.StoreType;
import io.pravega.controller.store.client.ZKClientConfig;
import java.util.Optional;
import lombok.Generated;

public class StoreClientConfigImpl
implements StoreClientConfig {
    private final StoreType storeType;
    private final Optional<ZKClientConfig> zkClientConfig;

    StoreClientConfigImpl(StoreType storeType, Optional<ZKClientConfig> zkClientConfig) {
        Preconditions.checkNotNull((Object)((Object)storeType), (Object)"storeType");
        Preconditions.checkNotNull(zkClientConfig, (Object)"zkClientConfig");
        if (storeType == StoreType.Zookeeper) {
            Exceptions.checkArgument((boolean)zkClientConfig.isPresent(), (String)"zkClientConfig", (String)"Should be non-empty", (Object[])new Object[0]);
        }
        this.storeType = storeType;
        this.zkClientConfig = zkClientConfig;
    }

    public static StoreClientConfig withInMemoryClient() {
        return new StoreClientConfigImpl(StoreType.InMemory, Optional.empty());
    }

    public static StoreClientConfig withZKClient(ZKClientConfig zkClientConfig) {
        Preconditions.checkNotNull((Object)zkClientConfig, (Object)"zkClientConfig");
        return new StoreClientConfigImpl(StoreType.Zookeeper, Optional.of(zkClientConfig));
    }

    public static StoreClientConfig withPravegaTablesClient(ZKClientConfig zkClientConfig) {
        Preconditions.checkNotNull((Object)zkClientConfig, (Object)"zkClientConfig");
        return new StoreClientConfigImpl(StoreType.PravegaTable, Optional.of(zkClientConfig));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "StoreClientConfigImpl(storeType=" + this.getStoreType() + ", zkClientConfig=" + this.getZkClientConfig() + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public StoreType getStoreType() {
        return this.storeType;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<ZKClientConfig> getZkClientConfig() {
        return this.zkClientConfig;
    }
}

