/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.client.impl;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.controller.store.client.ZKClientConfig;
import lombok.Generated;

public class ZKClientConfigImpl
implements ZKClientConfig {
    private final String connectionString;
    private final String namespace;
    private final int initialSleepInterval;
    private final int maxRetries;
    private final int sessionTimeoutMs;
    private final boolean secureConnectionToZooKeeper;
    private final String trustStorePath;
    private final String trustStorePasswordPath;

    ZKClientConfigImpl(String connectionString, String namespace, int initialSleepInterval, int maxRetries, int sessionTimeoutMs, boolean secureConnectionToZooKeeper, String trustStorePath, String trustStorePasswordPath) {
        Exceptions.checkNotNullOrEmpty((String)connectionString, (String)"connectionString");
        Exceptions.checkNotNullOrEmpty((String)namespace, (String)"namespace");
        Exceptions.checkArgument((initialSleepInterval > 0 ? 1 : 0) != 0, (String)"retryInterval", (String)"Should be a positive integer", (Object[])new Object[0]);
        Exceptions.checkArgument((maxRetries > 0 ? 1 : 0) != 0, (String)"maxRetries", (String)"Should be a positive integer", (Object[])new Object[0]);
        Exceptions.checkArgument((sessionTimeoutMs > 0 ? 1 : 0) != 0, (String)"sessionTimeoutMs", (String)"Should be a positive integer", (Object[])new Object[0]);
        this.connectionString = connectionString;
        this.namespace = namespace;
        this.initialSleepInterval = initialSleepInterval;
        this.maxRetries = maxRetries;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.secureConnectionToZooKeeper = secureConnectionToZooKeeper;
        this.trustStorePath = trustStorePath;
        this.trustStorePasswordPath = trustStorePasswordPath;
    }

    public String toString() {
        return String.format("%s(", this.getClass().getSimpleName()) + String.format("connectionString: %s, ", this.connectionString) + String.format("namespace: %s, ", this.namespace) + String.format("initialSleepInterval: %d, ", this.initialSleepInterval) + String.format("maxRetries: %d, ", this.maxRetries) + String.format("sessionTimeoutMs: %d, ", this.sessionTimeoutMs) + String.format("secureConnectionToZooKeeper: %b, ", this.secureConnectionToZooKeeper) + String.format("trustStorePath is %s, ", Strings.isNullOrEmpty((String)this.trustStorePath) ? "unspecified" : "specified") + String.format("trustStorePasswordPath is %s", Strings.isNullOrEmpty((String)this.trustStorePasswordPath) ? "unspecified" : "specified") + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ZKClientConfigImplBuilder builder() {
        return new ZKClientConfigImplBuilder();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getConnectionString() {
        return this.connectionString;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getInitialSleepInterval() {
        return this.initialSleepInterval;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isSecureConnectionToZooKeeper() {
        return this.secureConnectionToZooKeeper;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTrustStorePasswordPath() {
        return this.trustStorePasswordPath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ZKClientConfigImplBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String connectionString;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String namespace;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int initialSleepInterval;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int maxRetries;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int sessionTimeoutMs;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean secureConnectionToZooKeeper;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String trustStorePath;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String trustStorePasswordPath;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ZKClientConfigImplBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ZKClientConfigImplBuilder connectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ZKClientConfigImplBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ZKClientConfigImplBuilder initialSleepInterval(int initialSleepInterval) {
            this.initialSleepInterval = initialSleepInterval;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ZKClientConfigImplBuilder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ZKClientConfigImplBuilder sessionTimeoutMs(int sessionTimeoutMs) {
            this.sessionTimeoutMs = sessionTimeoutMs;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ZKClientConfigImplBuilder secureConnectionToZooKeeper(boolean secureConnectionToZooKeeper) {
            this.secureConnectionToZooKeeper = secureConnectionToZooKeeper;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ZKClientConfigImplBuilder trustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ZKClientConfigImplBuilder trustStorePasswordPath(String trustStorePasswordPath) {
            this.trustStorePasswordPath = trustStorePasswordPath;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ZKClientConfigImpl build() {
            return new ZKClientConfigImpl(this.connectionString, this.namespace, this.initialSleepInterval, this.maxRetries, this.sessionTimeoutMs, this.secureConnectionToZooKeeper, this.trustStorePath, this.trustStorePasswordPath);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ZKClientConfigImpl.ZKClientConfigImplBuilder(connectionString=" + this.connectionString + ", namespace=" + this.namespace + ", initialSleepInterval=" + this.initialSleepInterval + ", maxRetries=" + this.maxRetries + ", sessionTimeoutMs=" + this.sessionTimeoutMs + ", secureConnectionToZooKeeper=" + this.secureConnectionToZooKeeper + ", trustStorePath=" + this.trustStorePath + ", trustStorePasswordPath=" + this.trustStorePasswordPath + ")";
        }
    }
}

