/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.host;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.controller.store.client.StoreClient;
import io.pravega.controller.store.client.StoreType;
import io.pravega.controller.store.host.HostControllerStore;
import io.pravega.controller.store.host.HostMonitorConfig;
import io.pravega.controller.store.host.InMemoryHostStore;
import io.pravega.controller.store.host.ZKHostStore;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostStoreFactory {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HostStoreFactory.class);

    public static HostControllerStore createStore(HostMonitorConfig hostMonitorConfig, StoreClient storeClient) {
        Preconditions.checkNotNull((Object)hostMonitorConfig, (Object)"hostMonitorConfig");
        Preconditions.checkNotNull((Object)storeClient, (Object)"storeClient");
        if (hostMonitorConfig.isHostMonitorEnabled()) {
            Preconditions.checkArgument((storeClient.getType() == StoreType.Zookeeper || storeClient.getType() == StoreType.PravegaTable ? 1 : 0) != 0, (Object)"If host monitor is enabled then the store type should support Zookeeper");
            log.info("Creating Zookeeper based host store");
            return new ZKHostStore((CuratorFramework)storeClient.getClient(), hostMonitorConfig.getContainerCount());
        }
        log.info("Creating in-memory host store");
        return HostStoreFactory.createInMemoryStore(hostMonitorConfig);
    }

    @VisibleForTesting
    public static HostControllerStore createInMemoryStore(HostMonitorConfig hostMonitorConfig) {
        log.info("Creating in-memory host store");
        return new InMemoryHostStore(hostMonitorConfig.getHostContainerMap(), hostMonitorConfig.getContainerCount());
    }
}

