/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.host;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.cluster.Host;
import io.pravega.common.cluster.HostContainerMap;
import io.pravega.controller.store.host.HostControllerStore;
import io.pravega.controller.store.host.HostStoreException;
import io.pravega.controller.util.ZKUtils;
import io.pravega.shared.NameUtils;
import io.pravega.shared.segment.SegmentToContainerMapper;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.utils.ZKPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKHostStore
implements HostControllerStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZKHostStore.class);
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    private final String zkPath;
    private final CuratorFramework zkClient;
    private final Object lock = new Object();
    @GuardedBy(value="$lock")
    private boolean zkInit = false;
    private final SegmentToContainerMapper segmentMapper;
    private final NodeCache hostContainerMapNode;
    private final AtomicReference<HostContainerMap> hostContainerMap;
    private final AtomicReference<Listener> listenerRef;

    @VisibleForTesting
    public ZKHostStore(CuratorFramework client, int containerCount) {
        Preconditions.checkNotNull((Object)client, (Object)"client");
        this.zkClient = client;
        this.zkPath = ZKPaths.makePath((String)"cluster", (String)"segmentContainerHostMapping");
        this.segmentMapper = new SegmentToContainerMapper(containerCount, true);
        this.hostContainerMapNode = new NodeCache(this.zkClient, this.zkPath);
        this.hostContainerMap = new AtomicReference<HostContainerMap>(HostContainerMap.EMPTY);
        this.listenerRef = new AtomicReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryInit() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.zkInit) {
                ZKUtils.createPathIfNotExists(this.zkClient, this.zkPath, HostContainerMap.EMPTY.toBytes());
                this.hostContainerMapNode.getListenable().addListener(this::updateMap);
                this.hostContainerMapNode.start(true);
                this.updateMap();
                this.zkInit = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMap() {
        Object object = this.$lock;
        synchronized (object) {
            this.hostContainerMap.set(HostContainerMap.fromBytes((byte[])this.hostContainerMapNode.getCurrentData().getData()));
            Listener consumer = this.listenerRef.get();
            if (consumer != null) {
                consumer.signal();
            }
        }
    }

    @Override
    public Map<Host, Set<Integer>> getHostContainersMap() {
        this.tryInit();
        return this.hostContainerMap.get().getHostContainerMap();
    }

    @Override
    public void updateHostContainersMap(Map<Host, Set<Integer>> newMapping) {
        Preconditions.checkNotNull(newMapping, (Object)"newMapping");
        this.tryInit();
        byte[] serializedMap = HostContainerMap.createHostContainerMap(newMapping).toBytes();
        try {
            this.zkClient.setData().forPath(this.zkPath, serializedMap);
            log.info("Successfully updated segment container map");
        }
        catch (Exception e) {
            throw new HostStoreException("Failed to persist segment container map to zookeeper", e);
        }
    }

    private Host getHostForContainer(int containerId) {
        this.tryInit();
        Optional<Host> host = this.hostContainerMap.get().getHostContainerMap().entrySet().stream().filter(x -> ((Set)x.getValue()).contains(containerId)).map(Map.Entry::getKey).findAny();
        if (host.isPresent()) {
            log.debug("Found owning host: {} for containerId: {}", (Object)host.get(), (Object)containerId);
            return host.get();
        }
        throw new HostStoreException("Could not find host for container id: " + String.valueOf(containerId));
    }

    @Override
    public int getContainerCount() {
        return this.segmentMapper.getTotalContainerCount();
    }

    @Override
    public Host getHostForSegment(String scope, String stream, long segmentId) {
        String qualifiedName = NameUtils.getQualifiedStreamSegmentName((String)scope, (String)stream, (long)segmentId);
        return this.getHostForContainer(this.segmentMapper.getContainerId(qualifiedName));
    }

    @Override
    public Host getHostForTableSegment(String tableName) {
        return this.getHostForContainer(this.segmentMapper.getContainerId(tableName));
    }

    @VisibleForTesting
    public void addListener(Listener listener) {
        this.listenerRef.set(listener);
    }

    @FunctionalInterface
    @VisibleForTesting
    public static interface Listener {
        public void signal();
    }
}

