/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.controller.store.index.HostIndex;
import io.pravega.controller.store.stream.StoreException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKHostIndex
implements HostIndex {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZKHostIndex.class);
    private final CuratorFramework client;
    private final Executor executor;
    private final String hostRoot;

    public ZKHostIndex(CuratorFramework client, String hostRoot, Executor executor) {
        this.client = client;
        this.executor = executor;
        this.hostRoot = hostRoot;
    }

    @Override
    public CompletableFuture<Void> addEntity(String hostId, String entity) {
        return this.addEntity(hostId, entity, new byte[0]);
    }

    @Override
    public CompletableFuture<Void> addEntity(String hostId, String entity, byte[] entityData) {
        Preconditions.checkNotNull((Object)hostId);
        Preconditions.checkNotNull((Object)entity);
        return this.createNode(CreateMode.PERSISTENT, true, this.getHostPath(hostId, entity), entityData);
    }

    @Override
    public CompletableFuture<byte[]> getEntityData(String hostId, String entity) {
        Preconditions.checkNotNull((Object)hostId);
        Preconditions.checkNotNull((Object)entity);
        return this.readNode(this.getHostPath(hostId, entity));
    }

    @Override
    public CompletableFuture<Void> removeEntity(String hostId, String entity, boolean deleteEmptyHost) {
        Preconditions.checkNotNull((Object)hostId);
        Preconditions.checkNotNull((Object)entity);
        return this.deleteNode(this.getHostPath(hostId, entity)).thenCompose(ignore -> {
            if (deleteEmptyHost) {
                return this.deleteNode(this.getHostPath(hostId)).exceptionally(ex -> {
                    if (ex instanceof StoreException.DataNotEmptyException) {
                        return null;
                    }
                    throw (StoreException)ex;
                });
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public CompletableFuture<Void> removeHost(String hostId) {
        Preconditions.checkNotNull((Object)hostId);
        return this.deleteNode(this.getHostPath(hostId));
    }

    @Override
    public CompletableFuture<List<String>> getEntities(String hostId) {
        Preconditions.checkNotNull((Object)hostId);
        String hostPath = this.getHostPath(hostId);
        return this.sync(hostPath).thenCompose(v -> this.getChildren(hostPath));
    }

    @Override
    public CompletableFuture<Set<String>> getHosts() {
        return ((CompletableFuture)this.sync(this.hostRoot).thenCompose(v -> this.getChildren(this.hostRoot))).thenApply(list -> list.stream().collect(Collectors.toSet()));
    }

    private CompletableFuture<Void> createNode(CreateMode createMode, boolean createParents, String path, byte[] data) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            BackgroundCallback callback = (cli, event) -> {
                if (event.getResultCode() == KeeperException.Code.OK.intValue() || event.getResultCode() == KeeperException.Code.NODEEXISTS.intValue()) {
                    result.complete(null);
                } else {
                    result.completeExceptionally(this.translateErrorCode(path, event));
                }
            };
            if (createParents) {
                ((ErrorListenerPathAndBytesable)((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(createMode)).inBackground(callback, this.executor)).forPath(path, data);
            } else {
                ((ErrorListenerPathAndBytesable)((ACLBackgroundPathAndBytesable)this.client.create().withMode(createMode)).inBackground(callback, this.executor)).forPath(path, data);
            }
        }
        catch (Exception e) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e));
        }
        return result;
    }

    private CompletableFuture<byte[]> readNode(String path) {
        CompletableFuture<byte[]> result = new CompletableFuture<byte[]>();
        try {
            ((ErrorListenerPathable)this.client.getData().inBackground((cli, event) -> {
                if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                    result.complete(event.getData());
                } else if (event.getResultCode() == KeeperException.Code.NONODE.intValue()) {
                    log.debug("Node {} does not exist.", (Object)path);
                    result.complete(null);
                } else {
                    result.completeExceptionally(this.translateErrorCode(path, event));
                }
            }, this.executor)).forPath(path);
        }
        catch (Exception e) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e));
        }
        return result;
    }

    private CompletableFuture<Void> deleteNode(String path) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            ((ErrorListenerPathable)this.client.delete().inBackground((cli, event) -> {
                if (event.getResultCode() == KeeperException.Code.OK.intValue() || event.getResultCode() == KeeperException.Code.NONODE.intValue()) {
                    result.complete(null);
                } else {
                    result.completeExceptionally(this.translateErrorCode(path, event));
                }
            }, this.executor)).forPath(path);
        }
        catch (Exception e) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e));
        }
        return result;
    }

    @VisibleForTesting
    CompletableFuture<Void> sync(String path) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            ((ErrorListenerPathable)this.client.sync().inBackground((cli, event) -> {
                if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                    result.complete(null);
                } else {
                    result.completeExceptionally(this.translateErrorCode(path, event));
                }
            }, this.executor)).forPath(path);
        }
        catch (Exception e) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e, path));
        }
        return result;
    }

    private CompletableFuture<List<String>> getChildren(String path) {
        CompletableFuture<List<String>> result = new CompletableFuture<List<String>>();
        try {
            ((ErrorListenerPathable)this.client.getChildren().inBackground((cli, event) -> {
                if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                    result.complete(event.getChildren());
                } else if (event.getResultCode() == KeeperException.Code.NONODE.intValue()) {
                    result.complete(Collections.emptyList());
                } else {
                    result.completeExceptionally(this.translateErrorCode(path, event));
                }
            }, this.executor)).forPath(path);
        }
        catch (Exception e) {
            result.completeExceptionally(StoreException.create(StoreException.Type.UNKNOWN, e));
        }
        return result;
    }

    private StoreException translateErrorCode(String path, CuratorEvent event) {
        StoreException ex = event.getResultCode() == KeeperException.Code.CONNECTIONLOSS.intValue() || event.getResultCode() == KeeperException.Code.SESSIONEXPIRED.intValue() || event.getResultCode() == KeeperException.Code.SESSIONMOVED.intValue() || event.getResultCode() == KeeperException.Code.OPERATIONTIMEOUT.intValue() ? StoreException.create(StoreException.Type.CONNECTION_ERROR, path) : (event.getResultCode() == KeeperException.Code.NODEEXISTS.intValue() ? StoreException.create(StoreException.Type.DATA_EXISTS, path) : (event.getResultCode() == KeeperException.Code.BADVERSION.intValue() ? StoreException.create(StoreException.Type.WRITE_CONFLICT, path) : (event.getResultCode() == KeeperException.Code.NONODE.intValue() ? StoreException.create(StoreException.Type.DATA_NOT_FOUND, path) : (event.getResultCode() == KeeperException.Code.NOTEMPTY.intValue() ? StoreException.create(StoreException.Type.DATA_CONTAINS_ELEMENTS, path) : StoreException.create(StoreException.Type.UNKNOWN, (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)event.getResultCode()), (String)path))))));
        return ex;
    }

    private String getHostPath(String hostId, String child) {
        return this.hostRoot + "/" + hostId + "/" + child;
    }

    private String getHostPath(String hostId) {
        return this.hostRoot + "/" + hostId;
    }
}

