/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.kvtable;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.store.Version;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.kvtable.CreateKVTableResponse;
import io.pravega.controller.store.kvtable.KVTableState;
import io.pravega.controller.store.kvtable.KeyValueTable;
import io.pravega.controller.store.kvtable.records.KVTConfigurationRecord;
import io.pravega.controller.store.kvtable.records.KVTEpochRecord;
import io.pravega.controller.store.kvtable.records.KVTSegmentRecord;
import io.pravega.controller.store.kvtable.records.KVTStateRecord;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.StoreException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.IntStream;
import org.slf4j.LoggerFactory;

public abstract class AbstractKVTableBase
implements KeyValueTable {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(AbstractKVTableBase.class));
    protected final String scopeName;
    protected final String name;

    AbstractKVTableBase(String scope, String name) {
        this.scopeName = scope;
        this.name = name;
    }

    @Override
    public String getScopeName() {
        return this.scopeName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CompletableFuture<Void> updateState(KVTableState state, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getStateData(true, context).thenCompose(currState -> {
            VersionedMetadata<KVTableState> currentState = new VersionedMetadata<KVTableState>(((KVTStateRecord)currState.getObject()).getState(), currState.getVersion());
            return Futures.toVoid(this.updateVersionedState(currentState, state, context));
        });
    }

    @Override
    public CompletableFuture<VersionedMetadata<KVTableState>> getVersionedState(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getStateData(true, context).thenApply(x -> new VersionedMetadata<KVTableState>(((KVTStateRecord)x.getObject()).getState(), x.getVersion()));
    }

    @Override
    public CompletableFuture<VersionedMetadata<KVTableState>> updateVersionedState(VersionedMetadata<KVTableState> previous, KVTableState newState, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        if (KVTableState.isTransitionAllowed(previous.getObject(), newState)) {
            return this.setStateData(new VersionedMetadata<KVTStateRecord>(KVTStateRecord.builder().state(newState).build(), previous.getVersion()), context).thenApply(updatedVersion -> new VersionedMetadata<KVTableState>(newState, (Version)updatedVersion));
        }
        return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.OPERATION_NOT_ALLOWED, "KeyValueTable: " + this.getName() + " State: " + newState.name() + " current state = " + (Object)((Object)previous.getObject())));
    }

    @Override
    public CompletableFuture<KVTableState> getState(boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getStateData(ignoreCached, context).thenApply(x -> ((KVTStateRecord)x.getObject()).getState());
    }

    @Override
    public CompletableFuture<CreateKVTableResponse> create(KeyValueTableConfiguration configuration, long createTimestamp, int startingSegmentNumber, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.checkKeyValueTableExists(configuration, createTimestamp, startingSegmentNumber, context).thenCompose(createKVTResponse -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.createKVTableMetadata(context).thenCompose(v -> this.storeCreationTimeIfAbsent(createKVTResponse.getTimestamp(), context))).thenCompose(v -> this.createConfigurationIfAbsent(KVTConfigurationRecord.builder().scope(this.scopeName).kvtName(this.name).kvtConfiguration(configuration).build(), context))).thenCompose(v -> this.createStateIfAbsent(KVTStateRecord.builder().state(KVTableState.CREATING).build(), context))).thenCompose(v -> this.createHistoryRecords(startingSegmentNumber, (CreateKVTableResponse)createKVTResponse, context))).thenApply(v -> createKVTResponse));
    }

    private CompletionStage<Void> createHistoryRecords(int startingSegmentNumber, CreateKVTableResponse createKvtResponse, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        int numSegments = createKvtResponse.getConfiguration().getPartitionCount();
        double keyRangeChunk = 1.0 / (double)numSegments;
        long creationTime = createKvtResponse.getTimestamp();
        ImmutableList.Builder builder = ImmutableList.builder();
        IntStream.range(0, numSegments).boxed().forEach(x -> builder.add((Object)this.newSegmentRecord(0, startingSegmentNumber + x, creationTime, (double)x.intValue() * keyRangeChunk, (double)(x + 1) * keyRangeChunk)));
        KVTEpochRecord epoch0 = new KVTEpochRecord(0, (ImmutableList<KVTSegmentRecord>)builder.build(), creationTime);
        return this.createEpochRecord(epoch0, context).thenCompose(r -> this.createCurrentEpochRecordDataIfAbsent(epoch0, context));
    }

    private KVTSegmentRecord newSegmentRecord(int epoch, int segmentNumber, long time, Double low, Double high) {
        return KVTSegmentRecord.builder().creationEpoch(epoch).segmentNumber(segmentNumber).creationTime(time).keyStart(low).keyEnd(high).build();
    }

    private CompletableFuture<Void> createEpochRecord(KVTEpochRecord epoch, OperationContext context) {
        return this.createEpochRecordDataIfAbsent(epoch.getEpoch(), epoch, context);
    }

    @Override
    public CompletableFuture<List<KVTSegmentRecord>> getActiveSegments(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.verifyLegalState(context).thenCompose(v -> this.getActiveEpochRecord(true, context).thenApply(KVTEpochRecord::getSegments));
    }

    @Override
    public CompletableFuture<KVTEpochRecord> getActiveEpochRecord(boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getCurrentEpochRecordData(ignoreCached, context).thenApply(VersionedMetadata::getObject);
    }

    private CompletableFuture<Void> verifyLegalState(OperationContext context) {
        return this.getState(false, context).thenApply(state -> {
            if (state == null || state.equals((Object)KVTableState.UNKNOWN) || state.equals((Object)KVTableState.CREATING)) {
                throw StoreException.create(StoreException.Type.ILLEGAL_STATE, "KeyValueTable: " + this.getName() + " State: " + state.name());
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<KVTEpochRecord> getEpochRecord(int epoch, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        log.debug(context.getRequestId(), "getEpochRecord():: epoch number = {}", new Object[]{epoch});
        return this.getEpochRecordData(epoch, context).thenApply(VersionedMetadata::getObject);
    }

    @Override
    public CompletableFuture<KeyValueTableConfiguration> getConfiguration(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getConfigurationData(true, context).thenApply(x -> ((KVTConfigurationRecord)x.getObject()).getKvtConfiguration());
    }

    @Override
    public CompletableFuture<Set<Long>> getAllSegmentIds(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getActiveEpochRecord(true, context).thenApply(KVTEpochRecord::getSegmentIds);
    }

    @Override
    public abstract CompletableFuture<String> getId(OperationContext var1);

    abstract CompletableFuture<Void> createStateIfAbsent(KVTStateRecord var1, OperationContext var2);

    abstract CompletableFuture<Version> setStateData(VersionedMetadata<KVTStateRecord> var1, OperationContext var2);

    abstract CompletableFuture<VersionedMetadata<KVTStateRecord>> getStateData(boolean var1, OperationContext var2);

    abstract CompletableFuture<CreateKVTableResponse> checkKeyValueTableExists(KeyValueTableConfiguration var1, long var2, int var4, OperationContext var5);

    abstract CompletableFuture<Void> createKVTableMetadata(OperationContext var1);

    abstract CompletableFuture<Void> storeCreationTimeIfAbsent(long var1, OperationContext var3);

    abstract CompletableFuture<VersionedMetadata<KVTConfigurationRecord>> getConfigurationData(boolean var1, OperationContext var2);

    abstract CompletableFuture<Void> createConfigurationIfAbsent(KVTConfigurationRecord var1, OperationContext var2);

    abstract CompletableFuture<Void> createCurrentEpochRecordDataIfAbsent(KVTEpochRecord var1, OperationContext var2);

    abstract CompletableFuture<Void> createEpochRecordDataIfAbsent(int var1, KVTEpochRecord var2, OperationContext var3);

    abstract CompletableFuture<VersionedMetadata<KVTEpochRecord>> getCurrentEpochRecordData(boolean var1, OperationContext var2);

    abstract CompletableFuture<VersionedMetadata<KVTEpochRecord>> getEpochRecordData(int var1, OperationContext var2);
}

