/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.kvtable;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.store.Scope;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.index.HostIndex;
import io.pravega.controller.store.kvtable.CreateKVTableResponse;
import io.pravega.controller.store.kvtable.KVTOperationContext;
import io.pravega.controller.store.kvtable.KVTableMetadataStore;
import io.pravega.controller.store.kvtable.KVTableState;
import io.pravega.controller.store.kvtable.KeyValueTable;
import io.pravega.controller.store.kvtable.records.KVTSegmentRecord;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.StoreException;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKVTableMetadataStore
implements KVTableMetadataStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractKVTableMetadataStore.class);
    public static final Predicate<Throwable> DATA_NOT_FOUND_PREDICATE = e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException;
    private final LoadingCache<String, Scope> scopeCache;
    private final LoadingCache<Pair<String, String>, KeyValueTable> cache;
    private final HostIndex hostTaskIndex;
    private final Random requestIdGenerator = new Random();

    protected AbstractKVTableMetadataStore(HostIndex hostTaskIndex) {
        this.cache = CacheBuilder.newBuilder().maximumSize(10000L).refreshAfterWrite(10L, TimeUnit.MINUTES).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Pair<String, String>, KeyValueTable>(){

            @ParametersAreNonnullByDefault
            public KeyValueTable load(Pair<String, String> input) {
                try {
                    return AbstractKVTableMetadataStore.this.newKeyValueTable((String)input.getKey(), (String)input.getValue());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.scopeCache = CacheBuilder.newBuilder().maximumSize(1000L).refreshAfterWrite(10L, TimeUnit.MINUTES).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Scope>(){

            @ParametersAreNonnullByDefault
            public Scope load(String scopeName) {
                try {
                    return AbstractKVTableMetadataStore.this.newScope(scopeName);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.hostTaskIndex = hostTaskIndex;
    }

    public Scope getScope(String scopeName, OperationContext context) {
        if (context instanceof KVTOperationContext) {
            return ((KVTOperationContext)context).getScope();
        }
        Scope scope = (Scope)this.scopeCache.getUnchecked((Object)scopeName);
        scope.refresh();
        return scope;
    }

    abstract KeyValueTable newKeyValueTable(String var1, String var2);

    @Override
    public KVTOperationContext createContext(String scopeName, String name, long requestId) {
        return new KVTOperationContext(this.getScope(scopeName, null), this.getKVTable(scopeName, name, null), requestId);
    }

    @Override
    public KeyValueTable getKVTable(String scope, String name, OperationContext context) {
        if (context instanceof KVTOperationContext) {
            return ((KVTOperationContext)context).getKvTable();
        }
        KeyValueTable kvt = (KeyValueTable)this.cache.getUnchecked((Object)new ImmutablePair((Object)scope, (Object)name));
        log.debug("Got KVTable from cache: {}/{}", (Object)kvt.getScopeName(), (Object)kvt.getName());
        kvt.refresh();
        return kvt;
    }

    @Override
    public CompletableFuture<CreateKVTableResponse> createKeyValueTable(String scope, String name, KeyValueTableConfiguration configuration, long createTimestamp, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn((CompletableFuture)this.checkScopeExists(scope, context, executor).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return this.getSafeStartingSegmentNumberFor(scope, name, context, executor).thenCompose(startingSegmentNumber -> this.getKVTable(scope, name, context).create(configuration, createTimestamp, (int)startingSegmentNumber, context));
            }
            return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, "scope does not exist"));
        }), (Executor)executor);
    }

    OperationContext getOperationContext(OperationContext context) {
        return context != null ? context : new OperationContext(){
            private final long requestId;
            private final long operationStartTime;
            {
                this.requestId = AbstractKVTableMetadataStore.this.requestIdGenerator.nextLong();
                this.operationStartTime = System.currentTimeMillis();
            }

            @Override
            public long getOperationStartTime() {
                return this.operationStartTime;
            }

            @Override
            public long getRequestId() {
                return this.requestId;
            }
        };
    }

    String getScopedKVTName(String scope, String name) {
        return String.format("%s/%s", scope, name);
    }

    @Override
    public CompletableFuture<Long> getCreationTime(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getKVTable(scope, name, context).getCreationTime(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> setState(String scope, String name, KVTableState state, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getKVTable(scope, name, context).updateState(state, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<KVTableState> getState(String scope, String name, boolean ignoreCached, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getKVTable(scope, name, context).getState(ignoreCached, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedMetadata<KVTableState>> updateVersionedState(String scope, String name, KVTableState state, VersionedMetadata<KVTableState> previous, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getKVTable(scope, name, context).updateVersionedState(previous, state, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedMetadata<KVTableState>> getVersionedState(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getKVTable(scope, name, context).getVersionedState(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<List<KVTSegmentRecord>> getActiveSegments(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getKVTable(scope, name, context).getActiveSegments(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<KeyValueTableConfiguration> getConfiguration(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getKVTable(scope, name, context).getConfiguration(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Pair<List<String>, String>> listKeyValueTables(String scopeName, String continuationToken, int limit, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getScope(scopeName, context).listKeyValueTables(limit, continuationToken, executor, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Set<Long>> getAllSegmentIds(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getKVTable(scope, name, context).getAllSegmentIds(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> deleteKeyValueTable(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext kvtContext = this.getOperationContext(ctx);
        KeyValueTable kvTable = this.getKVTable(scope, name, kvtContext);
        return Futures.completeOn((CompletableFuture)Futures.exceptionallyExpecting((CompletableFuture)((CompletableFuture)kvTable.getActiveEpochRecord(true, kvtContext).thenApply(epoch -> epoch.getSegments().stream().map(KVTSegmentRecord::getSegmentNumber).reduce(Integer::max).get())).thenCompose(lastActiveSegment -> this.recordLastKVTableSegment(scope, name, (int)lastActiveSegment, kvtContext, executor)), DATA_NOT_FOUND_PREDICATE, null).thenCompose(v -> kvTable.delete(kvtContext)), (Executor)executor).thenCompose(v -> this.deleteFromScope(scope, name, kvtContext, executor));
    }

    abstract CompletableFuture<Void> recordLastKVTableSegment(String var1, String var2, int var3, OperationContext var4, Executor var5);

    abstract CompletableFuture<Integer> getSafeStartingSegmentNumberFor(String var1, String var2, OperationContext var3, Executor var4);

    abstract CompletableFuture<Void> deleteFromScope(String var1, String var2, OperationContext var3, Executor var4);

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HostIndex getHostTaskIndex() {
        return this.hostTaskIndex;
    }
}

