/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.kvtable;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.store.InMemoryScope;
import io.pravega.controller.store.Scope;
import io.pravega.controller.store.index.InMemoryHostIndex;
import io.pravega.controller.store.kvtable.AbstractKVTableMetadataStore;
import io.pravega.controller.store.kvtable.InMemoryKVTable;
import io.pravega.controller.store.kvtable.KeyValueTable;
import io.pravega.controller.store.stream.InMemoryStreamMetadataStore;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.StreamMetadataStore;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryKVTMetadataStore
extends AbstractKVTableMetadataStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryKVTMetadataStore.class);
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    @GuardedBy(value="$lock")
    private final Map<String, Integer> deletedKVTables = new HashMap<String, Integer>();
    private final InMemoryStreamMetadataStore streamStore;

    public InMemoryKVTMetadataStore(StreamMetadataStore streamStore) {
        super(new InMemoryHostIndex());
        this.streamStore = (InMemoryStreamMetadataStore)streamStore;
    }

    @Override
    KeyValueTable newKeyValueTable(String scope, String name) {
        Object object = this.$lock;
        synchronized (object) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Scope newScope(String scopeName) {
        return this.getScope(scopeName, null);
    }

    @Override
    public KeyValueTable getKVTable(String scope, String name, OperationContext context) {
        Object object = this.$lock;
        synchronized (object) {
            InMemoryScope kvtScope;
            if (this.streamStore.scopeExists(scope) && (kvtScope = (InMemoryScope)this.streamStore.getScope(scope, context)).checkTableExists(name)) {
                return kvtScope.getKeyValueTable(name);
            }
            return new InMemoryKVTable(scope, name);
        }
    }

    @Override
    public CompletableFuture<Void> deleteFromScope(String scope, String name, OperationContext context, Executor executor) {
        return Futures.completeOn(((InMemoryScope)this.getScope(scope, context)).removeKVTableFromScope(name), (Executor)executor);
    }

    @Override
    CompletableFuture<Void> recordLastKVTableSegment(String scope, String kvtable, int lastActiveSegment, OperationContext context, Executor executor) {
        Integer oldLastActiveSegment = this.deletedKVTables.put(this.getScopedKVTName(scope, kvtable), lastActiveSegment);
        Preconditions.checkArgument((oldLastActiveSegment == null || lastActiveSegment >= oldLastActiveSegment ? 1 : 0) != 0);
        log.debug("Recording last segment {} for kvtable {}/{} on deletion.", new Object[]{lastActiveSegment, scope, kvtable});
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> checkScopeExists(String scope, OperationContext context, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            return Futures.completeOn(CompletableFuture.completedFuture(this.streamStore.scopeExists(scope)), (Executor)executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> checkTableExists(String scopeName, String kvt, OperationContext context, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            return Futures.completeOn((CompletableFuture)this.checkScopeExists(scopeName, context, executor).thenCompose(exists -> {
                if (exists.booleanValue()) {
                    return CompletableFuture.completedFuture(((InMemoryScope)this.getScope(scopeName, context)).checkTableExists(kvt));
                }
                return CompletableFuture.completedFuture(Boolean.FALSE);
            }), (Executor)executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Scope getScope(String scopeName, OperationContext context) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.streamStore.scopeExists(scopeName)) {
                return this.streamStore.getScope(scopeName, context);
            }
            return new InMemoryScope(scopeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Integer> getSafeStartingSegmentNumberFor(String scopeName, String kvtName, OperationContext context, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            Integer safeStartingSegmentNumber = this.deletedKVTables.get(this.scopedKVTName(scopeName, kvtName));
            return CompletableFuture.completedFuture(safeStartingSegmentNumber != null ? safeStartingSegmentNumber + 1 : 0);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public CompletableFuture<Void> createEntryForKVTable(String scopeName, String kvtName, UUID id, OperationContext context, Executor executor) {
        return Futures.completeOn(((InMemoryScope)this.streamStore.getScope(scopeName, context)).addKVTableToScope(kvtName, id), (Executor)executor);
    }

    private String scopedKVTName(String scopeName, String streamName) {
        return scopeName + "/" + streamName;
    }
}

