/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.kvtable;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.store.Version;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.kvtable.AbstractKVTableBase;
import io.pravega.controller.store.kvtable.CreateKVTableResponse;
import io.pravega.controller.store.kvtable.KVTableState;
import io.pravega.controller.store.kvtable.records.KVTConfigurationRecord;
import io.pravega.controller.store.kvtable.records.KVTEpochRecord;
import io.pravega.controller.store.kvtable.records.KVTStateRecord;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.StoreException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryKVTable
extends AbstractKVTableBase {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryKVTable.class);
    private final UUID id;
    private final AtomicLong creationTime = new AtomicLong(Long.MIN_VALUE);
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private VersionedMetadata<KVTConfigurationRecord> configuration;
    @GuardedBy(value="lock")
    private VersionedMetadata<KVTStateRecord> state;
    @GuardedBy(value="lock")
    private VersionedMetadata<KVTEpochRecord> currentEpochRecord;
    @GuardedBy(value="lock")
    private Map<Integer, VersionedMetadata<KVTEpochRecord>> epochRecords = new HashMap<Integer, VersionedMetadata<KVTEpochRecord>>();

    public InMemoryKVTable(String scope, String name, UUID id) {
        super(scope, name);
        this.id = id;
    }

    public InMemoryKVTable(String scope, String name) {
        this(scope, name, UUID.randomUUID());
    }

    @Override
    public CompletableFuture<String> getId(OperationContext context) {
        return CompletableFuture.completedFuture(this.id.toString());
    }

    @Override
    public CompletableFuture<Void> delete(OperationContext context) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void refresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<CreateKVTableResponse> checkKeyValueTableExists(KeyValueTableConfiguration configuration, long timestamp, int startingSegmentNumber, OperationContext context) {
        VersionedMetadata<KVTStateRecord> currentState;
        KVTConfigurationRecord config;
        long time;
        CompletableFuture<CreateKVTableResponse> result = new CompletableFuture<CreateKVTableResponse>();
        Object object = this.lock;
        synchronized (object) {
            time = this.creationTime.get();
            config = this.configuration == null ? null : this.configuration.getObject();
            currentState = this.state;
        }
        if (time != Long.MIN_VALUE) {
            if (config != null) {
                this.handleMetadataExists(timestamp, result, time, startingSegmentNumber, config.getKvtConfiguration(), currentState);
            } else {
                result.complete(new CreateKVTableResponse(CreateKVTableResponse.CreateStatus.NEW, configuration, time, startingSegmentNumber));
            }
        } else {
            result.complete(new CreateKVTableResponse(CreateKVTableResponse.CreateStatus.NEW, configuration, timestamp, startingSegmentNumber));
        }
        return result;
    }

    @Override
    CompletableFuture<Void> createKVTableMetadata(OperationContext context) {
        return CompletableFuture.completedFuture(null);
    }

    private void handleMetadataExists(long timestamp, CompletableFuture<CreateKVTableResponse> result, long time, int startingSegmentNumber, KeyValueTableConfiguration config, VersionedMetadata<KVTStateRecord> currentState) {
        if (currentState != null) {
            KVTableState stateVal = currentState.getObject().getState();
            if (stateVal.equals((Object)KVTableState.UNKNOWN) || stateVal.equals((Object)KVTableState.CREATING)) {
                CreateKVTableResponse.CreateStatus status = time == timestamp ? CreateKVTableResponse.CreateStatus.NEW : CreateKVTableResponse.CreateStatus.EXISTS_CREATING;
                result.complete(new CreateKVTableResponse(status, config, time, startingSegmentNumber));
            } else {
                result.complete(new CreateKVTableResponse(CreateKVTableResponse.CreateStatus.EXISTS_ACTIVE, config, time, startingSegmentNumber));
            }
        } else {
            CreateKVTableResponse.CreateStatus status = time == timestamp ? CreateKVTableResponse.CreateStatus.NEW : CreateKVTableResponse.CreateStatus.EXISTS_CREATING;
            result.complete(new CreateKVTableResponse(status, config, time, startingSegmentNumber));
        }
    }

    @Override
    CompletableFuture<Void> storeCreationTimeIfAbsent(long timestamp, OperationContext context) {
        this.creationTime.compareAndSet(Long.MIN_VALUE, timestamp);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Long> getCreationTime(OperationContext context) {
        return CompletableFuture.completedFuture(this.creationTime.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<Void> createConfigurationIfAbsent(KVTConfigurationRecord config, OperationContext context) {
        Preconditions.checkNotNull((Object)config);
        Object object = this.lock;
        synchronized (object) {
            if (this.configuration == null) {
                this.configuration = new VersionedMetadata<KVTConfigurationRecord>(config, new Version.IntVersion(0));
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<VersionedMetadata<KVTConfigurationRecord>> getConfigurationData(boolean ignoreCached, OperationContext context) {
        Object object = this.lock;
        synchronized (object) {
            if (this.configuration == null) {
                return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, this.getName()));
            }
            return CompletableFuture.completedFuture(this.configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<Void> createStateIfAbsent(KVTStateRecord state, OperationContext context) {
        Preconditions.checkNotNull((Object)state);
        Object object = this.lock;
        synchronized (object) {
            if (this.state == null) {
                this.state = new VersionedMetadata<KVTStateRecord>(state, new Version.IntVersion(0));
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<Version> setStateData(VersionedMetadata<KVTStateRecord> newState, OperationContext context) {
        Preconditions.checkNotNull(newState);
        CompletableFuture<Version> result = new CompletableFuture<Version>();
        Object object = this.lock;
        synchronized (object) {
            if (Objects.equals(this.state.getVersion(), newState.getVersion())) {
                this.state = this.updatedCopy(newState);
                result.complete(this.state.getVersion());
            } else {
                result.completeExceptionally(StoreException.create(StoreException.Type.WRITE_CONFLICT, this.getName()));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<VersionedMetadata<KVTStateRecord>> getStateData(boolean ignoreCached, OperationContext context) {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == null) {
                return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, this.getName()));
            }
            return CompletableFuture.completedFuture(this.state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<Void> createCurrentEpochRecordDataIfAbsent(KVTEpochRecord data, OperationContext context) {
        Preconditions.checkNotNull((Object)data);
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Object object = this.lock;
        synchronized (object) {
            if (this.currentEpochRecord == null) {
                this.currentEpochRecord = new VersionedMetadata<KVTEpochRecord>(data, new Version.IntVersion(0));
            }
            result.complete(null);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<VersionedMetadata<KVTEpochRecord>> getCurrentEpochRecordData(boolean ignoreCached, OperationContext context) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentEpochRecord == null) {
                return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, this.getName()));
            }
            return CompletableFuture.completedFuture(this.currentEpochRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<Void> createEpochRecordDataIfAbsent(int epoch, KVTEpochRecord data, OperationContext context) {
        Preconditions.checkNotNull((Object)data);
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Object object = this.lock;
        synchronized (object) {
            this.epochRecords.putIfAbsent(epoch, new VersionedMetadata<KVTEpochRecord>(data, new Version.IntVersion(0)));
            result.complete(null);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<VersionedMetadata<KVTEpochRecord>> getEpochRecordData(int epoch, OperationContext context) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.epochRecords.containsKey(epoch)) {
                return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, this.getName()));
            }
            return CompletableFuture.completedFuture(this.epochRecords.get(epoch));
        }
    }

    private <T> VersionedMetadata<T> updatedCopy(VersionedMetadata<T> input) {
        return new VersionedMetadata<T>(input.getObject(), new Version.IntVersion(input.getVersion().asIntVersion().getIntValue() + 1));
    }
}

